<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "📡 Iniciando script de push com debug completo...\n";
echo "📡 Iniciando script de push...\n";

// --- Autoload da biblioteca WebPush ---
require '/home/jpwebapp/public_html/adm/aplicativos/notificacoes/vendor/autoload.php';

use Minishlink\WebPush\WebPush;
use Minishlink\WebPush\Subscription;

// --- Subscription do dispositivo ---
// Substitua pelos dados reais do dispositivo que vai receber a notificação
$subscription = Subscription::create([
    'endpoint' => 'https://fcm.googleapis.com/fcm/send/fyOr57dQHhg:APA91bHUwzXPYKjiHCHGJjItEoO5hWri_i9VBBh7TL0sCaLo5lc1MKcDtKeRnbNjtY8Ns7VhrulHK-dWX77HKAAOFXRvp_WbQnfDSWhUpGzQmXNwsiBRVpasx9bB26hRy1fzfiMEtoTm',
    'keys' => [
    'p256dh'   => 'BLPXkWTcJL7qcz_q25HMSdePRke6CZF7AKnEOrR7xPyi-HCFMWHLvPK2f9pEnsp_3vDRja1vINn7e-waYZhZ5QY',
    'auth'     => '0OyCNJ3Yb6_ThZHxDslePg'
    ]
]);

// --- Chaves VAPID ---
$vapid = [
         'subject' => 'mailto:jpweb@jpweb.com.br',
        'publicKey' => 'BJBGCVUQp28727mD6UkncQ4v0hXngLMa1Tn8ksS8VnLHyfOS3n3QdqzUd6QoysjKmKnQl-gtFwit5h6rIZeGi5A',
        'privateKey' => 'l6eT5A3fSKKFkvq4U0XWN3H2pBoBPfq01-mUy7QhFZ0'
];

$webPush = new WebPush($vapid);

// --- Payload da notificação ---
$payload = json_encode([
    'title' => '🔥 Teste Mestre!',
    'body'  => 'Notificação de teste com debug completo.',
    'icon'  => 'https://jpweb.app.br/img_icon_192.png',
    'image' => 'https://jpweb.app.br/imagens/pre.jpg',
    'url'   => 'https://jpweb.app.br/edu/'
]);

echo "🚀 Payload preparado:\n";
print_r(json_decode($payload, true));
echo "\n";

// --- Envio da notificação ---
echo "📨 Enviando notificação...\n";

try {
    $report = $webPush->sendOneNotification($subscription, $payload);

    echo "\n---- DEBUG ----\n";

    if ($report->isSuccess()) {
        echo "✅ Notificação enviada com sucesso!\n";
    } else {
        echo "❌ Falha ao enviar notificação: " . $report->getReason() . "\n";
    }

    // Resposta completa do FCM
    $response = $report->getResponse();
    if (!$response) {
        echo "⚠️ Nenhuma resposta do FCM (verifique curl ou bloqueio externo)\n";
    } else {
        echo "📥 Resposta completa do FCM:\n";
        echo $response->getBody() . "\n";
    }

} catch (\Exception $e) {
    echo "❌ Exceção capturada durante envio: " . $e->getMessage() . "\n";
}

echo "---- FIM ----\n";
