// Converte Base64 URL-safe para Uint8Array (necessário para applicationServerKey)
function urlBase64ToUint8Array(base64String) {
  const padding = '='.repeat((4 - base64String.length % 4) % 4);
  const base64 = (base64String + padding).replace(/-/g, '+').replace(/_/g, '/');
  const rawData = window.atob(base64);
  const outputArray = new Uint8Array(rawData.length);
  for (let i = 0; i < rawData.length; ++i) {
    outputArray[i] = rawData.charCodeAt(i);
  }
  return outputArray;
}

async function registerAndSubscribe(btn) {
  try {
    // 1️⃣ Registro do Service Worker
    const reg = await navigator.serviceWorker.register('/sw.js');
    console.log('✅ Service Worker registrado:', reg);

    // 2️⃣ Permissão de notificações
    const permission = await Notification.requestPermission();
    if (permission !== 'granted') {
      console.warn('⚠️ Permissão de notificação negada');
      return;
    }

    // 3️⃣ Chave pública VAPID
    const publicVapidKey = 'BJBGCVUQp28727mD6UkncQ4v0hXngLMa1Tn8ksS8VnLHyfOS3n3QdqzUd6QoysjKmKnQl-gtFwit5h6rIZeGi5A';

    // 4️⃣ Verifica e remove subscription antiga
    let subscription = await reg.pushManager.getSubscription();
    if (subscription) {
      console.log('ℹ️ Subscription antiga encontrada. Cancelando...');
      await subscription.unsubscribe();
      console.log('✅ Subscription antiga removida');
    }

    // 5️⃣ Cria nova subscription
    subscription = await reg.pushManager.subscribe({
      userVisibleOnly: true,
      applicationServerKey: urlBase64ToUint8Array(publicVapidKey)
    });
    console.log('📡 Subscription a enviar:', subscription);

    // 6️⃣ Envia subscription para o servidor
    const response = await fetch('/notificacoes/save_token.php', {
      method: 'POST',
      headers: { 'Content-Type': 'application/json' },
      body: JSON.stringify(subscription)
    });
    const result = await response.json();
    console.log('✅ Subscription enviada para o servidor:', result);

    // 7️⃣ Atualiza botão
    btn.textContent = "Notificações Ativadas ✅";
    btn.disabled = true;

  } catch (err) {
    console.error('❌ Erro ao registrar Service Worker ou criar subscription:', err);
  }
}

// ==============================
// Inicialização via clique do usuário
// ==============================
document.addEventListener('DOMContentLoaded', () => {
  const btn = document.getElementById('btnEnablePush');
  if (btn) {
    btn.addEventListener('click', () => registerAndSubscribe(btn));
    console.log('Listener de click registrado ✅');
  } else {
    console.warn('⚠️ Botão #btnEnablePush não encontrado no HTML');
  }
});
