<?php
require __DIR__ . '/vendor/src/autoload.php'; // Biblioteca Web Push

use Minishlink\WebPush\WebPush;
use Minishlink\WebPush\Subscription;

// Conectar ao banco (ajuste SEU_BANCO, USUARIO e SENHA)
$pdo = new PDO('mysql:host=localhost;dbname=SEU_BANCO;charset=utf8', 'USUARIO', 'SENHA');

// Buscar todos tokens da tabela padronizada
$tokens = $pdo->query("SELECT token FROM notificacoes_token")->fetchAll(PDO::FETCH_COLUMN);

// Configurar VAPID Keys
$auth = [
    'VAPID' => [
        'subject' => 'mailto:seuemail@dominio.com',
        'publicKey' => 'SUA_PUBLIC_KEY',
        'privateKey' => 'SUA_PRIVATE_KEY'
    ],
];

$webPush = new WebPush($auth);

// Enviar notificação para todos os tokens
foreach ($tokens as $token_json) {
    $sub = Subscription::create(json_decode($token_json, true));
    $webPush->sendOneNotification(
        $sub,
        json_encode([
            'title' => 'Notificação Mestre',
            'body' => 'Teste de envio sem Firebase'
        ])
    );
}

// Conferir resultados
foreach ($webPush->flush() as $report) {
    if ($report->isSuccess()) {
        echo "✅ Enviado para {$report->getEndpoint()}\n";
    } else {
        echo "❌ Falhou: {$report->getReason()}\n";
    }
}
