<?php
require __DIR__ . '/vendor/src/autoload.php';

use Minishlink\WebPush\WebPush;
use Minishlink\WebPush\Subscription;

$pdo = new PDO('mysql:host=localhost;dbname=SEU_BANCO;charset=utf8','USUARIO','SENHA',[
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
]);

$tokens = $pdo->query("SELECT token FROM notificacoes_token")->fetchAll(PDO::FETCH_COLUMN);

$vapid = require __DIR__ . '/vapid_keys.php';

$auth = [
    'VAPID' => [
        'subject' => 'mailto:contato@jpweb.com.br',
        'publicKey' => $vapid['publicKey'],
        'privateKey' => $vapid['privateKey'],
    ],
];

$webPush = new WebPush($auth);

foreach ($tokens as $token_json) {
    $sub = Subscription::create(json_decode($token_json, true));
    $webPush->sendOneNotification($sub, json_encode([
        'title' => 'Notificação Mestre',
        'body' => 'Teste de envio sem Firebase'
    ]));
}

foreach ($webPush->flush() as $report) {
    echo $report->isSuccess()
        ? "✅ Enviado para {$report->getEndpoint()}\n"
        : "❌ Falhou: {$report->getReason()}\n";
}
