<?php
$entidade = $_GET['ent'] ?? $APP->entidade->id;
$totais_por_ano = array();
$data_atual = new DateTime();
$ano_atual = $data_atual->format('Y');
for ($ano = $ano_atual; $ano >= $ano_atual - 3; $ano--) {
    $data_inicio_ano = new DateTime("$ano-01-01");
    $data_fim_ano = new DateTime("$ano-12-31");
    $consulta_status = "
        SELECT
            s.nome as status,
            count(e.id) as qtd
        FROM esic e
        LEFT JOIN esic_status s ON e.status = s.id
        WHERE e.entidade = '$entidade'
            AND YEAR(e.data) = '$ano'
        GROUP BY s.nome
        ORDER BY qtd DESC";
    $resultado_status = mysqli_query($conectaDB, $consulta_status) or die(mysqli_error($conectaDB));
    $totais_ano = array(
        'ano' => $ano,
        'total' => 0,
        'recebido' => 0,
        'finalizado' => 0,
        'analise' => 0,
        'pendente' => 0,
    );
    if ($resultado_status) {
        while ($linha_status = mysqli_fetch_assoc($resultado_status)) {
            switch ($linha_status['status']) {
                case 'Recebido':
                    $totais_ano['recebido'] += $linha_status['qtd'];
                    break;
                case 'Análise':
                    $totais_ano['analise'] += $linha_status['qtd'];
                    break;
                case 'Finalizado':
                    $totais_ano['finalizado'] += $linha_status['qtd'];
                    break;
                default:
                    $totais_ano['pendente'] += $linha_status['qtd'];
                    break;
            }
            // Somar o total de ocorrências para calcular o total geral
            $totais_ano['total'] += $linha_status['qtd'];
        }
    }
    if ($totais_ano['recebido'] == 0 && $totais_ano['analise'] == 0) {
        $totais_ano['analise'] = 0;
    }
    $totais_por_ano[] = $totais_ano;
}
?>

<style>
    table {width: 100%; border-collapse: collapse;}
    td {height: 50px; border: 1px solid var(--lineboxpar); text-align: center}
    .cabecalho { font: bold 13px Verdana; color:var(--tfo); background-color: var(--tta)}
    .dados { font: bold 13px Verdana; color:var(--lineboxfont) }
    .linha-clara { background-color: var(--lineboxtab)}
    .linha-escura { background-color:var(--lineboxpar)}
</style>

<div class="tta">RELATÓRIO ESTATÍSTICO E-SIC</div>
<div class="mt5 mb5"><h5>(*) Os números do ano em curso expressam os registros em tempo real.</h5></div> 
<div class="h5 mt5 mb5">
    <table>
        <tr>
            <td class="cabecalho">Ano</td>
            <td class="cabecalho">Recebido</td>
            <td class="cabecalho">Pendente</td>
            <td class="cabecalho">Respondido</td>
        </tr>
        <?php 
        $linha_css = 'linha-clara';
        foreach ($totais_por_ano as $totais_ano): 
            $linha_css = ($linha_css == 'linha-clara') ? 'linha-escura' : 'linha-clara';
        ?>
            <tr class="<?= $linha_css ?>">
                <td class="dados"><?= $totais_ano['ano'] ?></td>
                <td class="dados"><?= $totais_ano['total'] ?></td>
                <td class="dados"><?= $totais_ano['analise'] ?></td>
                <td class="dados"><?= $totais_ano['finalizado'] ?></td>
            </tr>
        <?php endforeach; ?>
    </table>
</div>
