$(document).ready(function () {
    function fecharSidebars() {
        $('.sidebar').removeClass('active'); // Fecha todos os sidebars
        $('.close-sidebar').hide(); // Esconde todos os botões de fechar
        $('.open-sidebar').show(); // Mostra todos os botões de abrir
    }

    function abrirSidebar(target) {
        fecharSidebars(); // Fecha os sidebars abertos
        $(target).addClass('active'); // Abre o sidebar correspondente
        $(`.open-sidebar[data-target="${target}"]`).hide(); // Esconde o botão de abrir correspondente
        $(`.close-sidebar[data-target="${target}"]`).show(); // Mostra o botão de fechar correspondente
        // Forçar rolagem para o topo ao abrir o sidebar
        $('html, body').animate({ scrollTop: 0 }, 0); // Rolagem instantânea para o topo
    }

    // Evento para abrir o sidebar com base no data-target
    $('.open-sidebar').click(function () {
        const target = $(this).data('target'); // Obtém o valor do data-target
        abrirSidebar(target);
    });

    // Evento para fechar os sidebars com base no data-target
    $('.close-sidebar').click(function () {
        const target = $(this).data('target'); // Obtém o valor do data-target
        $(target).removeClass('active'); // Fecha o sidebar correspondente
        $(`.open-sidebar[data-target="${target}"]`).show(); // Mostra o botão de abrir correspondente
        $(this).hide(); // Esconde o botão de fechar correspondente
    });

    $('.sidebar .close-sidebar, .sidebar [class^="close-sidebar-"]').click(function () {
        fecharSidebars();
    });
});
