function mudarTema(nome) {
  const link = document.getElementById('tema');
  const basePath = link.getAttribute('data-base') || '';
  const caminho = `${basePath}${nome}.css`;
  link.href = caminho;
  localStorage.setItem('temaSelecionado', nome);
}

window.addEventListener('DOMContentLoaded', () => {
  const temaSalvo = localStorage.getItem('temaSelecionado');
  if (temaSalvo) {
    mudarTema(temaSalvo); // reutiliza a mesma função
  }
});

window.addEventListener('pageshow', (event) => {
  if (event.persisted) {
    const temaSalvo = localStorage.getItem('temaSelecionado');
    if (temaSalvo) {
      mudarTema(temaSalvo);
    }
  }
});
