/*
CODIGO PHP
<div class="accordion-title upper">Nome do grupo<i class="fa fa-plus"></i></div>
<div class="accordion-content">
    <a href="#">conteúdo</a>
</div>
*/

document.querySelectorAll('.accordion-title').forEach(item => {
    item.addEventListener('click', () => {
        const content = item.nextElementSibling;
        const icon = item.querySelector('i');

 // Adicione logs para checar os valores
        console.log("Content: ", content);
        console.log("Icon: ", icon);

        if (!content || !icon) {
            console.error("Elemento não encontrado!");
            return; // Prevenindo erro adicional
        }
        
        // Fecha todos os conteúdos do acordeão
        document.querySelectorAll('.accordion-content').forEach(otherContent => {
            if (otherContent !== content) { // Ignora o conteúdo clicado
                otherContent.classList.remove('open'); // Remove a classe 'open'
                otherContent.style.maxHeight = null; // Reseta a altura
                otherContent.previousElementSibling.querySelector('i').classList.remove('fa-minus'); // Remove o ícone de menos
                otherContent.previousElementSibling.querySelector('i').classList.add('fa-plus'); // Adiciona o ícone de mais
            }
        });

        // Alterna a exibição do conteúdo clicado
        if (content.classList.contains('open')) {
            content.classList.remove('open'); // Remove a classe 'open'
            content.style.maxHeight = null; // Reseta a altura
            icon.classList.remove('fa-minus'); // Remove o ícone de menos
            icon.classList.add('fa-plus'); // Adiciona o ícone de mais
        } else {
            content.classList.add('open'); // Adiciona a classe 'open'
            content.style.maxHeight = content.scrollHeight + "px"; // Define a altura para a altura total do conteúdo
            icon.classList.remove('fa-plus'); // Remove o ícone de mais
            icon.classList.add('fa-minus'); // Adiciona o ícone de menos
        }
    });
});
