document.addEventListener('DOMContentLoaded', () => {
    // Seleciona todas as "accordion-title"
    document.querySelectorAll('.accordion-title').forEach(item => {
        item.addEventListener('click', () => {
            const content = item.nextElementSibling; // Próximo elemento (accordion-content)
            const icon = item.querySelector('i'); // Ícone dentro da título

            // Verifica se os elementos esperados existem
            if (!content || !icon) {
                console.warn('Elemento esperado não encontrado:', item);
                return;
            }

            // Fecha todos os outros conteúdos
            document.querySelectorAll('.accordion-content').forEach(otherContent => {
                if (otherContent !== content) { // Ignora o conteúdo clicado
                    otherContent.classList.remove('open');
                    otherContent.style.maxHeight = null;
                    const otherIcon = otherContent.previousElementSibling.querySelector('i');
                    if (otherIcon) {
                        otherIcon.classList.remove('fa-chevron-up');
                        otherIcon.classList.add('fa-chevron-down');
                    }
                }
            });

            // Alterna o estado do conteúdo clicado
            if (content.classList.contains('open')) {
                content.classList.remove('open');
                content.style.maxHeight = null;
                icon.classList.remove('fa-chevron-up');
                icon.classList.add('fa-chevron-down');
            } else {
                content.classList.add('open');
                content.style.maxHeight = content.scrollHeight + "px";
                icon.classList.remove('fa-chevron-down');
                icon.classList.add('fa-chevron-up');
            }
        });
    });
});
