// /notificacoes/sw.js

// 1️⃣ Install
self.addEventListener('install', event => {
  console.log('✅ Service Worker instalado');
  // Força ativação imediata
  self.skipWaiting();
});

// 2️⃣ Activate
self.addEventListener('activate', event => {
  console.log('⚡ Service Worker ativado');
  // Assume controle imediato das páginas
  event.waitUntil(self.clients.claim());
});

// 3️⃣ Recebe e mostra notificações push
self.addEventListener('push', event => {
  console.log('📨 Push recebido', event.data ? event.data.text() : '(sem dados)');
  
  const data = event.data ? event.data.json() : {};
  const title = data.title || 'Notificação';
  const options = {
    body: data.body || 'Você recebeu uma nova mensagem.',
    icon: '/notificacoes/img_icon_192.png',
    badge: '/notificacoes/img_icon_192.png'
  };

  event.waitUntil(
    self.registration.showNotification(title, options)
  );
});

// 4️⃣ Ação quando o usuário clica na notificação
self.addEventListener('notificationclick', event => {
  event.notification.close();
  event.waitUntil(
    clients.openWindow('/web/index.php')
  );
});
