if ('serviceWorker' in navigator && 'PushManager' in window) {
    navigator.serviceWorker.register('/notificacoes/sw.js').then(async registration => {

        const permission = await Notification.requestPermission();
        if (permission !== 'granted') return;

        const vapidPublicKey = 'BJBGCVUQp28727mD6UkncQ4v0hXngLMa1Tn8ksS8VnLHyfOS3n3QdqzUd6QoysjKmKnQl-gtFwit5h6rIZeGi5A';

        const subscription = await registration.pushManager.subscribe({
            userVisibleOnly: true,
            applicationServerKey: urlBase64ToUint8Array(vapidPublicKey),
        });

        const response = await fetch('/notificacoes/save_token.php', {
            method: 'POST',
            headers: {'Content-Type': 'application/json'},
            body: JSON.stringify(subscription),
        });

        const result = await response.json();
        console.log('✅ Token salvo no servidor:', result);

    }).catch(err => console.error('❌ Falha ao registrar Service Worker', err));
}

function urlBase64ToUint8Array(base64String) {
    const padding = '='.repeat((4 - base64String.length % 4) % 4);
    const base64 = (base64String + padding).replace(/-/g, '+').replace(/_/g, '/');
    const rawData = atob(base64);
    const outputArray = new Uint8Array(rawData.length);
    for (let i = 0; i < rawData.length; ++i) outputArray[i] = rawData.charCodeAt(i);
    return outputArray;
}
