<?php
$POPUP = $APP->startApp('popup');
$POPS = $POPUP->getPopupsView();
if($POPS) { 
    $vPopup = false; 
?>
<style>
/* POPUP CSS */
.popup-content {position:fixed; top:50%; left:50%; transform:translate(-50%, -150%); z-index:100001; max-width:90%; max-height:90%; transition: transform 2s ease, opacity 2s ease; opacity:0;}
.popup-backdrop {position:fixed; top:0; left:0; width:100%; height:100%; background:#000; z-index:100000; display:none;}
.popup-content img {width:100%; height:auto; border-radius:8px;}
.popup-close {position:absolute; top:10px; right:10px; cursor:pointer; font-size:20px; color:#CCC; z-index:100002;}
</style>

<?php foreach($POPS as $p) {
    if(!$_COOKIE['popup'.$p->id] && !$vPopup) { $vPopup = true; ?>
<div popup-container contar="<?= $p->id ?>" action="<?= URL_ADM.'app/popup/!/contador' ?>">
    <div class="popup-backdrop"></div>
    <div class="popup-content">
        <div class="popup-close">&#10005;</div>
        <?php if($p->imagens) { ?>
            <a href="<?= $p->link ?? '#' ?>">
                <img src="<?= URL_ADM.$p->imagens[0]->path.$p->imagens[0]->arquivo ?>" alt="<?= $p->titulo ?>">
            </a>
        <?php } ?>
    </div>
</div>

<script>
(function(){
    var container = document.querySelector('[popup-container][contar="<?= $p->id ?>"]');
    var backdrop = container.querySelector('.popup-backdrop');
    var content = container.querySelector('.popup-content');
    var close = container.querySelector('.popup-close');
    function setCookie(name,value,seconds){ 
        var d = new Date(); d.setTime(d.getTime() + (seconds*1000));
        document.cookie = name + "=" + value + "; path=/; expires=" + d.toUTCString(); }
    function showPopup(){
        backdrop.style.display='block';
        content.style.display='block';
        setTimeout(()=>{ 
            content.style.transform='translate(-50%, -50%)';
            content.style.opacity='1';
        }, 10);
        setCookie('popup<?= $p->id ?>','true',<?= $POPUP->setup->cache ?>);
        setCookie('popup-intervalo','true',<?= $POPUP->setup->intervalo ?>);
        var action = container.getAttribute('action');
        var ID = container.getAttribute('contar');
        fetch(action, {method:'POST', headers:{'Content-Type':'application/x-www-form-urlencoded'}, body:'acao=contar&ID='+ID}); }

    close.onclick = function(){
        content.style.opacity = '0';       // esvanece popup
        backdrop.style.opacity = '0';      // esvanece fundo preto
        setTimeout(() => {
            content.style.display = 'none';
            backdrop.style.display = 'none';
        }, 800); }
    backdrop.onclick = close.onclick;
    setTimeout(showPopup, <?= ($POPUP->setup->abertura*1000 >= 2000) ? $POPUP->setup->abertura*1000 : '2000' ?>);
    })();
</script>

<?php } } } ?>
