<div class="grid-auto-250">
    <?php
    if (!isset($NOTICIAS) || !$NOTICIAS) {$NOTICIAS = $APP->startApp('noticias'); }
    $secao = 'Publicações';
    $limite = 9;
    $orderBy = (object) ['campo' => 'data', 'ordem' => 'DESC'];
    $noticias = $NOTICIAS ? $NOTICIAS->getNoticiasNews($limite, $secao, $secaoNot ?? null, $orderBy) : [];
    if (empty($noticias)) {echo "<p>Nenhum cadastro para a seção '{$secao}'.</p>";} 
    else {foreach ($noticias as $n) {$capa = $n->capa;
    ?>
    <div class="block">
        <a href="pag.php?pg=public/view&secao=<?= urlencode($n->secao) ?>&tag=<?= $n->tag ?>">
            <img src="<?= URL_ADM . htmlspecialchars($capa->path) . htmlspecialchars($capa->arquivo) ?>" title="Imagem" alt="Imagem">
            <div class="text">
                <div><h6 class="mb10"><?= date('d/m/Y', strtotime($n->data)) ?> / <?= htmlspecialchars($n->secao) ?></h6></div>
                <div class="title mb5"><?= limita_caracteres(strip_tags($n->titulo), 140, false); ?>&nbsp;[<?= $n->contador ?>]</div>
                <p><?= limita_caracteres(strip_tags($n->subtitulo), 100, false); ?></p>
            </div>
        </a>
    </div> 
    <?php
        }
    }
    ?>
</div>
<div class="clear"></div>
<!--<div class="btn"><a href="pag.php?pg=public/list">Ver mais<i class="fa fa fa-arrow-right ml10"></i></a></div>-->
