<style>
.marquee-line {border:1px solid var(--marbor); width:100%; margin:0 auto; padding:10px; background:var(--marbkgtitle); border-radius:8px; overflow:hidden; display:flex; align-items:center; gap:10px;}
.marquee-icon {flex:0 0 auto; color:var(--marfont1); font-size:40px;}
.marquee-container {flex:1 1 auto; overflow:hidden; white-space:nowrap; box-sizing:border-box; background:var(--marbkgline); border-radius:6px;}
.marquee-content {display:inline-block; white-space:nowrap;}
.marquee-content span {display:inline-flex; align-items:center; white-space:nowrap; font:400 20px/20px 'Roboto',sans-serif; color:var(--marfont1); padding:0 30px;}
.marquee-content span i.fa-star {font-size:20px; line-height:20px; margin-right:10px; color:inherit !important;}
.marquee-content span p, .marquee-content span br, .marquee-content span * {color: var(--marfont1) !important;}
</style>

<?php
if (!isset($BLOCOS)) {$BLOCOS = $APP->startApp('blocos');}
const MARQUEES = ['Marquee 1', 'Marquee 2', 'Marquee 3'];
function renderMarqueeContent($blocos, $marquees) { $output = '';
    foreach ($marquees as $secao) {$bloco = $blocos->getBlocoSecao($secao, 1);
        if ($bloco && $bloco->texto) {$output .= 
        '<span><i class="fa fa-star"></i>' . $bloco->texto . '</span>'; } }
    return $output; } ?>

<div class="marquee-line">
    <div class="marquee-icon"><i class="fa fa-th-large mr10"></i></div>
    <div class="marquee-container">
        <div class="marquee-content">
            <?= renderMarqueeContent($BLOCOS, MARQUEES) ?>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', () => {
  const container = document.querySelector('.marquee-container');
  const content = container.querySelector('.marquee-content');
  content.innerHTML += content.innerHTML; 
  const totalWidth = content.scrollWidth / 2; // largura original
  const duration = totalWidth / 100;          // 100px/s -> velocidade
  content.style.animation = `marqueeAnim ${duration}s linear infinite`;
  const styleSheet = document.createElement('style');
  styleSheet.type = 'text/css';
  styleSheet.innerHTML = `@keyframes marqueeAnim {0%   { transform: translateX(0); }100% { transform: translateX(-${totalWidth}px); }}`;
  document.head.appendChild(styleSheet);
  container.addEventListener('mouseenter', () => {content.style.animationPlayState = 'paused';});
  container.addEventListener('mouseleave', () => {content.style.animationPlayState = 'running';});
});
</script>
