const CACHE_NAME = 'app-pwa-cache-v1';
const urlsToCache = [
  '/web/index.php',
  '/app/notify.js',
  '/app/manifest.json',
  '/app/images/promo1.jpg',
  '/app/images/promo2.jpg'
];

// Instalando SW e armazenando cache
self.addEventListener('install', event => {
  event.waitUntil(
    caches.open(CACHE_NAME).then(cache => cache.addAll(urlsToCache))
  );
  self.skipWaiting();
});

// Ativando SW
self.addEventListener('activate', event => {
  event.waitUntil(self.clients.claim());
});

// Interceptando requests e retornando cache se offline
self.addEventListener('fetch', event => {
  event.respondWith(
    caches.match(event.request).then(response => response || fetch(event.request))
  );
});

// Recebendo push
self.addEventListener('push', event => {
  const data = event.data ? event.data.json() : {
    title: 'Notificação',
    body: 'Você recebeu algo!',
    image: '/app/images/promo1.jpg',
    url: '/web/index.php'
  };

  const options = {
    body: data.body,
    icon: data.image,
    image: data.image,
    data: { url: data.url }
  };

  event.waitUntil(
    self.registration.showNotification(data.title, options)
  );
});

// Ao clicar na notificação, abre o link
self.addEventListener('notificationclick', event => {
  event.notification.close();
  event.waitUntil(
    clients.openWindow(event.notification.data.url)
  );
});
