// Registrar Service Worker
if ('serviceWorker' in navigator) {
  navigator.serviceWorker.register('/app/sw.js')
    .then(reg => console.log('✅ SW registrado:', reg))
    .catch(err => console.error('❌ Falha ao registrar SW:', err));
}

// Criar formulário de notificação
const form = document.createElement('div');
form.innerHTML = `
  <h3>Disparar Notificação</h3>
  <input type="text" id="notifyTitle" placeholder="Título" style="margin:5px; padding:5px; width:200px;">
  <input type="text" id="notifyBody" placeholder="Mensagem" style="margin:5px; padding:5px; width:200px;">
  <input type="text" id="notifyImage" placeholder="URL da imagem" style="margin:5px; padding:5px; width:200px;">
  <input type="text" id="notifyLink" placeholder="URL ao clicar" style="margin:5px; padding:5px; width:200px;">
  <button id="sendNotify" style="margin:10px; padding:10px 20px;">Enviar Notificação</button>
`;
document.body.appendChild(form);

document.getElementById('sendNotify').addEventListener('click', async () => {
  const permission = await Notification.requestPermission();
  console.log('Permissão:', permission);
  if (permission !== 'granted') return;

  const title = document.getElementById('notifyTitle').value || 'Notificação';
  const body = document.getElementById('notifyBody').value || 'Mensagem padrão';
  const image = document.getElementById('notifyImage').value || '/app/images/promo1.jpg';
  const url = document.getElementById('notifyLink').value || '/web/index.php';

  navigator.serviceWorker.ready.then(reg => {
    reg.showNotification(title, {
      body: body,
      icon: image,
      image: image,
      data: { url: url }
    });
  });
});

// Botão de teste rápido
const btnTest = document.createElement('button');
btnTest.textContent = 'Teste Rápido';
btnTest.style.margin = '20px';
btnTest.style.padding = '10px 20px';
btnTest.style.fontSize = '16px';
document.body.appendChild(btnTest);

btnTest.addEventListener('click', async () => {
  const permission = await Notification.requestPermission();
  if (permission !== 'granted') return;

  navigator.serviceWorker.ready.then(reg => {
    reg.showNotification('🚀 Notificação de Teste', {
      body: 'Seu PWA está funcionando!',
      icon: '/app/images/promo1.jpg',
      image: '/app/images/promo1.jpg',
      data: { url: '/web/index.php' }
    });
  });
});



// Função para disparar notificação
async function dispararNotificacao(title, body, image, url) {
  const permission = await Notification.requestPermission();
  if (permission !== 'granted') return;

  navigator.serviceWorker.ready.then(reg => {
    reg.showNotification(title, {
      body: body,
      icon: image,
      image: image,
      data: { url: url }
    });
  });
}

// Rotina de teste automática
function testeAutomático() {
  const notificacoes = [
    {
      title: '🚀 Teste 1',
      body: 'Esta é a primeira notificação',
      image: '/app/images/promo1.jpg',
      url: '/web/index.php'
    },
    {
      title: '🎯 Teste 2',
      body: 'Segunda notificação com outro link',
      image: '/app/images/promo2.jpg',
      url: '/web/index.php'
    },
    {
      title: '🔥 Teste 3',
      body: 'Última notificação do teste',
      image: '/app/images/promo1.jpg',
      url: '/web/index.php'
    }
  ];

  // Dispara as 3 notificações com 2 segundos de intervalo
  notificacoes.forEach((n, i) => {
    setTimeout(() => {
      dispararNotificacao(n.title, n.body, n.image, n.url);
    }, i * 2000);
  });
}

// Adicionar botão de teste automático
const btnAuto = document.createElement('button');
btnAuto.textContent = '💥 Teste Automático 3 Notificações';
btnAuto.style.margin = '20px';
btnAuto.style.padding = '10px 20px';
btnAuto.style.fontSize = '16px';
document.body.appendChild(btnAuto);

btnAuto.addEventListener('click', testeAutomático);
