/*
 *  Document   : usuarios.js
 *  Author     : ComunicPlus.com
 *  Description: Scripts página "Usuários"
 */
var Usuarios = function() {
    var tabelaUsuarios = function () {
        var table = $('#usuarios');

        // begin first table
        table.dataTable({

            // Internationalisation. For more info refer to http://datatables.net/manual/i18n
            "language": {
                "aria": {
                    "sortAscending": ": Sortear de A-Z",
                    "sortDescending": ": Sortear de Z-A"
                },
                "emptyTable": "No data available in table",
                "info": "Exibindo _START_ à _END_ de _TOTAL_ registros",
                "infoEmpty": "Sem registros.",
                "infoFiltered": "(Filtrado(s) de _MAX_ registros.)",
                "lengthMenu": "Exibindo _MENU_",
                "search": "Procurar:",
                "zeroRecords": "No matching records found",
                "paginate": {
                    "previous":"Anterior",
                    "next": "Próximo",
                    "last": "Última",
                    "first": "Primeira"
                }
            },


            // Or you can use remote translation file
            //"language": {
            //   url: '//cdn.datatables.net/plug-ins/3cfcc339e89/i18n/Portuguese.json'
            //},

            // Uncomment below line("dom" parameter) to fix the dropdown overflow issue in the datatable cells. The default datatable layout
            // setup uses scrollable div(table-scrollable) with overflow:auto to enable vertical scroll(see: assets/global/plugins/datatables/plugins/bootstrap/dataTables.bootstrap.js). 
            // So when dropdowns used the scrollable div should be removed. 
            //"dom": "<'row'<'col-md-6 col-sm-12'l><'col-md-6 col-sm-12'f>r>t<'row'<'col-md-5 col-sm-12'i><'col-md-7 col-sm-12'p>>",

            "bStateSave": true, // save datatable state(pagination, sort, etc) in cookie.

            "lengthMenu": [
                [25, 50, -1],
                [25, 50, "Todos"] // change per page values here
            ],
            // set the initial value
            "pageLength": 0,            
            "pagingType": "bootstrap_full_number",
            "columnDefs": [
                {  // set default column settings
                    'orderable': false,
                    'targets': [0]
                }, 
                {
                    "searchable": false,
                    "targets": [0]
                },
                {
                    "className": "dt-right", 
                    //"targets": [2]
                }
            ],
            "order": [
                [1, "asc"]
            ] // set first column as a default sort by asc
        });

        var tableWrapper = jQuery('#sample_1_wrapper');

        table.find('.group-checkable').change(function () {
            var set = jQuery(this).attr("data-set");
            var checked = jQuery(this).is(":checked");
            jQuery(set).each(function () {
                if (checked) {
                    $(this).prop("checked", true);
                    $(this).parents('tr').addClass("active");
                } else {
                    $(this).prop("checked", false);
                    $(this).parents('tr').removeClass("active");
                }
            });
        });

        table.on('change', 'tbody tr .checkboxes', function () {
            $(this).parents('tr').toggleClass("active");
        });
    }

    var vEditar = function(){
        if ($('.form-usuario').length) {
            jQuery('.form-usuario').validate({
                errorElement: 'span', //default input error message container
                errorClass: 'help-block help-block-error h6', // default input error message class
                focusInvalid: true, // do not focus the last invalid input
                highlight: function(e) {
                    jQuery(e).closest('.form-group').removeClass('has-error').addClass('has-error');
                    jQuery(e).closest('.help-block').remove();
                },
                success: function(e) {
                    jQuery(e).closest('.form-group').removeClass('has-error');
                    jQuery(e).closest('.help-block').remove();
                },
                rules: {
                    usuario: {
                        required: true,
                        //minlength: 5,
                        remote: {
                            url: $('.form-usuario').attr('action'),
                            type: "post",
                            data: {
                                'ID': function() {
                                    return $( "#ID" ).val();
                                },
                                'usuario': function() {
                                    return $( "#usuario" ).val();
                                },
                                'verifica-usuario': true,
                            }
                        }
                    },
                    nome: {
                        required: true,
                    },
                    email: {
                        required: true,
                        email: true
                    }
                },
                messages: {
                    usuario: {
                        required: 'Insira um Nick (Login) válido.',
                        //minlength: 'Mínimo de 5 caracteres.',
                        remote: 'Este usuário já está sendo usado.'
                    },
                    nome: {
                        required: 'Digite seu nome, ou como gostaria de ser citado.',
                    },
                    email: {
                        required: 'Insira seu endereço de e-mail.',
                        email: 'Insira um endereço de e-mail válido'
                    },
                },
                errorPlacement: function (error, element) { // render error placement for each input type
                    var cont = $(element).parent('.input-group');
                    if (cont.size() > 0) {
                        cont.after(error);
                    } else {
                        element.after(error);
                    }
                },
                submitHandler: function( form ){
                    var dados = $( form ).serialize();
                    var action = $ ( form ).attr('action');
                    $.ajax({
                        type: "POST",
                        dataType: "json",
                        url: action,
                        data: dados,
                        success: function( data ) {
                            retornoAjax(data);
                        },
                        error: function( data ) {
                            ajaxErro();
                        }
                    });

                    return false;
                }
            });
        }
    };

    var vSenha = function(){
        if ($('.form-senha').length) {
            jQuery('.form-senha').validate({
                errorElement: 'span', //default input error message container
                errorClass: 'help-block help-block-error h6', // default input error message class
                focusInvalid: true, // do not focus the last invalid input
                highlight: function(e) {
                    jQuery(e).closest('.form-group').removeClass('has-error').addClass('has-error');
                    jQuery(e).closest('.help-block').remove();
                },
                success: function(e) {
                    jQuery(e).closest('.form-group').removeClass('has-error');
                    jQuery(e).closest('.help-block').remove();
                },
                rules: {
                    senha1: {
                        required: true,
                        //minlength: 5,
                    },
                    senha2: {
                        equalTo: senha1,
                    }
                },
                messages: {
                    senha1: {
                        required: 'Insira sua nova senha.',
                        //minlength: 'Sua senha deve contar um mínimo de 5 caracteres.'
                    },
                    senha2: {
                        equalTo: 'As senhas não conferem.',
                    },
                },
                errorPlacement: function (error, element) { // render error placement for each input type
                    var cont = $(element).parent('.input-group');
                    if (cont.size() > 0) {
                        cont.after(error);
                    } else {
                        element.after(error);
                    }
                },
                submitHandler: function( form ){
                    var dados = $( form ).serialize();
                    var action = $ ( form ).attr('action');
                    $.ajax({
                        type: "POST",
                        dataType: "json",
                        url: action,
                        data: dados,
                        success: function( data ) {
                            retornoAjax(data);
                        },
                        error: function( data ) {
                            ajaxErro();
                        }
                    });

                    return false;
                }
            });
        }
    };
    var vAddUsuario = function(){
        if ($('.js-convite').length) {
            jQuery('.js-convite').validate({
                errorClass: 'help-block h6 text-left animated fadeInDown',
                errorElement: 'span',
                
                rules: {
                    tipo: {
                        required: true,
                    },
                    usuario: {
                        required: true,
                        //minlength: 5,
                        remote: {
                            url: $('.js-convite').attr('action'),
                            type: "post",
                            data: {
                                'ID': function() {
                                    return $( "#ID" ).val();
                                },
                                'usuario': function() {
                                    return $( "#usuario" ).val();
                                },
                                'consulta': true,
                            }
                        }
                    },
                    senha1: {
                        required: true,
                    },
                    senha2: {
                        required: true,
                        equalTo: $('#senha1'),
                    },
                    nome: {
                        required: true,
                    },
                    email: {
                        required: true,
                        email: true
                    }
                },
                messages: {
                    tipo: {
                        require: 'Selecione um tipo válido',
                    },
                    usuario: {
                        required: 'Insira um Nick (Login) válido.',
                        //minlength: 'Mínimo de 5 caracteres.',
                        remote: 'Este usuário já está sendo usado.'
                    },
                    nome: {
                        required: 'Digite seu nome, ou como gostaria de ser citado.',
                    },
                    email: {
                        required: 'Insira seu endereço de e-mail.',
                        email: 'Insira um endereço de e-mail válido'
                    },
                },
                submitHandler: function( form ){
                    var dados = $( form ).serialize();

                    $.ajax({
                        type: "POST",
                        dataType: "json",
                        url: $ ( form ).attr('action'),
                        data: dados,
                        beforeSend: function() {
                            $('#block-convite').addClass('block-opt-refresh');
                            $('.js-convite').find('input, textarea, button, select').attr('disabled', true);
                        },
                        success: function( data ) {
                            $('#block-convite').removeClass('block-opt-refresh');
                            $('.js-convite').find('input, textarea, button, select').removeAttr('disabled');
                            retornoAjax(data);
                        },
                        error: function( data ) {
                            $('#block-convite').removeClass('block-opt-refresh');
                            $('.js-convite').find('input, textarea, button, select').removeAttr('disabled');
                            $toast = toastr['error']('Informações inválidas. Atualize a página para continuar.');
                        }
                    });

                    return false;
                }
            });
        }
    };

    return {
        init: function () {
            // Init Login Form Validation
            vEditar();
            vSenha();
            tabelaUsuarios();
            vAddUsuario();
        }
    };
}();
jQuery(document).ready(function() { Usuarios.init(); });


$('#_gerente, #_admin, #status').on('change', function() {
    if ($(this).is(":checked")) {
        $.ajax({
            type: "POST",
            dataType: "json",
            url: $(this).attr('action'),
            data: 'ID='+$(this).attr('usuario')+'&'+$(this).attr('id')+'=add',
            success: function( data ) {
                retornoAjax(data);
            },
            error: function( data ) {
                ajaxErro();
            }
        });
    } else {
        $.ajax({
            type: "POST",
            dataType: "json",
            url: $(this).attr('action'),
            data: 'ID='+$(this).attr('usuario')+'&'+$(this).attr('id')+'=rem',
            success: function( data ) {
                retornoAjax(data);
            },
            error: function( data ) {
                ajaxErro();
            }
        });
    }
});
$('._excluir').each(function(){
    var action = $ (this).attr('action');
    var ID = $ (this).attr('usuario');
    $(this).click(function() {
        swal({
            title: "Tem certeza que deseja excluir este usuário?",
            text: "Esta ação não pode ser desfeita.",
            type: "info",
            showCancelButton: true,
            showConfirmButton: true,
            confirmButtonText: 'Excluir',
            confirmButtonClass: 'btn-danger',
            closeOnConfirm: false,
            showLoaderOnConfirm: true,
        }, function (isConfirm) {
            if (isConfirm){
                swal('Excluindo!', 'O usuário será excluido e a página será atualizada.', "success");
                $.ajax({
                    type: "POST",
                    dataType: "json",
                    url: action,
                    data: 'excluir='+ID,
                    success: function( data ) {
                        retornoAjax(data);
                    },
                    error: function( data ) {
                        ajaxErro();
                    }
                });
            }
        });
    });
});

$('._permissao').on('click', function() {
    var btn = $(this);
    if ($(this).attr("status") == 1) {
        $.ajax({
            type: "POST",
            dataType: "json",
            url: $(this).attr('action'),
            data: 'ID='+$(this).attr('usuario')+'&entidade='+$(this).attr('entidade')+'&app='+$(this).attr('app')+'&aplicativo='+$(this).attr('aplicativo')+'&tipo=rem',
            success: function( data ) {
                retornoAjax(data);
                $(btn).addClass('btn-outline');
                $(btn).attr('status', 0)
            },
            error: function( data ) {
                ajaxErro();
            }
        });
    } else {
        $.ajax({
            type: "POST",
            dataType: "json",
            url: $(this).attr('action'),
            data: 'ID='+$(this).attr('usuario')+'&entidade='+$(this).attr('entidade')+'&app='+$(this).attr('app')+'&aplicativo='+$(this).attr('aplicativo')+'&tipo=add',
            success: function( data ) {
                retornoAjax(data);
                $(btn).removeClass('btn-outline');
                $(btn).attr('status', 1)
                console.log(this)
            },
            error: function( data ) {
                ajaxErro();
            }
        });
    }
});