/*
 *  Document   : setup.js
 *  Author     : ComunicPlus.com
 *  Description: Scripts página "Setup"
 */
 var Setup = function() {
    var sPlataforma = function(){
        jQuery('.form-setup-plataforma').validate({
            errorElement: 'span', //default input error message container
            errorClass: 'help-block help-block-error h6', // default input error message class
            focusInvalid: true, // do not focus the last invalid input
            highlight: function(e) {
                jQuery(e).closest('.form-group').removeClass('has-error').addClass('has-error');
                jQuery(e).closest('.help-block').remove();
            },
            success: function(e) {
                jQuery(e).closest('.form-group').removeClass('has-error');
                jQuery(e).closest('.help-block').remove();
            },
            rules: {
                bloqueio_tentativas: {
                    required: true,
                },
                bloqueio_tempo: {
                    required: true,
                }
            },
            messages: {
                bloqueio_tentativas: {
                    required: 'Escolha uma opção',
                },
                bloqueio_tempo: {
                    required: 'Escolha uma opção válida',
                },
            },
            errorPlacement: function (error, element) { // render error placement for each input type
                var cont = $(element).parent('.input-group');
                if (cont.size() > 0) {
                    cont.after(error);
                } else {
                    element.after(error);
                }
            },
            submitHandler: function( form ){
                var dados = $( form ).serialize();
                var action = $ ( form ).attr('action');
                $.ajax({
                    type: "POST",
                    dataType: "json",
                    url: action,
                    data: dados,
                    success: function( data ) {
                        retornoAjax(data);
                    },
                    error: function( data ) {
                        ajaxErro();
                    }
                });

                return false;
            }
        });
    };

    var sEmail = function(){
        jQuery('.form-setup-email').validate({
            errorElement: 'span', //default input error message container
            errorClass: 'help-block help-block-error h6', // default input error message class
            focusInvalid: true, // do not focus the last invalid input
            highlight: function(e) {
                jQuery(e).closest('.form-group').removeClass('has-error').addClass('has-error');
                jQuery(e).closest('.help-block').remove();
            },
            success: function(e) {
                jQuery(e).closest('.form-group').removeClass('has-error');
                jQuery(e).closest('.help-block').remove();
            },
            rules: {
                nome: {
                    required: true,
                    minlength: 5,
                },
                email: {
                    required: true,
                    email: true,
                    minlength: 5,
                },
                host: {
                    required: true,
                    minlength: 5,
                },
                login: {
                    required: true,
                    minlength: 5,
                },
                senha: {
                    required: true,
                }
            },
            messages: {
                
            },
            errorPlacement: function (error, element) { // render error placement for each input type
                var cont = $(element).parent('.input-group');
                if (cont.size() > 0) {
                    cont.after(error);
                } else {
                    element.after(error);
                }
            },
            submitHandler: function( form ){
                var dados = $( form ).serialize();
                var action = $ ( form ).attr('action');
                $.ajax({
                    type: "POST",
                    dataType: "json",
                    url: action,
                    data: dados,
                    success: function( data ) {
                        retornoAjax(data);
                    },
                    error: function( data ) {
                        ajaxErro();
                    }
                });

                return false;
            }
        });
    };

    return {
        init: function () {
            // Init Login Form Validation
            sPlataforma();
            sEmail();
        }
    };
}();
jQuery(document).ready(function() { Setup.init(); });



