/*
 *  Document   : entidade.js
 *  Author     : ComunicPlus.com
 *  Description: Scripts página "Entidades"
 */
var Usuarios = function() {
    var tabelaUsuarios = function () {
        var table = $('#entidades');

        // begin first table
        table.dataTable({

            // Internationalisation. For more info refer to http://datatables.net/manual/i18n
            "language": {
                "aria": {
                    "sortAscending": ": Sortear de A-Z",
                    "sortDescending": ": Sortear de Z-A"
                },
                "emptyTable": "No data available in table",
                "info": "Exibindo _START_ à _END_ de _TOTAL_ registros",
                "infoEmpty": "Sem registros.",
                "infoFiltered": "(Filtrado(s) de _MAX_ registros.)",
                "lengthMenu": "Exibindo _MENU_",
                "search": "Procurar:",
                "zeroRecords": "No matching records found",
                "paginate": {
                    "previous":"Anterior",
                    "next": "Próximo",
                    "last": "Última",
                    "first": "Primeira"
                }
            },


            // Or you can use remote translation file
            //"language": {
            //   url: '//cdn.datatables.net/plug-ins/3cfcc339e89/i18n/Portuguese.json'
            //},

            // Uncomment below line("dom" parameter) to fix the dropdown overflow issue in the datatable cells. The default datatable layout
            // setup uses scrollable div(table-scrollable) with overflow:auto to enable vertical scroll(see: assets/global/plugins/datatables/plugins/bootstrap/dataTables.bootstrap.js). 
            // So when dropdowns used the scrollable div should be removed. 
            //"dom": "<'row'<'col-md-6 col-sm-12'l><'col-md-6 col-sm-12'f>r>t<'row'<'col-md-5 col-sm-12'i><'col-md-7 col-sm-12'p>>",

            "bStateSave": true, // save datatable state(pagination, sort, etc) in cookie.

            "lengthMenu": [
                [25, 50, -1],
                [25, 50, "Todos"] // change per page values here
            ],
            // set the initial value
            "pageLength": 0,            
            "pagingType": "bootstrap_full_number",
            "columnDefs": [
                {  // set default column settings
                    'orderable': true,
                    'targets': [0]
                }, 
                {
                    "searchable": false,
                    "targets": [0]
                },
                {
                    "className": "dt-right", 
                    //"targets": [2]
                }
            ],
            "order": [
                [0, "asc"]
            ] // set first column as a default sort by asc
        });

        var tableWrapper = jQuery('#sample_1_wrapper');

        table.find('.group-checkable').change(function () {
            var set = jQuery(this).attr("data-set");
            var checked = jQuery(this).is(":checked");
            jQuery(set).each(function () {
                if (checked) {
                    $(this).prop("checked", true);
                    $(this).parents('tr').addClass("active");
                } else {
                    $(this).prop("checked", false);
                    $(this).parents('tr').removeClass("active");
                }
            });
        });

        table.on('change', 'tbody tr .checkboxes', function () {
            $(this).parents('tr').toggleClass("active");
        });
    }

    var vEditar = function(){
        if ($('.js-editar').length) {
            jQuery('.js-editar').validate({
                errorClass: 'help-block text-right animated fadeInDown',
                errorElement: 'div',
                errorPlacement: function(error, e) {
                    jQuery(e).parents('.form-group > div').append(error);
                },
                highlight: function(e) {
                    jQuery(e).closest('.form-group').removeClass('has-error').addClass('has-error');
                    jQuery(e).closest('.help-block').remove();
                },
                success: function(e) {
                    jQuery(e).closest('.form-group').removeClass('has-error');                
                    jQuery(e).closest('.help-block').remove();
                },
                rules: {
                    nome: {
                        required: true,
                    },
                },
                messages: {
                    nome: {
                        required: 'Insira um nome para a nova entidade',
                    },
                },
                submitHandler: function( form ){                    
                    var dados = new FormData(form);
                    $.ajax({
                        type: "POST",
                        dataType: "json",
                        url: $ ( form ).attr('action'),
                        data: dados,
                        contentType: false,
                        processData: false,
                        beforeSend: function() {
                            $('#block-adicionareditar').addClass('block-opt-refresh');
                            $('.js-editar').find('input, textarea, button, select').attr('disabled', true);
                        },
                        success: function( data ) {
                            $('#block-editar').removeClass('block-opt-refresh');
                            $('.js-editar').find('input, textarea, button, select').removeAttr('disabled');
                            retornoAjax(data);
                        },
                        error: function( data ) {
                            $('#block-adicinar').removeClass('block-opt-refresh');
                            $('.js-editar').find('input, textarea, button, select').removeAttr('disabled');
                            $toast = toastr['error']('Informações inválidas. Atualize a página para continuar.');
                        }
                    });

                    return false;
                }
            });
        }
    };

    var vAdicionar = function(){
        if ($('.js-adicionar-e').length) {
            jQuery('.js-adicionar-e').validate({
                errorClass: 'help-block text-right animated fadeInDown',
                errorElement: 'div',
                errorPlacement: function(error, e) {
                    jQuery(e).parents('.form-group > div').append(error);
                },
                highlight: function(e) {
                    jQuery(e).closest('.form-group').removeClass('has-error').addClass('has-error');
                    jQuery(e).closest('.help-block').remove();
                },
                success: function(e) {
                    jQuery(e).closest('.form-group').removeClass('has-error');                
                    jQuery(e).closest('.help-block').remove();
                },
                rules: {
                    nome: {
                        required: true,
                    },
                },
                messages: {
                    nome: {
                        required: 'Insira um nome para a nova entidade',
                    },
                },
                submitHandler: function( form ){
                    var dados = new FormData(form);
                    $.ajax({
                        type: "POST",
                        dataType: "json",
                        url: $ ( form ).attr('action'),
                        data: dados,
                        contentType: false,
                        processData: false,
                        beforeSend: function() {
                            $('#block-adicionar').addClass('block-opt-refresh');
                            $('.js-adicionar').find('input, textarea, button, select').attr('disabled', true);
                        },
                        success: function( data ) {
                            $('#block-adicionar').removeClass('block-opt-refresh');
                            $('.js-adicionar').find('input, textarea, button, select').removeAttr('disabled');
                            retornoAjax(data);
                        },
                        error: function( data ) {
                            $('#block-adicinar').removeClass('block-opt-refresh');
                            $('.js-adicionar').find('input, textarea, button, select').removeAttr('disabled');
                            $toast = toastr['error']('Informações inválidas. Atualize a página para continuar.');
                        }
                    });

                    return false;
                }
            });
        }
    };

    return {
        init: function () {
            // Init Login Form Validation
            tabelaUsuarios();
            vAdicionar();
            vEditar();
        }
    };
}();
jQuery(document).ready(function() { Usuarios.init(); });


$('._excluir').each(function(){
    var action = $ (this).attr('action');
    var ID = $ (this).attr('entidade');
    $(this).click(function() {
        swal({
            title: "Tem certeza que deseja excluir esta entidade?",
            text: "Esta ação não pode ser desfeita.",
            type: "info",
            showCancelButton: true,
            showConfirmButton: true,
            confirmButtonText: 'Excluir',
            confirmButtonClass: 'btn-danger',
            closeOnConfirm: false,
            showLoaderOnConfirm: true,
        }, function (isConfirm) {
            if (isConfirm){
                swal('Excluindo!', 'A entidade foi excluida.', "success");
                $.ajax({
                    type: "POST",
                    dataType: "json",
                    url: action,
                    data: 'acao=excluir&entidade='+ID,
                    success: function( data ) {
                        retornoAjax(data);
                    },
                    error: function( data ) {
                        ajaxErro();
                    }
                });
            }
        });
    });
});

$('._acesso').on('change', function() {
    if ($(this).is(":checked")) {
        $.ajax({
            type: "POST",
            dataType: "json",
            url: $(this).attr('action'),
            data: 'entidade='+$(this).attr('entidade')+'&app='+$(this).attr('app')+'&aplicativo='+$(this).attr('aplicativo')+'&tipo=add',
            success: function( data ) {
                retornoAjax(data);
            },
            error: function( data ) {
                ajaxErro();
            }
        });
    } else {
        $.ajax({
            type: "POST",
            dataType: "json",
            url: $(this).attr('action'),
            data: 'entidade='+$(this).attr('entidade')+'&app='+$(this).attr('app')+'&aplicativo='+$(this).attr('aplicativo')+'&tipo=rem',
            success: function( data ) {
                retornoAjax(data);
            },
            error: function( data ) {
                ajaxErro();
            }
        });
    }
});