$(document).on('keyup', 'input[searchMenu]', function(e){
    searchMenu($(this).val().toLowerCase())
})

function removeAcentos(text) {
    text = text.toLowerCase();
    text = text.replace(new RegExp('[ÁÀÂÃ]','gi'), 'a');
    text = text.replace(new RegExp('[ÉÈÊ]','gi'), 'e');
    text = text.replace(new RegExp('[ÍÌÎ]','gi'), 'i');
    text = text.replace(new RegExp('[ÓÒÔÕ]','gi'), 'o');
    text = text.replace(new RegExp('[ÚÙÛ]','gi'), 'u');
    text = text.replace(new RegExp('[Ç]','gi'), 'c');
    return text;                 
}

function searchMenu(filter) {
    // Declare variables 
    var input, filter, ul, li, td, i, txtValue;
    ul = $("#search_menu");
    li = $(ul).find("li").not('[search-fixed]');

    // Loop through all ul rows, and hide those who don't match the search query
    for (i = 0; i < li.length; i++) {
        td = $(li[i]).find("a")[0];
        if (td) {
            txtValue = td.textContent || td.innerText;
            if (removeAcentos(txtValue).toLowerCase().indexOf(filter) > -1) {
                $(li[i]).show();
            } else {
                $(li[i]).hide();
            }
        }
    }
}

$('.page-sidebar').keyup(function (e) {
    var $lista = $('.page-sidebar ul li:visible.start:not(.heading)');
    var $current = 0;
    var $next;
    $.each($lista, function(key, value) {
      if($(value).is('.active')) {
        $current = key;
      }
    });
    if (e.keyCode == 38) {
        $next = $lista[$current-1];
    } else if (e.keyCode == 40) {
        $next = $lista[$current+1];
    }
    if (e.keyCode == 13) {
        $link = $('.page-sidebar ul li:visible.start.active a').attr('href');
        document.location.href = $link
    }
    if ($next) {
        $('.page-sidebar ul li:visible.start:not(.heading)').removeClass('active');
        $($next).addClass('active');
    }
});