var btnEditar = $('#ajuda-editar');
var btnSalvar = $('#ajuda-salvar');
var btnCancelar = $('#ajuda-cancelar');
var divTarget = $('#ajuda');
var textAjuda = $('#text-ajuda');
var formAjuda = $('#form-ajuda');
var infoEditor = $('#info-editor');
var historico;

function summerNote() {
    
    historico = divTarget.html();
    
    editor = $(divTarget).summernote({
        height: 'auto',
        dialogsFade: true,
        placeholder: 'Digite ou insira o texto/código html de ajuda.',
        lang: 'pt-BR',
        toolbar: [
            ['style', ['style']],
            ['font', ['bold', 'underline', 'clear']],
            //['fontname', ['fontname']],
            ['color', ['color']],
            ['para', ['ul', 'ol', 'paragraph']],
            ['table', ['table']],
            ['insert', ['link', /*'picture', 'video'*/]],
            ['view', ['fullscreen', 'codeview', 'help']]
          ],
        callbacks: {
            onInit: function() {
                textAjuda.html(historico);
            },
            onChange: function(contents, $editable) {
              editor.val(editor.summernote('isEmpty') ? "" : contents);
              v.element(editor);
              textAjuda.html(contents);
            }
          }
    });

    var v = $(formAjuda).validate({
        errorElement: 'span',
        errorClass: 'help-block help-block-error h6',
        focusInvalid: true,
        highlight: function(e) {
            jQuery(e).closest('.form-group').removeClass('has-error').addClass('has-error');
            jQuery(e).closest('.help-block').remove();
        },
        success: function(e) {
            jQuery(e).closest('.form-group').removeClass('has-error');
            jQuery(e).closest('.help-block').remove();
        },
        rules: {
            ajuda: {
                //required: true,
            }
        },
        messages: {
            
        },
        errorPlacement: function (error, element) { // render error placement for each input type
            var cont = $(element).parent('.input-group');
            if (cont.size() > 0) {
                cont.after(error);
            } else {
                element.after(error);
            }
        },
        submitHandler: function( form ){

            var action = $ (form).attr('action');
            var dados = $ (form).serialize();
            
            $.ajax({
                type: "POST",
                dataType: "json",
                url: action,
                data: dados,
                success: function( data ) {
                    retornoAjax(data);
                    if(data.success == true) {
                        editor.summernote('destroy');
                        btnEditar.show('slow');
                        btnSalvar.hide('slow');
                        btnCancelar.hide('slow');
                        infoEditor.hide('slow');
                        editor.html(data.ajuda);
                    }
                },
                error: function( data ) {
                    console.log(data.responseText)
                    ajaxErro();
                }
            });

            return false;
        }
    });
}

function cancelarSummerNote() {
    editor.summernote('destroy');
    editor.html(historico);
}
$(btnEditar).on('click', function() {
    summerNote();
    $(this).hide('slow');
    btnSalvar.show('slow');
    btnCancelar.show('slow');
    infoEditor.show('slow');
})
$(btnCancelar).on('click', function() {
    cancelarSummerNote();
    btnEditar.show('slow');
    btnSalvar.hide('slow');
    btnCancelar.hide('slow');
    infoEditor.hide('slow');
})
$(btnSalvar).on('click', function(e) {
    formAjuda.submit();
})