<?
function SSL() {
	if(empty($_SERVER['HTTPS']) || $_SERVER['HTTPS'] == "off"){
	    $redirect = 'https://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
	    header('HTTP/1.1 301 Moved Permanently');
	    header('Location: ' . $redirect);
	    exit();
	}
} SSL();

error_reporting(E_ERROR);


##### INI ########################################
// Charset
	header('Content-Type: text/html; charset=UTF-8');
	setlocale(LC_ALL, 'pt_BR', 'pt_BR', 'utf-8', 'portuguese');
	date_default_timezone_set('America/Sao_Paulo');

##### URL ########################################
// Localiza Diretório
	define('PATH', substr(str_replace(basename(__FILE__), '', $_SERVER['PHP_SELF']), 1, -1));
	define('DIR', PATH ? '\\'.PATH.'/' : '\\');
	define('URL', (isset($_SERVER['HTTPS'])?'https://':'http://').$_SERVER['SERVER_NAME'].'/');
	define('URL_DIR', (isset($_SERVER['HTTPS'])?'https://':'http://').$_SERVER['SERVER_NAME'].str_replace('\\', '/', DIR));
	define('URL_VIEW', URL.'web/');


// Recebe a URL digitada
	$url_digitada = str_replace( (PATH ? PATH.'/' : ''), '', explode('?', $_SERVER['REQUEST_URI'])[0]);
// Verifica se / é ultimo caractere e a ignora
	if (substr($url_digitada, -1) == '/') { $url_digitada = substr($url_digitada, 0, -1); };
// Transforma a URL em array separando a string a cada barra
	$url_array = explode("/", $url_digitada);
// Torna 0 o HOST, e remove www.
	$url_array[0] = $_SERVER['SERVER_NAME']; if (strstr($url_array[0], 'www.')) { $url_array[0] = substr($url_array[0], 4); };
	define('URL_ARRAY', $url_array);


##### CORE #######################################
// Inclui Plugins (Funções, Bcrypt, MysqliDB)
	include('app/core/plugins.php');
	include('app/core/bcrypt/bcrypt.php');
	include('app/core/mysqlidb/mysqlidb.php');
// Inclui Config
	include('app/config.php');
// Inclui Classes do CORE
	require('app/core/APP.php');

##### APP ########################################
// Inicia a Aplicação
	$APP = new APP();
	$AUTH = $APP->Auth();

if(strpos($_SERVER['HTTP_ORIGIN'], $_SERVER['SERVER_NAME']) !== false) {
	header('Access-Control-Allow-Origin: '.$_SERVER['HTTP_ORIGIN']);
	header('Access-Control-Allow-Credentials: true');
}

	
	########################################################
	##### API LIVRE ########################################
	########################################################
	$api_app_livre = array(
		'news' => array(
			'cronjob'
		),

        'notificacoes' => array(
            'saveToken',
            'send',
        ),

		'mural' => array(
			'criar'
		),
		'esic' => array(
			'criar',
		),
		'ouvidoria' => array(
			'consulta',
			'criar'
		),
		'faleconosco' => array(
			'criar'
		),
		'esic' => array(
			'consulta',
			'criar'
		),
		'enquetes' => array(
			'enquetes',
		),
		'protocolo' => array(
			'consulta',
		),
		'popup' => array(
			'contador',
		),
		'sites' => array(
			'ps-bandeira',
			'ps-processa',
			'comprar',
			'ps-retorno'
		),
		'embargos' => array(
			'consulta',
			'certidao',
			'qrcode'
		),
		'restricoes' => array(
			'consulta',
			'certidao',
			'qrcode'
		),
		'pesquisas' => array(
			'respostas'
		),
		'livros' => array(
			'update'
		),
		'ead' => array(
			'google'
		),
		'vagas' => array(
			'candidatos',
			'consulta'
		)
	);
	########################################################
	########################################################

	//var_dump('here');
	//exit();

##### AJAX #######################################
if ($url_array[1] == '!') {
	// Permitidos sem Autorização (Globais);
	$api_livre = array('login', 'recuperar-senha', /*'cadastro',*/ 'migracao', 'contador', 'logout');

	##### AUTORIZADO
	if($AUTH->status === true) {
		$f = $url_array[2];
		if(file_exists('app/api/'.$f.'.php')) {
			include('app/api/'.$f.'.php');
						
		} else {
			die('Comando inexistente.');
		}		
	##### PERMITIDOS
	} else if ( in_array($url_array[2], $api_livre) ) {
		$f = $url_array[2];
		if(file_exists('app/api/'.$f.'.php')) {
			include('app/api/'.$f.'.php');

		} else {
			die('Comando inexistente.');
		}
	##### ACESSO NEGADO
	} else {
		die('Acesso Negado.');
	}


##### ENTIDADE ?! ################################
} else if ($AUTH->status & !$AUTH->entidade & !$AUTH->_admin) {
	
	if(!$APP->entidades) {
		$e404 = 'Você ainda não foi inscrito em nenhuma entidade.';
		$_pagina = '404';
	} else if($APP->menuEntidades()) {
		$_pagina = 's_entidades';
	}
	include('htmlBase.php');
	exit();


##### APLICATIVOS #################################
} else if ($url_array[1] == 'app' && ($S = $APP->startAPP())) {

	## Verifica Erros no Aplicativo
	if($S->erro) {
		$_pagina = '404';
		include('htmlBase.php');
		exit();
	}

	define('SDIR', DIR.'app/'.$S->tag.'/');

	# Reconfigura caminho URL, cria $TAG e $PATH
	$url_parent = $url_array; unset($url_array[0]);unset($url_array[1]); $url_array = array_values($url_array);
	$tag = $url_array[0];
	$path['app'] = $APP->setup->aplicativos.$tag.'/';
	$path['api'] = $APP->setup->aplicativos.$tag.'/api/';
	$path['core'] = $APP->setup->aplicativos.$tag.'/core/';
	$path['paginas'] = $APP->setup->aplicativos.$tag.'/paginas/';
	$path['publico'] = $APP->setup->aplicativos.$tag.'/publico/';
	$path['publico-js'] = $APP->setup->aplicativos.$tag.'/publico/js/';
	$path['publico-img'] = $APP->setup->aplicativos.$tag.'/publico/img/';

	## Inclui APP CORE do Aplicativo
	if( is_file($path['core'].'app.php') ) {
		include($path['core'].'app.php');
	} else {
		$S->{'erro'} = 'O core do aplicativo <b>'.$S->nome.'</b> não existe ou não está acessível.';
		include('htmlBase.php');
		exit();
	}

	if($url_array[1] == '!') {
			##### AUTORIZADO
		if($AUTH->status === true) {
			$f = $url_array[2];
			if(file_exists($path['api'].$f.'.php')) {
				include($path['api'].$f.'.php');							
			} else {
				die('Comando inexistente.');
			}
		##### ACESSO NEGADO
		} else {
			die('Acesso Negado.');
		}

	## LOGADO
	} else if($AUTH->status) {

		if ($url_array[1] == '') {
			$_pagina = 'home';
		} else {
			$url_digitada = $url_array; array_shift($url_digitada);
			$url_digitada = implode('/', $url_digitada);

			for( $u = 0; $u < count($url_array)-1; $u++) {
				$pe = explode("/",$url_digitada,-$u); // QUEBRA URL DIGITADA POR CADA "/", LIMITANDO
				$p = str_replace("/","_", implode("/",$pe)); // // Substitui / por _ e JUNTA ARRAY
				$p = !empty($p) ? $p : '404';
					// Procura Arquivo .php em pácginas apartir do URL
				if(file_exists($path['paginas'].$p.'.php')) {
					$_pagina = $p; break;
				} else {
					$_pagina = '404';
				}
			}
		}
		include('htmlBase.php');

	## NÃO LOGADO E SEM PERMISSÃO
	} else {
		$_pagina = 'login';
		include('app/pag/login.php');
	}



##### ACESSO EXTERNO A API #######################
} else if ($url_array[1] == 'app' AND (@in_array($url_array[4], $api_app_livre[$url_array[2]])) ) {

	$path['app'] = $APP->setup->aplicativos.$url_array[2].'/';
	$path['api'] = $APP->setup->aplicativos.$url_array[2].'/api/';
	$path['core'] = $APP->setup->aplicativos.$url_array[2].'/core/';
	$path['paginas'] = $APP->setup->aplicativos.$url_array[2].'/paginas/';
	$path['publico'] = $APP->setup->aplicativos.$url_array[2].'/publico/';
	$path['publico-js'] = $APP->setup->aplicativos.$url_array[2].'/publico/js/';
	$path['publico-img'] = $APP->setup->aplicativos.$url_array[2].'/publico/img/';

	## Inclui APP CORE do Aplicativo
	if( is_file($path['core'].'app.php') ) {
		include($path['core'].'app.php');
	}

	if($url_array[3] == '!') {
		$f = $url_array[4];
		if( file_exists($path['api'].$f.'.php') ) {
			include($path['api'].$f.'.php');							
		} else {
			die('Comando inexistente.');
		}
	}



##### HTML #######################################
} else {
	// Páginas Livres:
	$pag_livre = array('login', '404', 'convite');

	if($url_array[1] == 'convite') {
		$_pagina = 'login';
		include('app/pag/login.php');
		exit();
	}
	## LOGADO
	if($AUTH->status) {		
		if($url_array[1] == '') {
			if($APP->isProfessor) {
				header('location: '.URL_DIR.'app/ead/');
			}
			if($APP->isVereador) {

			}
			$_pagina = 'central';
		} else {
			$url_digitada = $url_array; array_shift($url_digitada);
			$url_digitada = implode('/', $url_digitada);

			for( $u = 0; $u < count($url_array)-1; $u++) {
				$pe = explode("/",$url_digitada,-$u); // QUEBRA URL DIGITADA POR CADA "/", LIMITANDO
				$p = str_replace("/","_", implode("/",$pe)); // // Substitui / por _ e JUNTA ARRAY
				$p = !empty($p) ? $p : '404';
					// Procura Arquivo .php em pácginas apartir do URL
				if(file_exists('app/pag/'.$p.'.php')) {
					$_pagina = $p; break;
				} else {
					$_pagina = '404';
				}
			}
		}
		include('htmlBase.php');

	## NÃO LOGADO PÁGINAS LIVRES
	} else if ( in_array($url_array[1], $pag_livre) ) {
		$_pagina = $url_array[1];
		if(file_exists('app/pag/'.$_pagina.'.php')) {
			include('app/pag/'.$_pagina.'.php');			
		} else {
			include ('app/pag/404.php');
		}

	## NÃO LOGADO E SEM PERMISSÃO
	} else {
		$_pagina = 'login';
		include('app/pag/login.php');
	}
}
?>