<?php
ob_start(); // Inicia buffer de saída

##### INI ########################################
// Charset

setlocale(LC_ALL, 'pt_BR', 'pt_BR', 'utf-8', 'portuguese');
date_default_timezone_set('America/Sao_Paulo');

##### URL ########################################
// Localiza Diretório
define('PATH', substr(str_replace(basename(__FILE__), '', $_SERVER['PHP_SELF']), 1, -1));
define('DIR', PATH ? '\\'.PATH.'/' : '\\');
if (!defined('URL')) {
    define('URL', (isset($_SERVER['HTTPS']) ? 'https://' : 'http://') . $_SERVER['SERVER_NAME'] . '/');
}
define('URL_DIR', (isset($_SERVER['HTTPS']) ? 'https://' : 'http://') . $_SERVER['SERVER_NAME'] . str_replace('\\', '/', DIR));
define('DIR_WEB', URL . 'web/');

// Recebe a URL digitada
$url_digitada = str_replace((PATH ? PATH.'/' : ''), '', $_SERVER['REQUEST_URI']);
$url_digitada = explode('?', $url_digitada)[0];
if (substr($url_digitada, -1) == '/') { $url_digitada = substr($url_digitada, 0, -1); }
$url_array = explode("/", $url_digitada);
$url_array[0] = $_SERVER['SERVER_NAME']; 
if (strstr($url_array[0], 'www.')) { $url_array[0] = substr($url_array[0], 4); }
define('URL_ARRAY', $url_array);

if (isset($dirAPI)) {
    define('API', str_replace(basename(__FILE__), '', $dirAPI));
    define('URL_ADM', (isset($_SERVER['HTTPS']) ? 'https://' : 'http://') . str_replace(
        array('transparencia.', 'sema.', 'saude.', 'edu.', 'mei.'),
        '', str_replace('www.', '', $_SERVER['SERVER_NAME'])
    ) . str_replace('../', '/', API));
}

if (isset($entidade) && !defined('ENTIDADE')) { define('ENTIDADE', $entidade); }

##### CORE #######################################
// Inclui Plugins (Funções, Bcrypt, MysqliDB)
require('app/core/plugins.php');
require('app/core/mysqlidb/mysqlidb.php');
// Inclui Config
require('app/config.php');
// Inclui Classes do CORE
require('app/core/APP.php');

##### INICIA APP #################################
$APP = new APP('view', $entidade);

$conectaDB = mysqli_connect($infoDB['host'], $infoDB['username'], $infoDB['password'], $infoDB['db']) 
    or die('Não foi possível conectar-se ao banco de dados');
mysqli_query($conectaDB, 'SET NAMES "utf8"');
mysqli_query($conectaDB, 'SET CHARACTER SET utf8');
mysqli_query($conectaDB, 'SET COLLATION_CONNECTION = "utf8_general_ci"');

function dirURL($address) {
    $address = explode('/', $address);
    $keys = array_keys($address, '..');
    foreach($keys as $keypos => $key) { 
        array_splice($address, $key - ($keypos * 2 + 1), 2);  
    }
    $address = implode('/', $address);
    $address = str_replace('./', '', $address);
    return $address;
}
