﻿<!--
Projeto: Plataforma
Version: 1
Tema: Metronic
Desenvolvimento: JP Web
Suporte: jpweb@jpweb.com.br / (61) 9 8251-2032
-->
<!DOCTYPE html>
<!--[if IE 8]> <html lang="pt-BR" class="ie8 no-js"> <![endif]-->
<!--[if IE 9]> <html lang="pt-BR" class="ie9 no-js"> <![endif]-->
<!--[if !IE]><!-->
<html lang="pt-BR">
<!--<![endif]-->

<!-- HEAD -->
<head>
    <meta charset="utf-8" />
    <title>.:: ADM ::.</title>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content="width=device-width, initial-scale=1" name="viewport" />
    <meta content="Área Administrativa - JPWebWork" name="description" />
        <!-- GLOBAL STYLES -->
        <link href="https://fonts.googleapis.com/css?family=Open+Sans:400,300,600,700&subset=all" rel="stylesheet" type="text/css" />
        <link href="<?= DIR ?>publico/plugins/font-awesome/css/font-awesome.min.css" rel="stylesheet" type="text/css" />
        <link href="<?= DIR ?>publico/plugins/simple-line-icons/simple-line-icons.min.css" rel="stylesheet" type="text/css" />
        <link href="<?= DIR ?>publico/plugins/bootstrap/css/bootstrap.css" rel="stylesheet" type="text/css" />
        <link href="<?= DIR ?>publico/plugins/bootstrap-switch/css/bootstrap-switch.min.css" rel="stylesheet" type="text/css" />
        <link href="<?= DIR ?>publico/plugins/bootstrap-toastr/toastr.css" rel="stylesheet" type="text/css" />
        <link href="<?= DIR ?>publico/plugins/bootstrap-sweetalert/sweetalert.css" rel="stylesheet" type="text/css" />
        <link href="<?= DIR ?>publico/plugins/datatables/datatables.min.css" rel="stylesheet" type="text/css" />
        <link href="<?= DIR ?>publico/plugins/datatables/plugins/bootstrap/datatables.bootstrap.css" rel="stylesheet" type="text/css" />
        <link href="<?= DIR ?>publico/plugins/bootstrap-datetimepicker/css/bootstrap-datetimepicker.css" rel="stylesheet" type="text/css" />
        <link href="<?= DIR ?>publico/plugins/select2/css/select2.min.css" rel="stylesheet" type="text/css" />
        <link href="<?= DIR ?>publico/plugins/select2/css/select2-bootstrap.min.css" rel="stylesheet" type="text/css" />
        <link href="<?= DIR ?>publico/plugins/bootstrap-summernote/summernote.css" rel="stylesheet" type="text/css" />
        <link href="<?= DIR ?>publico/plugins/dropzone/dropzone.css" rel="stylesheet" type="text/css" />
        <link href="<?= DIR ?>publico/plugins/cubeportfolio/css/cubeportfolio.css" rel="stylesheet" type="text/css" />
        <link href="<?= DIR ?>publico/plugins/jcrop/css/jquery.Jcrop.min.css" rel="stylesheet" type="text/css" />

        <link href="<?= DIR ?>publico/css/components-md.css" rel="stylesheet" id="style_components" type="text/css" />
        <link href="<?= DIR ?>publico/css/plugins-md.css" rel="stylesheet" type="text/css" />

        <link href="<?= DIR ?>publico/css/pag/portfolio.css" rel="stylesheet" type="text/css" />
        
        <!-- Tema -->
        <link href="<?= DIR ?>publico/css/layout.css" rel="stylesheet" type="text/css" />
        <link href="<?= DIR ?>publico/css/temas/light.css" rel="stylesheet" type="text/css" />
        <?  # Inclui CSS Página
        if (is_file('publico/css/pag/'.$_pagina.'.css')) {
        echo '<!-- CSS PÁGINA -->
        <link href="'.DIR.'publico/css/pag/'.$_pagina.'.css" rel="stylesheet" type="text/css"/>';
        }
        ?>
        <!-- Custom -->
        <link href="<?= DIR ?>publico/css/custom.css" rel="stylesheet" type="text/css" />
        <!-- FAVICON -->
        <link rel="shortcut icon" href="<?= DIR ?>publico/img/favicon.png" />
</head>
<!-- /HEAD -->
<? flush(); ?>

<!-- BODY -->
<body class="page-container-bg-solid page-header-fixed page-sidebar-closed-hide-logo page-md page-footer-fixed">
    <!-- HEADER -->
    <div class="page-header navbar navbar-fixed-top">
        <!-- HEADER INNER -->
        <div class="page-header-inner ">
            <!-- LOGO -->
            <div class="page-logo">
                <a href="<?= DIR ?>">
                    <img src="<?= DIR ?>publico/img/logo.png" alt="JP Web" class="logo-default" /> </a>
                <div class="menu-toggler sidebar-toggler"></div>
            </div>
            <!-- /LOGO -->

            <!-- TOGGLER -->
            <a class="menu-toggler responsive-toggler" data-toggle="collapse" data-target=".navbar-collapse"> </a>
            <!-- /TOGGLER -->
            <? if ($AUTH->entidade) { $E = $APP->menuEntidades($AUTH->usuario->ID); $c = count($E); ?>
            <div class="page-actions">
                <? if($AUTH->entidade->site) { ?>
                <a href="<?= $AUTH->entidade->site ?>" class ="btn btn-success no-shadow no-radius btn-md" style="margin-right: 10px;">
                    <span class="h5 no-transform">
                        <i class="fa fa-home"></i> Ir para Site
                    </span>
                </a>
                <? } ?>
                <div class="btn-group">
                    <button type="button" class="btn btn-success no-shadow no-radius btn-md dropdown-toggle" data-toggle="dropdown" data-hover="dropdown" data-close-others="true" aria-expanded="true">
                        <span class="h5 no-transform">
                            <?= $AUTH->entidade->nome ?? 'Selecione uma entidade:' ?>
                        </span>
                        <? if ($c >1 ) { ?> <i class="fa fa-angle-down"></i> <? } ?>
                    </button>
                    <? if ($c > 1) { ?>
                    <ul class="dropdown-menu" role="menu">
                        <? foreach($APP->entidades as $e) { if ($e != $AUTH->entidade) { ?>
                        <li>
                            <a fn="seleciona_Entidade" action="<?= DIR ?>!/entidade" entidade="<?= $e->id ?>">
                                <i class="icon-docs"></i> <?= $e->nome ?>
                            </a>
                        </li>
                        <? } } ?>
                    </ul>
                    <? } ?>
                </div>
            </div>
            <? } ?>


            <!-- TOP -->
            <div class="page-top">
                <!-- MENU -->
                <div class="top-menu">
                    <ul class="nav navbar-nav pull-right">
                        <!-- AUDITORIA -->
                        <? if ($MSG = $APP->AuditoriaMensagens()) { $count = array_sum($MSG) ?? false; ?>
                        <li class="dropdown dropdown-extended dropdown-notification !dropdown-dark" id="header_notification_bar">
                            <a class="dropdown-toggle" data-toggle="dropdown" data-hover="dropdown" data-close-others="true">
                                <span class="title hidden-xs"> Mensagens </span>
                                <i class="icon-bell"></i>
                                <? if ($count) { ?>
                                    <span class="badge badge-success"> <?= $count ?> </span>
                                <? } ?>
                            </a>
                            <ul class="dropdown-menu">
                                <li class="external">
                                    <h3>
                                        <? if ($count) { ?>
                                            <span class="bold"><?= $count ?></span> <?= ($count > 1) ? 'Mensagens sem respostas.' : 'Mensagem sem resposta.' ?>
                                        <? } else { ?>
                                            Nenhuma Notificação à exibir
                                        <? } ?>
                                    </h3>
                                </li>
                                <li>
                                    <ul class="dropdown-menu-list scroller" style="height: <?= 84*count($MSG) ?>px;" data-handle-color="#637283">
                                        <? foreach($MSG as $app => $msg) { ?>
                                            <div class="bg-grey-steel bg-font-grey-steel <?= ($msg == 0) ? 'font-dark' : 'font-red' ?>" style="padding: 5px; padding-left: 10px;"><?= $app ?></div>
                                            <li>
                                                <a href="<?= DIR.'app/'.strtolower(str_replace(array('-', ' '), '', $app)); ?>">
                                                <span class="details">
                                                    <span class="label label-sm label-icon <?= ($msg == 0) ? 'label-default' : 'label-danger' ?>">
                                                        <i class="fa <?= $msg==0 ? 'fa-check' : 'fa-exclamation' ?>"></i>
                                                    </span> <?= $msg==0 ? 'Todas as mensagem respondidas.' : ($msg==1 ? $msg.' Mensagem' : $msg.' Mensagens') ?></span>
                                                </a>
                                            </li>
                                        <? } ?>
                                    </ul>
                                </li>
                            </ul>
                        </li>
                        <? } ?>

                        <!-- AUDITORIA -->
                        <? $A = ($APP->Auditoria());  $count = false; ?>
                        <li class="dropdown dropdown-extended dropdown-notification !dropdown-dark" id="header_notification_bar">
                            <a class="dropdown-toggle" data-toggle="dropdown" data-hover="dropdown" data-close-others="true">
                                <span class="title hidden-xs"> Auditoria </span>
                                <i class="icon-bell"></i>
                                <? if ($count = count($A->alertas, COUNT_RECURSIVE)-count($A->alertas)) { ?>
                                    <span class="badge badge-success"> <?= $count ?> </span>
                                <? } ?>
                            </a>
                            <ul class="dropdown-menu">
                                <li class="external">
                                    <h3>
                                        <? if ($count) { ?>
                                            <span class="bold"><?= $count ?></span> <?= ($count > 1) ? 'Tópicos sem atualizações.' : 'Tópico sem atualização.' ?>
                                        <? } else { ?>
                                            Categorias Atualizadas
                                        <? } ?>
                                    </h3>
                                </li>
                                <li>
                                    <ul class="dropdown-menu-list scroller" style="height: 350px;" data-handle-color="#637283">
                                        <? if(count($A->alertas)) { foreach($A->alertas as $grupo => $a) { ?>
                                            <div class="bg-grey-steel bg-font-grey-steel font-red" style="padding: 5px; padding-left: 10px;"><?= $grupo ?></div>
                                            <? foreach($a as $a) { ?>
                                            <li>
                                                <a href="<?= DIR.'app/transparencia' ?>">
                                                <span class="time"><?= ($a->ultimo) ? Tempo($a->ultimo) : 'Nunca' ?></span>
                                                <span class="details">
                                                    <span class="label label-sm label-icon label-danger">
                                                        <i class="fa fa-calendar"></i>
                                                    </span> <?= $a->categoria ?> </span>
                                                </a>
                                            </li>
                                            <? } ?>
                                        <? } } ?>
                                        <? if(count($A->historico)) { foreach($A->historico as $grupo => $a) { ?>
                                            <div class="bg-grey-steel bg-font-grey-steel font-dark" style="padding: 5px; padding-left: 10px;"><?= $grupo ?></div>
                                            <? foreach($a as $a) { ?>
                                            <li>
                                                <a>
                                                <span class="time"><?= ($a->ultimo) ? Tempo($a->ultimo) : 'Nunca' ?></span>
                                                <span class="details">
                                                    <span class="label label-sm label-icon label-default">
                                                        <i class="fa fa-clock-o"></i>
                                                    </span> <?= $a->categoria ?> </span>
                                                </a>
                                            </li>
                                            <? } ?>
                                        <? } } ?>
                                    </ul>
                                </li>
                            </ul>
                        </li>
                        <!-- USUÁRIO -->
                        <li class="dropdown dropdown-user dropdown-extended dropdown-notification !dropdown-dark">
                            <a class="dropdown-toggle" data-toggle="dropdown" data-hover="dropdown" data-close-others="true">
                                <!-- DOC: Do not remove below empty space(&nbsp;) as its purposely used -->
                                <img alt="<?= $AUTH->usuario->nome ?>" class="img-circle" src="<?= DIR ?>publico/img/avatar.png" />
                                <span class="username username-hide-on-mobile"> <?= explode(' ', $AUTH->usuario->nome)[0]; ?> </span>
                                <i class="fa fa-angle-down"></i>
                            </a>
                            <ul class="dropdown-menu dropdown-menu-default" style="width: 250px;">
                                <li class="external">
                                    <h2 style="margin: 0px; margin-bottom: 7px; font-size: 1.5em;"><?= $AUTH->usuario->nome ?></h2>
                                    <h3><?= $AUTH->usuario->email ?></h3>
                                </li>
                                <li>
                                    <a href="<?= DIR ?>adm/usuarios/<?= $AUTH->usuario->usuario ?>">
                                        <i class="icon-user"></i> Minha Conta
                                        <span class="badge badge-success no-shadow pull-right">
                                            <span class="m-badge m-badge--success" style="padding: 5px;">
                                                <?= $AUTH->_admin ? 'Master' : ($AUTH->_gerente ? 'Administrador' : 'Usuário') ?>
                                            </span>
                                        </span>
                                    </a>
                                </li>
                                <li>
                                    <a href="<?= DIR ?>adm/usuarios/<?= $AUTH->usuario->usuario ?>#tab-historico">
                                        <i class="fa fa-history"></i> Atividades
                                    </a>
                                </li>
                                <hr style="margin:0 10px;">
                                <li>
                                    <a href="<?= DIR ?>ajuda">
                                        <i class="fa fa-support"></i> Ajuda
                                    </a>
                                </li>
                                <hr style="margin:0 10px;">
                                <div style="padding: 10px;">
                                    <a fn="Sair" action="<?= DIR ?>!/logout">
                                        <button type="button" class="btn red-mint btn-outline no-shadow btn-circle"><i class="fa fa-sign-out"></i> Desconectar</button>
                                    </a>
                                </div>
                            </ul>
                        </li>
                        <!-- /USUÁRIO -->
                    </ul>
                </div>
                <!-- /MENU -->
            </div>
            <!-- /TOP -->
        </div>
        <!-- /HEADER INNER -->
    </div>
    <!-- /HEADER -->

    <!-- HEADER & CONTENT DIVIDER -->
    <div class="clearfix"> </div>
    <!-- /HEADER & CONTENT DIVIDER -->

    <!-- CONTAINER -->
    <div class="page-container">
        <!-- MENU -->
        <div class="page-sidebar-wrapper">
            <div class="page-sidebar navbar-collapse collapse">
                <!-- BEGIN SIDEBAR MENU -->
                <ul id="search_menu" search-list class="page-sidebar-menu" data-keep-expanded="false" data-auto-scroll="true" data-slide-speed="200">
                    <li search-fixed class="nav-item start">
                        <a>
                            <input type="search" searchMenu class="form-control form-lg" autofocus autocomplete="Off" autosave="Off" name="pesquisar" placeholder="Pesquisar no Menu">
                        </a>
                    </li>
                    <br>
                    <li class="nav-item start <?= menuP('') ?>">
                        <a href="<?= DIR ?>" class="nav-link nav-toggle">
                            <i class="icon-home"></i>
                            <span class="title">Central</span>
                        </a>
                    </li>
                    <? if ($AUTH->_gerente || $AUTH->_admin) { ?>
                        <li class="nav-item start <?= menuP('usuarios') ?>">
                            <a href="<?= DIR ?>usuarios" class="nav-link nav-toggle">
                                <i class="icon-users"></i>
                                <span class="title">Usuários e Permissões</span>
                            </a>
                        </li>
                    <? } ?>
                    <? if ($AUTH->_admin) { ?>
                        <li class="nav-item start <?= menuP('entidades') ?>">
                            <a href="<?= DIR ?>entidades" class="nav-link nav-toggle">
                                <i class="icon-directions"></i>
                                <span class="title">Entidades</span>
                            </a>
                        </li>
                        <li class="nav-item start hidden <?= menuP('aplicativos') ?>">
                            <a href="<?= DIR ?>aplicativos" class="nav-link nav-toggle">
                                <i class="icon-diamond"></i>
                                <span class="title">Aplicativos</span>
                            </a>
                        </li>
                        <li class="nav-item start <?= menuP('setup') ?>">
                            <a href="<?= DIR ?>setup" class="nav-link nav-toggle">
                                <i class="icon-settings"></i>
                                <span class="title">Setup</span>
                            </a>
                        </li>
                    <? } ?>
                    <li class="nav-item start <?= menuP('ajuda') ?>">
                        <a href="<?= DIR ?>ajuda" class="nav-link nav-toggle">
                            <i class="fa fa-support "></i>
                            <span class="title">Ajuda</span>
                        </a>
                    </li>

                    <? if($APP->apps->apps) { foreach ($APP->apps->grupos as $k => $g) { ?>
                        <li class="heading">
                            <h3 class="uppercase"><?= $k ?></h3>
                        </li>
                        <? foreach ($g as $k => $a) { ?>
                            <li class="nav-item start <?= menuS($a->tag) ?>">
                                <a href="<?= DIR ?>app/<?= $a->tag ?>" class="nav-link nav-toggle">
                                    <i class="<?= $a->icone ?>"></i>
                                    <span class="title"><?= $a->nome ?></span>
                                </a>
                            </li>
                        <? } ?>
                    <? } } ?>

                </ul>
                <!-- END SIDEBAR MENU -->
            </div>
            <!-- END SIDEBAR -->
        </div>
        <!-- /MENU -->

        <!-- PÁGINA -->
        <div class="page-content-wrapper">
            <!-- BEGIN CONTENT BODY -->
            <div class="page-content">

                <?                
                $APP->Entidades($AUTH->usuario->ID);

                if(!$AUTH->entidade & $_pagina == 'central') {
                    if($APP->entidades) {
                        $_pagina = 's_entidades';
                    } else {
                        $e404 = 'Você ainda não foi inscrito em nenhuma entidade.';
                        $_pagina = '404';
                    }
                    include ('app/pag/'.$_pagina.'.php');

                } else if ($S) {
                    if($S->erro) {
                        include ('aplicativos/404.php');
                    } else {
                        include ('aplicativos/controlador.php');
                    }

                } else {
                    include ('app/pag/'.$_pagina.'.php');
                }
                ?>
            </div>
            <!-- END CONTENT BODY -->
        </div>
        <!-- /PÁGINA -->

        <!-- FOOTER -->
        <div class="page-footer">
            <div class="page-footer-inner"> 2017 &copy;
                <a target="_blank" href="http://jpw.net.br">JP Web</a> &nbsp;| &nbsp; Plataforma v1.0
            </div>
            <div class="scroll-to-top">
                <i class="icon-arrow-up"></i>
            </div>
        </div>
        <!-- /FOOTER -->
    </div>
    <!-- /CONTAINER -->

</div>

    <!--[if lt IE 9]>
    <script src="<?= DIR ?>publico/plugins/respond.min.js"></script>
    <script src="<?= DIR ?>publico/plugins/excanvas.min.js"></script> 
    <script src="<?= DIR ?>publico/plugins/ie8.fix.min.js"></script> 
    <![endif]-->
    <!-- CORE PLUGINS -->
    <script src="<?= DIR ?>publico/plugins/jquery.min.js" type="text/javascript"></script>
    <script src="<?= DIR ?>publico/plugins/bootstrap/js/bootstrap.min.js" type="text/javascript"></script>
    <script src="<?= DIR ?>publico/plugins/js.cookie.min.js" type="text/javascript"></script>
    <script src="<?= DIR ?>publico/plugins/jquery-slimscroll/jquery.slimscroll.min.js" type="text/javascript"></script>
    <script src="<?= DIR ?>publico/plugins/jquery.blockui.min.js" type="text/javascript"></script>
    <script src="<?= DIR ?>publico/plugins/bootstrap-switch/js/bootstrap-switch.min.js" type="text/javascript"></script>
    <script src="<?= DIR ?>publico/plugins/bootstrap-sweetalert/sweetalert.js" type="text/javascript"></script>
    <script src="<?= DIR ?>publico/plugins/jquery-validation/js/jquery.validate.js" type="text/javascript"></script>
    <script src="<?= DIR ?>publico/plugins/jquery-validation/js/additional-methods.min.js" type="text/javascript"></script>
    <script src="<?= DIR ?>publico/plugins/jquery-validation/js/lang/pt-BR.js" type="text/javascript"></script>
    <script src="<?= DIR ?>publico/plugins/bootstrap-toastr/toastr.js" type="text/javascript"></script>
    <script src="<?= DIR ?>publico/plugins/select2/js/select2.full.js" type="text/javascript"></script>
    <script src="<?= DIR ?>publico/plugins/select2/js/i18n/pt-BR.js" type="text/javascript"></script>
    <script src="<?= DIR ?>publico/scripts/datatable.js" type="text/javascript"></script>
    <script src="<?= DIR ?>publico/plugins/datatables/datatables.all.min.js" type="text/javascript"></script>
    <script src="<?= DIR ?>publico/plugins/datatables/datatables.min.js" type="text/javascript"></script>
    <script src="<?= DIR ?>publico/plugins/datatables/plugins/bootstrap/datatables.bootstrap.js" type="text/javascript"></script>
    <script src="<?= DIR ?>publico/plugins/bootstrap-datetimepicker/js/bootstrap-datetimepicker.js" type="text/javascript"></script>
    <script src="<?= DIR ?>publico/plugins/jquery-inputmask/jquery.inputmask.bundle.min.js" type="text/javascript"></script>

    <!-- SCRIPTS APLICATIVO -->
    <?= $JS ?>

    <?
    if($S) {
        ?><script>SDIR = '<?= SDIR ?>'</script>
        <script src="<?= DIR.$path['publico-js'] ?>app.js" type="text/javascript"></script><?
        # Inclui Script Página
        if (is_file($path['publico-js'].$_pagina.'.js')) {
            echo '<!-- JS PÁGINA -->
            <script src="'.DIR.$path['publico-js'].$_pagina.'.js" type="text/javascript"></script>';
        }
    } else {
        # Inclui Script Página
        if (is_file('publico/scripts/pag/'.$_pagina.'.js')) {
            echo '<!-- JS PÁGINA -->
            <script src="'.DIR.'publico/scripts/pag/'.$_pagina.'.js" type="text/javascript"></script>';
        }
    }
    ?>    
    <!-- GLOBAL APP -->
    <script src="<?= DIR ?>publico/scripts/app.js" type="text/javascript"></script>
    <script src="<?= DIR ?>publico/scripts/menu.js" type="text/javascript"></script>
    <script src="<?= DIR ?>publico/plugins/bootstrap-summernote/summernote.min.js" type="text/javascript"></script>
    <script src="<?= DIR ?>publico/plugins/bootstrap-summernote/lang/summernote-pt-BR.js" type="text/javascript"></script>
    <!-- LAYOUT SCRIPTS -->
    <script src="<?= DIR ?>publico/scripts/layout.js" type="text/javascript"></script>
    <script src="<?= DIR ?>publico/scripts/quick-nav.js" type="text/javascript"></script>
    <script src="<?= DIR ?>publico/scripts/formularios.js" type="text/javascript"></script>
    <script id="jQuery"></script>
</body>
</html>