<?php
## Cria classe APP
class APP {
    // Core
    PUBLIC $db = null;
    PUBLIC $IP = null;

    // Funções
    PROTECTED $_auth = null;

    // Autenticação e Login
    PRIVATE $_usuario = null;
    PRIVATE $_sessao = null;
    PRIVATE $_chave = null;
    PRIVATE $_senha = null;
    PRIVATE $_registro = null;
    PRIVATE $_infoLogin = null;
    PRIVATE $_salvar = null;

    PUBLIC $apps = null;
    PUBLIC $setup = null;
    PUBLIC $entidades = array();

    PUBLIC $mensagens;

    PUBLIC $_url = null;

    PRIVATE $isView = false;

    PUBLIC $_vereador = false;
    PUBLIC $isVereador = 0;

    PUBLIC $_professor = false;
    PUBLIC $isProfessor = 0;

    function __construct($view = false) {

        GLOBAL $url_array;
        $this->db = new MysqliDb( InfoDB );
        $this->IP = getIP();
        $this->_url = $url_array;

        $this::Setup();
        $this::Ajuda();

        // Inicializa _auth antes de qualquer acesso
        $this->_auth = $this::Auth();

        // Chama aplicativos se status estiver OK e entidade definida
        if ($this->_auth && !empty($this->_auth->status)) {
            if (!empty($this->_auth->entidade)) {
                $this::getAplicativos(false, $this->isVereador, $this->isProfessor);
            }
        }

        if ($view) {
            $this->isView = true;
            $this->apps = $this::getAplicativos(true);
            $this::Entidades();
        }

        // Substitua ENTIDADE por 0 ou outra lógica desejada
        if ((int) 0 !== 0) { 
            $this->entidade = $this->_auth->entidade = $this::getEntidade(0);
        }
    }


    function geraProtocolo($num = 8) {
        $P = strtoupper(geraSenha($num));
        $this->db->where('protocolo', $P);
        if( !$this->db->get('ouvidoria') ) {
            $this->db->where('protocolo', $P);
            if( !$this->db->get('esic') ) {
                return $P;
            } else {
                return $this::geraProtocolo();
            }
        } else {
            return $this::geraProtocolo();
        }
    }

    function Ajuda(){
        $alvos = array(
            'usuarios',
            'entidades',
            'setup',
            'plataforma'
            );
        $this->db->where('app', $alvos, 'IN');
        if ( $ajuda = $this->db->ObjectBuilder()->get('app_aplicativos_ajuda') ) {
            $ajudas = (object) null;
            foreach($ajuda as $a) {
                $ajudas->{$a->app} = $a->ajuda;
            }
            return $this->ajuda = $ajudas;
        } else {
            return false;
        }
    }

    ##### SET and GET { ######
    function setUsuario($value) {
        $this->_usuario = $value;
    }
    function setSessao($value) {
        $this->_sessao = $value;
    }
    function setSenha($value) {
        $this->_senha = $value;
    }
    function setChave($value) {
        $this->_chave = $value;
    }
    function setSalvar($value) {
        $this->_salvar = $value;
    }
    function getUsuarios() {
        if(!$this->_auth->_admin) { $this->db->where('_admin', 0); }
        return $this->db->ObjectBuilder()->get('app_usuarios');
    }
    function getUsuario($VAR) {
        $this->db->where('usuario', $VAR);
        $this->db->orWhere('ID', $VAR);
        return $this->db->ObjectBuilder()->getOne('app_usuarios');
    }
    function getUsuarioPerfil($login) {
        $this->db->where('usuario', $login);
        $this->db->orWhere('ID', $VAR);
        $u = $this->db->ObjectBuilder()->getOne('app_usuarios');
        if($this->_auth->_admin OR $this->_auth->_gerente OR ($this->_auth->usuario->ID == $u->ID)) {
            return $u;
        } else {
            return false;
        }
    }
    function getPermissoes($ID = null) {
        $ID = $ID ?? $this->_usuario->ID;
        $this->db->where('p.usuario', $ID);
        $this->db->groupBy('s.id');
        $this->db->join('app_aplicativos s', 's.id = p.aplicativo', 'INNER');
        $r = $this->db->getValue('app_permissoes p', 's.nome', null);
        return $r;
    }

    function getUsuarioID($ID) {
        $this->db->where('ID', $ID);
        return $this->db->ObjectBuilder()->getOne('app_usuarios');
    }

    ###########################
    ##### SETUP { #############
        PRIVATE function Setup() {
            if ( $this->setup = $this->db->ObjectBuilder()->getOne('app_setup') ) {

                if (!defined('BLOQUEIO')) define('BLOQUEIO', 1);
                if (!defined('TEMPO')) define('TEMPO', 3600);
                if (!defined('AUTOCONECTAR')) define('AUTOCONECTAR', true);
                if (!defined('HD')) define('HD', '/caminho/hd');
                if (!defined('APLICATIVOS')) define('APLICATIVOS', '/caminho/apps');
                if (!defined('EMAIL')) define('EMAIL', 'contato@dominio.com');
                if (!defined('EMAIL_NOME')) define('EMAIL_NOME', 'Nome do Site');
                if (!defined('EMAIL_HOST')) define('EMAIL_HOST', 'smtp.dominio.com');
                if (!defined('EMAIL_LOGIN')) define('EMAIL_LOGIN', 'login@dominio.com');
                if (!defined('EMAIL_SENHA')) define('EMAIL_SENHA', 'senha123');
                if (!defined('EMAIL_PORTA')) define('EMAIL_PORTA', 587);
                if (!defined('SITE_URL')) define('SITE_URL', 'https://www.dominio.com');
                if (!defined('LIMITE_CAPA')) define('LIMITE_CAPA', 5);
            } else {
                return false;
            }
        }
    ###### }

    ###########################
    ##### ENTIDADES { #########
        function Entidades($usuario = false, $ID = false) {
            // Todas as Entidades
            if ($usuario === true) {
                $this->db->groupBy('e.id');
                if($ID) { $this->db->where('id', $ID); }
                $entidades = $this->db->ObjectBuilder()->get('app_entidades e');
                return $entidades;
            
            } else if ($ID != false) {
                $this->db->join('app_permissoes p', 'p.entidade = '.$ID.' AND p.usuario = '.$usuario, 'INNER');
                $this->db->join('app_entidades_aplicativos es', 'es.aplicativo = p.aplicativo AND e.id = es.entidade', 'INNER');
                $this->db->groupBy('e.id');
                $entidades = $this->db->ObjectBuilder()->get('app_entidades e', null, 'e.*');
                $this->entidades = $entidades;
                if( count($entidades) > 0 ) {
                    $entidade = null;
                    foreach($entidades as $e) { 
                        if($e->id == $ID) {
                            $entidade = $e;
                        }
                     }
                    return $entidade;
                } else {
                    return null;
                }
            
             } else if ($this->isView) {
                $p = $this->db->subQuery('p');
                $p->groupBy('entidade');
                $p->groupBy('aplicativo');
                $p->get('app_permissoes', null, 'entidade, aplicativo');

                $p2 = $this->db->subQuery('es');
                $p2->groupBy('entidade');
                $p2->groupBy('aplicativo');
                $p2->get('app_entidades_aplicativos', null, 'entidade, aplicativo');

                $this->db->join($p, 'p.entidade = e.id', 'INNER');
                $this->db->join($p2, 'es.aplicativo = p.aplicativo AND e.id = es.entidade', 'INNER');
                $this->db->orderBy('e.matriz', 'DESC');
                $this->db->orderBy('e.nome', 'ASC');
                $this->db->groupBy('p.entidade');
                $this->db->groupBy('e.id');
                $entidades = $this->db->ObjectBuilder()->get('app_entidades e', null, 'e.*');
                $this->entidades = $entidades;

                if (count($entidades)) { // Seleção Automática (APENAS 1 ENTIDADE)
                    if (!$this->_auth) {
                        $this->_auth = (object) array(); // Inicializa $this->_auth como objeto vazio
                    }
                    $this->_auth->entidade = $this->entidade = $entidades[0]; // Linha 216
                    return $this->entidades = $entidades;
                } else {
                    return null;
                }

            } else {
                $this->db->join('app_permissoes p', 'p.entidade = e.id AND p.usuario = '.$usuario, 'INNER');
                $this->db->join('app_entidades_aplicativos es', 'es.aplicativo = p.aplicativo AND e.id = es.entidade', 'INNER');
                $this->db->groupBy('e.id');
                $entidades = $this->db->ObjectBuilder()->get('app_entidades e', null, 'e.*');
                $this->entidades = $entidades;
                if(count($entidades) == 1) { // Seleção Automática (APENAS 1 ENTIDADE);
                    return $entidades[0];
                } else if (count($entidades) > 1) {
                    $this->entidades = $entidades;
                    return null;
                } else {
                    return null;
                }
            }
        }

        function getEntidadesADMT() {
            $t = $this->db->subQuery('t');
                $t->groupBy('entidade');
                $t->get('transparencia', null, 'entidade, id');
                $this->db->join($t, 't.entidade = en.id', 'LEFT');

            $t = $this->db->subQuery('tl');
                $t->groupBy('entidade');
                $t->get('transparencia_externo', null, 'entidade, id');
                $this->db->join($t, 'tl.entidade = en.id', 'LEFT');

            $c = $this->db->subQuery('c');
                $c->groupBy('entidade');
                $c->get('concursos', null, 'entidade, id');
                $this->db->join($c, 'c.entidade = en.id', 'LEFT');

            $e = $this->db->subQuery('e');
                $e->groupBy('entidade');
                $e->get('engenharia', null, 'entidade, id');
                $this->db->join($e, 'e.entidade = en.id', 'LEFT');

            $d = $this->db->subQuery('d');
                $d->groupBy('entidade');
                $d->get('diariooficial', null, 'entidade, id');
                $this->db->join($d, 'd.entidade = en.id', 'LEFT');

            $es = $this->db->subQuery('es');
                $es->groupBy('entidade');
                $es->get('esic', null, 'entidade, id');
                $this->db->join($es, 'es.entidade = en.id', 'LEFT');

            $fc = $this->db->subQuery('fc');
                $fc->groupBy('entidade');
                $fc->get('faleconosco', null, 'entidade, id');
                $this->db->join($fc, 'fc.entidade = en.id', 'LEFT');

            $f = $this->db->subQuery('f');
                $f->groupBy('entidade');
                $f->get('faq', null, 'entidade, id');
                $this->db->join($f, 'f.entidade = en.id', 'LEFT');

            $l = $this->db->subQuery('l');
                $l->groupBy('entidade');
                $l->get('licitacoes', null, 'entidade, id');
                $this->db->join($l, 'l.entidade = en.id', 'LEFT');

            $o = $this->db->subQuery('o');
                $o->groupBy('entidade');
                $o->get('ouvidoria', null, 'entidade, id');
                $this->db->join($o, 'o.entidade = en.id', 'LEFT');

            $p = $this->db->subQuery('p');
                $p->groupBy('entidade');
                $p->get('protocolo', null, 'entidade, id');
                $this->db->join($p, 'p.entidade = en.id', 'LEFT');

            $this->db->groupBy('en.ID');
            $this->db->orderBy('en.matriz', 'DESC');
            $this->db->orderBy('en.nome', 'ASC');
            $list = $this->db->ObjectBuilder()->get('app_entidades en', null, 'en.*,
                (
                CASE tl.id
                    WHEN NULL
                        THEN t.id
                    ELSE tl.id
                    END
                ) AS transparencia,
                c.id as concursos,
                e.id as engenharia,
                d.id as diario,
                es.id as esic,
                fc.id as faleconosco,
                f.id as faq,
                l.id as licitacoes,
                o.id as ouvidoria,
                p.id as protocolo');
            $modulos = array('transparencia', 'concursos', 'engenharia', 'diario', 'esic', 'faleconosco', 'faq', 'licitacoes', 'ouvidoria', 'protocolo');
            foreach($list as $e) {
                foreach ($modulos as $m) {
                    if($e->{$m} != null) {
                        $e->{'modulos'}[] = $m;
                    }
                }
                $E[$e->id] = $e;
            }
            return $E;
        }

        function getEntidadesAPP($app) {
            $this->db->join('app_aplicativos a', 'a.tag = "'.$app.'"', 'INNER');
            $this->db->join('app_permissoes p', 'p.aplicativo = a.id AND p.entidade = e.id', 'INNER');
            $this->db->join('app_entidades_aplicativos es', 'es.aplicativo = p.aplicativo AND e.id = es.entidade', 'INNER');
            $this->db->groupBy('e.id, a.id');
            $this->db->having('id_app');
            $entidadess = $this->db->ObjectBuilder()->get('app_entidades e', null, 'e.*, a.id as id_app');
            foreach ($entidadess as $e) {
                $entidades[$e->id] = $e;
            }
            return $entidades;
        }
        function getAnosAPP($app, $ID = false) {
            if($ID) {
                $this->db->where("entidade = '$ID' ");
            }
            $this->db->OrderBy('ano', 'desc');
            if ($return = $this->db->ObjectBuilder()->get($app, null, 'DISTINCT YEAR(data) as ano')) {
                foreach($return as $tag => $ano) {
                    $anos[$ano->ano] = $ano->ano;
                }
                return $anos;
            } else {
                return false;
            }
        }
        

        function getEntidadesTransp() {
            $t = $this->db->subQuery('t');
                $t->groupBy('entidade');
                $t->get('transparencia', null, 'entidade, id');
            $this->db->join('app_permissoes p', 'p.entidade = e.id', 'INNER');
            $this->db->join('app_entidades_aplicativos es', 'es.aplicativo = p.aplicativo AND e.id = es.entidade', 'INNER');
            $this->db->join($t, 't.entidade = e.id', 'INNER');
            $this->db->groupBy('e.id');
            $entidadess = $this->db->ObjectBuilder()->get('app_entidades e', null, 'e.*');
            foreach ($entidadess as $e) {
                $entidades[$e->id] = $e;
            }
            return $entidades;
        }

        function getAnosTransp($ID = false, $grupo = false, $secao = false) {
            if($ID) {
                $this->db->where("entidade = '$ID' ");
            }
            $this->db->OrderBy('ano', 'desc');
            if ($return = $this->db->ObjectBuilder()->get('transparencia', null, 'DISTINCT exercicio as ano')) {
                foreach($return as $tag => $ano) {
                    $anos[$ano->ano] = $ano->ano;
                }
                return $anos;
            } else {
                return false;
            }
        }

        function getAnosLicit($ID = false) {
            $this->db->join('licitacoes_entidades e', 'e.licitacao = l.id', 'LEFT');
            if($ID) {
                $this->db->where('(l.entidade = '.$ID.' OR e.entidade = '.$ID.')');
            }
            $this->db->OrderBy('ano', 'desc');
            if ($return = $this->db->ObjectBuilder()->get('licitacoes l', null, 'DISTINCT YEAR(l.data) as ano')) {
                foreach($return as $tag => $ano) {
                    $anos[$ano->ano] = $ano->ano;
                }
                return $anos;
            } else {
                return false;
            }
        }

        function getMesesLicit($ID = false) {
            if($ID) {
                $this->db->where("entidade = '$ID' ");
            }
            $this->db->OrderBy('ano', 'desc');
            $this->db->OrderBy('mes', 'asc');
            $this->db->GroupBy('ano');
            $this->db->GroupBy('mes');
            if ($return = $this->db->ObjectBuilder()->get('licitacoes', null, 'DISTINCT YEAR(data) as ano, MONTH(data) as mes')) {
                $_meses[1] = 'Janeiro';
                $_meses[2] = 'Fevereiro';
                $_meses[3] = 'Março';
                $_meses[4] = 'Abril';
                $_meses[5] = 'Maio';
                $_meses[6] = 'Junho';
                $_meses[7] = 'Julho';
                $_meses[8] = 'Agosto';
                $_meses[9] = 'Setembro';
                $_meses[10] = 'Outubro';
                $_meses[11] = 'Novembro';
                $_meses[12] = 'Dezembro';
                foreach($return as $mes) {
                    $meses[$mes->ano][$mes->mes] = (object) array(
                        'id' => $mes->mes,
                        'mes' => $_meses[$mes->mes],
                    );
                }
                return $meses;
            } else {
                return false;
            }
        }
        
        function getEntidadesLicit() {
            $this->db->join('app_permissoes p', 'p.entidade = e.id', 'INNER');
            $this->db->join('app_entidades_aplicativos es', 'es.aplicativo = p.aplicativo AND e.id = es.entidade', 'INNER');
            $this->db->join('licitacoes t', 't.entidade = e.id', 'INNER');
            $this->db->groupBy('e.id');
            $entidadess = $this->db->ObjectBuilder()->get('app_entidades e', null, 'e.*');
            foreach ($entidadess as $e) {
                $entidades[$e->id] = $e;
            }
            return $entidades;
        }

        function getAnosConc($ID = false) {
            if($ID) {
                $this->db->where("entidade = '$ID' ");
            }
            $this->db->OrderBy('ano', 'desc');
            if ($return = $this->db->ObjectBuilder()->get('concursos', null, 'DISTINCT YEAR(data) as ano')) {
                foreach($return as $tag => $ano) {
                    $anos[$ano->ano] = $ano->ano;
                }
                return $anos;
            } else {
                return false;
            }
        }
        function getEntidadesConc() {
            $this->db->join('app_permissoes p', 'p.entidade = e.id', 'INNER');
            $this->db->join('app_entidades_aplicativos es', 'es.aplicativo = p.aplicativo AND e.id = es.entidade', 'INNER');
            $this->db->join('concursos t', 't.entidade = e.id', 'INNER');
            $this->db->groupBy('e.id');
            $entidadess = $this->db->ObjectBuilder()->get('app_entidades e', null, 'e.*');
            foreach ($entidadess as $e) {
                $entidades[$e->id] = $e;
            }
            return $entidades;
        }

        function getAnosNot($ID = false) {
            if($ID) {
                $this->db->where("entidade = '$ID' ");
            }
            $this->db->OrderBy('ano', 'desc');
            if ($return = $this->db->ObjectBuilder()->get('noticias', null, 'DISTINCT YEAR(data) as ano')) {
                foreach($return as $tag => $ano) {
                    $anos[$ano->ano] = $ano->ano;
                }
                return $anos;
            } else {
                return false;
            }
        }
        function getEntidadesNot() {
            $this->db->join('app_permissoes p', 'p.entidade = e.id', 'INNER');
            $this->db->join('app_entidades_aplicativos es', 'es.aplicativo = p.aplicativo AND e.id = es.entidade', 'INNER');
            $this->db->join('noticias n', 'n.entidade = e.id', 'INNER');
            $this->db->groupBy('e.id');
            $entidadess = $this->db->ObjectBuilder()->get('app_entidades e', null, 'e.*');
            foreach ($entidadess as $e) {
                $entidades[$e->id] = $e;
            }
            return $entidades;
        }

        function getEntidadesFAQ() {
            $this->db->join('app_permissoes p', 'p.entidade = e.id', 'INNER');
            $this->db->join('app_entidades_aplicativos es', 'es.aplicativo = p.aplicativo AND e.id = es.entidade', 'INNER');
            $this->db->join('faq f', 'f.entidade = e.id', 'INNER');
            $this->db->groupBy('e.id');
            $entidadess = $this->db->ObjectBuilder()->get('app_entidades e', null, 'e.*');
            foreach ($entidadess as $e) {
                $entidades[$e->id] = $e;
            }
            return $entidades;
        }

        function getAnosDiario($ID = false) {
            if($ID) {
                $this->db->where("entidade = '$ID' ");
            }
            $this->db->OrderBy('ano', 'desc');
            if ($return = $this->db->ObjectBuilder()->get('diariooficial', null, 'DISTINCT YEAR(data) as ano')) {
                foreach($return as $tag => $ano) {
                    $anos[$ano->ano] = $ano->ano;
                }
                return $anos;
            } else {
                return false;
            }
        }
        function getEntidadesDiario() {
            $this->db->join('app_permissoes p', 'p.entidade = e.id', 'INNER');
            $this->db->join('app_entidades_aplicativos es', 'es.aplicativo = p.aplicativo AND e.id = es.entidade', 'INNER');
            $this->db->join('diariooficial t', 't.entidade = e.id', 'INNER');
            $this->db->groupBy('e.id');
            $entidadess = $this->db->ObjectBuilder()->get('app_entidades e', null, 'e.*');
            foreach ($entidadess as $e) {
                $entidades[$e->id] = $e;
            }
            return $entidades;
        }
        function getEntidadesEngenharia() {
            $this->db->join('app_permissoes p', 'p.entidade = e.id', 'INNER');
            $this->db->join('app_entidades_aplicativos es', 'es.aplicativo = p.aplicativo AND e.id = es.entidade', 'INNER');
            $this->db->join('engenharia t', 't.entidade = e.id', 'INNER');
            $this->db->groupBy('e.id');
            $entidadess = $this->db->ObjectBuilder()->get('app_entidades e', null, 'e.*');
            foreach ($entidadess as $e) {
                $entidades[$e->id] = $e;
            }
            return $entidades;
        }

        function getAnosAgenda($ID = false) {
            if($ID) {
                $this->db->where("entidade = '$ID' ");
            }
            $this->db->OrderBy('ano', 'desc');
            if ($return = $this->db->ObjectBuilder()->get('agenda', null, 'DISTINCT YEAR(data) as ano')) {
                foreach($return as $tag => $ano) {
                    $anos[$ano->ano] = $ano->ano;
                }
                return $anos;
            } else {
                return false;
            }
        }
        function getAnosEngenharia($ID = false) {
            if($ID) {
                $this->db->where("entidade = '$ID' ");
            }
            $this->db->OrderBy('ano', 'desc');
            if ($return = $this->db->ObjectBuilder()->get('engenharia', null, 'DISTINCT YEAR(data_inicio) as ano')) {
                foreach($return as $tag => $ano) {
                    $anos[$ano->ano] = $ano->ano;
                }
                return $anos;
            } else {
                return false;
            }
        }
        function getEntidadesAgenda() {
            $this->db->join('app_permissoes p', 'p.entidade = e.id', 'INNER');
            $this->db->join('app_entidades_aplicativos es', 'es.aplicativo = p.aplicativo AND e.id = es.entidade', 'INNER');
            $this->db->join('agenda a', 'a.entidade = e.id', 'INNER');
            $this->db->groupBy('e.id');
            $entidadess = $this->db->ObjectBuilder()->get('app_entidades e', null, 'e.*');
            foreach ($entidadess as $e) {
                $entidades[$e->id] = $e;
            }
            return $entidades;
        }

        function getEntidade($ID) {
            if( $E = $this::Entidades(true, $ID) ) {
                foreach($E as $e) {
                    if($e->id == $ID) {
                        return $e;
                    }
                }
                return false;
            } else {
                return false;
            }
        }
        function entidadeAplicativos($ID, $u = false) { 
            $this->db->where('e.entidade', $ID);    
            $this->db->join('app_entidades_aplicativos e', 's.id = e.aplicativo', 'INNER');
            $this->db->groupBy('s.id');
            $this->db->orderBy('s.nome', 'ASC');
            if ($u) {
                $this->db->join('app_permissoes p', 'p.usuario = '.$u.' AND p.aplicativo = s.id AND p.entidade = '.$ID, 'LEFT');
            } else {
                $this->db->join('app_permissoes p', 'p.aplicativo = s.id AND p.entidade = '.$ID, 'LEFT');
            }
            if($APP) {
                $this->db->having('s.id', $APP);
            }
            $return = $this->db->ObjectBuilder()->get('app_aplicativos s', null, 's.*, p.usuario as permissao');
            return $return;
        }
        function vMenuApp($ID) {
            if($this::entidadeAplicativos($this->_auth->entidade->id, $this->_auth->usuario->ID, $ID)) {
                return true;
            } else {
                return false;
            }
        }
        function menuEntidades() {
            $this::Entidades($this->_auth->usuario->ID);
            return $this->entidades;
        }
        function selecionaEntidade($ID) {
            if($this::getEntidade($ID)){
                $this->db->where('sessao', $this->_auth->sessao);
                $data['entidade'] = $ID;
                if ($this->db->update('app_usuarios_sessoes', $data)) {
                    return true;
                } else {
                    return false;
                }
            } else {
                return false;
            }
        }
        function resetEntidade() {
            $this->db->where('sessao', $this->_auth->sessao);
            $data['entidade'] = 0;
            $this->db->update('app_usuarios_sessoes', $data);
            setcookie('entidade#'.$this->_auth->usuario->usuario, '', -50, '/', '');
            unset($_COOKIE['entidade#'.$this->_auth->usuario->usuario]);
            $this::Auth();
        }
    ###### }

    ###########################
    ##### START APP { #########
        function startAPP($app = null) {
            $tag = $app ?? $this->_url[2];
            $pag = $this->_url[3] ?? null;
            if($this->apps->apps[$tag]) {
                if($this->db->tableExists($tag)) {
                    $this->S = $this->apps->apps[$tag];
                    $this->S->{'ajuda'} = $this::getAjuda($this->apps->apps[$tag]->ID);

                    if($this->isView) {
                        if( is_file(PATH_CRON.$this->setup->aplicativos.$this->S->tag.'/core/app.php') ) {
                            return include_once(PATH_CRON.$this->setup->aplicativos.$this->S->tag.'/core/app.php');
                        }

                        $PATH = API.$this->setup->aplicativos.$this->S->tag.'/core/app.php';
                        if( is_file($PATH) ) {
                            $isView = true;
                            return include_once($PATH);
                        } else {
                            return (object) array('erro' =>'O Aplicativo <b>'.$this->apps->apps[$tag]->nome.'</b> não pode ser iniciado.');
                        }
                    } else {
                        return $this->S;
                    }

                } else {
                    return (object) array('erro' =>'O Aplicativo <b>'.$this->apps->apps[$tag]->nome.'</b> não possui banco de dados instalado.');
                }
            } else if ($this->auth) {
                return (object) array('erro' =>'O Aplicativo solicitado não existe ou não está instalado.');
            }
        }
    ###### }

    ###########################
    ##### AJUDA APP { #########
        function getAjuda($app) {
            $this->db->where('app', $app);
            return $this->db->ObjectBuilder()->getOne('app_aplicativos_ajuda');
        }

        function atualizarAjuda($app, $ajuda) {
            $AJUDA = $this::getAjuda($app);
            $data['ajuda'] = $ajuda;

            if ($AJUDA) {
                $this->db->where('app', $app);
                if ($this->db->update('app_aplicativos_ajuda', $data)) {
                    return true;
                }
            } else {
                $data['app'] = $app;
                if ($this->db->insert('app_aplicativos_ajuda', $data)) {
                    return true;
                }
            }
            return false;
        }
    ###### }




    ###########################
    ##### EMAIL { #############
        function startEmail() {
            ##### PHP MAILER;
            if($this->isView) {
                if( is_file(PATH_CRON.'app/core/PHPMailer/PHPMailerAutoload.php') ) {
                    include (PATH_CRON.'app/core/PHPMailer/PHPMailerAutoload.php');
                } else {
                    include (API.'app/core/PHPMailer/PHPMailerAutoload.php');
                }
            } else {
                include ('app/core/PHPMailer/PHPMailerAutoload.php');
            }
            $this->email = new PHPMailer;
                $this->email->isSMTP();
                $this->email->Host = EMAIL_HOST;
                $this->email->SMTPAuth = true;
                $this->email->Username = EMAIL_LOGIN;
                $this->email->Password = EMAIL_SENHA;
                $this->email->SMTPSecure = 'tls'; // ssl / tls
                $this->email->Port = EMAIL_PORTA;
                $this->email->setFrom(EMAIL, EMAIL_NOME);
        }
    ###### }

    ###########################
    ##### ENVIA SENHA { #######
        function enviarSenha($usuario, $token) {
            if (!$this->email) { $this->startEmail(); }
            ## E-mail do Usuário
            $this->email->addAddress($usuario->email, $usuario->nome);
            ### Assunto / Mensagem:
            $this->email->Subject = 'Recuperar Senha - JP Web!';
            $this->email->Body    = 'Olá, '.$usuario->nome.'<br>';
            $this->email->Body    .= '<br>Você solicitou um token para recuperação de senha em nossa plataforma.<br>';
            $this->email->Body    .= '<br>Para alterar sua senha basta clicar no link abaixo:<br><br>';
            $this->email->Body    .= '<a href="'.SITE_URL.'recuperar-senha/'.$token.'"> Alterar minha senha!</a>';
            $this->email->isHTML(true);

            if(@$this->email->send()) {
                return true;
            } else {
                return false;
            }
        }
    ###### }

    ###########################
    ##### ENVIA CONVITE { #####
        function enviarConvite($dados) { $dados = (object) $dados;
            if (!$this->email) { $this->startEmail(); }
            ## E-mail do Usuário
            $this->email->addAddress($dados->email, $dados->nome);
            ### Assunto / Mensagem:
            $this->email->Subject = 'Conclua seu cadastro!';
            $this->email->Body    = 'Olá, '.$dados->nome.'<br>';
            if ($dados->tipo == 1) {
                $this->email->Body    .= '<br>Você acaba de receber um convite para se inscrever no portal JP Web!<br>';
            } else if ($dados->tipo == 2) {
                $this->email->Body    .= '<br>Você acaba de receber um convite para se juntar à equipe de gerenciadores da JP Web!<br>';
            } else if ($dados->tipo == 3) {
                $this->email->Body    .= '<br>Você acaba de receber um convite para se juntar à equipe de administradores da plataforma JP Web!<br>';
            }
            $this->email->Body    .= '<br>Para aceitar o convite, clique no link abaixo:<br><br>';
            $this->email->Body    .= '<a href="'.SITE_URL.'convite/'.$dados->codigo.'"> Vamos lá!</a>';
            $this->email->isHTML(true);


            if(@$this->email->send()) {
                return true;
            } else {
                return false;
            }
        }
    ###### }

    ###########################
    ##### VALIDA CONVITE { ####
        function validaConvite($codigo) {
            $this->db->where('c.codigo', $codigo);
            $this->db->join('app_usuarios u', 'u.email = c.email', 'LEFT');
            $this->db->where('u.id IS NULL');
            return @$this->db->ObjectBuilder()->get('app_convites c', null, 'c.*, u.id as usuario')[0];
        }
    ###### }

    ###########################
    ##### VALIDA TOKEN { ######
        function validaToken($token) {
            $this->db->where('r.token', $token);
            $this->db->where('r.data', array( date("Y-m-d H:i:s", strtotime("-1 day")), date("Y-m-d H:i:s")), 'BETWEEN');
            $this->db->join('app_usuarios u', 'r.usuario = u.id', 'INNER');
            return $this->db->ObjectBuilder()->get('app_recuperacao r', null, 'u.*, r.token as token,  r.id as token_id')[0];
        }
    ###### }

    ###########################
    ##### ENVIA PROTOCOLO { ###
        function enviarProtocolo($dados, $link) { $dados = (object) $dados;
            if (!$this->email) { $this->startEmail(); }
            ## E-mail do Usuário
            $this->email->addAddress($usuario->email, $usuario->nome);
            ### Assunto / Mensagem:
            $this->email->Subject = 'Protocolo Gerado - JP Web!';
            $this->email->Body    = 'Olá, '.$dados->nome.'<br>';
            $this->email->Body    .= '<br>Sua solicitação foi recebida com sucesso!<br>';
            $this->email->Body    .= 'Você pode acompanhá-la pelo protocolo a seguir:<br><br>';
            $this->email->Body    .= '<b>'.$dados->PROTOCOLO.'</b><br><br>';
            $this->email->Body    .= '<br>Ou acessando diretamente pelo link abaixo:<br><br>';
            $this->email->Body    .= '<a href="'.$link.'/'.$dados->protocolo.'"> Acompanhar Solicitação</a>';
            $this->email->isHTML(true);

            if(@$this->email->send()) {
                return true;
            } else {
                return false;
            }
        }
        function enviarMsgProtocolo($dados, $link) { $dados = (object) $dados;
            if (!$this->email) { $this->startEmail(); }
            ## E-mail do Usuário
            $this->email->addAddress($usuario->email, $usuario->nome);
            ### Assunto / Mensagem:
            $this->email->Subject = 'Protocolo Gerado - JP Web!';
            $this->email->Body    = 'Olá, '.$dados->nome.'<br>';
            $this->email->Body    .= '<br>Sua solicitação foi atualizada!<br>';
            $this->email->Body    .= 'Você pode acompanhá-la pelo protocolo a seguir:<br><br>';
            $this->email->Body    .= '<b>'.$dados->PROTOCOLO.'</b><br><br>';
            $this->email->Body    .= '<br>Ou acessando diretamente pelo link abaixo:<br><br>';
            $this->email->Body    .= '<a href="'.$link.'/'.$dados->protocolo.'"> Acompanhar Solicitação</a>';
            $this->email->isHTML(true);

            if(@$this->email->send()) {
                return true;
            } else {
                return false;
            }
        }
    ###### }


    ####################
    ##### LOGIN { ######    
        PUBLIC function newLogin($usuario = false, $senha = false, $time = false) {
            $this->_sessao = geraSenha(60);
            $this->_chave = geraSenha(20);
        }

        // Consulta Usuário
        PRIVATE function cUsuario() {
            // Inicia conexão
            $this->db->where('usuario', $this->_usuario);
            $this->db->orWhere('email', $this->_usuario);
            $user = $this->db->getOne('app_usuarios');
            if($user) {         
                return  $this->_infoLogin = (object) $user;
            } else {
                return false;
            }
        }

        // Consulta LOGIN
        PRIVATE function cLogin($var = false) {
            // Inicia conexão
            $this->db->where('usuario', $this->_usuario);
            $this->db->orWhere('email', $this->_usuario);
            $user = $this->db->getOne('app_usuarios');
            if($user) {         
                return $this->_infoLogin = (object) $user;
            } else {
                // Consulta Vereadores
                if ($this->db->tableExists('vereadores')) {
                    if($ver = $this::cVereador($this->_usuario)) {
                        return $ver;
                    }
                }
                // Consulta Professores
                if ($this->db->tableExists('ead_professores')) {
                    if($prof = $this::cProfessor($this->_usuario)) {
                        return $prof;
                    }
                }
                // Consulta Bloqueio
                if ($this::cBloqueio()->registros < BLOQUEIO) {
                    $this::regLogin(null, 0);
                } else {
                    $this::regLogin(null, 3);
                }
            }
        }

        PRIVATE function cVereador($var = false) {
            // Inicia conexão
            $this->db->where('usuario', $this->_usuario);
            $user = $this->db->getOne('vereadores', 'id as ID, usuario, nome, senha, status, 0 as _gerente, 0 as _admin, entidade');
            if($user) {         
                $this->_vereador = true;
                return  $this->_infoLogin = (object) $user;
            }
            return;
        }

        PRIVATE function cProfessor($var = false) {
            // Inicia conexão
            $this->db->where('usuario', $this->_usuario);
            $user = $this->db->getOne('ead_professores', 'id as ID, usuario, nome, senha, status, 0 as _gerente, 0 as _admin, entidade');
            if($user) {         
                $this->_professor = true;
                return  $this->_infoLogin = (object) $user;
            }
            return;
        }

        // Consulta Bloqueio
        PRIVATE function cBloqueio() {
            $ID = $this->_infoLogin->ID;

            $data = date("Y-m-d H:i:s", strtotime("-".TEMPO." minutes"));
            $data2 = date("Y-m-d H:i:s");
            $infos = array($ID, $this->IP, $data, $data2);

            $query = "SELECT usuario, ip, data FROM app_usuarios_sessoes WHERE (usuario = ? OR ip = ?) AND (status IN(0,2)) AND  data BETWEEN ? AND ? ORDER BY data DESC
            ";
            $registros = $this->db->rawQuery($query, $infos);
            

            if(count($registros)) {
                $tempo1 = new DateTime($registros[0][data]);
                $tempo = $tempo1->diff( new DateTime("-".TEMPO." minutes"));
                $diff = str_pad($tempo->i, 2, 0, STR_PAD_LEFT).':'.str_pad($tempo->s, 2, 0, STR_PAD_LEFT);
            }       
            $return = (object) array( 
                'registros' => @count($registros),
                'tempo' => $diff ?? null,
            );
            return $this->_registro = (object) $return;
        }

        PRIVATE function cSenha($senha)  {
            if((Bcrypt::check($senha, $this->_infoLogin->senha)) == true) {
                return true;
            } else {
                return false;
            }
        }

        // Registro Login
         PRIVATE function regLogin($status, $ID = null, $timeout = null) {               
            if ($status === 1) {
                $salvar = $this->setup->salvar_tempo;
                if ($timeout) {
                    $data = Array (
                        'usuario' => $ID,
                        'status' => $status,
                        'situacao' => 1,
                        'ip' => $this->IP,
                        'browser' => $_SERVER["HTTP_USER_AGENT"],
                        'sessao' => $this->_sessao,
                        'chave' => $this->_chave,
                        'timeout' => date("Y-m-d H:i:s", strtotime("+ $salvar days"))
                    );
                } else {
                    $data = Array (
                        'usuario' => $ID,
                        'status' => $status,
                        'situacao' => 1,
                        'ip' => $this->IP,
                        'browser' => $_SERVER["HTTP_USER_AGENT"],
                        'sessao' => $this->_sessao,
                        'chave' => $this->_chave,
                    );
                }
                
            } else {
                $data = Array (
                    'usuario' => $ID,
                    'status' => $status,
                    'situacao' => 0,
                    'ip' => $this->IP,
                    'browser' => $_SERVER["HTTP_USER_AGENT"],
                    'sessao' => NULL,
                    'chave' => NULL,
                    'timeout' => NULL
                );
            }
            $this->db->insert ('app_usuarios_sessoes', $data);
            $this::cBloqueio();
        }

        // Login
        PUBLIC function Login($Print = true) {
            if(!$this::cLogin($this->_usuario)) {
                ## Consulta Bloqueio
                if($this::cBloqueio($this->_infoLogin->ID)->registros >= BLOQUEIO) {
                    $return = array(
                        'success' => false,
                        'titulo' => 'Oops! Que chato!',
                        'msg' => 'Este terminal ou usuário está bloquedo por várias tentativas mal suscedidade de login. <b>Você poderá tentar novamente em '.$this->_registro->tempo.' minutos</b>',
                        'mtipo' => 'error',
                    );

                } else {
                    $return = array(
                        'success' => false,
                        'titulo' => 'Usuário Inválido',
                        'msg' => 'Não conseguimos identificar este usuário.',
                        'clear' => 'usuario',
                        'focus' => 'usuario',
                        'mtipo' => 'error',
                    );
                }
                if(empty(session_name())) { session_destroy(); }

            ## Bloqueio
            } else if ($this::cBloqueio($this->_infoLogin->ID)->registros >= BLOQUEIO) {
                $return = array(
                    'success' => false,
                    'titulo' => 'Oops! Que chato!',
                    'msg' => 'Este terminal ou usuário está bloquedo por várias tentativas mal suscedidade de login.<br><br>Você poderá tentar novamente em '.$this->_registro->tempo.' minutos',
                    'reset' => '.form-login',
                    'mtipo' => 'error',
                    );

                $this::regLogin($this->_infoLogin->ID, 3);
                if(empty(session_name())) { session_destroy(); }

            ## Liberado de Bloqueio e Login
            } else {
                ## Senha Correta
                if ($this::cSenha($this->_senha) === true) {

                    if($this->_infoLogin->status == 0) {
                        $return = array(
                            'success' => false,
                            'icone' => 'si si-user-unfollow fa-2x',
                            'titulo' => 'Oops! Que chato!',
                            'msg' => 'Esta conta está inativa ou bloqueada. Para maiores informações entre em contato conosco.',
                            'mtipo' => 'error', 
                        );

                        $this::regLogin($this->_infoLogin->ID, 3);

                    } else {

                        $return = array(
                            'success' => true,
                            'titulo' => 'Bem Vindo, '.$this->_infoLogin->nome,
                            'msg' => 'Você será redirecionado em instantes.',
                            'href' => DIR,
                            'mtipo' => 'info',
                        );
                        
                        $usuario = $this->_usuario;
                        $sessao = $this->_sessao;
                        $chave = $this->_chave;

                        if(empty(session_name())) { session_destroy(); }
                        session_start();
                        $entidade = $this::Entidades($this->_infoLogin->ID);

                        if($entidade) { $_SESSION['entidade'] = $entidade; }
                        $_SESSION['usuario'] = $usuario;
                        $_SESSION['sessao'] = $sessao;
                        $_SESSION['chave'] = $chave;


                        if($this->_salvar) {
                            setcookie('usuario', $usuario, (time() + ($this->_salvar * 24 * 3600)), '/', '');
                            setcookie('vereador', (int) $this->_vereador, (time() + ($this->_salvar * 24 * 3600)), '/', '');
                            setcookie('professor', (int) $this->_professor, (time() + ($this->_salvar * 24 * 3600)), '/', '');
                            setcookie('sessao', $sessao, (time() + ($this->_salvar * 24 * 3600)), '/', '');
                            setcookie('chave', $chave, (time() + ($this->_salvar * 24 * 3600)), '/', '');
                        } else {
                            setcookie('usuario', $usuario, 0, '/', '');
                            setcookie('vereador', (int) $this->_vereador, 0, '/', '');
                            setcookie('professor', (int) $this->_professor, 0, '/', '');
                            setcookie('sessao', $sessao, 0, '/', '');
                            setcookie('chave', $chave, 0, '/', '');
                        }

                        $this::regLogin($this->_infoLogin->ID, 1, $this->_salvar);
                    }

                ## Senha Incorreta
                } else {
                    $this::regLogin($this->_infoLogin->ID, 2);

                    if($this->_registro->registros == 5) {
                        $bloqueio = 'Usuário bloqueado por '.BLOQUEIO.' minutos';
                    }

                    $return = array(
                        'success' => false,
                        'titulo' => $bloqueio ?? 'Senha Incorreta :/',
                        'msg' => $msg ?? 'ATENÇÃO: Você efetuou '.$this->_registro->registros.' de '.BLOQUEIO.' tentativas mal suscedidade.',
                        'focus' => 'senha',
                        'clear' => 'senha',
                        'mtipo' => 'error',
                    );
                    if(empty(session_name())) { session_destroy(); }
                }

            }
            if ($Print == true) {
                echo json_encode($return);
            }
        }
    ###### }


    ####################
    ##### LOGOUT { #####
        PUBLIC function logout() {
            $data = array('timeout' => $this->db->now(), 'situacao' => 2);

            $this->db->where('sessao', $this->_auth->sessao);
            $this->db->where('usuario', $this->_auth->usuario->ID);
            
            $logout = $this->db->update('app_usuarios_sessoes', $data);

            if($logout) {
                if($_COOKIE['entidade#'.$this->_auth->usuario->usuario]) {
                    setcookie('entidade#'.$this->_auth->usuario->usuario, '', -100, '/', '');
                }
                $return = array(
                    'success' => true,
                    'titulo' => 'Até breve!',
                    'msg' => 'Sua página será recarregada.',
                    'mtipo' => 'info',
                    'href' => 'reload'
                );
            } else {
                return $return = false;
            }
        echo json_encode($return);
    }
    ###### }


    ####################
    ##### AUTH { #######
        PUBLIC function Auth() {

            if($this->isView) {
                $this->_auth = (object) array(
                    'status' => false,
                    'entidade' => $this::Entidades()[0],
                );
            }

            if($this->_auth) { return $this->_auth; }

            $usuario = $_COOKIE['usuario'] ?? null;
            $sessao = $_COOKIE['sessao'] ?? null;
            $chave = $_COOKIE['chave'] ?? null;
            $vereador = $_COOKIE['vereador'] ?? null;
            $professor = $_COOKIE['professor'] ?? null;


            if(!isset($entidade) || !$entidade) {$entidade = property_exists($this, 'entidade') ? $this->entidade : null;}
            if(!$entidade) { $entidade = $this->entidade ?? null; }
            if(!$usuario) { $usuario = $this->_usuario ?? null; }
            if(!$sessao) { $sessao = $this->_sessao ?? null; }
            if(!$chave) { $chave = $this->_chave ?? null; }

            if($vereador && $this->db->tableExists('vereadores')) {
                $this->_usuario = $usuario;
                $vereadorID = $this::cVereador()->ID ?? 0;
                if($this->isVereador = $vereadorID) {
                    $this->_vereador = true;
                }
                $params = array($usuario, $sessao, $this->IP, $_SERVER["HTTP_USER_AGENT"]);
                $query = "SELECT u.*, u.ID as ID, r.timeout, u.entidade as entidade, r.id as sessao_id, r.sessao as sessao, r.status as sessao_status, r.data as sessao_data, r.ip as sessao_ip, r.chave as chave_sessao FROM vereadores as u INNER JOIN app_usuarios_sessoes as r ON (u.id = r.usuario) WHERE ((u.usuario = ?) AND (r.sessao = ?)) and (r.ip = ?) and (r.browser = ?) and (r.timeout IS NULL OR date(r.timeout) > NOW()) and (u.status > 0)  GROUP BY u.ID ORDER BY r.ID DESC";            
                $user = $this->db->rawQueryOne($query, $params);
            }

            if(empty($user) && $professor && $this->db->tableExists('ead_professores')) {                
                $this->_usuario = $usuario;
                $professorID = $this::cProfessor()->ID ?? 0;
                if($this->isProfessor = $professorID) {
                    $this->_professor = true;
                }               
                $params = array($usuario, $sessao, $this->IP, $_SERVER["HTTP_USER_AGENT"]);
                $query = "SELECT u.*, u.ID as ID, r.timeout, u.entidade as entidade, r.id as sessao_id, r.sessao as sessao, r.status as sessao_status, r.data as sessao_data, r.ip as sessao_ip, r.chave as chave_sessao FROM ead_professores as u INNER JOIN app_usuarios_sessoes as r ON (u.id = r.usuario) WHERE ((u.usuario = ?) AND (r.sessao = ?)) and (r.ip = ?) and (r.browser = ?) and (r.timeout IS NULL OR date(r.timeout) > NOW()) and (u.status > 0)  GROUP BY u.ID ORDER BY r.ID DESC";           
                $user = $this->db->rawQueryOne($query, $params);
            }

            if(empty($user)) {
                $params = array($usuario, $usuario, $sessao, $this->IP, $_SERVER["HTTP_USER_AGENT"]);
                $query = "SELECT u.*, r.timeout, r.entidade as entidade, r.id as sessao_id, r.sessao as sessao, r.status as sessao_status, r.data as sessao_data, r.ip as sessao_ip, r.chave as chave_sessao FROM app_usuarios as u INNER JOIN app_usuarios_sessoes as r ON (u.ID = r.usuario) WHERE ((u.usuario = ? OR u.email = ?) AND (r.sessao = ?)) and (r.ip = ?) and (r.browser = ?) and (r.timeout IS NULL OR date(r.timeout) > NOW()) and (u.status > 0)  GROUP BY u.ID ORDER BY r.ID DESC";           
                $user = $this->db->rawQueryOne($query, $params);
            }

            $entidade = $user['entidade'] ?? null;


            ## Usuário não encontrado
            if (!$user || !is_array($user) || !count($user)) {
                return null;
            ## Usuário Encontrado
            } else {                
                if (($user['status'] == 0)) {
                    return null;
                } else {
                    $this->_auth = (object)
                        array( 
                            'status' => true,
                            'sessao' => $user['sessao'],
                            'usuario' => (object) array(
                                'ID' => $user['ID'],
                                'nome' => $user['nome'],
                                'usuario' => $user['usuario'],
                                'email' => $user['email'],
                                'senha' => $user['senha'],

                                'status' => $user['status'],
                                'entidade' => $user['entidade']
                            ),
                            '_gerente' => $user['_gerente'],
                            '_admin' => $user['_admin'],
                            'entidade' => $this::Entidades($user['ID'], $entidade),
                        );
                    if($this->_vereador) {
                        $this->_auth->entidade = $this::getEntidade($user['entidade']);
                    }
                    if($this->_professor) {
                        $this->_auth->entidade = $this::getEntidade($user['entidade']);
                    }
                    return $this->_auth;
                }
            }
        }
    ###### }


    ###########################
    ##### APLICATIVOS { #######
        PUBLIC function getAplicativos($all = false, $vereadores = false, $professores = false) {
            if($all) {
                $this->db->join('app_aplicativos_grupos g', 's.grupo = g.id', 'LEFT');
                $this->db->join('app_permissoes p', '(s.id = p.aplicativo)', 'LEFT');
                $this->db->orderBy('g.ordem', 'ASC');
                $this->db->orderBy('s.nome', 'ASC');
                $this->db->groupBy('s.id');
                $app = $this->db->ObjectBuilder()->get('app_aplicativos s', null, 's.*, g.nome as grupo, g.id as grupo_ID, p.id as permissao') ?? null;
                foreach ($app as $a) {
                    $menuId = $a->id ?? $a->ID ?? null;
                    $menus = $menuId ? $this->getMenus($menuId) : [];

                    $a->{'permissoes'} = $this::getPermissoesAPP($a->ID ?? 0);
                    $return['grupos'][$a->grupo][$a->tag] = $a;
                    $return['grupos'][$a->grupo][$a->tag]->menu = $menus;
                    $return['apps'][$a->tag] = $a;
                    $return['apps'][$a->tag]->menu = $menus;
                }
                return (object) $return;
            } else if ($vereadores) {
                $this->db->join('app_aplicativos_grupos g', 's.grupo = g.id', 'LEFT');
                $this->db->join('app_permissoes p', '(s.id = p.aplicativo)', 'LEFT');
                $this->db->orderBy('g.ordem', 'ASC');
                $this->db->orderBy('s.nome', 'ASC');
                $this->db->groupBy('s.id');
                $this->db->where('s.tag', 'noticias');
                $app = $this->db->ObjectBuilder()->get('app_aplicativos s', null, 's.*, g.nome as grupo, g.id as grupo_ID, p.id as permissao') ?? null;
                foreach ($app as $a) {
                    $menus = $this->getMenus($a->id);
                    $a->{'permissoes'} = $this::getPermissoesAPP($a->ID);
                    $return['grupos'][$a->grupo][$a->tag] = $a;
                    $return['grupos'][$a->grupo][$a->tag]->menu = $menus;
                    $return['apps'][$a->tag] = $a;
                    $return['apps'][$a->tag]->menu = $menus;
                }
                return $this->apps = (object) $return;
            } else if ($professores) {
                $this->db->join('app_aplicativos_grupos g', 's.grupo = g.id', 'LEFT');
                $this->db->join('app_permissoes p', '(s.id = p.aplicativo)', 'LEFT');
                $this->db->orderBy('g.ordem', 'ASC');
                $this->db->orderBy('s.nome', 'ASC');
                $this->db->groupBy('s.id');
                $this->db->where('s.tag', 'ead');
                $app = $this->db->ObjectBuilder()->get('app_aplicativos s', null, 's.*, g.nome as grupo, g.id as grupo_ID, p.id as permissao') ?? null;
                foreach ($app as $a) {
                    $menus = $this->getMenus($a->id);
                    $a->{'permissoes'} = $this::getPermissoesAPP($a->ID);
                    $return['grupos'][$a->grupo][$a->tag] = $a;
                    $return['grupos'][$a->grupo][$a->tag]->menu = $menus;
                    $return['apps'][$a->tag] = $a;
                    $return['apps'][$a->tag]->menu = $menus;
                }
                return $this->apps = (object) $return;
            } else {
                $this->db->join('app_aplicativos_grupos g', 's.grupo = g.id', 'INNER');
                if($this->_auth->entidade->id) {
                    $this->db->join('app_permissoes p', '(s.id = p.aplicativo AND p.usuario = '.$this->_auth->usuario->ID.' AND p.entidade = '.$this->_auth->entidade->id.')', 'INNER');
                } else {
                    @$this->db->join('app_permissoes p', '(s.id = p.aplicativo AND p.usuario = '.$this->_auth->usuario->ID.')', 'INNER');
                }
                $this->db->join('app_entidades_aplicativos es', 'es.entidade = p.entidade AND es.aplicativo = s.id', 'INNER');
                $this->db->orderBy('g.ordem', 'ASC');
                $this->db->orderBy('s.nome', 'ASC');
                $this->db->groupBy('s.id');
                $this->db->where('s.status', 1);
                $app = $this->db->ObjectBuilder()->get('app_aplicativos s', null, 's.*, g.nome as grupo, g.id as grupo_ID, p.id as permissao') ?? null;
                //var_dump($this->db->getLastQuery()); die();
                foreach ($app as $a) {
                    $menus = $this->getMenus($a->ID);
                    $a->{'permissoes'} = $this::getPermissoesAPP($a->ID);
                    $return['grupos'][$a->grupo][$a->tag] = $a;
                    $return['grupos'][$a->grupo][$a->tag]->menu = $menus;
                    $return['apps'][$a->tag] = $a;
                    $return['apps'][$a->tag]->menu = $menus;
                }
                $this->apps = (object) $return;
                return $this->apps;
            }
        }

        function getPermissoesAPP($ID) {
            $this->db->where('aplicativo', $ID);
            $entidadeId = $this->_auth->entidade->id ?? 0;
            $this->db->where('entidade', $entidadeId);
            return $this->db->getValue('app_permissoes', 'count(ID)');
        }


        function getMenus($ID) {
            $this->db->where('aplicativo', $ID);
            $this->db->orderBy('setup', 'ASC');
            $this->db->orderBy('ordem', 'ASC');
            if( $menu = $this->db->ObjectBuilder()->get('app_aplicativos_menus') ) {
                return $menu;
            } else {
                return false;
            }
        }

        function vAcessoAplicativo($APP, $E) {
            $this->db->where('entidade', $E);
            $this->db->where('aplicativo', $APP);
            return count($this->db->ObjectBuilder()->get('app_entidades_aplicativos'));
        }
    ###### }


    ###########################
    ##### HISTÓRICO { #########
        function getHistorico($ID = null) {
            # Segurança
            $this->db->where('usuario', $ID ?? $this->_auth->usuario->ID);
            $this->db->OrderBy('id', 'DESC');
            $this->_historico = $this->db->ObjectBuilder()->get('app_usuarios_sessoes', 100);
            return $this->_historico;
        }
    ###### }


    ###########################
    ####### BUSCA { ###########
        function startBusca($busca, $extra = false) {
            $resultado = false;

            // Notícias
            $this->db->where("titulo LIKE '%$busca%'");
            if($extra) { $this->db->orWhere("subtitulo LIKE '%$busca%'"); }
            $this->db->where('entidade', $this->_auth->entidade->id);
            $this->db->where('status', 1);
                $resultado->{'noticias'} = $this->db->ObjectBuilder()->get('noticias');

            // Engenharia
            if ($this->db->tableExists('engenharia')) {
                $this->db->join('engenharia_arquivos a', 'a.codigo = e.codigo', 'LEFT');
                $this->db->join('engenharia_modalidades m', 'm.id = e.modalidade', 'INNER');
                $this->db->where("e.titulo LIKE '%$busca%'");
                $this->db->orWhere("e.local LIKE '%$busca%'");
                $this->db->orWhere("e.texto LIKE '%$busca%'");
                if($extra) { $this->db->orWhere("a.arquivo LIKE '%$busca%'"); }
                $this->db->GroupBy('e.id');
                $this->db->where('e.entidade', $this->_auth->entidade->id);
                    $resultado->{'engenharia'} = $this->db->ObjectBuilder()->get('engenharia e', null, 'e.*, m.nome as modalidade_nome');
            }

            // FAQ
            if ($this->db->tableExists('faq')) {
                $this->db->join('faq_secoes s', 's.id = f.secao', 'INNER');
                $this->db->where('f.status', 1);
                $this->db->where("f.pergunta LIKE '%$busca%'");
                $this->db->orWhere("f.resposta LIKE '%$busca%'");
                $this->db->GroupBy('f.id');
                $this->db->where('f.entidade', $this->_auth->entidade->id);
                    $resultado->{'faq'} = $this->db->ObjectBuilder()->get('faq f', null, 'f.*, s.nome as secao_nome');
            }

            // Downloads
            if ($this->db->tableExists('downloads')) {
                $this->db->join('downloads d', 'd.codigo = a.codigo', 'INNER');
                $this->db->join('downloads_secoes s', 'd.secao = s.id', 'INNER');
                $this->db->where("a.legenda LIKE '%$busca%'");
                if($extra) { $this->db->orWhere("a.arquivo LIKE '%$busca%'"); }
                $this->db->GroupBy('a.id');
                $this->db->where('d.entidade', $this->_auth->entidade->id);
                    $resultado->{'downloads'} = $this->db->ObjectBuilder()->get('downloads_arquivos a', null, 'a.*, s.nome as secao_nome, d.titulo');
            }

            // Áudios
            $this->db->where("titulo LIKE '%$busca%'");
            if($extra) {  $this->db->orWhere("descricao LIKE '%$busca%'"); }
            $this->db->where('entidade', $this->_auth->entidade->id);
                $resultado->{'audios'} = $this->db->ObjectBuilder()->get('audios');

            // Galerias
            $this->db->where("titulo LIKE '%$busca%'");
            if($extra) { $this->db->orWhere("descricao LIKE '%$busca%'"); }
            $this->db->where('entidade', $this->_auth->entidade->id);
                $resultado->{'galerias'} = $this->db->ObjectBuilder()->get('galerias');

            // Vídeos
            $this->db->where("titulo LIKE '%$busca%'");
            if($extra) { $this->db->orWhere("descricao LIKE '%$busca%'"); }
            $this->db->where('entidade', $this->_auth->entidade->id);
                $resultado->{'videos'} = $this->db->ObjectBuilder()->get('videos');

            // Transparência
            if ($this->db->tableExists('transparencia')) {
                $this->db->where('t.entidade', $this->_auth->entidade->id);
                $this->db->join('transparencia_grupos as g', 'g.id = t.grupo', 'LEFT');
                $this->db->join('transparencia_categorias as c', 'c.id = t.categoria', 'LEFT');
                $this->db->where("t.titulo LIKE '%$busca%'");
                if($extra) { $this->db->orWhere("t.texto LIKE '%$busca%'"); }
                    $resultado->{'transparencia'} = $this->db->ObjectBuilder()->get('transparencia t', null, 't.*, g.nome as grupo, c.nome as secao');
            }

            // Diário
            if ($this->db->tableExists('diariooficial')) {
                $this->db->where("titulo LIKE '%$busca%'");
                if($extra) { $this->db->orWhere("texto LIKE '%$busca%'"); }
                $this->db->having('entidade', $this->_auth->entidade->id);
                    $resultado->{'diario'} = $this->db->ObjectBuilder()->get('diariooficial');
            }

            // Licitações
            if ($this->db->tableExists('licitacoes')) {
                $this->db->where("titulo LIKE '%$busca%'");
                $this->db->orWhere("objeto LIKE '%$busca%'");
                if($extra) { $this->db->orWhere("descricao LIKE '%$busca%'"); }
                $this->db->where('entidade', $this->_auth->entidade->id);
                    $resultado->{'licitacoes'} = $this->db->ObjectBuilder()->get('licitacoes');
            }

            // Concursos
            if ($this->db->tableExists('concursos')) {
                $this->db->where("titulo LIKE '%$busca%'");
                if($extra) { $this->db->orWhere("texto LIKE '%$busca%'"); }
                $this->db->where('entidade', $this->_auth->entidade->id);
                    $resultado->{'concursos'} = $this->db->ObjectBuilder()->get('concursos');
            }

            // Agenda
            $this->db->where("titulo LIKE '%$busca%'");
            if($extra) { $this->db->orWhere("texto LIKE '%$busca%'"); }
            $this->db->where('entidade', $this->_auth->entidade->id);
                $resultado->{'agenda'} = $this->db->ObjectBuilder()->get('agenda');

            // Governo
            if ($this->db->tableExists('governo')) {
                $this->db->where("titulo LIKE '%$busca%'");
                $this->db->orWhere("(subtitulo LIKE '%$busca%' OR texto LIKE '%$busca%')");
                $this->db->where('entidade', $this->_auth->entidade->id);
                    $resultado->{'governo'} = $this->db->ObjectBuilder()->get('governo');
            }
            

            // Classificados
            if ($this->db->tableExists('classificados')) {
                $this->db->where("titulo LIKE '%$busca%'");
                $this->db->orWhere("(subtitulo LIKE '%$busca%' OR texto LIKE '%$busca%')");
                $this->db->where('entidade', $this->_auth->entidade->id);
                    $resultado->{'classificados'} = $this->db->ObjectBuilder()->get('classificados');
            }

        
            // Pesquisa
            if ($this->db->tableExists('pesquisas')) {
                $this->db->join('pesquisas_secoes s', 's.id = p.secao', 'INNER');
                $this->db->where('p.status', 1);
                $this->db->where("(p.titulo LIKE '%$busca%' OR p.texto LIKE '%$busca%')");
                $this->db->where('p.entidade', $this->_auth->entidade->id);
                    $resultado->{'pesquisas'} = $this->db->ObjectBuilder()->get('pesquisas p', null, 'p.*, s.nome as secao');
            }

            // Enquetes
            if ($this->db->tableExists('enquetes')) {
                $this->db->where('status', 1);
                $this->db->where("(titulo LIKE '%$busca%' or texto LIKE '%$busca%')");
                $this->db->where('entidade', $this->_auth->entidade->id);
                    $resultado->{'enquetes'} = $this->db->ObjectBuilder()->get('enquetes');
            }


            // Links
            if ($this->db->tableExists('links')) {
                $this->db->where("titulo LIKE '%$busca%'");
                $this->db->where('entidade', $this->_auth->entidade->id);
                    $resultado->{'links'} = $this->db->ObjectBuilder()->get('links');
            }

            return $resultado;

        }

    ###### }


    ###########################
    ##### AUDITORIA { #########
        function Auditoria() {
            // Categorias
            $this->db->where('c.entidade', $this->_auth->entidade->id);
            $this->db->join('transparencia_grupos g', 'c.grupo = g.id', 'INNER');
            $this->db->OrderBy('g.nome', 'ASC');
            $this->db->OrderBy('c.nome', 'ASC');
            $categorias = $this->db->ObjectBuilder()->get('transparencia_categorias c', null, 'c.*, g.nome as grupo');

            $return = (object) array('alertas' => array(), 'historico' => array());

            foreach($categorias as $c) {
                switch ($c->atualizacao) {
                    case 'Diária':
                        $time = '-1 day';
                        break;
                    
                    case 'Semanal':
                        $time = '-1 week';
                        break;
                    
                    case 'Quinzenal':
                        $time = '-15 days';
                        break;
                    
                    case 'Mensal':
                        $time = '-1 month';
                        break;
                    
                    case 'Bimestral':
                        $time = '-2 months';
                        break;
                    
                    case 'Trimestral':
                        $time = '-3 months';
                        break;
                    
                    case 'Quadrimestral':
                        $time = '-4 months';
                        break;
                    
                    case 'Semestral':
                        $time = '-6 months';
                        break;
                    
                    case 'Anual':
                        $time = '-1 year';
                        break;
                    
                    default:
                        $time = false;
                        break;
                }
                if($time) {
                    $time = (new DateTime($time))->format('Y-m-d H:i:s');

                    $this->db->where('data', $time, '>=');
                    $this->db->where('categoria', $c->id);
                    $this->db->OrderBy('data', 'DESC');
                    $this->db->where('entidade', $this->_auth->entidade->id);
                    if (!$z = $this->db->ObjectBuilder()->getOne('transparencia')) {
                        $this->db->where('categoria', $c->id);
                        $this->db->where('entidade', $this->_auth->entidade->id);
                        $this->db->orderBy('data', 'DESC');
                        $data = $this->db->ObjectBuilder()->getOne('transparencia');
                        $return->{'alertas'}[$c->grupo][] = (object) array( 'categoria'=> $c->nome, 'ultimo' => $data->data, 'titulo' => $data->titulo, 'periodo' => $c->atualizacao );
                    } else {
                        $return->{'historico'}[$c->grupo][] = (object) array( 'categoria'=> $c->nome, 'ultimo' => $z->data, 'titulo' => $z->titulo, 'periodo' => $c->atualizacao );
                    }
                } else {
                    $this->db->where('categoria', $c->id);
                    $this->db->where('entidade', $this->_auth->entidade->id);
                    $this->db->orderBy('data', 'DESC');
                    $data = $this->db->ObjectBuilder()->getOne('transparencia');
                    $return->{'historico'}[$c->grupo][] = (object) array( 'categoria'=> $c->nome, 'ultimo' => $data->data, 'titulo' => $data->titulo, 'periodo' => $c->atualizacao );
                }
            }
            return (object) $return;
        }

        function AuditoriaMensagens() {

            // Fale Conosco
            if($this->apps->apps['faleconosco']) {
                $this->db->where("resposta = '' OR resposta IS NULL");
                $this->db->where('entidade', $this->_auth->entidade->id);
                $mensagens['Fale Conosco'] = $this->db->getValue('faleconosco', 'count(id)');
            }

            $status = array('Finalizado', 'Encerrado', 'Concluído', 'Despachado', 'Respondido', 'Finalizados', 'Encerrados', 'Concluidos', 'Despachados', 'Respondidos');

            // E-Sic
            if($this->apps->apps['esic']) {
                $this->db->join('esic_respostas r', 'r.esic = e.id', 'LEFT');
                $this->db->where('r.id IS NULL');
                $this->db->join('esic_status s', 's.id = e.status', 'LEFT');
                $this->db->where('s.nome', $status, 'NOT IN');
                $this->db->where('e.entidade', $this->_auth->entidade->id);
                $mensagens['E-Sic'] = $this->db->getValue('esic e', 'count(e.id)');
            }

            // Ouvidoria
            if($this->apps->apps['ouvidoria']) {
                $this->db->join('ouvidoria_respostas r', 'r.ouvidoria = o.id', 'LEFT');
                $this->db->where('r.id IS NULL');
                $this->db->join('ouvidoria_status s', 's.id = o.status', 'LEFT');
                $this->db->where('s.nome', $status, 'NOT IN');
                $this->db->where('o.entidade', $this->_auth->entidade->id);
                $mensagens['Ouvidoria'] = $this->db->getValue('ouvidoria o', 'count(o.id)');
            }

            return $mensagens;
        }
    ###### }

    ###########################
    ##### SEÇÕES/ANO { ########
    function getSecoesAnos($app, $entidade) {
        if ($app == 'enquetes') {
            $this->db->where('e.entidade', $entidade);
            $this->db->OrderBy('YEAR(e.data)', 'DESC');
            $this->db->OrderBy('s.nome', 'ASC');
            $this->db->groupBy('s.id');
            //$this->db->groupBy('YEAR(e.data)');
            $this->db->join('enquetes_secoes s', 'e.secao = s.id', 'INNER');
            $secoes = $this->db->ObjectBuilder()->get('enquetes e', null, 'YEAR(e.data) as ano, s.nome as nome');
            return $secoes;
        } else if ($app == 'agenda') {
            $this->db->where('e.entidade', $entidade);
            $this->db->OrderBy('YEAR(e.data)', 'DESC');
            $this->db->OrderBy('s.nome', 'ASC');
            $this->db->groupBy('s.id');
            //$this->db->groupBy('YEAR(e.data)');
            $this->db->join('agenda_secoes s', 'e.secao = s.id', 'INNER');
            $secoes = $this->db->ObjectBuilder()->get('agenda e', null, 'YEAR(e.data) as ano, s.nome as nome');
            return $secoes;
        } else if($app == 'links') {
            $this->db->where('entidade', $entidade);
            $this->db->OrderBy('secao', 'ASC');
            $this->db->groupBy('secao');
            //$this->db->groupBy('YEAR(data)');
            $secoes = $this->db->ObjectBuilder()->get($app, null, 'secao as nome');
            return $secoes;
        } else {
            $this->db->where('entidade', $entidade);
            $this->db->OrderBy('YEAR(data)', 'DESC');
            $this->db->OrderBy('secao', 'ASC');
            $this->db->groupBy('secao');
            //$this->db->groupBy('YEAR(data)');
            $secoes = $this->db->ObjectBuilder()->get($app, null, 'YEAR(data) as ano, secao as nome');
            return $secoes;
        }
    }
    ###### }

    ###########################
    ##### ARQUIVOS PESQUISA { #
        function getArquivosPesquisa($app, $filtro, $codigo) {
            if($app == 'diario') {
                $app = 'diariooficial';
            }
            if ($filtro) {
                $this->db->where("legenda LIKE '%$filtro%'");
            }
            $this->db->where("codigo", $codigo);
            return $this->db->ObjectBuilder()->get($app.'_arquivos');
        }
    ###### }

}