<?
ini_set('xdebug.var_display_max_depth', 5);
ini_set('xdebug.var_display_max_children', 256);
ini_set('xdebug.var_display_max_data', 1024);


## Banco ORIGEM
$SiteOriginal = Array (
    'host' => 'localhost',
    'username' => 'root', 
    'password' => '',
    'db'=> 'original',
    //'port' => '',
    //'prefix' => 'my_',
    'charset' => 'utf8');

## Banco PLATAFORMA
$SiteMigracao = Array (
    'host' => 'localhost',
    'username' => 'root', 
    'password' => '',
    'db'=> 'rondon',
    //'port' => '',
    //'prefix' => 'my_',
    'charset' => 'utf8');

$entidade = 1;


$dbFrom = new MysqliDb( $SiteOriginal );
$dbTo = new MysqliDb( $SiteMigracao );


$inserir = true;

if (ob_get_level() == 0) ob_start();
################# Usuários:
	$usuarios = $dbFrom->ObjectBuilder()->get('login');	
	foreach($usuarios as $u) {
		$insertUsuarios[] =
			array(
				'id' => $u->id,
				'nome' => $u->nome,
				'usuario' => $u->login,
				'email' => $u->email,
				'senha' => Bcrypt::hash($u->login),
				'status' => 1,
				'_gerente' => 0,
				'_admin' => 0,
			);
	}
	if ($inserir) {
		if($dbTo->insertMulti('app_usuarios', $insertUsuarios)) {
			li('Usuários Inseridos com sucesso!');
		} else {
			li('Falha ao inserir usuários:<br><b>'.$dbTo->getLastError().'</b>');
		}
	}flush();ob_flush();


################# Agenda:
	// Seções
	if($secoes = $dbFrom->ObjectBuilder()->get('agenda', null, 'DISTINCT(secao) as secao')) {
		$i=1;
		foreach($secoes as $s) {
			$insertSecoesAgenda[stringTag($s->secao)] = array(
				'id' => $i++,
				'nome' => $s->secao,
				'entidade' => $entidade
			);
		}
		if ($inserir) {
			if($dbTo->insertMulti('agenda_secoes', $insertSecoesAgenda)) {
				li('Seções da Agenda Inseridas com sucesso!');
			} else {
				li('Falha ao inserir seções da agenda:<br><b>'.$dbTo->getLastError().'</b>');
			}
		}
	}flush();ob_flush();

	// Agendas
	if($agendas = $dbFrom->ObjectBuilder()->get('agenda')) {
		foreach($agendas as $a) {
			if ( explode('-', $a->data)[0] < 2000) { $a->data = date('2017-01-01'); }
			$insertAgendas[] =
				array(
					'id' => $a->id,
					'usuario' => 0,
					'secao' => $insertSecoesAgenda[stringTag($a->secao)]['id'],
					'titulo' => ($titulo = str_replace('Pauta:', '', explode("\r\n", $a->texto)[0])),
					'tag' => stringTag($titulo),
					'texto' => explode("\r\n", $a->texto)[1],
					'codigo' => geraSenha(25),
					'data' => $a->data.' 00:00:00',
					'entidade' => $entidade,
				);
		}
		if ($inserir) {
			if($dbTo->insertMulti('agenda', $insertAgendas)) {
				li('Agendas Inseridas com sucesso!');
			} else {
				li('Falha ao inserir agendas:<br><b>'.$dbTo->getLastError().'</b>');
			}
		}
	}flush();ob_flush();


################# Diário:
	// Seções
	if($secoes = $dbFrom->ObjectBuilder()->get('diario', null, 'DISTINCT(secao) as secao')) {
		$i=1;
		foreach($secoes as $s) {
			$insertSecoesDiarios[stringTag($s->secao)] = array(
				'id' => $i++,
				'nome' => $s->secao,
				'entidade' => $entidade
			);
		}
		if ($inserir) {
			if($dbTo->insertMulti('diariooficial_secoes', $insertSecoesDiarios)) {
				li('Seções do Diário Oficial Inseridas com sucesso!');
			} else {
				li('Falha ao inserir seções do diário oficial:<br><b>'.$dbTo->getLastError().'</b>');
			}
		}
	}flush();ob_flush();

	// Diário
	if($diarios = $dbFrom->ObjectBuilder()->get('diario')) {
		foreach($diarios as $d) {
			if ( explode('-', $d->data)[0] < 2000) { $d->data = date('2017-01-01'); }
			$insertDiarios[] =
				array(
					'id' => $d->id,
					'secao' => $insertSecoesDiarios[stringTag($d->secao)]['id'],
					'titulo' => $d->titulo,
					'tag' => stringTag($d->titulo),
					'texto' => $d->texto,
					'codigo' => $d->cod_not,
					'data' => $d->data.' 00:00:00',
					'entidade' => 1,
				);
		}
		if ($inserir) {
			if($dbTo->insertMulti('diariooficial', $insertDiarios)) {
				li('Diário Oficial Inserido com sucesso!');
			} else {
				li('Falha ao inserir diário oficial:<br><b>'.$dbTo->getLastError().'</b>');
			}
		}
	}flush();ob_flush();
	
	// Arquivos
	if ($arquivos = $dbFrom->ObjectBuilder()->get('diario_down')) {
		$path = HD.'diariooficial/migracao/';
		if (!is_dir($path)) { @mkdir($path, 0777, true);}

		foreach($arquivos as $a) {
			if ( explode('-', $a->data)[0] < 2000) { $a->data = date('2017-01-01'); }
			if(strlen($a->cod_not) > 1 AND strlen($a->arquivo) > 1) {
				$insertDiariosArquivos[] = array(
					'codigo' => $a->cod_not,
					'path' => $path,
					'arquivo' => $a->arquivo,
					'legenda' => $a->titulo,
					'data' => $a->data,
					'tipo' => 'arquivo'
				);
			}
		}
		if ($inserir) { 
			if($dbTo->insertMulti('diariooficial_arquivos', $insertDiariosArquivos)) {
				li('Arquivos do Diário Oficial Inserido com sucesso!');
			} else {
				li('Falha ao inserir arquivos do diário oficial:<br><b>'.$dbTo->getLastError().'</b>');
			}
		}
	}flush();ob_flush();


################# Transparência:
	// Grupos e Categorias
	if($grupos = $dbFrom->ObjectBuilder()->get('downloads', null, 'DISTINCT(secao) as secao')) {
		$i=1;
		foreach($grupos as $g) {
			$insertGruposTransparencia[stringTag($g->secao)] = array(
				'id' => $i,
				'nome' => $g->secao,
				'entidade' => $entidade
			);
			$insertCategoriasTransparencia[stringTag($g->secao)] = array(
				'grupo' => $i,
				'nome' => $g->secao,
				'entidade' => $entidade
			);
			$i++;
		}
		if ($inserir) {
			if($dbTo->insertMulti('transparencia_grupos', $insertGruposTransparencia)) {
				li('Grupos do Transparência Inseridas com sucesso!');
			} else {
				li('Falha ao inserir grupos do transparência:<br><b>'.$dbTo->getLastError().'</b>');
			}
			if($dbTo->insertMulti('transparencia_categorias', $insertCategoriasTransparencia)) {
				li('Categorias do Transparência Inseridas com sucesso!');
			} else {
				li('Falha ao inserir categorias do transparência:<br><b>'.$dbTo->getLastError().'</b>');
			}
		}
	}flush();ob_flush();

	// Transparências
	if($transp = $dbFrom->ObjectBuilder()->get('downloads')) {
		foreach($transp as $t) {
			if ( explode('-', $t->data)[0] < 2000) { $t->data = date('2017-01-01'); }
			$insertTransparencias[] =
				array(
					'id' => $t->id,
					'usuario' => 0,
					'grupo' => $insertGruposTransparencia[stringTag($t->secao)]['id'],
					'categoria' => $insertGruposTransparencia[stringTag($t->secao)]['id'],
					'titulo' => $t->titulo,
					'tag' => stringTag($t->titulo),
					'texto' => $t->texto,
					'codigo' => $t->cod_not,
					'data' => $t->data.' 00:00:00',
					'entidade' => 1,
				);
		}
		if ($inserir) {
			if($dbTo->insertMulti('transparencia', $insertTransparencias)) {
				li('Transparência Inserido com sucesso!');
			} else {
				li('Falha ao inserir transparência:<br><b>'.$dbTo->getLastError().'</b>');
			}
		}
	}flush();ob_flush();
	
	// Arquivos
	if ($arquivos = $dbFrom->ObjectBuilder()->get('downloads_down')) {
		$path = HD.'transparencia/migracao/';
		if (!is_dir($path)) { @mkdir($path, 0777, true);}

		foreach($arquivos as $a) {
			if ( explode('-', $a->data)[0] < 2000) { $a->data = date('2017-01-01'); }
			if(strlen($a->cod_not) > 1 AND strlen($a->arquivo) > 1) {
				$insertTranspArquivos[] = array(
					'codigo' => $a->cod_not,
					'path' => $path,
					'arquivo' => $a->arquivo,
					'legenda' => $a->titulo,
					'data' => $a->data,
					'tipo' => 'arquivo'
				);
			}
		}
		if ($inserir) { 
			if($dbTo->insertMulti('transparencia_arquivos', $insertTranspArquivos)) {
				li('Arquivos do Transparência Inserido com sucesso!');
			} else {
				li('Falha ao inserir arquivos do transparência:<br><b>'.$dbTo->getLastError().'</b>');
			}
		}
	}flush();ob_flush();


################# Licitação:
	// Status
	$dbFrom->where('sec', 'S');
	if($status = $dbFrom->ObjectBuilder()->get('processos_listagem_combos', null, 'id, dsc_item as status')) {
		foreach($status as $s) {
			$insertLicitacoesStatus[stringTag($s->status)] = array(
				'id' => $s->id,
				'nome' => $s->status,
				'entidade' => $entidade,
			);
		}
		if ($inserir) {
			if($dbTo->insertMulti('licitacoes_status', $insertLicitacoesStatus)) {
				li('Status do Licitações Inseridas com sucesso!');
			} else {
				li('Falha ao inserir status do licitações:<br><b>'.$dbTo->getLastError().'</b>');
			}
		}
	}flush();ob_flush();

	// Modalidades
	$dbFrom->where('sec', 'M');
	if($modalidades = $dbFrom->ObjectBuilder()->get('processos_listagem_combos', null, 'id, dsc_item as modalidade')) {
		foreach($modalidades as $m) {
			$insertLicitacoesModalidades[stringTag($m->modalidade)] = array(
				'id' => $m->id,
				'nome' => $m->modalidade,
				'entidade' => $entidade,
			);
		}
		if ($inserir) {
			if($dbTo->insertMulti('licitacoes_modalidades', $insertLicitacoesModalidades)) {
				li('Modalidades do Licitações Inseridas com sucesso!');
			} else {
				li('Falha ao inserir modalidades do licitações:<br><b>'.$dbTo->getLastError().'</b>');
			}
		}
	}flush();ob_flush();

	// Tipos
	$dbFrom->where('sec', 'T');
	if($tipos = $dbFrom->ObjectBuilder()->get('processos_listagem_combos', null, 'id, dsc_item as tipo')) {
		foreach($tipos as $t) {
			$insertLicitacoesTipos[stringTag($t->tipo)] = array(
				'id' => $t->id,
				'nome' => $t->tipo,
				'entidade' => $entidade,
			);
		}
		if ($inserir) {
			if($dbTo->insertMulti('licitacoes_tipos', $insertLicitacoesTipos)) {
				li('Tipos do Licitações Inseridas com sucesso!');
			} else {
				li('Falha ao inserir tipos do licitações:<br><b>'.$dbTo->getLastError().'</b>');
			}
		}
	}flush();ob_flush();
	

	// Licitações
	if($licitacoes = $dbFrom->ObjectBuilder()->get('processos')) {
		foreach($licitacoes as $l) {
			if ( explode('-', $l->data_abertura)[0] < 2000) { $l->data_abertura = date('2017-01-01'); }
			if(strlen($l->status) AND $insertLicitacoesStatus[stringTag($l->situacao)]['id']) {
				$insertLicitacoes[] =
					array(
						'usuario' => 0,
						'numero' => $l->processo,
						'objeto' => $l->titulo,
						'categoria' => 1,
						'modalidade' => $insertLicitacoesModalidades[stringTag($l->modalidade)]['id'] ?? 0,
						'tipo' => $insertLicitacoesTipos[stringTag($l->tipo)]['id'] ?? 0,
						'inicio' => $l->data_abertura,
						'fim' => null,
						'status' => $insertLicitacoesStatus[stringTag($l->situacao)]['id'],
						'titulo' => 'Processo Licitatório '.$l->processo,
						'tag' => stringTag('Processo Licitatório '.$l->processo),
						'descricao' => $l->descricao,
						'codigo' => $l->cod_not,
						'fundamentacao' => $l->fundamentacao,
						'data' => $l->data.' 00:00:00',
						'entidade' => $entidade,
					);
			}
		}
		if ($inserir) {
			if($dbTo->insertMulti('licitacoes', $insertLicitacoes)) {
				li('Licitações Inseridas com sucesso!');
			} else {
				li('Falha ao inserir licitações:<br><b>'.$dbTo->getLastError().'</b>');
			}
		}
	}flush();ob_flush();
	
	// Arquivos
	if ($arquivos = $dbFrom->ObjectBuilder()->get('processos_down')) {
		$path = HD.'licitacoes/migracao/';
		if (!is_dir($path)) { @mkdir($path, 0777, true);}
		foreach($arquivos as $a) {
			if ( explode('-', $a->data)[0] < 2000) { $a->data = date('2017-01-01'); }
			if(strlen($a->cod_not) > 1 AND strlen($a->arquivo) > 1) {
				$insertLicitacoesArquivos[] = array(
					'codigo' => $a->cod_not,
					'path' => $path,
					'arquivo' => $a->arquivo,
					'legenda' => $a->titulo,
					'data' => $a->data,
					'tipo' => 'arquivo'
				);
			}
		}
		if ($inserir) { 
			if($dbTo->insertMulti('licitacoes_arquivos', $insertLicitacoesArquivos)) {
				li('Arquivos do Licitações Inserido com sucesso!');
			} else {
				li('Falha ao inserir arquivos do licitacoes:<br><b>'.$dbTo->getLastError().'</b>');
			}
		}
	}flush();ob_flush();


################# Vídeos:
	// Vídeos
	if($videos = $dbFrom->ObjectBuilder()->get('videos')) {
		foreach($videos as $v) {
			if ( explode('-', $v->data)[0] < 2000) { $v->data = date('2017-01-01'); }
			$insertVideos[] =
				array(
					'id' => $v->id,
					'secao' => $v->secao,
					'titulo' => $v->titulo,
					'descricao' => $v->descricao,
					'codigo' => $v->codigo,
					'data' => $v->data.' 00:00:00',
					'entidade' => $entidade,
				);
		}
		if ($inserir) {
			if($dbTo->insertMulti('videos', $insertVideos)) {
				li('Vídeos Inseridas com sucesso!');
			} else {
				li('Falha ao inserir vídeos:<br><b>'.$dbTo->getLastError().'</b>');
			}
		}
	}flush();ob_flush();


################# Notícias:
	// Capas
	if($capas = $dbFrom->ObjectBuilder()->get('noticias', null, 'cod_not, imagem as capa')) {
		foreach($capas as $c) {
			$path = HD.'noticias/migracao/';
			if (!is_dir($path)) { @mkdir($path, 0777, true);}
			$insertNoticiasCapa[$c->cod_not] = array(
				'codigo' => $c->cod_not,
				'path' => $path,
				'arquivo' => $c->capa,
				'legenda' => null,
				'tipo' => 'capa'
			);
		}
		if ($inserir) {
			foreach($insertNoticiasCapa as $capa) {
				if ($dbTo->insert('noticias_arquivos', $capa)) { $codigo = $capa['codigo'];
					$CAPA[$capa['arquivo']] = $dbTo->getInsertId() ?? 0;
				} else {
					foreach($CAPA as $del) { $DEL[] = $del; }
					$dbTo->where('id', $DEL, 'IN');$dbTo->delete('noticias_arquivos');

					li('Falha ao inserir vídeos:<br><b>'.$dbTo->getLastError().'</b>');
					break;
				}
			}
			li('Capas das Notícias Inseridas com sucesso!');
		}
	}flush();ob_flush();

	// Notícias
	if($noticias = $dbFrom->ObjectBuilder()->get('noticias')) {
		foreach($noticias as $n) {
			if ( explode('-', $n->data)[0] < 2000) { $n->data = date('2017-01-01'); }
			$insertNoticias[] =
				array(
					'usuario' => 0,
					'titulo' => $n->titulo,
					'tag' => stringTag($n->titulo),
					'subtitulo' => $n->subtitulo,
					'texto' => $n->texto,
					'codigo' => $n->cod_not,
					'secao' => $n->secao,
					'capa' => $CAPA[$n->imagem],
					'data' => $n->data.' 00:00:00',
					'destaque' => $n->capa,
					'status' => ($n->status == 'sim') ? 1 : 0,
					'entidade' => $entidade,
					'contador' => $n->conta
				);
		}
		if ($inserir) {
			if($dbTo->insertMulti('noticias', $insertNoticias)) {
				li('Notícias Inseridas com sucesso!');
			} else {
				li('Falha ao inserir notícias:<br><b>'.$dbTo->getLastError().'</b>');
			}
		}
	}flush();ob_flush();
	
	// Imagens
	$dbFrom->join('noticias n', 'n.id = a.cod_not', 'INNER');
	if ($arquivos = $dbFrom->ObjectBuilder()->get('noticias_img a', null, 'a.*, n.cod_not as codigo')) {
		$path = HD.'noticias/migracao/';
		if (!is_dir($path)) { @mkdir($path, 0777, true);}
		foreach($arquivos as $a) {
			if(strlen($a->cod_not) > 1 AND strlen($a->fotog) > 1) {
				$insertNoticiasImagens[] = array(
					'codigo' => $a->codigo,
					'path' => $path,
					'arquivo' => $a->fotog,
					'legenda' => $a->comentario,
					'tipo' => 'imagem'
				);
			}
		}
		if ($inserir) { 
			if($dbTo->insertMulti('noticias_arquivos', $insertNoticiasImagens)) {
				li('Imagens das Notícias Inseridas com sucesso!');
			} else {
				li('Falha ao inserir imagnes das notícias:<br><b>'.$dbTo->getLastError().'</b>');
			}
		}
	}flush();ob_flush();

	// Arquivos
	if ($arquivos = $dbFrom->ObjectBuilder()->get('noticias_download')) {
		$path = HD.'noticias/migracao/';
		if (!is_dir($path)) { @mkdir($path, 0777, true);}
		foreach($arquivos as $a) {
			if ( explode('-', $a->data)[0] < 2000) { $a->data = date('2017-01-01'); }
			if(strlen($a->cod_not) > 1 AND strlen($a->arquivo) > 1) {
				$insertNoticiasArquivos[] = array(
					'codigo' => $a->cod_not,
					'path' => $path,
					'arquivo' => $a->arquivo,
					'legenda' => $a->titulo,
					'data' => $a->data,
					'tipo' => 'arquivo'
				);
			}
		}
		if ($inserir) { 
			if($dbTo->insertMulti('licitacoes_arquivos', $insertNoticiasArquivos)) {
				li('Arquivos do Licitações Inserido com sucesso!');
			} else {
				li('Falha ao inserir arquivos do licitacoes:<br><b>'.$dbTo->getLastError().'</b>');
			}
		}
	}flush();ob_flush();

	// Links
	$dbFrom->join('noticias n', 'n.id = l.idp', 'INNER');
	if ($links = $dbFrom->ObjectBuilder()->get('noticias_link l', null, 'l.*, n.cod_not as codigo')) {
		foreach($links as $l) {
			if(strlen($l->titulo) > 1 AND strlen($l->link) > 1) {
				$insertNoticiasLinks[] = array(
					'codigo' => $l->codigo,
					'titulo' => $l->titulo,
					'link' => $l->link,
				);
			}
		}
		if ($inserir) { 
			if($dbTo->insertMulti('noticias_links', $insertNoticiasLinks)) {
				li('Links das Notícias Inseridos com sucesso!');
			} else {
				li('Falha ao inserir links das notícias:<br><b>'.$dbTo->getLastError().'</b>');
			}
		}
	}flush();ob_flush();

	// Vídeos
	if ($videos = $dbFrom->ObjectBuilder()->get('noticias_videos')) {
		foreach($videos as $v) {
			if(strlen($v->titulo) > 1 AND strlen($v->codigo) > 1 AND strlen($v->cod_not) > 1) {
				$insertNoticiasVideos[] = array(
					'codigo' => $v->cod_not,
					'titulo' => $v->titulo,
					'link' => $v->codigo,
				);
			}
		}
		if ($inserir) { 
			if($dbTo->insertMulti('noticias_links', $insertNoticiasVideos)) {
				li('Vídeos das Notícias Inseridos com sucesso!');
			} else {
				li('Falha ao inserir vídeos das notícias:<br><b>'.$dbTo->getLastError().'</b>');
			}
		}
	}flush();ob_flush();


################# Protocolo:
	// Status
	if($status = $dbFrom->ObjectBuilder()->get('protocolo_documento_status', null, 'id, nom_status as status')) {
		foreach($status as $s) {
			$insertProtocoloStatus[stringTag($s->status)] = array(
				'id' => $s->id,
				'nome' => $s->status,
				'entidade' => $entidade,
			);
		}
		if ($inserir) {
			if($dbTo->insertMulti('protocolo_status', $insertProtocoloStatus)) {
				li('Status do Protocolo Inseridos com sucesso!');
			} else {
				li('Falha ao inserir status do protocolo:<br><b>'.$dbTo->getLastError().'</b>');
			}
		}
	}flush();ob_flush();

	// Departamentos
	if($status = $dbFrom->ObjectBuilder()->get('protocolo_departamento', null, 'id, nom_departamento as status')) {
		foreach($status as $s) {
			$insertProtocoloDepartamento[stringTag($s->status)] = array(
				'id' => $s->id,
				'nome' => $s->status,
				'entidade' => $entidade,
			);
		}
		if ($inserir) {
			if($dbTo->insertMulti('protocolo_departamentos', $insertProtocoloDepartamento)) {
				li('Departamentos do Protocolo Inseridos com sucesso!');
			} else {
				li('Falha ao inserir departamentos do protocolo:<br><b>'.$dbTo->getLastError().'</b>');
			}
		}
	}flush();ob_flush();

	// Acessos
	$dbFrom->where('id_protocolo_perfil', 0, '!=');
	if($acessos = $dbFrom->ObjectBuilder()->get('login', null, 'id, id_protocolo_perfil as nivel')) {
		foreach($acessos as $a) {
			$insertProtocoloAcessos[$a->id] = array(
				'usuario' => $a->id,
				'nivel' => $a->nivel == 1 ? 1 : 2,
				'entidade' => $entidade,
			);
		}
		if ($inserir) {
			if($dbTo->insertMulti('protocolo_acessos', $insertProtocoloAcessos)) {
				li('Acesos do Protocolo Inseridos com sucesso!');
			} else {
				li('Falha ao inserir acessos do protocolo:<br><b>'.$dbTo->getLastError().'</b>');
			}
		}
	}flush();ob_flush();

	// Departamentos Acessos
	$dbFrom->where('id_protocolo_perfil', 0, '!=');
	$dbFrom->where('id_protocolo_departamento', 0, '!=');
	if($acessosDepto = $dbFrom->ObjectBuilder()->get('login', null, 'id, id_protocolo_departamento as depto')) {
		foreach($acessosDepto as $a) {
			$insertProtocoloAcessosDepto[$a->id] = array(
				'usuario' => $a->id,
				'departamento' => $a->depto,
				'entidade' => $entidade,
			);
		}
		if ($inserir) {
			if($dbTo->insertMulti('protocolo_departamentos_acesso', $insertProtocoloAcessosDepto)) {
				li('Acesos à Departamentos do Protocolo Inseridos com sucesso!');
			} else {
				li('Falha ao inserir acessos à departamentos do protocolo:<br><b>'.$dbTo->getLastError().'</b>');
			}
		}
	}flush();ob_flush();

	// Protocolos
	$dbFrom->join('protocolo_usuario_externos u', 'u.id = p.id_pessoa_fisica OR u.id = p.id_pessoa_juridica', 'INNER');
	$dbFrom->join('login l', 'l.login = p.id_login', 'INNER');
	if($protocolos =
		$dbFrom->ObjectBuilder()->get(
			'protocolo_documento p',
			null,
			'p.protocolo as id, p.data_recebimento as data, p.assunto, p.id_status as status, u.cpf, u.cnpj, u.nome as nome, u.telefone as fone, id_protocolo_departamento_atual as departamento'
			)
		) {
		foreach($protocolos as $p) {
			if ( explode('-', $p->data)[0] < 2000) { $p->data = date('2017-01-01'); }
			$insertProtocolos[] =
				array(
					'id' => $p->id,
					'data' => $p->data,
					'assunto' => $p->assunto,
					'documento' => $p->cpf ?? $p->cnpj,
					'email' => $p->email,
					'nome' => $p->nome,
					'fone' => $p->fone,
					'codigo' =>$p->id,
					'descricao' => null,
					'departamento' => $p->departamento,
					'status' => $p->status,
					'entidade' => $entidade,
					'envio' => 1,
				);
		}
		if ($inserir) {
			if($dbTo->insertMulti('protocolo', $insertProtocolos)) {
				li('Protocolos Inseridos com sucesso!');
			} else {
				li('Falha ao inserir protocolos:<br><b>'.$dbTo->getLastError().'</b>');
			}
		}
	}flush();ob_flush();

	// Despachos
	$dbFrom->join('protocolo_documento p', 'p.id = d.id_protocolo_documento', 'INNER');
	if($despachos =
		$dbFrom->ObjectBuilder()->get(
			'protocolo_despacho d',
			null,
			'd.id, d.id_login as usuario, p.protocolo, d.despacho, d.data'
			)
		) {
		foreach($despachos as $d) {
			if ( explode('-', $d->data)[0] < 2000) { $d->data = date('2017-01-01'); }
			$insertProtocoloDespachos[] = array(
				'id' => $d->id,
				'protocolo' => $d->protocolo,
				'usuario' => $d->usuario,
				'resposta' => $d->despacho,
				'codigo' => geraSenha(25),
				'data' => $d->data,
			);
		}
		if ($inserir) {
			if($dbTo->insertMulti('protocolo_respostas', $insertProtocoloDespachos)) {
				li('Despachos do Protocolo Inseridos com sucesso!');
			} else {
				li('Falha ao inserir despacho do protocolo:<br><b>'.$dbTo->getLastError().'</b>');
			}
		}
	} flush(); ob_flush();


######################################
######################################
################## Funções:
function li($conteudo) {
	echo '<li>'.$conteudo.'</li>';
}



/*
# Notícias
site/noticias/lib/pastaup -> zHD/noticias/migracao
site/noticias/lib/fotos -> zHD/noticias/migracao/fotos

# Diário Oficial
site/diario/lib/pastaup -> zHD/diariooficial/migracao

# Licitações
site/processos/lib/pastaup -> zHD/licitacoes/migracao

# Transparência
site/downloads/lib/pastaup -> zHD/transparencia/migracao
*/