<?
class Vereadores extends APP {
	
	PRIVATE $APP;
	PUBLIC $vereadores;

	function __construct($isView) {
		if($isView) { $this->isView = true; }
		parent::__construct($isView);
		if($isView) {
			$this->isView = true;
		} else {
			$this::getVereadores();
		}		
		if (defined('ENTIDADE')) {
			$this->_auth->entidade = $this::getEntidade(ENTIDADE);
		}
	}

	function setSetup($tabela, $ID, $dados) {
		$this->db->where('id', $ID);
		if ( $this->db->update('vereadores_'.$tabela, $dados) ) {
			return $ID;
		} else {
			return false;
		}
	}

	function addSetup($tabela, $ID, $dados) {
		if ( $this->db->insert('vereadores_'.$tabela, $dados) ) {
			return $this->db->getInsertID();
		} else {
			return false;
		}
	}

	function delSetup($tabela, $ID) {
		$this->db->where('id', $ID);
		if ( $this->db->delete('vereadores_'.$tabela) ) {
			return true;
		} else {
			return false;
		}
	}

	function excluirArquivo($ID) {
		$a = $this::getArquivo($ID);
		if( is_file($a->path.$a->arquivo) ) {
			@unlink($a->path.$a->arquivo);
		}
		if( $a->tipo == 'imagem' ) {
			@unlink($a->path.'min/'.$a->arquivo);
		}
		$this->db->where('id', $ID);
		$this->db->delete('vereadores_arquivos');

		$this->db->where('capa', $ID);
		$this->db->update('vereadores', array('capa' => 0));
		return true;
	}

	function addLink($dados) {
		return $this->db->insert('vereadores_links', $dados);
	}
	function addVideo($dados) {
		return $this->db->insert('vereadores_videos', $dados);
	}

	function setLegenda($ID, $legenda) {
		$this->db->where('id', $ID);
		return $this->db->update('vereadores_arquivos', $legenda);
	}

	function getVideos($n) {
		$this->db->where('codigo', $n->codigo);
		return $this->db->ObjectBuilder()->get('vereadores_videos');
	}

	function getLinks($n) {
		$this->db->where('codigo', $n->codigo);
		return $this->db->ObjectBuilder()->get('vereadores_links');
	}

	function getArquivo($ID) {
		$this->db->where('id', $ID);
		return $this->db->ObjectBuilder()->getOne('vereadores_arquivos');
	}

	function getArquivosCodigo($codigo) {
		$this->db->where('codigo', $codigo);
		return $this->db->ObjectBuilder()->get('vereadores_arquivos');
	}

	function atualizaCapa($ID, $dados) { 
		$this->db->where('codigo', $dados['codigo']);
		$this->db->where('tipo', 'capa');
		if( $capa = $this->db->ObjectBuilder()->getOne('vereadores_arquivos') ) {
			$this->db->where('id', $capa->id);

			if ($this->db->update('vereadores_arquivos', $dados) ) {	

				$data = array('capa' => $capa->id);
				$this->db->where('id', $ID);
				if($this->db->update('vereadores', $data)) {
					return $capa;
				} else {
					return false;
				}				
			} else {
				return false;
			}
		} else {
			if( $this->db->insert('vereadores_arquivos', $dados) ) {
				$capa = $this->db->getInsertID();
		
				$data = array('capa' => $capa);

				$this->db->where('id', $ID);
				if($this->db->update('vereadores', $data)) {
					return $capa;
				} else {
					return false;
				}
			}
		}
	}

	function atualizaPerfil($ID, $dados) { 
		$this->db->where('codigo', $dados['codigo']);
		$this->db->where('tipo', 'perfil');
		if( $perfil = $this->db->ObjectBuilder()->getOne('vereadores_arquivos') ) {
			$this->db->where('id', $perfil->id);
			if ($this->db->update('vereadores_arquivos', $dados) ) {
				$data = array('perfil' => $perfil->id);
				$this->db->where('id', $ID);
				if($this->db->update('vereadores', $data)) {
					return $perfil;
				} else {
					return false;
				}				
			} else {
				return false;
			}
		} else {
			if( $this->db->insert('vereadores_arquivos', $dados) ) {
				$perfil = $this->db->getInsertID();
		
				$data = array('perfil' => $perfil);

				$this->db->where('id', $ID);
				if($this->db->update('vereadores', $data)) {
					return $perfil;
				} else {
					return false;
				}
			}
		}
	}

	function getUrlArquivo($ID) {
		$this->db->where('id', $ID);
		$a = $this->db->ObjectBuilder()->getOne('vereadores_arquivos');
		if($a) {
			return DIR.$a->path.$a->arquivo;
		} else {
			return '';
		}
	}

	function galeriaImagem($n, $capa = true) {
		if($capa) {
			$this->db->where("(codigo = '$n->codigo') AND (tipo = 'imagem' OR tipo = 'capa' OR tipo = 'perfil')");
		} else {
			$this->db->where("(codigo = '$n->codigo') AND (tipo = 'imagem')");
		}
		return $this->db->ObjectBuilder()->get('vereadores_arquivos');
	}

	function galeriaArquivos($n) {
		$this->db->where('codigo', $n->codigo);
		$this->db->where('tipo', 'arquivo');
		return $this->db->ObjectBuilder()->get('vereadores_arquivos');
	}

	function getCapa($n) {
		$this->db->where('codigo', $n->codigo);
		$this->db->where('tipo', 'capa');
		return $this->db->ObjectBuilder()->getOne('vereadores_arquivos');
	}

	function getPerfil($n) {
		$this->db->where('codigo', $n->codigo);
		$this->db->where('tipo', 'perfil');
		return $this->db->ObjectBuilder()->getOne('vereadores_arquivos');
	}

	function getCapaID($ID) {
		$this->db->where('id', $ID);
		if ( $capa = $this->db->ObjectBuilder()->getOne('vereadores_arquivos') ){
			return $capa;
		} else {
			return $capa = (object) array(
				'path' => API.HD.'vereadores/'.$this->entidade->id.'/',
				'arquivo' => 'capa.jpg',
			);
		}
	}
	
	function getVereadores() {
		$this->db->where('entidade', $this->_auth->entidade->id);
		$this->db->OrderBy('nome', 'ASC');
		$this->vereadores = $this->db->ObjectBuilder()->get('vereadores');
		return $this->vereadores;
	}

	function getVereadorTag($TAG) {
		$this->db->where('tag', $TAG);
		$this->db->where('entidade', $this->_auth->entidade->id);
		$vereador = $this->db->ObjectBuilder()->getOne('vereadores');
		if($n = $vereador) {
			$arquivos['capa'] = $this::getCapaID($n->capa);
			$arquivos['perfil'] = $this::getCapaID($n->perfil);
			$arquivos['videos'] = $this::getVideos($n);
			$arquivos['arquivos'] = $this::galeriaArquivos($n);
			$arquivos['links'] = $this::getLinks($n);
			$arquivos['imagens'] = $this::galeriaImagem($n, false);
			$vereador->{'arquivos'} = (object) $arquivos;
		}
		return $vereador;
	}

	function getVereadorID($ID) {
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		$governo = $this->db->ObjectBuilder()->getOne('vereadores');
		if($n = $governo) {
			$arquivos['capa'] = $this::getCapaID($n->capa);
			$arquivos['perfil'] = $this::getCapaID($n->perfil);
			$arquivos['videos'] = $this::getVideos($n);
			$arquivos['arquivos'] = $this::galeriaArquivos($n);
			$arquivos['links'] = $this::getLinks($n);
			$arquivos['imagens'] = $this::galeriaImagem($n);
			$governo->{'arquivos'} = (object) $arquivos;
		}
		return $governo;
	}

	function editar($ID, $dados) {
		$this->db->where('(tag = "'.$dados['tag'].'" AND id != "'.$ID.'")');
		$this->db->orWhere('tag LIKE ("'.$dados['tag'].'_%")  AND id != "'.$ID.'"');
		$TAGS = count($this->db->get('vereadores'));
		if($TAGS) {	$dados['tag'] = $dados['tag'].'_'.$TAGS; }

		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		if($this->db->update('vereadores', $dados)) {
			return $dados['tag'];
		} else {
			return false;
		}
	}

	function desativar($ID) {
		$dados = array('status' => '0');
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->update('vereadores', $dados);
	}

	function ativar($ID) {
		$dados = array('status' => 1);
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->update('vereadores', $dados);
	}

	function excluir($ID) {
		$n = $this::getVereadorID($ID);

		if ($A = $this::getArquivosCodigo($n->codigo)) {
			foreach ($A as $a) {
				$this::excluirArquivo($a->id);
			}
			$path = $A[0]->path;
			@rmdir($path.'min/');
			@rmdir($path);
			@rmdir($path.'arquivos/');
			$from = array('imagens/', 'arquivos/'); $to = array('', '');
			@rmdir(str_replace($from, $to, $path));
		}

		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->delete('vereadores');
	}

	function excluirLink($ID) {
		$this->db->where('id', $ID);
		return $this->db->delete('vereadores_links');
	}

	function excluirVideo($ID) {
		$this->db->where('id', $ID);
		return $this->db->delete('vereadores_videos');
	}

	function editarLink($ID, $dados) {
		$this->db->where('id', $ID);
		if( $this->db->update('vereadores_links', $dados) ) {
			return true;
		} else {
			return false;
		}
	}

	function editarVideo($ID, $dados) {
		$this->db->where('id', $ID);
		if( $this->db->update('vereadores_videos', $dados) ) {
			return true;
		} else {
			return false;
		}
	}

	function criar($dados) {
		$this->db->where('tag', $dados['tag']);
		$this->db->orWhere('tag LIKE ("'.$dados['tag'].'_%")');
		$TAGS = count($this->db->get('vereadores'));
		if($TAGS) {	$dados['tag'] = $dados['tag'].'_'.$TAGS; }
		if ($this->db->insert('vereadores', $dados)){
			return $dados['tag'];
		} else {
			var_dump($this->db->getLastError());
			return false;
		}
	}

	function contar($n) {
		$dados['contador'] = ++$n->contador;
		$this->db->where('id', $n->id);
		return $this->db->update('vereadores', $dados);
	}

	function getVereadorNews($limitador, $orderBy = false, $pagina = 1) {
		$this->db->where('entidade', $this->entidade->id);
		if ($orderBy) {
			$this->db->OrderBy($orderBy->campo, $orderBy->ordem);
		} else {
			$this->db->OrderBy('nome', 'ASC');
		}
		$this->db->pageLimit = $limitador;
		if ($ver = $this->db->ObjectBuilder()->paginate('vereadores', $pagina))  {
			$this->totalCount = $this->db->totalCount;
			foreach($ver as $v) {
				$v->{'perfil'} = (object) $this::getCapaID($v->perfil);
				$v->{'capa'} = (object) $this::getCapaID($v->capa);
				$vereadores[] = (object) $v;
			}
			return $vereadores;
		} else {
			return false;
		}
	}

	function getNoticiasNews($limitador, $full = false, $orderBy = false, $pagina = 1) {
		if ($orderBy) {
			$this->db->OrderBy('n.'.$orderBy->campo, $orderBy->ordem);
		} else {
			$this->db->OrderBy('n.data', 'DESC');
		}
		if ($this->_remover) {
			$this->db->where('n.id', $this->_remover, 'NOT IN');
		}
		$this->db->where('n.vereador', 0, '>');
		$this->db->groupBy('n.id');
		$this->db->pageLimit = $limitador;
		if ($not = $this->db->ObjectBuilder()->paginate('noticias n', $pagina, 'n.*'))  {
			$this->totalCount = $this->db->totalCount;
			foreach($not as $n) {
				$this->_remover[] = $n->id;
				$n->{'capa'} = (object) $this::getCapaID($n->capa);
				if($limitador == 1 OR $full) {
					$arquivos['capa'] = $this::getCapaID($n->capa);
					$arquivos['videos'] = $this::getVideos($n);
					$arquivos['arquivos'] = $this::galeriaArquivos($n);
					$arquivos['audios'] = $this::galeriaAudios($n);
					$arquivos['links'] = $this::getLinks($n);
					$arquivos['imagens'] = $this::galeriaImagem($n);
					$n->{'arquivos'} = (object) $arquivos;
				}
				$noticias[] = (object) $n;
			}
			return $noticias;
		} else {
			return false;
		}
	}

}

return $VEREADORES = new Vereadores($isView);

?>