var FormWizard = function () {

    var handleSummernote = function () {

        var form = $('#form-novo');
        var error = $('.alert-danger', form);
        var success = $('.alert-success', form);

        var v = form.validate({
            doNotHideMessage: true, //this option enables to show the error/success messages on tab switch.
            errorElement: 'span', //default input error message container
            errorClass: 'help-block help-block-error', // default input error message class
            focusInvalid: false, // do not focus the last invalid input
            rules: {
                //account
                data: {
                    required: true
                },
                hora: {
                    required: true
                },
                nome: {
                    required: true
                },
                documento: {
                    required: false
                },
                departamento: {
                    required: true
                },
                assunto: {
                    required: true
                },
                origem: {
                    required: false
                },
                descricao: {
                    required: true
                }
            },

            ignore: ":hidden:not(#texto),.note-editable.panel-body",

            messages: { // custom messages for radio buttons and checkboxes
                
            },

            errorPlacement: function (error, element) { // render error placement for each input type
                if (element.attr("name") == "gender") { // for uniform radio buttons, insert the after the given container
                    error.insertAfter("#form_gender_error");
                } else if (element.attr("name") == "texto") { // for uniform checkboxes, insert the after the given container
                    error.insertAfter("#erro-editor");
                } else {
                    error.insertAfter(element); // for other inputs, just perform default behavior
                }
            },

            invalidHandler: function (event, validator) { //display error alert on form submit   
                success.hide();
                error.show();
                App.scrollTo(error, -200);
            },

            highlight: function (element) { // hightlight error inputs
                $(element)
                    .closest('.form-group').removeClass('has-success').addClass('has-error'); // set error class to the control group
            },

            unhighlight: function (element) { // revert the change done by hightlight
                $(element)
                    .closest('.form-group').removeClass('has-error'); // set error class to the control group
            },

            success: function (label) {
                if (label.attr("for") == "gender" || label.attr("for") == "payment[]") { // for checkboxes and radio buttons, no need to show OK icon
                    label
                        .closest('.form-group').removeClass('has-error');
                    label.remove(); // remove error label here
                } else { // display success icon for other inputs
                    label
                        .addClass('valid') // mark the current input as valid and display OK icon
                    .closest('.form-group').removeClass('has-error'); // set success class to the control group
                }
            },

            submitHandler: function (form) {
                data = $('#form-novo').serialize();
                var action = $('#form-novo').attr('action');

                documento = $('[name=documento]').val()

                if( documento.length > 1 ) {

                    if ( !validar('[name=documento]', 'cpf-cnpj') ) {
                        $('[name=documento]').select();
                        swal("Documento inválido.", "O Documento informado é inválido.", "error");
                        return false;
                    }
                }

                //var acao = 'criar';
                $.ajax({
                    type: "POST",
                    dataType: "json",
                    url: action,
                    data: data,
                    beforeSend: function() {
                        BlockUI('#blockNovo');
                    },
                    success: function( data ) {
                        retornoAjax(data);
                        unBlockUI('#blockNovo');
                    },
                    error: function( data ) {
                        unBlockUI('#blockNovo');
                        $toast = toastr['error']('Informações inválidas. Atualize a página para continuar.');
                    }
                });
            }

        });
    }


    return {
        //main function to initiate the module
        init: function () {
            //validations();
            handleSummernote();
        }
    };
}();
jQuery(document).ready(function() {
    FormWizard.init();
});



var TableDatatablesEditable = function () {

    var handleTable = function () {

        var table = $('#sample_editable_1');

        var oTable = table.dataTable({
            buttons: [
                { extend: 'print',
                    title: 'Notícias',
                    className: 'btn green no-shadow no-radius btn-outline font-s13',
                    text: '<i class="fa fa-print"></i> Imprimir',
                    exportOptions: { columns: [0,1,2] },
                },
                { extend: 'copy',
                    title: 'Notícias',
                    className: 'btn green no-shadow no-radius btn-outline font-s13', 
                    text: '<i class="fa fa-clipboard"></i> Copiar',
                    exportOptions: { columns: [0,1,2] },
                },
                { extend: 'pdf',
                    title: 'Notícias',
                    className: 'btn green no-shadow no-radius btn-outline font-s13',
                    text: '<i class="fa fa-pdf"></i> PDF',
                    exportOptions: { columns: [0,1,2] },
                },
                { extend: 'excel',
                    title: 'Notícias',
                    className: 'btn green no-shadow no-radius btn-outline font-s13',
                    text: '<i class="fa fa-excel"></i> Excel',
                    exportOptions: { columns: [0,1,2] },
                },
                { extend: 'csv',
                    title: 'Notícias',
                    className: 'btn green no-shadow no-radius btn-outline font-s13',
                    text: '<i class="fa fa-cvs"></i> CVS',
                    exportOptions: { columns: [0,1,2] },
                },
                { extend: 'colvis',
                    className: 'btn green no-shadow no-radius btn-outline font-s13',
                    text: 'Colunas',
                }
            ],

            "dom": "<'row' <'col-md-12'B>><'row'<'col-md-6 col-sm-12'l><'col-md-6 col-sm-12'f>r><'table-scrollable't><'row'<'col-md-5 col-sm-12'i><'col-md-7 col-sm-12'p>>",

            "lengthMenu": [
                [25, 50, 100, -1],
                [25, 50, 100, "Todos"] // change per page values here
            ],

            // Or you can use remote translation file
            //"language": {
            //   url: '//cdn.datatables.net/plug-ins/3cfcc339e89/i18n/Portuguese.json'
            //},

            // set the initial value
            "pageLength": 50,

            "language": {
                "sProcessing":   "A processar...",
                "sLengthMenu":   "Mostrar _MENU_ registros",
                "sZeroRecords":  "Não foram encontrados resultados",
                "sInfo":         "Mostrando de _START_ até _END_ de _TOTAL_ registros",
                "sInfoEmpty":    "Mostrando de 0 até 0 de 0 registros",
                "sInfoFiltered": "(filtrado de _MAX_ registros no total)",
                "sInfoPostFix":  "",
                "sSearch":       "Procurar:",
                "sUrl":          "",
                "oPaginate": {
                    "sFirst":    "Primeiro",
                    "sPrevious": "Anterior",
                    "sNext":     "Seguinte",
                    "sLast":     "Último"
                },
                "language": {
                    buttons: {
                        copySuccess: {
                            _: '%d Copiado com sucesso!',
                            1: '1 ligne copiée'
                        }
                    }
                }
            },

            "columnDefs": [{ // set default column settings
                'orderable': true,
                'type': 'date-uk',
                'targets': [0]
            }, {
                "searchable": true,
                "targets": [0]
            }],
            "order": [
                [0, "desc"]
            ], // set first column as a default sort by ascgetSaldoCliente
        });

        var tableWrapper = $("#sample_editable_1_wrapper");

        var nEditing = null;
        var nNew = false;

        table.on('click', '.delete', function (e) {

            var action = $('#controle-ajax').attr('action');
            var acao = $('#controle-ajax').attr('acao');
            var ID = $(this).closest('tr').attr('ID');

            swal({
                title: "Tem certeza que deseja excluir esta vaga?",
                text: "Esta ação não pode ser desfeita.",
                type: "info",
                showCancelButton: true,
                showConfirmButton: true,
                confirmButtonText: 'Excluir',
                confirmButtonClass: 'btn-danger',
                closeOnConfirm: false,
                showLoaderOnConfirm: true,
            }, function (isConfirm) {
                if (isConfirm){
                    
                    //swal('Excluindo!', 'O agendamento será excluido e a página será atualizada.', "success");
                    swal.close()

                    $.ajax({
                        type: "POST",
                        dataType: "json",
                        url: action,
                        data: 'ID='+ID+'&acao=deletar',
                        success: function( data ) {
                            retornoAjax(data);
                            if (data.success == true) {
                                var nRow = $('[ID='+ID+']');
                                oTable.fnDeleteRow(nRow);
                            }
                        },
                        error: function( data ) {
                            $toast = toastr['error']('Informações inválidas. Atualize a página para continuar.');
                        }
                    });
                }
            });

        });

    }

    return {

        //main function to initiate the module
        init: function () {
            handleTable();
        }

    };

}();
jQuery(document).ready(function() {
    TableDatatablesEditable.init();
});

function select2() {
    $.fn.select2.defaults.set("theme", "bootstrap");
    $.fn.select2.defaults.set('language', 'pt-BR');
    $(".select2").select2({
        selectOnClose: true,
        placeholder: 'Selecione',
        selectOnBlur: true,
        tags: false,
    });
} select2();

$('[status]').on('change', function(e) {
    action = $('#controle-ajax').attr('action');
    ID = $(this).attr('vaga');
    status = $(this).val();

    $.ajax({
        type: "POST",
        dataType: "json",
        url: action,
        data: 'ID='+ID+'&status='+status+'&acao=status',
        success: function( data ) {
            retornoAjax(data);
        },
        error: function( data ) {
            $toast = toastr['error']('Informações inválidas. Atualize a página para continuar.');
        }
    });
})


$('[notificar]').on('click', function(e) {
    
    var action = $('#controle-ajax').attr('action');
    var ID = $(this).attr('notificar')
    var btn = this;

    swal({
        title: "Este processo demora alguns segundos.",
        text: "Envie um email informando atualizações.",
        type: "info",
        reverseButtons: true,
        showConfirmButton: true,
        confirmButtonText: 'Notificar',
        confirmButtonClass: 'btn-success',
        showCancelButton: false,
        closeOnConfirm: false,
        showLoaderOnConfirm: true,
        html: true,
    }, function (isConfirm) {
        if (isConfirm){
            
            $.ajax({
                type: "POST",
                dataType: "json",
                url: action,
                data: 'ID='+ID+'&acao=notificar',
                beforeSend: function() {
                    BlockUI(btn);
                },
                success: function( data ) {
                    unBlockUI(btn);
                    if(data.success == true) {
                        swal('Usuário Notificado', 'Foi enviado um email para o usuário.', "success");
                        $(btn).removeClass('red').addClass('btn-outline').addClass('green').attr('title', 'Usuário notificado').removeAttr('notificar');
                    } else {
                        swal('Notificação não enviada', 'Não foi possível enviar a notificação.\r\nAtualize a página e tente novamente.', "error");
                        $(btn).removeClass('green').addClass('red');
                    }
                },
                error: function( data ) {
                    $toast = toastr['error']('Informações inválidas. Atualize a página para continuar.');
                }
            });
        }
    });
})

$('#carregar').on('change', function(e) {
    $(this).closest('form').submit();
})

var Consulta = function() {
    var vConfirmar = function(){
        jQuery('.js-consulta').validate({
            errorClass: 'help-block text-right animated fadeInDown',
            errorElement: 'div',
            errorPlacement: function(error, e) {
                jQuery(e).parents('.form-group > div').append(error);
            },
            highlight: function(e) {
                jQuery(e).closest('.form-group').removeClass('has-error').addClass('has-error');
                jQuery(e).closest('.help-block').remove();
            },
            success: function(e) {
                jQuery(e).closest('.form-group').removeClass('has-error');                
                jQuery(e).closest('.help-block').remove();
            },
            rules: {
                protocolo: {
                    required: true,
                },
            },
            messages: {
                
            },
            ignore: ":hidden:not(#texto),.note-editable.panel-body",
            submitHandler: function( form ){
                var dados = $( form ).serialize();
                var action = $( form ).attr('action');

                $.ajax({
                    type: "POST",
                    dataType: "json",
                    url: action,
                    data: dados,
                    success: function( data ) {
                        retornoAjax(data);
                    },
                    error: function( data ) {
                        $toast = toastr['error']('Protocolo Inexistente.');
                    }
                });

                return false;
            }
        });
    };

    return {
        init: function () {
            // Init Login Form Validation
            vConfirmar();
        }
    };
}();
jQuery(function(){ Consulta.init(); });

$('.cnpj').each(function() {
    $(this).inputmask({
      mask: ['99.999.999/9999-99'],
      keepStatic: true,
    });
})