<?
class Transparencia extends APP {
	PRIVATE $APP;

	PUBLIC $transparencias;
	PUBLIC $categorias;
	PUBLIC $grupos;
	PUBLIC $categorias_grupos;

	function __construct($isView) { GLOBAL $_POST;
		parent::__construct($isView);
		if($isView) {
			$this->isView = true;
		} else {
			$this::getTransparencias($_POST['carregar']);
		}
		$this::getCategorias();
		$this::getGrupos();
		$this::getTranspMenus();
	}

	function excluirArquivo($ID) {
		$a = $this::getArquivo($ID);
		if( is_file($a->path.$a->arquivo) ) {
			@unlink($a->path.$a->arquivo);
		}
		$this->db->where('id', $ID);
		$this->db->delete('transparencia_arquivos');
		return true;
	}

	function setSetup($tabela, $ID, $dados) {
		$this->db->where('id', $ID);
		if ( $this->db->update('transparencia_'.$tabela, $dados) ) {
			return $ID;
		} else {
			return false;
		}
	}

	function addSetup($tabela, $ID, $dados) {
		if ( $this->db->insert('transparencia_'.$tabela, $dados) ) {
			return $this->db->getInsertID();
		} else {
			return false;
		}
	}

	function delSetup($tabela, $ID) {
		$this->db->where('id', $ID);
		if ( $this->db->delete('transparencia_'.$tabela) ) {
			return true;
		} else {
			return false;
		}
	}

	function setLegenda($ID, $legenda) {
		$this->db->where('id', $ID);
		return $this->db->update('transparencia_arquivos', $legenda);
	}

	function getArquivo($ID) {
		$this->db->where('id', $ID);
		return $this->db->ObjectBuilder()->getOne('transparencia_arquivos');
	}

	function getIcones() {
		GLOBAL $path;
		return sDir($path['publico'].'icones');
	}

	function getOrdens() {
		GLOBAL $path;
		return sDir($path['publico'].'ordem');
	}

	function getArquivosCodigo($codigo, $filtro = false, $ordem = false) {
		if($filtro) {
			$this->db->where("(legenda LIKE ('%$filtro%') OR arquivo LIKE ('%$filtro%'))");
		}
		$this->db->where('codigo', $codigo);
		if($ordem == 'data desc') {
			$this->db->OrderBy('data', 'DESC');
			$this->db->OrderBy('legenda', 'ASC');
			$this->db->OrderBy('arquivo', 'ASC');

		} else if($ordem == 'data asc') {
			$this->db->OrderBy('data', 'ASC');
			$this->db->OrderBy('legenda', 'ASC');
			$this->db->OrderBy('arquivo', 'ASC');

		} else if($ordem == 'nome desc') {
			$this->db->OrderBy('legenda', 'DESC');
			$this->db->OrderBy('arquivo', 'DESC');

		} else if($ordem == 'nome asc') {
			$this->db->OrderBy('legenda', 'ASC');
			$this->db->OrderBy('arquivo', 'ASC');

		} else {
			$this->db->OrderBy('data', 'DESC');
			$this->db->OrderBy('legenda', 'ASC');
			$this->db->OrderBy('arquivo', 'ASC');
		}
		return $this->db->ObjectBuilder()->get('transparencia_arquivos');
	}

	function getLinks($codigo) {
		$this->db->where('codigo', $codigo);
		$this->db->OrderBy('titulo', 'ASC');
		return $this->db->ObjectBuilder()->get('transparencia_links');
	}

	function getLinksExterno($ent = false) {
		$this->db->where('entidade', $ent ? $ent : $this->_auth->entidade->id);
		$this->db->OrderBy('titulo', 'ASC');
		return $this->db->ObjectBuilder()->get('transparencia_externo');
	}

	function addLink($dados) {
		if ($this->db->insert('transparencia_links', $dados)) {
			return $this->db->getInsertID();
		} else {
			return false;
		}
	}
	function excluirLink($ID) {
		$this->db->where('id', $ID);
		return $this->db->delete('transparencia_links');
	}
	function editarLink($ID, $dados) {
		$this->db->where('id', $ID);
		if( $this->db->update('transparencia_links', $dados) ) {
			return true;
		} else {
			return false;
		}
	}

	function addLinkExterno($dados) {
		if ($this->db->insert('transparencia_externo', $dados)) {
			return $this->db->getInsertID();
		} else {
			return false;
		}
	}
	function excluirLinkExterno($ID) {
		$this->db->where('id', $ID);
		return $this->db->delete('transparencia_externo');
	}
	function editarLinkExterno($ID, $dados) {
		$this->db->where('id', $ID);
		if( $this->db->update('transparencia_externo', $dados) ) {
			return true;
		} else {
			return false;
		}
	}

	function getUrlArquivo($ID) {
		$this->db->where('id', $ID);
		$a = $this->db->ObjectBuilder()->getOne('transparencia_arquivos');
		if($a) {
			return DIR.$a->path.$a->arquivo;
		} else {
			return '';
		}
	}

	function galeriaArquivos($n) {
		$this->db->where('codigo', $n->codigo);
		return $this->db->ObjectBuilder()->get('transparencia_arquivos');
	}
	
	function getTransparencias($limitador) {
		if(!$limitador) { $limitador = 300; } else if ($limitador == 'todos') { $limitador = null; }
		$this->db->join('transparencia_categorias c', 'c.id = t.categoria', 'LEFT');
		$this->db->join('transparencia_grupos g', 'g.id = t.grupo', 'LEFT');
		$this->db->where('t.entidade', $this->_auth->entidade->id);
		$this->db->orderBy('id', 'DESC');
		$this->transparencias = $this->db->ObjectBuilder()->get('transparencia t', $limitador, 't.*, c.nome as categoria, g.nome as grupo');
		return $this->transparencias;
	}

	function getTransparenciaTag($TAG) {
		$this->db->join('transparencia_grupos g', 'g.id = grupo', 'LEFT');
		$this->db->where('t.tag', $TAG);
		$this->db->where('t.entidade', $this->_auth->entidade->id);
		$transparencia = $this->db->ObjectBuilder()->get('transparencia t', null, 't.*, g.nome as grupo_nome')[0];
		return $transparencia;
	}

	function getTransparenciaID($ID) {
		$this->db->where('id', $ID);
		$transparencia = $this->db->ObjectBuilder()->getOne('transparencia');
		return $transparencia;
	}

	function setIcone($ID, $icone) {
		$this->db->where('id', $ID);
		$dados['icone'] = $icone;
		if( $this->db->update('transparencia_categorias', $dados) ) {
			return true;
		} else {
			return false;
		}
	}

	function setOrdem($ID, $icone) {
		$this->db->where('id', $ID);
		$dados['ordem'] = $icone;
		if( $this->db->update('transparencia_categorias', $dados) ) {
			return true;
		} else {
			return false;
		}
	}

	function editar($ID, $dados) {
		$this->db->where('(tag = "'.$dados['tag'].'" AND id != "'.$ID.'")');
		$this->db->orWhere('tag LIKE ("'.$dados['tag'].'_%")  AND id != "'.$ID.'"');
		$TAGS = count($this->db->get('transparencia'));
		if($TAGS) {	$dados['tag'] = $dados['tag'].'_'.$TAGS; }

		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		if( $this->db->update('transparencia', $dados) ) {
			return $dados['tag'];
		} else {
			return false;
		}
	}


	function excluir($ID) {
		$n = $this::getTransparenciaID($ID);

		if ($A = $this::getArquivosCodigo($n->codigo)) {
			foreach ($A as $a) {
				$this::excluirArquivo($a->id);
			}
			$path = $A[0]->path;
			@rmdir($path.'min/');
			@rmdir($path);
			@rmdir($path.'arquivos/');
			$from = array('imagens/', 'arquivos/'); $to = array('', '');
			@rmdir(str_replace($from, $to, $path));
		}

		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->delete('transparencia');
	}


	function criar($dados) {
		$this->db->where('tag', $dados['tag']);
		$this->db->orWhere('tag LIKE ("'.$dados['tag'].'_%")');
		$TAGS = count($this->db->get('transparencia'));
		if($TAGS) {	$dados['tag'] = $dados['tag'].'_'.$TAGS; }
		if ($this->db->insert('transparencia', $dados)){
			return $dados['tag'];
		} else {
			var_dump($this->db->getLastError());
			return false;
		}
	}

	function getTranspMenus() {
		$this->db->OrderBy('nome', 'ASC');
		$this->db->groupBy('nome');
		$this->db->where('entidade', $this->_auth->entidade->id);
		$this->menus = $this->db->ObjectBuilder()->get('transparencia_menus');
		return $this->menus;
	}

	function getGrupos() {
		$this->db->join('transparencia_menus m', 'g.menu = m.id', 'LEFT');
		$this->db->OrderBy('g.nome', 'ASC');
		$this->db->groupBy('g.nome');
		$this->db->where('g.entidade', $this->_auth->entidade->id);
		$this->grupos = $this->db->ObjectBuilder()->get('transparencia_grupos g', null, 'g.*, m.nome as menu_nome');
		return $this->grupos;
	}

	function getCategorias($entidade = false) {
		if($entidade) {
			$this->db->join('transparencia t', 'c.id = t.categoria', 'INNER');
			$this->db->where('t.entidade', $entidade);
		} else {
			$this->db->where('c.entidade', $this->_auth->entidade->id);
		}
		$this->db->join('transparencia_grupos g', 'g.id = c.grupo', 'INNER');
		$this->db->OrderBy('c.grupo', 'ASC');
		$this->db->OrderBy('c.nome', 'ASC');
		$this->db->GroupBy('c.id');
		if($entidade) {
			//$this->db->GroupBy('t.exercicio');
			$this->db->OrderBy('t.exercicio', 'DESC');
			$this->categorias = $this->db->ObjectBuilder()->get('transparencia_categorias c', null, 'c.*, g.nome as grupo_nome, max(t.exercicio) as exercicio');
		} else {
			$this->categorias = $this->db->ObjectBuilder()->get('transparencia_categorias c', null, 'c.*, g.nome as grupo_nome');
		}
		return $this->categorias;
	}

	function getCategoriaID($ID) {
		$this->db->where('id', $ID);
		return $this->db->ObjectBuilder()->getOne('transparencia_categorias');
	}
	
	function getCategoriasGrupos() {
		if( $grupos = $this::getGrupos() ) {
			foreach($grupos as $g) {
				$this->db->OrderBy('nome', 'ASC');
				$this->db->groupBy('nome');
				$this->db->where('grupo', $g->id);
				$categorias[$g->nome] = $this->db->ObjectBuilder()->get('transparencia_categorias');
			}
			$this->categorias_grupos = $categorias;
			return (object) $categorias;
		} else {
			return false;
		}
	}

	function getAnosGrupo($filtros) {
		# ENTIDADE
		if($filtros->ent) {
			$this->db->where('t.entidade', $filtros->ent);
		} else {
			$this->db->where('t.entidade', $this->_auth->entidade->id);
		}
		$this->db->join('transparencia_grupos g', 'g.id = t.grupo', 'INNER');
		if($filtros->grupo) {
			$this->db->where('g.nome', $filtros->grupo);
		}
		$this->db->groupBy('YEAR(t.data)');
		$this->db->orderBy('YEAR(t.data)', 'DESC');
		return $this->db->ObjectBuilder()->getValue('transparencia t', 'YEAR(t.data)', null);

	}

	function viewCategoriasGruposArquivos($filtros = false, $ordem = false) {
		# ANO
		if($filtros->ano) {
			$this->db->where("(exercicio = ".(int)$filtros->ano." OR c.exibicao = 1)");
		}
		# ENTIDADE
		if($filtros->ent) {
			$this->db->where('t.entidade', $filtros->ent);
		} else {
			$this->db->where('t.entidade', $this->_auth->entidade->id);
		}
		# BUSCA
		if($filtros->b) {
			//$this->db->where("t.titulo LIKE '%$filtros->b%'");
			$this->db->join('transparencia_arquivos a', 'a.codigo = t.codigo', 'LEFT');
			$this->db->where("(t.titulo LIKE '%$filtros->b%' OR ((a.legenda != '' AND a.legenda LIKE '%$filtros->b%') OR (a.arquivo LIKE '%$filtros->b%')))");
		}

		# Grupo
		if($filtros->grupo) {
			$this->db->where('g.nome', $filtros->grupo);
		}
		# Grupo
		if($filtros->secao) {
			//$this->db->where('c.nome', $filtros->secao);
		}

		$this->db->join('transparencia_categorias c', 'c.id = t.categoria', 'INNER');
		$this->db->join('transparencia_grupos g', 'g.id = t.grupo', 'INNER');
		$this->db->join('transparencia_menus m', 'm.id = g.menu', 'INNER');
		$this->db->OrderBy('grupo_nome', 'ASC');
		$this->db->OrderBy('categoria_nome', 'ASC');
		if($ordem) {
			$this->db->orderBy('t.'.$ordem->campo, $ordem->ordem);
		} else {
			$this->db->orderBy('t.data', 'DESC');
		}
		if ( $t = $this->db->ObjectBuilder()->get('transparencia t', null, 't.*, m.nome as menu_nome, c.nome as categoria_nome, c.ordem, g.nome as grupo_nome, c.descricao as descricao_categoria') ) {
			$return = false;
			foreach($t as $t) {
				$t->{'arquivos'} = $this::getArquivosCodigo($t->codigo, $filtros->b, $t->ordem);
				$t->{'links'} = $this::getLinks($t->codigo);
				$return->{$t->grupo_nome}->{$t->categoria_nome}->descricao = $t->descricao_categoria;
				$return->{$t->grupo_nome}->{$t->categoria_nome}->transparencias->{$t->id} = $t;
				$return->{$t->grupo_nome}->{$t->categoria_nome}->total++;
			}
			return $return;
		} else {
			return null;
		}		
	}

	function viewCategoriasGruposArquivosOLD($filtros = false) {
		# ANO
		if($filtros->ano) {
			$this->db->where("( exercicio = ".(int)$filtros->ano." OR c.exibicao = 1)");
		}
		# ENTIDADE
		if($filtros->ent) {
			$this->db->where('t.entidade', $filtros->ent);
		} else {
			$this->db->where('t.entidade', $this->_auth->entidade->id);
		}
		# BUSCA
		if($filtros->b) {
			$this->db->where("t.titulo LIKE '%$filtros->b%'");
		}

		$this->db->join('transparencia_categorias c', 'c.id = t.categoria', 'INNER');
		$this->db->join('transparencia_grupos g', 'g.id = t.grupo', 'INNER');
		$this->db->join('transparencia_menus m', 'm.id = g.menu', 'INNER');
		$this->db->OrderBy('grupo_nome', 'ASC');
		$this->db->OrderBy('categoria_nome', 'ASC');
		$this->db->orderBy('t.data', 'DESC');
		if ( $t = $this->db->ObjectBuilder()->get('transparencia t', null, 't.*, m.nome as menu_nome, c.nome as categoria_nome, g.nome as grupo_nome, c.descricao as descricao_categoria') ) {
			$return = false;
			foreach($t as $t) {
				$t->{'arquivos'} = $this::getArquivosCodigo($t->codigo);
				$t->{'links'} = $this::getLinks($t->codigo);
				$return->{$t->grupo_nome}->{$t->categoria_nome}->descricao = $t->descricao_categoria;
				$return->{$t->grupo_nome}->{$t->categoria_nome}->transparencias->{$t->id} = $t;
				$return->{$t->grupo_nome}->{$t->categoria_nome}->total++;
			}
			return $return;
		} else {
			return null;
		}		
	}

	function viewMenusGruposArquivos($filtros = false) {
		# ANO
		if($filtros->ano) {
			//$this->db->where("( exercicio = ".(int)$filtros->ano." OR c.exibicao = 1)");
		}
		# ENTIDADE
		if($filtros->ent) {
			$this->db->where('t.entidade', $filtros->ent);
		} else {
			$this->db->where('t.entidade', $this->_auth->entidade->id);
		}
		# BUSCA
		if($filtros->b) {
			$this->db->where("t.titulo LIKE '%$filtros->b%'");
		}

		$this->db->join('transparencia_categorias c', 'c.id = t.categoria', 'INNER');
		$this->db->join('transparencia_grupos g', 'g.id = t.grupo', 'INNER');
		$this->db->join('transparencia_menus m', 'm.id = g.menu', 'INNER');
		$this->db->OrderBy('ordem', 'ASC');
		$this->db->OrderBy('grupo_nome', 'ASC');
		$this->db->OrderBy('categoria_nome', 'ASC');
		$this->db->orderBy('t.exercicio', 'DESC');
		$this->db->orderBy('t.data', 'DESC');
		$this->db->GroupBy('c.id');
		if ( $t = $this->db->ObjectBuilder()->get('transparencia t', null, 't.id, max(t.exercicio) as ano, c.nome as categoria_nome, g.nome as grupo_nome, g.aside as grupo_aside, m.nome as menu_nome, m.ordem as ordem, c.icone as icone') ) {
			$return = false;
			foreach($t as $t) {
				if($filtros->aside == true) {
					$return[$t->menu_nome][$t->grupo_nome][] = (object) array(
						'nome' => $t->categoria_nome,
						'icone' => $t->icone,
						'link' => $t->grupo_aside,
						'ano' => $t->ano
					);
				} else {
					$return->{$t->menu_nome}[] = (object) array(
						'grupo' => $t->grupo_nome,
						'categoria' => $t->categoria_nome,
						'icone' => $t->icone,
						'link' => $t->grupo_aside,
						'ano' => $t->ano
					);
				}
			}
			return $return;
		} else {
			return null;
		}		
	}
}

return $TRANSPARENCIA = new Transparencia($isView);

?>