<?

class Restricoes extends APP {
	PRIVATE $APP;

	PUBLIC $restricoes;
	PUBLIC $cert_positiva;
	PUBLIC $cert_negativa;

	function __construct($isView) { GLOBAL $_POST;
		if($isView) { $this->isView = true; }
		parent::__construct($isView);
		$this::getStatus();
	}

	function getCertidao($codigo) {
		$this->db->where('codigo', $codigo);
		$cert = $this->db->ObjectBuilder()->getOne('restricoes_certidoes');
		$cert->e = json_decode($cert->info);
		return $cert;
	}

	function getUrl($url) {
		$curl = curl_init();
		curl_setopt_array($curl,
			array(
			    CURLOPT_URL => $url,
			    CURLOPT_HEADER => false,
			    CURLOPT_RETURNTRANSFER => true,
			    CURLOPT_NOBODY => false,
			    CURLOPT_SSL_VERIFYHOST => 0,
			    CURLOPT_SSL_VERIFYPEER => 0
			)
		);
		$return = curl_exec($curl);
		curl_close($curl);
		return $return;
	}

	function validaCertidao($doc, $retry = false) {
		$padrao = $this::getStatusPadrao();
		$this->db->where('documento', $doc);
		$this->db->where('status', $padrao);
		if($this->cert_positiva = $this->db->ObjectBuilder()->get('restricoes', null)) {
			return true;

		} else if($this->cert_negativa = $this::consultaCertidao($doc)) {
			return true;

		} else {
			$setup = $this::getSetup();
			$info = (object) array(
				'prazo' => $setup->prazo,
				'texto' => str_replace('%documento%', $tipo.' nº '.$doc, $setup->texto_negativa),
			);
			$insert = array(
				'contrato' => 0,
				'documento' => $doc,
				'info' => json_encode($info),
				'data' => date('Y-m-d H:i:s'),
				'vencimento' => date('Y-m-d', strtotime('+ '.$setup->prazo)),
				'codigo' => strtoupper(geraSenha(10)),
				'entidade' => 0
			);
			$this->db->insert('restricoes_certidoes', $insert);
			if(!$retry) {
				return $this::validaCertidao($doc, true);
			} else {
				return false;
			}
		}
	}

	function consultaCertidao($doc) {
		$this->db->where('documento', $doc);
		$this->db->where('vencimento', date('Y-m-d'), '>=');
		$this->db->orderBy('vencimento', 'DESC');
		if($c = $this->db->ObjectBuilder()->getOne('restricoes_certidoes')) {
			$c->info = json_decode($c->info);
		}
		return $c;
	}

	function consultaCC($codigo) {
		$this->db->where('codigo', $codigo);
		if($c = $this->db->ObjectBuilder()->getOne('restricoes_certidoes')) {
			$c->info = json_decode($c->info);
		}
		return $c;
	}

	function salvarCertidao($info) {
		return $this->db->insert('restricoes_certidoes', $infos);
	}

	function setSetup($tabela, $ID, $dados) {
		$this->db->where('id', $ID);
		if ( $this->db->update('restricoes_'.$tabela, $dados) ) {
			return $ID;
		} else {
			$this::addSetup($tabela, $ID, $dados);
			return false;
		}
	}

	function addSetup($tabela, $ID, $dados) {
		if ( $this->db->insert('restricoes_'.$tabela, $dados) ) {
			return $this->db->getInsertID();
		} else {
			return false;
		}
	}

	function delSetup($tabela, $ID) {
		$this->db->where('id', $ID);
		if ( $this->db->delete('restricoes_'.$tabela) ) {
			return true;
		} else {
			return false;
		}
	}

	function getSetup() {
		$this->db->orderBy('id', 'DESC');
		return $this->setup = $this->db->ObjectBuilder()->getOne('restricoes_setup');
	}

	function excluirArquivo($ID) {
		$a = $this::getArquivo($ID);
		if( is_file($a->path.$a->arquivo) ) {
			@unlink($a->path.$a->arquivo);
		}
		if( $a->tipo == 'imagem' ) {
			@unlink($a->path.'min/'.$a->arquivo);
		}
		$this->db->where('id', $ID);
		$this->db->delete('restricoes_arquivos');
		return true;
	}

	function getArquivo($ID) {
		$this->db->where('id', $ID);
		return $this->db->ObjectBuilder()->getOne('restricoes_arquivos');
	}

	function consultaEmbargo($id = false, $doc = false) {
		if($id) { $this->db->where('id', $id); }
		if($doc) { $this->db->where('documento', $doc); }
		return $this->db->ObjectBuilder()->getValue('restricoes', 'id', 1);
	}

	function getArquivosCodigo($codigo) {
		$this->db->where('codigo', $codigo);
		return $this->db->ObjectBuilder()->get('restricoes_arquivos');
	}

	function galeriaArquivos($o) {
		$this->db->where('codigo', $o->codigo);
		$this->db->where('tipo', 'arquivo');
		return $this->db->ObjectBuilder()->get('restricoes_arquivos');
	}

	function setStatus($ID, $status, $depto = false) {
		$this->db->where('id', $ID);
		$dados['status'] = $status;
		$this->db->update('restricoes', $dados);
	}

	function setLegenda($ID, $legenda) {
		$this->db->where('id', $ID);
		return $this->db->update('restricoes_arquivos', $legenda);
	}

	function addResposta($dados) {
		if ( $this->db->insert('restricoes_respostas', $dados) ) {
			return $this->db->getInsertID();
		} else {
			return false;
		}
	}

	function excluirResposta($ID) {
		if ($r = $this::getRespostaID($ID) ) {
			if ($A = $this::getArquivosCodigo($r->codigo)) {
				foreach ($A as $a) {
					$this::excluirArquivo($a->id);
				}
				$path = $A[0]->path;
				@rmdir($path);
				$from = array('arquivos/', 'imagens/'); $to = array('', '');
				@rmdir(str_replace($from, $to, $path));
			}
		}
		$this->db->where('id' ,$ID);
		if ( $this->db->delete('restricoes_respostas') ) {
			return true;
		} else {
			return false;
		}
	}

	function editarResposta($ID, $dados) {
		$this->db->where('id', $ID);
		if ( $this->db->update('restricoes_respostas', $dados) ) {
			return true;
		} else {
			return false;
		}
	}

	function getRespostas($p) {
		$this->db->join('app_usuarios u', 'r.usuario = u.ID', 'LEFT');
		$this->db->where('r.contrato', $p);
		$this->db->where('r.resposta', 'Restricoes recebido.', '!=');
		return $this->db->ObjectBuilder()->get('restricoes_respostas r', null, 'r.*, u.nome as usuario_nome');
	}

	function getRespostaID($r) {
		$this->db->where('id', $r);
		return $this->db->ObjectBuilder()->getOne('restricoes_respostas');
	}
	
	function getRestricoes($limitador = 300, $busca = false) {
		if(!$limitador) { $limitador = 300; } else if ($limitador == 'all') { $limitador = null; }
		$this->db->where('p.entidade', $this->_auth->entidade->id);

		$this->db->join('restricoes_status s', 's.id = p.status', 'LEFT');
		$this->db->OrderBy('p.data', 'DESC');

		if ($busca) {
			$this->db->where("(p.documento = '$busca' OR p.nome LIKE '%$busca%')");
		}

		if ($restricoes = $this->db->ObjectBuilder()->get('restricoes p', $limitador, 'p.*, s.nome as status, s.id as status_id')) {
			foreach($restricoes as $p) {
				$p->{'respostas'} = $this::getRespostas($p->id);
				$RESTRICOES[] = $p;
			}
			return $this->restricoes = $RESTRICOES;
		} else {
			return null;
		}
			
	}

	function getRestricoesCodigo($codigo) {
		$this->db->join('restricoes_departamentos d', 'd.id = p.departamento', 'LEFT');
		$this->db->join('restricoes_status s', 's.id = p.status', 'LEFT');
		$this->db->where('p.codigo', $codigo);
		$this->db->where('p.entidade', $this->_auth->entidade->id);
		$contrato = $this->db->ObjectBuilder()->get('restricoes p', null, 'p.*, d.nome as departamento, p.departamento as departamento_id, s.nome as status, s.id as status_id')[0];
		return $contrato;
	}

	function getRestricaoID($ID) {
		$this->db->join('restricoes_status s', 's.id = p.status', 'LEFT');
		if(is_array($ID)) {
			$this->db->where('p.id', $ID, 'IN');
		} else {
			$this->db->where('p.id', $ID);
		}
		if( $contrato = $this->db->ObjectBuilder()->get('restricoes p', null, 'p.*, s.nome as status, s.id as status_id')[0] ) {
			$contrato->{'respostas'} = $this::getRespostas($contrato->id);
		}
		return $contrato;
	}

	function consultaAcessoRestricoes($usuario, $contrato) {
		$this->db->where('usuario', $usuario);
		$this->db->where('entidade', $this->_auth->entidade->id);
		$this->db->where('nivel', 1);
		if ( $this->db->getOne('restricoes_acessos') ) {
			return true;
		
		} else {
			$this->db->join('restricoes_departamentos d', 'd.id = p.departamento', 'INNER');
			$this->db->join('restricoes_departamentos_acesso a', "a.departamento = d.id AND a.usuario = '".$this->_auth->usuario->ID."'", 'INNER');
			$this->db->where('p.id', $contrato->id);

			if ( $this->db->get('restricoes p', null, 'p.*') ) {
				return true;

			} else {
				return $contrato->departamento;

			}
		}
	}

	function getUsuarioID($ID) {
		$this->db->where('ID', $ID);
		return $this->db->ObjectBuilder()->getOne('app_usuarios');
	}

	function editar($ID, $dados) {
		$this->db->where('id', $ID);
		if( $this->db->update('restricoes', $dados) ) {
			return true;
		} else {
			return false;
		}
	}


	function excluir($ID) {
		$o = $this::getRestricoesID($ID);

		if ($r = $o->respostas) {
			foreach($r as $r) {
				if ($A = $this::getArquivosCodigo($r->codigo)) {
					foreach ($A as $a) {
						$this::excluirArquivo($a->id);
					}
					$path = $A[0]->path;
					@rmdir($path);
					$from = array($r->codigo); $to = array('', '');
					@rmdir(str_replace($from, $to, $path));
				}
				$R[] = $r->id;
			}
			$this->db->where('id', $R, 'IN');
			$this->db->delete('restricoes_respostas');
		}
		if ($A = $this::getArquivosCodigo($o->codigo)) {
			foreach ($A as $a) {
				$this::excluirArquivo($a->id);
			}
			$path = $A[0]->path;
			@rmdir($path);
			$from = array('arquivos/'); $to = array('', '');
			@rmdir(str_replace($from, $to, $path));
		}

		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->delete('restricoes');
	}


	function criar($dados) {
		$dados['status'] = $this::getStatusPadrao($dados['entidade']);
		if ($this->db->insert('restricoes', $dados)){
			$ID = $this->db->getInsertID();
			if($dados['email']) {
				//$this::enviarEmail('criar', $ID);
			}
			return $ID;
		} else {
			var_dump($this->db->getLastError());
			return false;
		}
	}

	function getDepartamentos() {
		$this->db->OrderBy('nome', 'ASC');
		$this->db->groupBy('nome');
		$this->db->where('entidade', $this->_auth->entidade->id);
		$this->departamentos = $this->db->ObjectBuilder()->get('restricoes_departamentos');
		return $this->departamentos;
	}

	function getDepartamentoID($ID) {
		$this->db->where('id', $ID);
		$this->db->groupBy('nome');
		$this->db->where('entidade', $this->_auth->entidade->id);
		$departamento = $this->db->ObjectBuilder()->get('restricoes_departamentos');
		return $departamento;
	}

	function getStatus() {
		$this->db->OrderBy('nome', 'ASC');
		$this->db->groupBy('nome');
		$this->db->where('entidade', $this->_auth->entidade->id);
		$this->status = $this->db->ObjectBuilder()->get('restricoes_status');
		return $this->status;
	}

	function getStatusPadrao($entidade = false) {
		if($entidade) {
			$this->db->where('entidade', $entidade);
		}
		$this->db->OrderBy('nome', 'ASC');
		$this->db->groupBy('nome');
		$this->db->where('padrao', 1);
		$this->status_padrao = $this->db->ObjectBuilder()->getValue('restricoes_status', 'id', 1);
		return $this->status_padrao ?? 0;
	}

	function padraoStatus($ID) {
		$dados['padrao'] = 0;
		$this->db->update('restricoes_status', $dados);

		$dados['padrao'] = 1;
		$this->db->where('id', $ID);
		$this->db->update('restricoes_status', $dados);
		return true;
	}

	function getRestricoesView($limitador, $busca = false, $orderBy = false, $pagina = 1) {
		$padrao = $this::getStatusPadrao($this->_auth->entidade->id);

		$this->db->join('restricoes_status s', 's.id = e.status', 'LEFT');
		if ($busca) {
			$this->db->where("(e.documento = '$busca' OR e.nome LIKE '%$busca%')");
		}
		$this->db->where('e.status', $padrao);
		//$this->db->where('e.entidade', $this->entidade->id);
		if ($orderBy) {
			$this->db->OrderBy($orderBy->campo, $orderBy->ordem);
		} else {
			$this->db->OrderBy('data', 'DESC');
		}
		$this->db->pageLimit = $limitador;
		if ($restricoes = $this->db->ObjectBuilder()->paginate('restricoes e', $pagina, 'e.*, s.nome as status, s.id as status_id'))  {
			$this->totalCount = $this->db->totalCount;
			foreach($restricoes as $e) { 
				$e->{'respostas'} = $this::getRespostas($e->id);
			}
			return $restricoes;
		} else {
			return false;
		}
	}
}

return $RESTRICOES = new Restricoes($isView);


function mascara($val, $mask) {
  $maskared = '';
  $k = 0;
  for($i = 0; $i<=strlen($mask)-1; $i++)
  {
     if($mask[$i] == '#')
     {
        if(isset($val[$k]))
        $maskared .= $val[$k++];
     }
     else
     {
        if(isset($mask[$i]))
           $maskared .= $mask[$i];
     } 
  }
  return $maskared;
}


?>