<?

class Protocolo extends APP {
	PRIVATE $APP;

	PUBLIC $protocolos;
	PUBLIC $departamentos;

	function __construct($isView) { GLOBAL $_POST;
		if($isView) { $this->isView = true; }
		parent::__construct($isView);
		$this::getDepartamentos();
		//$this::getProtocolos($_POST['carregar'], $_POST['departamento'], $_POST['busca']);
		//$this::getUsuarios();
		//$this::getStatus();
		$this::getSetup();
		$this->_admin = $this::consultaNivel($this->_auth->usuario->ID);
		$this::visitaAssistida($this->_admin, $_POST['departamento']);
	}

	function visitaAssistida($admin = null, $depto = null) {
		if(!$admin OR !$depto) {
			return false;
		} else {
			$u = $this::getUsuarioID($this->_auth->usuario->ID);
			$u->{'_admin'} = null;
			$u->{'departamentos'}[] = $this::getDepartamentoID($depto);
			$u->{'lista_dptos'} = $this->departamentos->nome;
			$this->usuarios[$this->_auth->usuarios->ID];
		}
	}

	PRIVATE function getSetup() {
		if(!$this->db->ObjectBuilder()->rawQuery('SHOW COLUMNS FROM protocolo_setup WHERE Field = "entidade"')){
			$this->db->rawQuery('ALTER TABLE protocolo_setup CHANGE COLUMN id id INT(11) NOT NULL AUTO_INCREMENT FIRST, ADD COLUMN entidade INT(11) NOT NULL DEFAULT 0 AFTER email_porta;');

			$this->db->where('matriz', 1);
			$ent = $this->db->ObjectBuilder()->getValue('app_entidades', 'id');
			$this->db->where('id', 1);
			$this->db->update('protocolo_setup', array('entidade' => (int) $ent));
		}
		$this->db->where('entidade', $this->_auth->entidade->id);
		if ( $this->setup = $this->db->ObjectBuilder()->getOne('protocolo_setup') ) {
			## Configurações de E-amail
			define('pEMAIL', $this->setup->email_email);
			define('pEMAIL_NOME', $this->setup->email_nome);
			define('pEMAIL_HOST', $this->setup->email_host);
			define('pEMAIL_LOGIN', $this->setup->email_login);
			define('pEMAIL_SENHA', $this->setup->email_senha);
			define('pEMAIL_PORTA', $this->setup->email_porta ?? 587);
		} else {
			return false;
		}
	}

	function viewID($id, $ano) {
		if ($id >= 2018000001) {
			$ano = substr($id, 0, 4);
			$numero = (int) substr($id, 5);
			return str_pad($numero, 5, "0", STR_PAD_LEFT).'/'.$ano;
		} else {
			return str_pad($id, 5, "0", STR_PAD_LEFT).'/'.$ano;
		}
	}

	function configEmail($dados) {
		if($this->setup) {
			$this->db->where('id', $this->setup->id);
			return $this->db->update('protocolo_setup', $dados);
		} else {
			return $this->db->insert('protocolo_setup', $dados);
		}
	}

	function startEmail() {
		##### PHP MAILER;
		include ('app/core/PHPMailer/PHPMailerAutoload.php');
		$this->email = new PHPMailer;
			$this->email->isSMTP();
			//$this->email->SMTPDebug = 2;
			$this->email->Host = pEMAIL_HOST;
			$this->email->SMTPAuth = true;
			$this->email->Username = pEMAIL_LOGIN;
			$this->email->Password = pEMAIL_SENHA;
			$this->email->SMTPSecure = 'ssl'; // ssl / tls
			$this->email->Port = pEMAIL_PORTA;
			$this->email->setFrom(pEMAIL, pEMAIL_NOME);
	}


	function enviarEmail($acao, $ID) {

		GLOBAL $APP;
		GLOBAL $path;
		$p = $this::getProtocoloID($ID);
		if(!$p->email) {
			return false;
		}

		if(!$acao or !$p) { return true; }

		## Iniciar E-mail
		if (!$this->email) { $this->startEmail(); }

		## Prepara Mensagem;
		if($acao == 'criar') {
			$assunto = 'Protocolo online registrado com sucesso!';
			$mensagem = 'Olá, '.$p->nome.'.<br>
				Acaba de ser registrado seu protocolo em nosso sistema.<br>
				Seu protocolo será respondido assim que possível.<br>';

		} else if ($acao == 'atualizacao') {
			$assunto = 'Protocolo online atualizado!';
			$mensagem = 'Olá, '.$p->nome.'.<br>
				Seu protocolo foi atualizado em nosso sistema.<br>';
		}

		## Importa Template
		include($path['core'].'template.php');

		## Prepara o Envio
		$this->email->addAddress($p->email);
		$this->email->Subject = $assunto;
		$this->email->Body    = $template;
		$this->email->isHTML(true);
		## Envia
		if (@$this->email->send()) {
			## Informa envip.
			$this->db->where('id', $ID);
			$dados['envio'] = 1;
			$this->db->update('protocolo', $dados);
		}
		return true;
	}

	function excluirArquivo($ID) {
		$a = $this::getArquivo($ID);
		if( is_file($a->path.$a->arquivo) ) {
			@unlink($a->path.$a->arquivo);
		}
		if( $a->tipo == 'imagem' ) {
			@unlink($a->path.'min/'.$a->arquivo);
		}
		$this->db->where('id', $ID);
		$this->db->delete('protocolo_arquivos');
		return true;
	}

	function getArquivo($ID) {
		$this->db->where('id', $ID);
		return $this->db->ObjectBuilder()->getOne('protocolo_arquivos');
	}

	function consultaProtocolo($p, $d) {
		if(is_array($p)) {
			$this->db->where('id', $p, 'IN');
		} else {
			$this->db->where('id', $p);
		}
		$this->db->where('documento', $d);
		return $this->db->ObjectBuilder()->getValue('protocolo', 'id', 1);
	}

	function getArquivosCodigo($codigo) {
		$this->db->where('codigo', $codigo);
		return $this->db->ObjectBuilder()->get('protocolo_arquivos');
	}

	function galeriaArquivos($o) {
		$this->db->where('codigo', $o->codigo);
		$this->db->where('tipo', 'arquivo');
		return $this->db->ObjectBuilder()->get('protocolo_arquivos');
	}

	function setStatus($ID, $status, $depto = false) {
		$this->db->where('id', $ID);
		$dados['status'] = $status;
		if($depto) { $dados['departamento'] = $depto; }
		$this->db->update('protocolo', $dados);
	}

	function setSetup($tabela, $ID, $dados) {
		$this->db->where('id', $ID);
		if ( $this->db->update('protocolo_'.$tabela, $dados) ) {
			return $ID;
		} else {
			return false;
		}
	}

	function setLegenda($ID, $legenda) {
		$this->db->where('id', $ID);
		return $this->db->update('protocolo_arquivos', $legenda);
	}

	function addSetup($tabela, $ID, $dados) {
		if ( $this->db->insert('protocolo_'.$tabela, $dados) ) {
			return $this->db->getInsertID();
		} else {
			return false;
		}
	}

	function delSetup($tabela, $ID) {
		$this->db->where('id', $ID);
		if ( $this->db->delete('protocolo_'.$tabela) ) {
			return true;
		} else {
			return false;
		}
	}

	function addResposta($dados) {
		if ( $this->db->insert('protocolo_respostas', $dados) ) {
			return $this->db->getInsertID();
		} else {
			return false;
		}
	}

	function excluirResposta($ID) {
		if ($r = $this::getRespostaID($ID) ) {
			if ($A = $this::getArquivosCodigo($r->codigo)) {
				foreach ($A as $a) {
					$this::excluirArquivo($a->id);
				}
				$path = $A[0]->path;
				@rmdir($path);
				$from = array('arquivos/', 'imagens/'); $to = array('', '');
				@rmdir(str_replace($from, $to, $path));
			}
		}
		$this->db->where('id' ,$ID);
		if ( $this->db->delete('protocolo_respostas') ) {
			return true;
		} else {
			return false;
		}
	}

	function editarResposta($ID, $dados) {
		$this->db->where('id', $ID);
		if ( $this->db->update('protocolo_respostas', $dados) ) {
			return true;
		} else {
			return false;
		}
	}

	function consultaRecebimento($p) {
		$this->db->where('r.protocolo', $p);
		$this->db->join('app_usuarios u', 'r.usuario = u.ID', 'LEFT');
		$this->db->OrderBy('r.id', 'DESC');
		return $this->db->ObjectBuilder()->get('protocolo_respostas r', null, 'r.*, u.nome as usuario_nome')[0] ?? false;
	}

	function getRespostas($p) {
		$this->db->where('r.protocolo', $p);
		$this->db->where('r.resposta', 'Protocolo recebido.', '!=');
		$this->db->join('app_usuarios u', 'r.usuario = u.ID', 'LEFT');
		return $this->db->ObjectBuilder()->get('protocolo_respostas r', null, 'r.*, u.nome as usuario_nome') ?? false;
	}

	function getRespostaID($r) {
		$this->db->where('id', $r);
		return $this->db->ObjectBuilder()->getOne('protocolo_respostas');
	}
	
	function getProtocolos($limitador = 300, $departamento = false, $busca = false) {
		if(!$limitador) { $limitador = 300; } else if ($limitador == 'all') { $limitador = null; }

		$this->db->where('usuario', $this->_auth->usuario->ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		$this->db->where('nivel', array(1,-1), 'IN');
		if (!$this->db->getOne('protocolo_acessos')) {
			$this->db->join('protocolo_departamentos d', 'd.id = p.departamento', 'LEFT');
			$this->db->join('protocolo_departamentos_acesso a', "a.departamento = d.id AND a.usuario = '".$this->_auth->usuario->ID."'", 'INNER');
		} else {
			$this->db->join('protocolo_departamentos d', 'd.id = p.departamento', 'LEFT');
		}
		$this->db->join('app_usuarios u', 'u.id = p.usuario', 'LEFT');
		$this->db->join('protocolo_status s', 's.id = p.status', 'LEFT');
		$this->db->where('s.nome', array('encerrado', 'encerrados', 'finalizado', 'finalizados', 'despachado', 'despachados'), 'NOT IN');
		$this->db->where('p.entidade', $this->_auth->entidade->id);
		$this->db->OrderBy('p.data', 'DESC');
		
		if ($departamento) { $this->db->where('d.id', $departamento); }

		if ($busca) {
			$b = explode('/', $busca);
			if($b[1]) {
				if(strlen($b[1]) == 2) {
					$ano = '20'.$b[1];
				} else if (strlen($b[1]) == 4) {
					$ano = $b[1];
				}
			}
			$filtro = (int) $b[0];
			if($ano) {
				$this->db->where("YEAR(p.data) = '$ano'");
			}
			$this->db->where("p.id LIKE '%$filtro'");
		}

		if ($protocolos = $this->db->ObjectBuilder()->get('protocolo p', $limitador, 'p.*, d.nome as departamento, p.departamento as departamento_id, s.nome as status, s.id as status_id, u.nome as usuario_nome') ) {
			foreach($protocolos as $p) {
				$p->{'respostas'} = $this::getRespostas($p->id);
				$PROTOCOLOS[] = $p;
			}
			return $this->protocolos = $PROTOCOLOS;
		} else {
			return null;
		}
			
	}

	function getProtocoloCodigo($codigo) {
		$this->db->join('protocolo_departamentos d', 'd.id = p.departamento', 'LEFT');
		$this->db->join('protocolo_status s', 's.id = p.status', 'LEFT');
		$this->db->where('p.codigo', $codigo);
		$this->db->where('p.entidade', $this->_auth->entidade->id);
		$protocolo = $this->db->ObjectBuilder()->get('protocolo p', null, 'p.*, d.nome as departamento, p.departamento as departamento_id, s.nome as status, s.id as status_id')[0];
		return $protocolo;
	}

	function getDeptoAnterior($ID) {
		$this->db->where('id', $ID);
		return (int) $this->db->getValue('protocolo', 'departamento');
	}

	function getProtocoloID($ID) {
		$this->db->join('protocolo_departamentos d', 'd.id = p.departamento', 'LEFT');
		$this->db->join('protocolo_status s', 's.id = p.status', 'LEFT');
		if(is_array($ID)) {
			$this->db->where('p.id', $ID, 'IN');
		} else {
			$this->db->where('p.id', $ID);
		}
		$this->db->OrderBy('p.id', 'DESC');
		if( $protocolo = $this->db->ObjectBuilder()->get('protocolo p', null, 'p.*, d.nome as departamento, p.departamento as departamento_id, s.nome as status, s.id as status_id')[0] ) {
			$protocolo->{'respostas'} = $this::getRespostas($protocolo->id);
		}
		return $protocolo;
	}

	function consultaAcessoProtocolo($usuario, $protocolo) {
		$this->db->where('usuario', $usuario);
		$this->db->where('entidade', $this->_auth->entidade->id);
		$this->db->where('nivel', 1);
		if ( $this->db->getOne('protocolo_acessos') ) {
			return true;
		
		} else {
			$this->db->join('protocolo_departamentos d', 'd.id = p.departamento', 'INNER');
			$this->db->join('protocolo_departamentos_acesso a', "a.departamento = d.id AND a.usuario = '".$this->_auth->usuario->ID."'", 'INNER');
			$this->db->where('p.id', $protocolo->id);

			if ( $this->db->get('protocolo p', null, 'p.*') ) {
				return true;

			} else {
				return $protocolo->departamento;

			}
		}


	}

	function getUsuarioID($ID) {
		$this->db->where('ID', $ID);
		return $this->db->ObjectBuilder()->getOne('app_usuarios');
	}

	function editar($ID, $dados) {
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		$dados['envio'] = 0;
		if( $this->db->update('protocolo', $dados) ) {
			return true;
		} else {
			return false;
		}
	}


	function excluir($ID) {
		$o = $this::getProtocoloID($ID);

		if ($r = $o->respostas) {
			foreach($r as $r) {
				if ($A = $this::getArquivosCodigo($r->codigo)) {
					foreach ($A as $a) {
						$this::excluirArquivo($a->id);
					}
					$path = $A[0]->path;
					@rmdir($path);
					$from = array($r->codigo); $to = array('', '');
					@rmdir(str_replace($from, $to, $path));
				}
				$R[] = $r->id;
			}
			$this->db->where('id', $R, 'IN');
			$this->db->delete('protocolo_respostas');
		}
		if ($A = $this::getArquivosCodigo($o->codigo)) {
			foreach ($A as $a) {
				$this::excluirArquivo($a->id);
			}
			$path = $A[0]->path;
			@rmdir($path);
			$from = array('arquivos/'); $to = array('', '');
			@rmdir(str_replace($from, $to, $path));
		}

		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->delete('protocolo');
	}


	function criar($dados) {
		$dados['status'] = $this::getStatusPadrao($dados['entidade']);
		if ($this->db->insert('protocolo', $dados)){
			$ID = $this->db->getInsertID();
			if($dados['email']) {
				//$this::enviarEmail('criar', $ID);
			}
			return $ID;
		} else {
			var_dump($this->db->getLastError());
			return false;
		}
	}

	function getDepartamentos() {
		$this->db->OrderBy('nome', 'ASC');
		$this->db->groupBy('nome');
		$this->db->where('entidade', $this->_auth->entidade->id);
		$departamentos = $this->db->ObjectBuilder()->get('protocolo_departamentos');
		foreach($departamentos as $d) {
			$this->departamentos[$d->id] = $d;
		}
		return $this->departamentos;
	}

	function getDepartamentoID($ID) {
		$this->db->where('id', $ID);
		$this->db->groupBy('nome');
		$this->db->where('entidade', $this->_auth->entidade->id);
		$departamento = $this->db->ObjectBuilder()->get('protocolo_departamentos');
		return $departamento;
	}

	function getStatus() {
		$this->db->OrderBy('nome', 'ASC');
		$this->db->groupBy('nome');
		$this->db->where('entidade', $this->_auth->entidade->id);
		$this->status = $this->db->ObjectBuilder()->get('protocolo_status');
		return $this->status;
	}

	function getStatusPadrao($entidade = false) {
		if($entidade) {
			$this->db->where('entidade', $entidade);
		} else {
			$this->db->where('entidade', $this->_auth->entidade->id);
		}
		$this->db->OrderBy('nome', 'ASC');
		$this->db->groupBy('nome');
		$this->db->where('padrao', 1);
		$this->status_padrao = $this->db->ObjectBuilder()->getValue('protocolo_status', 'id', 1);
		return $this->status_padrao ?? 0;
	}

	function padraoStatus($ID) {
		$dados['padrao'] = 0;
		$this->db->update('protocolo_status', $dados);

		$dados['padrao'] = 1;
		$this->db->where('id', $ID);
		$this->db->update('protocolo_status', $dados);
		return true;
	}

	function notificar($ID) {
		return $this::enviarEmail('atualizacao', $ID);
	}
	
	function resetEnvio($ID) {
		$this->db->where('id', $ID);
		$update['envio'] = 0;
		$this->db->update('protocolo', $update);
	}

	function getUsuarios() { GLOBAL $S;
		//$this->db->where('u.ID', $this->_auth->usuario->ID);
		$this->db->join('app_permissoes p', "p.usuario = u.ID AND p.aplicativo = '$S->ID' AND p.entidade = '".$this->_auth->entidade->id."'", 'INNER');
		$this->db->join('app_entidades_aplicativos e', "e.entidade = '".$this->_auth->entidade->id."' AND e.aplicativo = '$S->ID'", 'INNER');
		if ( $u = $this->db->ObjectBuilder()->get('app_usuarios u', null, 'u.*') ) {
			foreach ($u as $u) {
				$u->{'_admin'} = $this::consultaNivel($u->ID);
				$u->{'_controle'} = $this::consultaControle($u->ID);
				$u->{'departamentos'} = $this::consultaDepartamentos($u->ID);
				$u->{'lista_dptos'} = $this::listarDepartamentos($u->ID);
				$usuarios[$u->ID] = $u;
			}
		}
		$this->usuarios = $usuarios;
	}

	function consultaNivel($ID) {
		$this->db->where('usuario', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		$this->db->where('nivel', 1);
		return $nivel = $this->db->ObjectBuilder()->getValue('protocolo_acessos', 'id', 1);
	}

	function consultaControle($ID) {
		$this->db->where('usuario', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		$this->db->where('nivel', -1);
		return $nivel = $this->db->ObjectBuilder()->getValue('protocolo_acessos', 'id', 1);
	}

	function consultaDepartamentos($ID) {
		$this->db->where('a.usuario', $ID);
		$this->db->where('a.entidade', $this->_auth->entidade->id);
		$this->db->join('protocolo_departamentos_acesso a', 'a.departamento = d.id', 'INNER');
		$departamentos = $this->db->ObjectBuilder()->get('protocolo_departamentos d', NULL, 'd.*');
		return $departamentos;
	}

	function listarDepartamentos($ID) {
		$this->db->where('a.usuario', $ID);
		$this->db->where('a.entidade', $this->_auth->entidade->id);
		$this->db->join('protocolo_departamentos_acesso a', 'a.departamento = d.id', 'INNER');
		if ( $lista = $this->db->getValue('protocolo_departamentos d', 'd.nome', null) ) {
			return implode(', ', $lista);
		}
	}

	function setAcesso($ID, $departamentos, $nivel = null) {
		$this::setDepartamentos($ID, $departamentos);
		$this::setNivel($ID, $nivel);
		return true;
	}

	function receber($ID) {
		$recebido = $this::statusRecebido();
		$dados = array(
			'protocolo' => $ID,
			'usuario' => $this->_auth->usuario->ID,
			'resposta' => 'Protocolo recebido.',
			'codigo' => geraSenha(25),
			'data' => date('Y-m-d H:i:s'),
			);

		if ($recebido AND $this::addResposta($dados) ) {
			$this::setStatus($ID, $recebido);
			$this::resetEnvio($ID);
			return true;
		} else {
			$return = array(
				'success' => false,
				'msg' => 'Dados inválidos. Atualize a página e tente novamente.',
				'mtipo' => 'error',
			);
		}
		
	}

	function statusRecebido() {
		$this->db->where('nome', 'Recebido');
		$this->db->where('entidade', $this->_auth->entidade->id);
		if ( $status = $this->db->ObjectBuilder()->getOne('protocolo_status') ) {
			return $status->id;
		} else {
			$dados = array(
				'nome' => 'Recebido',
				'entidade' => $this->_auth->entidade->id,
				'padrao' => 0,
			);
			if($this->db->insert('protocolo_status', $dados)) {
				return $this->db->getInsertID();
			} else {
				return false;
			}
		}
	}

	function setDepartamentos($ID, $dep) {
		$this->db->where('usuario', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		$this->db->delete('protocolo_departamentos_acesso');
		if($dep) {
			foreach($dep as $d) {
				$dados[] = array(
					'usuario' => $ID,
					'entidade' => $this->_auth->entidade->id,
					'departamento' => $d
				);
			}
			$this->db->insertMulti('protocolo_departamentos_acesso', $dados);
		}
	}

	function setNivel($ID, $nivel) {
		if($nivel == 0) {
			$this->db->where('usuario', $ID);
			$this->db->where('entidade', $this->_auth->entidade->id);
			$this->db->delete('protocolo_acessos');

		} else if ( $reg = $this::consultaNivel($ID) ) {
			$dados = array ('usuario' => $ID, 'nivel' => $nivel, 'entidade' => $this->_auth->entidade->id);
			$this->db->where('id', $reg);
			$this->db->update('protocolo_acessos', $dados);

			$this->db->where('usuario', $ID);
			$this->db->where('entidade', $this->_auth->entidade->id);
			$this->db->delete('protocolo_departamentos_acesso');

		} else {
			$dados = array ('usuario' => $ID, 'nivel' => $nivel, 'entidade' => $this->_auth->entidade->id);
			$this->db->insert('protocolo_acessos', $dados);

			$this->db->where('usuario', $ID);
			$this->db->where('entidade', $this->_auth->entidade->id);
			$this->db->delete('protocolo_departamentos_acesso');
		}
	}

	function Auditoria($DEP = false) {
		if($DEP === false) {
			$this->db->join('protocolo_departamentos d', 'd.id = p.departamento', 'LEFT');
			$this->db->join('protocolo_status s', 's.id = p.status', 'LEFT');
			$this->db->where('p.entidade', $this->_auth->entidade->id);
			$this->db->OrderBy('d.nome', 'ASC');
			$this->db->GroupBy('d.id');
			$this->db->GroupBy('s.id');
			if ($protocolos = $this->db->ObjectBuilder()->get('protocolo p', null, 'p.*, d.nome as departamento, d.id as departamento_id, s.nome as status, count(s.id) as qtd, count(p.id) as total') ) {
				$auditoria = (object) array();
				foreach($protocolos as $p) {
					$auditoria->{$p->departamento ?? 'Sem Departamento'}[$p->status] = $p->total;
					$auditoria->{$p->departamento ?? 'Sem Departamento'}['id'] = $p->departamento_id;
				}
				return $auditoria;
			} else {
				return null;
			}
		} else {
			if($DEP > 0) {
				$this->db->where('d.id', $DEP);
			} else {
				$this->db->where('d.id IS NULL');
			}
			$this->db->join('protocolo_departamentos d', 'd.id = p.departamento', 'LEFT');
			$this->db->join('protocolo_status s', 's.id = p.status', 'LEFT');
			$this->db->where('p.entidade', $this->_auth->entidade->id);
			$this->db->OrderBy('d.nome', 'ASC');
			$this->db->OrderBy('s.nome', 'ASC', array('recebido', 'pendente', 'finalizado'));
			$this->db->OrderBy('p.data', 'ASC');
			$this->db->OrderBy('p.id', 'ASC');
			if ($protocolos = $this->db->ObjectBuilder()->get('protocolo p', 250, 'p.*, d.nome as departamento, p.departamento as departamento_id, s.nome as status, s.id as status_id') ) {
				$auditoria = (object) array();
				foreach($protocolos as $p) {
					$p->{'respostas'} = $this::getRespostas($p->id);
					$auditoria->{$p->status}[] = $p;
				}
				return $auditoria;
			} else {
				return null;
			}

		}	
	}


}

return $PROTOCOLO = new Protocolo($isView);

?>