<?
class Popup extends APP {
	PRIVATE $APP;

	PUBLIC $popups;
	PUBLIC $secoes;

	function __construct($isView) {
		if($isView) { $this->isView = true; }
		parent::__construct($isView);
		$this::getPopups();
		$this::getSecoes();
		$this::getSetup();
		if ((int) ENTIDADE !== 0) {
			$this->_auth->entidade = $this::getEntidade(ENTIDADE);
		}
	}

	function getSetup() {
		$this->db->where('entidade', ($this->_auth->entidade->id ?? 1));
		$setup = $this->db->ObjectBuilder()->getOne('popup_setup');
		if ($setup) {
			return $this->setup = $setup;
		} else {
			$dados = array(
				'abertura' => 15,
				'intervalo' => 600,
				'cache' => 0,
				'entidade' => ($this->_auth->entidade->id ?? 1),
			);
			$this->db->insert('popup_setup', $dados);
			return $this::getSetup();
		}
	}

	function galeriaImagem($p) {
		$this->db->where("(codigo = '$p->codigo')");
		return $this->db->ObjectBuilder()->get('popup_arquivos');
	}

	function setSetup($tabela, $ID, $dados) {
		$this->db->where('id', $ID);
		if ( $this->db->update('popup_'.$tabela, $dados) ) {
			return $ID;
		} else {
			return false;
		}
	}

	function addSetup($tabela, $ID, $dados) {
		if ( $this->db->insert('popup_'.$tabela, $dados) ) {
			return $this->db->getInsertID();
		} else {
			return false;
		}
	}

	function delSetup($tabela, $ID) {
		$this->db->where('id', $ID);
		if ( $this->db->delete('popup_'.$tabela) ) {
			return true;
		} else {
			return false;
		}
	}

	function setLegenda($ID, $legenda) {
		$this->db->where('id', $ID);
		return $this->db->update('popup_arquivos', $legenda);
	}

	function excluirArquivo($ID) {
		$a = $this::getArquivo($ID);
		if( is_file($a->path.$a->arquivo) ) {
			@unlink($a->path.$a->arquivo);
		}
		if( $a->tipo == 'imagem' ) {
			@unlink($a->path.'min/'.$a->arquivo);
		}
		$this->db->where('id', $ID);
		$this->db->delete('popup_arquivos');
		return true;
	}

	function getArquivo($ID) {
		$this->db->where('id', $ID);
		return $this->db->ObjectBuilder()->getOne('popup_arquivos');
	}

	function getUrlArquivo($ID) {
		$this->db->where('id', $ID);
		$a = $this->db->ObjectBuilder()->getOne('popup_arquivos');
		if($a) {
			return DIR.$a->path.$a->arquivo;
		} else {
			return '';
		}
	}

	function getPopups() {
		$this->db->where('p.entidade', $this->_auth->entidade->id);
		$this->db->join('popup_secoes s', 'p.secao = s.id', 'LEFT');
		$this->db->join('app_aplicativos a', 'p.app_id = a.id', 'LEFT');
		$this->db->OrderBy('p.data', 'DESC');
		$this->popups = $this->db->ObjectBuilder()->get('popup p', null, 'p.*, s.nome as secao, s.id as secao_id, a.nome as integrado, a.icone as integrado_icone');
		return $this->popups;
	}

        function getPopupsView() {
            $this->db->where('p.status', 1);
            $this->db->where('p.entidade', $this->_auth->entidade->id);
            $this->db->join('popup_secoes s', 'p.secao = s.id', 'LEFT');
            $this->db->join('app_aplicativos a', 'p.app_id = a.id', 'LEFT');
            $this->db->OrderBy('p.data', 'DESC');

            $pop = $this->db->ObjectBuilder()->get('popup p', null, 'p.*, s.nome as secao, s.id as secao_id, a.nome as integrado, a.icone as integrado_icone');

            $POP = []; // Inicializa o array

            foreach ($pop as $p) {
                if ($p->app_id == 0) {
                    $p->{'imagens'} = $this::galeriaImagem($p);
                }
                $POP[] = $p;
            }

            return $POP;
        }


	function getPopupTag($TAG) {
		$this->db->where('tag', $TAG);
		$this->db->where('entidade', $this->_auth->entidade->id);
		$popup = $this->db->ObjectBuilder()->getOne('popup');
		return $popup;
	}

	function getPopupID($ID) {
		$this->db->where('id', $ID);
		$popup = $this->db->ObjectBuilder()->getOne('popup');
		return $popup;
	}

	function editar($ID, $dados) {
		if($dados['tag']) {
			$this->db->where('(tag = "'.$dados['tag'].'" AND id != "'.$ID.'")');
			$this->db->orWhere('tag LIKE ("'.$dados['tag'].'_%")  AND id != "'.$ID.'"');
			$TAGS = count($this->db->get('popup'));
			if($TAGS) {	$dados['tag'] = $dados['tag'].'_'.$TAGS; }
		}
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		if( $this->db->update('popup', $dados) ) {
			return $dados['tag'] ?? true;
		} else {
			return false;
		}
	}

	function desativar($ID) {
		$dados = array('status' => '0');
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->update('popup', $dados);
	}

	function ativar($ID) {
		$dados = array('status' => 1);
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->update('popup', $dados);
	}

	function excluir($ID) {
		$n = $this::getPopupID($ID);

		if ($A = $this::getArquivosCodigo($n->codigo)) {
			foreach ($A as $a) {
				$this::excluirArquivo($a->id);
			}
			$path = $A[0]->path;
			@rmdir($path.'min/');
			@rmdir($path);
			@rmdir($path.'arquivos/');
			$from = array('imagens/', 'arquivos/'); $to = array('', '');
			@rmdir(str_replace($from, $to, $path));
		}
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->delete('popup');
	}

	function getArquivosCodigo($codigo) {
		$this->db->where('codigo', $codigo);
		return $this->db->ObjectBuilder()->get('popup_arquivos');
	}

	function criar($dados) {
		$this->db->where('tag', $dados['tag']);
		$this->db->orWhere('tag LIKE ("'.$dados['tag'].'_%")');
		$TAGS = count($this->db->get('popup'));
		if($TAGS) {	$dados['tag'] = $dados['tag'].'_'.$TAGS; }
		if ($this->db->insert('popup', $dados)){
			return $dados['tag'];
		} else {
			var_dump($this->db->getLastError());
			return false;
		}
	}
	
	function getSecoes() {
		$this->db->OrderBy('nome', 'ASC');
		$this->db->groupBy('nome');
		$this->db->where('entidade', $this->_auth->entidade->id);
		$this->secoes = $this->db->ObjectBuilder()->get('popup_secoes');
		return $this->secoes;
	}

	function getAppIntegrados() {
		$this->db->where('a.id', array(3,12), 'IN');
		$this->db->OrderBy('a.nome', 'ASC');
		$this->db->join('app_entidades_aplicativos p', 'a.id = p.aplicativo AND p.entidade = '.$this->_auth->entidade->id, 'INNER');
		$this->db->groupBy('a.id');
		$aplicativos = $this->db->ObjectBuilder()->get('app_aplicativos a', null, 'a.*');
		return $aplicativos;
	}

	function getNoticias() {
		$this->db->where('status', 1);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->ObjectBuilder()->get('noticias');
	}
	function getEnquetes() {
		$this->db->where('status', 1);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->ObjectBuilder()->get('enquetes');
	}

	function contar($p) {
		$dados['contador'] = ++$p->contador;
		$this->db->where('id', $p->id);
		return $this->db->update('popup', $dados);
	}

	function viewIntegracao($p) {
		// Notícias
		if($p->app_id == 3) { 
			$this->db->where('id', $p->app_alvo);
			$this->db->where('entidade', $this->_auth->entidade->id);
			$noticia = $this->db->ObjectBuilder()->getOne('noticias n');
			if($n = $noticia) {
				$noticia->{'capa'} = (object) $this::getNoticiaCapa($n->capa);
			}
			return $noticia;
		}

		// Enquetes
		if($p->app_id == 12) {
			return $this::getEnqueteID($p->app_alvo);
		}
	}
		function getEnqueteID($ID) {
			$this->db->where('o.enquete', $ID);
			$this->db->where('e.entidade', $this->_auth->entidade->id);
			$this->db->join('enquetes_secoes s', 's.id = e.secao', 'LEFT');
			$this->db->join('enquetes_opcoes o', 'o.enquete = e.id', 'LEFT');
			$this->db->OrderBy('e.data', 'DESC');
			$this->db->groupBy('e.id');
			$this->db->groupBy('o.enquete');
			$en = $this->db->ObjectBuilder()->get('enquetes e', NULL, 'e.*, s.nome as secao, s.id as secao_id, SUM(o.votos) as votos')[0];
			if($en) {
				$en->{'opcoes'} = $this::getEnqueteOpcoes($ID);
				return $en;
			}
			return $en;
		}
			function getEnqueteOpcoes($ID) {
				$this->db->where('enquete', $ID);
				return $this->db->ObjectBuilder()->get('enquetes_opcoes');
			}

		function getNoticiaCapa($ID) {
			$this->db->where('id', $ID);
			if ( $capa = $this->db->ObjectBuilder()->getOne('noticias_arquivos') ){
				return $capa;
			} else {
				return $capa = (object) array(
					'path' => API.HD.'noticias/',
					'arquivo' => 'capa.jpg',
					);
			}
		}

}

return $POPUP = new Popup($isView);

?>