<?php
// autoload.php
// Carrega automaticamente as classes do WebPush e suas dependências

spl_autoload_register(function ($class) {
    $prefix = 'Minishlink\\WebPush\\';
    $baseDir = __DIR__ . '/vendor/src/';

    $len = strlen($prefix);
    if (strncmp($prefix, $class, $len) !== 0) {
        // não é da biblioteca
        return;
    }

    $relativeClass = substr($class, $len);
    $file = $baseDir . $relativeClass . '.php';

    if (file_exists($file)) {
        require $file;
    }
});
