<?php
// vapid_generate.php
// Gera ou exibe chaves VAPID no formato do arquivo existente

require_once __DIR__ . '/vendor/web-push-php-master/src/VAPID.php';
use Minishlink\WebPush\VAPID;

$vapidFile = __DIR__ . '/vapid_keys.php';

// Se já existir, só exibe as chaves atuais
if (file_exists($vapidFile)) {
    $keys = require $vapidFile;
    echo "✅ Chaves VAPID já existem:\n";
    echo "Public Key: " . $keys['publicKey'] . "\n";
    echo "Private Key: " . $keys['privateKey'] . "\n";
    exit;
}

// Caso contrário, gera novas
$keys = VAPID::createVapidKeys();

// Salva no mesmo formato
$content = "<?php\n" .
"// Chaves VAPID geradas previamente para o aplicativo Notificações\n" .
"return [\n" .
"    'publicKey'  => '" . $keys['publicKey'] . "',\n" .
"    'privateKey' => '" . $keys['privateKey'] . "'\n" .
"];";

file_put_contents($vapidFile, $content);

echo "✅ Novas chaves VAPID geradas e salvas:\n";
echo "Public Key: " . $keys['publicKey'] . "\n";
echo "Private Key: " . $keys['privateKey'] . "\n";
