<?php
header('Content-Type: application/json; charset=utf-8');

// ==============================
// 1️⃣ Inclui arquivo de conexão seguro
// ==============================
require_once __DIR__ . '/../adm/app/config.php'; // ajuste se necessário

$info = defined('InfoDB') ? InfoDB : null;
if (!$info) {
    echo json_encode(['status' => 'error', 'message' => 'Configuração InfoDB ausente']);
    exit;
}

// ==============================
// 2️⃣ Abre conexão
// ==============================
$conn = new mysqli($info['host'], $info['username'], $info['password'], $info['db']);
if ($conn->connect_error) {
    echo json_encode(['status' => 'error', 'message' => 'Falha na conexão: ' . $conn->connect_error]);
    exit;
}
$conn->set_charset($info['charset'] ?? 'utf8');

// ==============================
// 3️⃣ Recebe JSON do navegador
// ==============================
$input = file_get_contents('php://input');
$data = json_decode($input, true);

// DEBUG temporário para conferir
file_put_contents(__DIR__.'/debug_subscription.txt', print_r($data, true));

if (!$data || !isset($data['endpoint'], $data['keys']['p256dh'], $data['keys']['auth'])) {
    echo json_encode(['status' => 'error', 'message' => 'Token não recebido ou incompleto']);
    $conn->close();
    exit;
}

$endpoint = $data['endpoint'];
$p256dh   = $data['keys']['p256dh'];
$auth     = $data['keys']['auth'];

// ==============================
// 4️⃣ Cria tabela caso não exista
// ==============================
$conn->query("
CREATE TABLE IF NOT EXISTS notificacoes_tokens (
    id INT AUTO_INCREMENT PRIMARY KEY,
    endpoint TEXT NOT NULL,
    p256dh TEXT NOT NULL,
    auth TEXT NOT NULL,
    data_registro DATETIME NOT NULL,
    UNIQUE KEY unique_endpoint (endpoint(255))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
");

// ==============================
// 5️⃣ Insere ou atualiza token existente
// ==============================
// Usa prepared statement
$stmt = $conn->prepare("
INSERT INTO notificacoes_tokens (endpoint, p256dh, auth, data_registro)
VALUES (?, ?, ?, NOW())
ON DUPLICATE KEY UPDATE p256dh=VALUES(p256dh), auth=VALUES(auth), data_registro=NOW()
");

if (!$stmt) {
    echo json_encode(['status' => 'error', 'message' => 'Erro na query: ' . $conn->error]);
    $conn->close();
    exit;
}

$stmt->bind_param("sss", $endpoint, $p256dh, $auth);
if (!$stmt->execute()) {
    echo json_encode(['status' => 'error', 'message' => 'Falha ao salvar token: ' . $stmt->error]);
    $stmt->close();
    $conn->close();
    exit;
}

$stmt->close();
$conn->close();

// ==============================
// 6️⃣ Retorna sucesso
// ==============================
echo json_encode(['status' => 'success', 'message' => 'Token salvo com sucesso']);
