<?php
// vapid_generate.php

require_once __DIR__ . '/vendor/web-push-php-master/src/VAPID.php';
use Minishlink\WebPush\VAPID;

// Caminho do arquivo onde as chaves serão salvas
$vapidFile = __DIR__ . '/vapid_keys.php';

// Se já existir, apenas exibe
if (file_exists($vapidFile)) {
    require $vapidFile;
    echo "✅ Chaves VAPID já existem:\n";
    echo "Public Key: " . $VAPID_PUBLIC_KEY . "\n";
    echo "Private Key: " . $VAPID_PRIVATE_KEY . "\n";
    exit;
}

// Caso contrário, gera novas
$keys = VAPID::createVapidKeys();

$VAPID_PUBLIC_KEY  = $keys['publicKey'];
$VAPID_PRIVATE_KEY = $keys['privateKey'];

// Salva em vapid_keys.php
file_put_contents($vapidFile, "<?php\n\$VAPID_PUBLIC_KEY = '$VAPID_PUBLIC_KEY';\n\$VAPID_PRIVATE_KEY = '$VAPID_PRIVATE_KEY';\n");

echo "✅ Novas chaves VAPID geradas:\n";
echo "Public Key: $VAPID_PUBLIC_KEY\n";
echo "Private Key: $VAPID_PRIVATE_KEY\n";
