<?php
require __DIR__ . '/../../vendor/web-push-php-master/src/WebPush.php';
require __DIR__ . '/../../vendor/web-push-php-master/src/Subscription.php';

use Minishlink\WebPush\WebPush;
use Minishlink\WebPush\Subscription;

require_once __DIR__ . '/../../app/config.php'; // conexão com banco

// Importa chaves VAPID do arquivo
$vapidKeys = require __DIR__ . '/vapid_keys.php';

$auth = [
    'VAPID' => [
        'subject'    => 'mailto:seuemail@dominio.com', // substitua pelo seu email
        'publicKey'  => $vapidKeys['publicKey'],
        'privateKey' => $vapidKeys['privateKey'],
    ],
];

$webPush = new WebPush($auth);

// Pega todos os tokens da tabela notificacoes_token
$res = $conn->query("SELECT * FROM notificacoes_token");

if (!$res) {
    die("Erro ao buscar tokens: " . $conn->error);
}

while ($row = $res->fetch_assoc()) {
    $subscription = Subscription::create([
        'endpoint' => $row['endpoint'],
        'keys' => [
            'p256dh' => $row['p256dh'],
            'auth'   => $row['auth']
        ]
    ]);

    $payload = json_encode([
        'title' => '🚀 Notificação de Teste',
        'body'  => 'Funcionou! O push está ativo.'
    ]);

    $webPush->sendOneNotification($subscription, $payload);
}

// Envia todas notificações pendentes
foreach ($webPush->flush() as $report) {
    if ($report->isSuccess()) {
        echo "✅ Notificação enviada: " . $report->getEndpoint() . "<br>";
    } else {
        echo "❌ Falha: " . $report->getReason() . "<br>";
    }
}
