var FormWizard = function () {

    var handleSummernote = function () {
        var myElement = $('#texto');
        myElement.show();
        myElement.summernote({
            height: 300,
            dialogsFade: true,
            placeholder: 'Digite ou insira o texto da notícia aqui',
            lang: 'pt-BR',
            toolbar: [
                ['style', ['style']],
                ['font', ['bold', 'underline', 'clear']],
                //['fontname', ['fontname']],
                ['color', ['color']],
                ['para', ['ul', 'ol', 'paragraph']],
                ['table', ['table']],
                ['insert', ['link'/*, 'picture', 'video'*/]],
                ['view', ['fullscreen', 'codeview', 'help']]
              ],
            callbacks: {
                onChange: function(contents, $editable) {
                    myElement.val(myElement.summernote('isEmpty') ? "" : contents);
                    v.element(myElement); 
                }
            }
        });
        //API:
        //var sHTML = $('#summernote_1').code(); // get code
        //$('#summernote_1').destroy(); // destroy




        function format(state) {
            if (!state.id) return state.text; // optgroup
            return "<img class='flag' src='../../assets/global/img/flags/" + state.id.toLowerCase() + ".png'/>&nbsp;&nbsp;" + state.text;
        }

        var form = $('#form-editar');
        var error = $('.alert-danger', form);
        var success = $('.alert-success', form);

        var v = form.validate({
            doNotHideMessage: true, //this option enables to show the error/success messages on tab switch.
            errorElement: 'span', //default input error message container
            errorClass: 'help-block help-block-error', // default input error message class
            focusInvalid: false, // do not focus the last invalid input
            rules: {
                //account
                data: {
                    required: true
                },
                hora: {
                    required: true
                },
                titulo: {
                    minlength: 5,
                    required: true
                },
                subtitulo: {
                    //required: false
                },
                secao: {
                    required: true
                },
                texto: {
                    //required: false
                }
            },

            ignore: ":hidden:not(#texto),.note-editable.panel-body",

            messages: { // custom messages for radio buttons and checkboxes
                
            },

            errorPlacement: function (error, element) { // render error placement for each input type
                if (element.attr("name") == "gender") { // for uniform radio buttons, insert the after the given container
                    error.insertAfter("#form_gender_error");
                } else if (element.attr("name") == "texto") { // for uniform checkboxes, insert the after the given container
                    error.insertAfter("#erro-editor");
                } else {
                    error.insertAfter(element); // for other inputs, just perform default behavior
                }
            },

            invalidHandler: function (event, validator) { //display error alert on form submit   
                success.hide();
                error.show();
                App.scrollTo(error, -200);
            },

            highlight: function (element) { // hightlight error inputs
                $(element)
                    .closest('.form-group').removeClass('has-success').addClass('has-error'); // set error class to the control group
            },

            unhighlight: function (element) { // revert the change done by hightlight
                $(element)
                    .closest('.form-group').removeClass('has-error'); // set error class to the control group
            },

            success: function (label) {
                if (label.attr("for") == "gender" || label.attr("for") == "payment[]") { // for checkboxes and radio buttons, no need to show OK icon
                    label
                        .closest('.form-group').removeClass('has-error');
                    label.remove(); // remove error label here
                } else { // display success icon for other inputs
                    label
                        .addClass('valid') // mark the current input as valid and display OK icon
                    .closest('.form-group').removeClass('has-error'); // set success class to the control group
                }
            },

            submitHandler: function (form) {
                data = new FormData ( form );
                var action = $('#form-editar').attr('action');
                //var acao = 'criar';
                $.ajax({
                    type: "POST",
                    dataType: "json",
                    url: action,
                    data: data,
                    cache: false,
                    contentType: false,
                    processData: false,
                    beforeSend: function() {
                        BlockUI('#block-editar')
                    },
                    success: function( data ) {
                        unBlockUI('#block-editar')
                        retornoAjax(data);
                    },
                    error: function( data ) {
                        unBlockUI('#block-editar')
                        $toast = toastr['error']('Informações inválidas. Atualize a página para continuar.');
                    }
                });
            }

        });
    }


    return {
        //main function to initiate the module
        init: function () {
            //validations();
            handleSummernote();
        }
    };

}();
jQuery(document).ready(function() {
    FormWizard.init();
});

$('[excluirArquivo]').on('click', function() {
    
    if (confirm("Tem Certeza que deseja excluir esta imagem?") == false) { return; }

    action = $('#action-upload').attr('action');
    ID = $(this).attr('excluirArquivo');
    tipo = $(this).attr('tipo');
    $.ajax({
        type: 'POST',
        url: action,
        data: "acao=deletar&arquivo="+ID,
        dataType: "json",
        success: function( data ) {
            retornoAjax(data);
            if(data.success) {
                console.log(tipo)
                $('#'+tipo).fadeOut(300);
                $('#novo-'+tipo).fadeIn(300);
            }
        }
    });
})


var tabelaLista = function () {

    var tabelaLista = function () {

        function restoreRow(oTable, nRow) {
            var aData = oTable.fnGetData(nRow);
            var jqTds = $('>td', nRow);

            for (var i = 0, iLen = jqTds.length; i < iLen; i++) {
                oTable.fnUpdate(aData[i], nRow, i, false);
            }

            oTable.fnDraw();
        }

        function editRow(oTable, nRow) {
            var aData = oTable.fnGetData(nRow);
            var jqTds = $('>td', nRow);
            ID = $(nRow).closest('tr').attr('envio-ID');

            jqTds[0].innerHTML = '<input type="text" required name="nome" class="form-control" value="' + aData[0] + '">';
            jqTds[1].innerHTML = '<button type="button" class="edit btn btn-xs btn-success no-transform no-shadow no-radius font-s13">Salvar</button>';
            jqTds[2].innerHTML = '<button type="button" class="cancel btn btn-xs green btn-outline no-transform no-shadow no-radius font-s13">Cancelar</button>';
        }

        function saveRow(oTable, nRow, ID) {
            var jqInputs = $('input,select', nRow);
            $ID = enviaAjax(jqInputs, ID, oTable, nRow, jqInputs);
        }

        function cancelEditRow(oTable, nRow) {
            var jqInputs = $('input,select', nRow);
            oTable.fnUpdate(jqInputs[0].value, nRow, 0, false);
            oTable.fnUpdate('<button type="button" class="edit btn btn-xs btn-success no-transform no-shadow no-radius font-s13">Editar</button>', nRow, 1, false);
            oTable.fnUpdate('<button type="button" class="delete btn btn-xs btn-danger no-transform no-shadow no-radius font-s13">Excluir</button>', nRow, 2, false);
            oTable.fnDraw();
        }

        function enviaAjax(dados, ID = false, oTable, nRow, jqInputs) {
            //$(".data").inputmask(); $(".hora").unmask();
            data = dados.serialize();
            var action = $('#controle-ajax').attr('action');
            var acao = $('#controle-ajax').attr('acao');
            $.ajax({
                type: "POST",
                dataType: "json",
                url: action,
                data: data+'&ID='+ID+'&acao='+acao+'&tabela=grupos',
                success: function( data ) {
                    retornoAjax(data);
                    if(data.success == true) {
                        $(nRow).attr('envio-ID', data.ID);
                        oTable.fnUpdate(jqInputs[0].value, nRow, 0, false);
                        oTable.fnUpdate('<a href="'+data.href+'" type="button" class="btn btn-xs btn-success no-transform no-shadow no-radius font-s13">Gerenciar</a>', nRow, 1, false);
                        oTable.fnUpdate('<button type="button" class="delete btn btn-xs btn-danger no-transform no-shadow no-radius font-s13">Excluir</button>', nRow, 2, false);
                        oTable.fnDraw();
                    }
                },
                error: function( data ) {
                    $toast = toastr['error']('Informações inválidas. Atualize a página para continuar.');
                }
            });
            $('#controle-ajax').attr('acao', '');
        }

        var tableLinks = $('#tabela_lista');


        var oTable = tableLinks.dataTable({
            buttons: [
                /*{ extend: 'print',
                    title: 'Agenda',
                    className: 'btn green no-shadow no-radius btn-outline font-s13',
                    text: '<i class="fa fa-print"></i> Imprimir',
                    exportOptions: { columns: [0] },
                },
                { extend: 'copy',
                    title: 'Agenda',
                    className: 'btn green no-shadow no-radius btn-outline font-s13', 
                    text: '<i class="fa fa-clipboard"></i> Copiar',
                    exportOptions: { columns: [0] },
                },
                { extend: 'pdf',
                    title: 'Agenda',
                    className: 'btn green no-shadow no-radius btn-outline font-s13',
                    text: '<i class="fa fa-pdf"></i> PDF',
                    exportOptions: { columns: [0] },
                },
                { extend: 'excel',
                    title: 'Agenda',
                    className: 'btn green no-shadow no-radius btn-outline font-s13',
                    text: '<i class="fa fa-excel"></i> Excel',
                    exportOptions: { columns: [0] },
                },
                { extend: 'csv',
                    title: 'Agenda',
                    className: 'btn green no-shadow no-radius btn-outline font-s13',
                    text: '<i class="fa fa-cvs"></i> CVS',
                    exportOptions: { columns: [0] },
                },
                { extend: 'colvis',
                    className: 'btn green no-shadow no-radius btn-outline font-s13',
                    text: 'Colunas',
                }*/
            ],

            "dom": "<'row' <'col-md-12'B>><'row'<'col-md-6 col-sm-12'l><'col-md-6 col-sm-12'f>r><'table-scrollable't><'row'<'col-md-5 col-sm-12'i><'col-md-7 col-sm-12'p>>",

            "lengthMenu": [
                [-1],
                ["Todos"] // change per page values here
            ],

            // Or you can use remote translation file
            //"language": {
            //   url: '//cdn.datatables.net/plug-ins/3cfcc339e89/i18n/Portuguese.json'
            //},

            // set the initial value
            "pageLength": -1,

            "language": {
                "sProcessing":   "A processar...",
                "sLengthMenu":   "Mostrar _MENU_ registros",
                "sZeroRecords":  "Não foram encontrados resultados",
                "sInfo":         "Mostrando de _START_ até _END_ de _TOTAL_ registros",
                "sInfoEmpty":    "Mostrando de 0 até 0 de 0 registros",
                "sInfoFiltered": "(filtrado de _MAX_ registros no total)",
                "sInfoPostFix":  "",
                "sSearch":       "Procurar:",
                "sUrl":          "",
                "oPaginate": {
                    "sFirst":    "Primeiro",
                    "sPrevious": "Anterior",
                    "sNext":     "Seguinte",
                    "sLast":     "Último"
                },
                "language": {
                    buttons: {
                        copySuccess: {
                            _: '%d Copiado com sucesso!',
                            1: '1 ligne copiée'
                        }
                    }
                }
            },

            "columnDefs": [{ // set default column settings
                'orderable': true,
                'targets': [0]
            }, {
                "searchable": true,
                "targets": [0]
            }],
            "order": [
                [1, "asc"]
            ] // set first column as a default sort by asc
        });

        var tableWrapper = $("#editable_wrapper_link");

        var nEditing = null;
        var nNew = false;

        $('#adicionarEnvio').click(function (e) {
            e.preventDefault();

            if (nNew && nEditing) {
                if (confirm("A linha em edição não foi salva. Você deseja salvá-la?")) {
                    saveRow(oTable, nEditing); // save
                    $(nEditing).find("td:first").html("Untitled");
                    nEditing = null;
                    nNew = false;

                } else {
                    oTable.fnDeleteRow(nEditing); // cancel
                    nEditing = null;
                    nNew = false;
                    return;
                }
            }

            var aiNew = oTable.fnAddData(['', '', '', '', '', '', '', '', '', '', '', '', '']);
            var nRow = oTable.fnGetNodes(aiNew[0]);
            oTable.find('tbody').prepend(nRow);
            $('#controle-ajax').attr('acao', 'novo');
            editRow(oTable, nRow);
            nEditing = nRow;
            nNew = true;
            $(oTable).find('input,select').first().focus();
        });

        tableLinks.on('click', '.delete', function (e) {

            var action = $('#controle-ajax').attr('action');
            var acao = $('#controle-ajax').attr('acao');
            var ID = $(this).closest('tr').attr('envio-ID');

            swal({
                title: "Tem certeza que deseja remover este email?",
                text: "Esta ação não pode ser desfeita.",
                type: "info",
                showCancelButton: true,
                showConfirmButton: true,
                confirmButtonText: 'Remover',
                confirmButtonClass: 'btn-danger',
                closeOnConfirm: false,
                showLoaderOnConfirm: true,
            }, function (isConfirm) {
                if (isConfirm){
                    
                    //swal('Excluindo!', 'O agendamento será excluido e a página será atualizada.', "success");
                    swal.close()

                    $.ajax({
                        type: "POST",
                        dataType: "json",
                        url: action,
                        data: 'ID='+ID+'&acao=deletar&tabela=envios',
                        success: function( data ) {
                            retornoAjax(data);
                            if (data.success == true) {
                                var nRow = $('[envio-ID='+ID+']');
                                oTable.fnDeleteRow(nRow);
                            }
                        },
                        error: function( data ) {
                            $toast = toastr['error']('Informações inválidas. Atualize a página para continuar.');
                        }
                    });
                }
            });
            
            
        });

        tableLinks.on('click', '.cancel', function (e) {
            e.preventDefault();
            if (nNew) {
                oTable.fnDeleteRow(nEditing);
                nEditing = null;
                nNew = false;
            } else {
                restoreRow(oTable, nEditing);
                nEditing = null;
            }
        });

        tableLinks.on('click', '.edit', function (e) {
            nNew = false;

            var ID = $(this).closest('tr').attr('envio-ID');
            if(ID) {
                $('#controle-ajax').attr('acao', 'editar');
            } else {
                $('#controle-ajax').attr('acao', 'novo');
            }

            /* Get the row as a parent of the link that was clicked on */
            var nRow = $(this).parents('tr')[0];

            if (nEditing !== null && nEditing != nRow) {
                /* Currently editing - but not this row - restore the old before continuing to edit mode */
                restoreRow(oTable, nEditing);
                editRow(oTable, nRow);
                nEditing = nRow;
            } else if (nEditing == nRow && this.innerHTML == "Salvar") {
                /* Editing this row and want to save it */
                saveRow(oTable, nEditing, ID);
                //nEditing = null;
                //alert("Updated! Do not forget to do some ajax to sync with backend :)");
            } else {
                /* No edit in progress - let's start one */
                editRow(oTable, nRow);
                nEditing = nRow;
            }
        });
    }

    return {

        //main function to initiate the module
        init: function () {
            tabelaLista();
        }

    };

}();
jQuery(document).ready(function() {
    tabelaLista.init();
});

var Adicionar = function() {
    var vConfirmar = function(){
        jQuery('.js-adicionar').validate({
            errorClass: 'help-block text-right animated fadeInDown',
            errorElement: 'div',
            errorPlacement: function(error, e) {
                jQuery(e).parents('.form-group > div').append(error);
            },
            highlight: function(e) {
                jQuery(e).closest('.form-group').removeClass('has-error').addClass('has-error');
                jQuery(e).closest('.help-block').remove();
            },
            success: function(e) {
                jQuery(e).closest('.form-group').removeClass('has-error');                
                jQuery(e).closest('.help-block').remove();
            },
            rules: {
                emails: {
                    //required: falsetrue,
                }
            },
            messages: {
                
            },
            submitHandler: function( form ){
                var dados = $( form ).serialize();
                var action = $( form ).attr('action');
                $.ajax({
                    type: "POST",
                    dataType: "json",
                    url: action,
                    data: dados,
                    success: function( data ) {
                        retornoAjax(data);
                    },
                    error: function( data ) {
                        $toast = toastr['error']('Informações inválidas. Atualize a página para continuar.');
                    }
                });
            }
        });
    };

    return {
        init: function () {
            // Init Login Form Validation
            vConfirmar();
        }
    };
}();
jQuery(function(){ Adicionar.init(); });




$('[reiniciar]').on('click', function () {

    if (confirm("Tem Certeza que deseja reiniciar os envios?") == false) { return; }
    
    ID = $(this).attr('reiniciar');
    action = $('#form-editar').attr('action');

    $.ajax({
        type: "POST",
        dataType: "json",
        url: action,
        data: 'acao=reiniciar&ID='+ID,
        success: function( data ) {
            retornoAjax(data);
        },
        error: function( data ) {
            $toast = toastr['error']('Informações inválidas. Atualize a página para continuar.');
        }
    });
    
})







var controlePlay = $('[play]');
var controleLoop;
var timeLoop = controlePlay.attr('time')+'000';

$('[play]').on('click', function () {
    
    ID = $($('[envio-ID][status=0]')[0]).attr('envio-ID')

    if( $(this).attr('status') == 0 )  {
        if( ($(this).attr('enviar') > 0) || (ID != undefined)) {
            play()
        } else {
            $toast = toastr['info']('Não existem emails a enviar!');
        }
    } else {
        pause()
    }
})


function play() {

    controlePlay.attr('status', 1);
    action = controlePlay.attr('action');

    playLooping();

}

function playLooping() {

    console.log(timeLoop);

    $('[divProgress]').addClass('progress-striped active');
    controlePlay.html('<i class="fa fa-spinner fa-spin spin"></i> Enviando');

    if(controlePlay.attr('status') == 0) {
        stopLoop();
        alertPause();
        return false;
    } else if (controlePlay.attr('enviar') == 0) {
        stopLoop();
        alertCompleto();
        return false;
    }

    ID = $($('[envio-ID][status=0]')[0]).attr('envio-ID')

    action = controlePlay.attr('action');

    $.ajax({
        type: "POST",
        dataType: "json",
        url: action,
        data: 'acao=play&ID='+ID,
        beforeSend: function() {
            btnLoader(ID);
        },
        success: function( data ) {
            retornoAjax(data);
            if(data.success) {
                btnSuccess(ID);
                if(data.pct) { $('[barProcess]').css('width', data.pct+'%'); }
            } else {
                btnErro(ID);
            }

            if(controlePlay.attr('enviar') == 0) {
                stopLoop();
                alertCompleto();
                return false;
            } else if (controlePlay.attr('status') == 0) {
                stopLoop();
                alertPause();
            } else {
                controleLoop = setTimeout(function(){ playLooping() }, parseInt(timeLoop));                
            }
        },
        error: function( data ) {
            btnErro(ID);
            $toast = toastr['error']('Informações inválidas. Atualize a página para continuar.');
            controleLoop = setTimeout(function(){ playLooping() }, parseInt(timeLoop));
        }
    });
}

function alertPause() {
    swal("Processo Pausado!", "O envio de emails foi pausado.", "info")
}

function alertCompleto() {
    swal("Processo Concluído!", "A lista de emails foi completamente processada.", "success")
}

function stopLoop() {
    $('[divProgress]').removeClass('progress-striped active');
    controlePlay.html('<i class="fa fa-envelope-o"></i> Enviar Emails');
    clearTimeout(controleLoop);
}

function pause() {
    controlePlay.attr('status', 0);
    stopLoop();
    alertPause();
}


function btnLoader(ID) {
    BlockUI('[btnLoader='+ID+']');
    $('.btn'+ID).hide();
    $('[btnLoader='+ID+']').show();
}
function btnSuccess(ID) {
    unBlockUI('[btnLoader='+ID+']');
    $('.btn'+ID).hide();
    $('[btnAtivo='+ID+']').show();

    $('[envio-ID='+ID+']').attr('status', 1);
    controlePlay.attr('enviar', parseInt(controlePlay.attr('enviar'))-parseInt(1));
}
function btnErro(ID) {
    unBlockUI('[btnLoader='+ID+']');
    $('.btn'+ID).hide();
    $('[btnAtivo='+ID+']').show().html('<span title="Atualize a página para tentar enviar novamente.">NÃO ENVIADO</span>').removeClass('btn-success').addClass('btn-danger');
    
        $('[envio-ID='+ID+']').attr('status', 2);
    controlePlay.attr('enviar', parseInt(controlePlay.attr('enviar'))-parseInt(1));
}