<?
class News extends APP {
	PRIVATE $APP;

	PUBLIC $campanhas;
	PUBLIC $grupos;
	PUBLIC $emails;

	function __construct($isView) { global $path;
		if($isView) { $this->isView = true; }
		parent::__construct($isView);
		$this::getCampanhas();
		$this::getGrupos();
		$this::getEmails();
		$this::getSetup();
		$this->defaultHeader = DIR.$path['publico-img'].'header.jpg';
		$this->defaultFooter = DIR.$path['publico-img'].'footer.jpg';
	}

	PRIVATE function getSetup() {
		if ( $this->setup = $this->db->ObjectBuilder()->getOne('news_setup') ) {
			## Configurações de E-amail
			define('nEMAIL', $this->setup->email_email);
			define('nEMAIL_NOME', $this->setup->email_nome);
			define('nEMAIL_HOST', $this->setup->email_host);
			define('nEMAIL_LOGIN', $this->setup->email_login);
			define('nEMAIL_SENHA', $this->setup->email_senha);
			define('nEMAIL_PORTA', $this->setup->email_porta ?? 587);
			define('nSITE_URL', siteURL());
		} else {
			return false;
		}
	}

	function startEmail() {
		##### PHP MAILER;
		if( is_file(PATH_CRON.'app/core/PHPMailer/PHPMailerAutoload.php') ) {
			include (PATH_CRON.'app/core/PHPMailer/PHPMailerAutoload.php');
		} else { 
			include ('app/core/PHPMailer/PHPMailerAutoload.php');
		}
		$this->email = new PHPMailer;
			$this->email->isSMTP();
			$this->email->Host = nEMAIL_HOST;
			$this->email->SMTPAuth = true;
			$this->email->Username = nEMAIL_LOGIN;
			$this->email->Password = nEMAIL_SENHA;
			$this->email->SMTPSecure = 'ssl'; // ssl / tls
			$this->email->Port = nEMAIL_PORTA;
			$this->email->setFrom(nEMAIL, nEMAIL_NOME);
	}


	function enviarEmail($registro) {

		GLOBAL $path;

		$c = $this::getCampanhaEnvio($registro);

		if(!$c) { return true; }

		include($path['core'].'template.php');
		

		if (!$this->email) { $this->startEmail(); }
		$this->email->addAddress($c->email);
		$this->email->Subject = $c->titulo;
		$this->email->Body    = $template;
		$this->email->isHTML(true);

		if( @$this->email->send() ) { 
			$this->db->where('id', $registro);
			$update = array( 'envio' => date('Y-m-d H:i:s'), 'status' => 1 );
			$this->db->update('news_envios', $update);
			$lista = $this::getListaCampanha($c->id);
			$return = $this::getPorcentagem($lista);
			$return->{'email'} = $c->email;
			$return->{'status'} = true;

			$this::historicoEnvios($c->id, 1);

		    return $return;
		} else {
			$return = (object) array();
			$return->{'status'} = false;
			$return->{'email'} = $c->email;
		    return $return;
		}
	}

	function cronEnviarEmail($registro) {

		$c = $this::getCampanhaEnvio($registro);

		if(!$c) { return true; }

		include(PATH_CRON.'aplicativos/news/core/template.php');


		if (!$this->email) { $this->startEmail(); }
		$this->email->addAddress($c->email);
		$this->email->Subject = $c->titulo;
		$this->email->Body    = $template;
		$this->email->isHTML(true);

		if( @$this->email->send() ) { 
			$this->db->where('id', $registro);
			$update = array( 'envio' => date('Y-m-d H:i:s'), 'status' => 1 );
			$this->db->update('news_envios', $update);
			$lista = $this::getListaCampanha($c->id);
			$return = $this::getPorcentagem($lista);
			$return->{'email'} = $c->email;
			$return->{'status'} = true;

			$this::historicoEnvios($c->id, 1);

		    return $return;
		} else {
			$return = (object) array();
			$return->{'status'} = false;
			$return->{'email'} = $c->email;
		    return $return;
		}
	}

	function setSetup($tabela, $ID, $dados) {
		$this->db->where('id', $ID);
		if ( $this->db->update('news_'.$tabela, $dados) ) {
			return $ID;
		} else {
			return false;
		}
	}

	function addSetup($tabela, $ID, $dados) {
		if ( $this->db->insert('news_'.$tabela, $dados) ) {
			return $this->db->getInsertID();
		} else {
			return false;
		}
	}

	function delSetup($tabela, $ID) {
		$this->db->where('id', $ID);
		if ( $this->db->delete('news_'.$tabela) ) {
			return true;
		} else {
			die('merda!');
			return false;
		}
	}

	function getCampanhas() {
		$this->db->where('c.entidade', $this->_auth->entidade->id);
		if ($news = $this->db->ObjectBuilder()->get('news c', null, 'c.*') ) {
			foreach($news as $c) {
				$c->{'header'} = $this::getArquivo($c->header);
				$c->{'footer'} = $this::getArquivo($c->footer);
				$c->{'lista'} = $this::getListaCampanha($c->id);
				$c->{'envios'} = $this::getPorcentagem($c->lista);
				$CAMP[] = $c;
			}
			return $this->campanhas = $CAMP;
		} else {
			return null;
		}
			
	}

	function getCampanhaCodigo($codigo) {
		$this->db->join('news_status s', 's.id = e.status', 'LEFT');
		$this->db->where('e.codigo', $codigo);
		$this->db->where('e.entidade', $this->_auth->entidade->id);
		$esic = $this->db->ObjectBuilder()->get('news e', null, 'e.*, s.nome as status, s.id as status_id')[0];
		return $esic;
	}

	function editar($ID, $dados) {
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		if( $this->db->update('news', $dados) ) {
			return true;
		} else {
			return false;
		}
	}

	function excluir($ID) {
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->delete('news');
	}


	function criar($dados) {
		if ($this->db->insert('news', $dados)){
			return $this->db->getInsertId();
		} else {
			var_dump($this->db->getLastError());
			return false;
		}
	}

	function excluirArquivo($ID) {
		$a = $this::getArquivo($ID);
		if( is_file($a->path.$a->arquivo) ) {
			@unlink($a->path.$a->arquivo);
		}
		if( $a->tipo == 'imagem' ) {
			@unlink($a->path.'min/'.$a->arquivo);
		}
		$this->db->where('id', $ID);
		$this->db->delete('news_arquivos');
		return true;
	}

	function getArquivo($ID) {
		$this->db->where('id', $ID);
		return $this->db->ObjectBuilder()->getOne('news_arquivos');
	}


	function getGrupos() {
		$this->db->join('news_emails_grupos eg', 'eg.grupo = g.id', 'LEFT');
		$this->db->join('news_emails e', 'e.id = eg.email', 'LEFT');
		$this->db->OrderBy('g.nome', 'ASC');
		$this->db->where('g.entidade', $this->_auth->entidade->id);
		$this->db->groupBy('g.id');
		$this->db->groupBy('eg.grupo');
		$this->grupos = $this->db->ObjectBuilder()->get('news_grupos g', null, 'g.*, count(e.id) as emails');	
		return $this->grupos;
	}

	function getGrupoID($ID) {
		$this->db->where('id', $ID);
		$this->db->OrderBy('nome', 'ASC');
		$this->db->where('entidade', $this->_auth->entidade->id);
		$this->db->groupBy('id');
		$grupo = $this->db->ObjectBuilder()->getOne('news_grupos');
		if($grupo) {
			$grupo->{'emails'} = $this::getEmailsGrupo($grupo->id);
		}
		return $grupo;
	}

	function getEmailID($ID) {
		$this->db->where('id', $ID);
		$email = $this->db->ObjectBuilder()->getOne('news_emails');
		if($email) {
			$email->{'grupos'} = $this::getGruposEmail($email->id);
		}
		return $email;
	}

	function getEmailsGrupo($ID) {
		$this->db->where('eg.grupo', $ID);
		$this->db->join('news_emails e', 'e.id = eg.email', 'INNER');
		$this->db->groupBy('eg.email');
		$lista = $this->db->ObjectBuilder()->get('news_emails_grupos eg', null, 'e.*, eg.id as reg');
		return $lista;
	}

	function getEmailsGrupoWOC($grupo, $campanha) {
		$this->db->where('eg.grupo', $grupo);
		$this->db->join('news_emails e', 'e.id = eg.email', 'INNER');
		$this->db->join('news_grupos g', 'g.id = eg.grupo', 'INNER');
		$this->db->join('news_envios l', 'l.email = e.id', 'LEFT');
			$this->db->where('l.id IS NULL');
		return $this->db->ObjectBuilder()->get('news_emails_grupos eg', null, 'e.*, eg.id as reg');
	}

	function getGruposEmail($ID) {
		$this->db->where('eg.email', $ID);
		$this->db->join('news_emails e', 'e.id = eg.email', 'INNER');
		$this->db->join('news_grupos g', 'g.id = eg.grupo', 'INNER');
		return $this->db->ObjectBuilder()->get('news_emails_grupos eg', null, 'g.*, eg.id as reg');
	}

	function configEmail($dados) {
		if($this->setup) {
			$this->db->where('id', $this->setup->id);
			return $this->db->update('news_setup', $dados);
		} else {
			return $this->db->insert('news_setup', $dados);
		}
	}

	function getEmails() {
		$this->db->join('news_emails_grupos eg', 'eg.email = e.id', 'LEFT');
		$this->db->OrderBy('e.email', 'ASC');
		$this->db->OrderBy('e.email', 'ASC');
		$this->db->groupBy('e.id');
		$this->db->where('e.entidade', $this->_auth->entidade->id);
		$this->emails = $this->db->ObjectBuilder()->get('news_emails e', null, 'e.*, count(eg.id) as grupos');
		return $this->emails;
	}

	function addGrupo($nome, $lista = false) {
		// Prepara Lista
		if($lista) { $lista = $this::preparaLista($lista); }
		// Cria Grupo, se não existir
		if ($g = $this::novoGrupo($nome)->id) {
			if ($lista) { $this::addListaGrupo($g, $lista); }
			return $g;
		} else {
			return false;
		}
	}

	function excluirGrupo($ID) {
		$this->db->where('grupo', $ID);
		$this->db->delete('news_emails_grupos');
		$this->db->where('id', $ID);
		$this->db->delete('news_grupos');
		return true;
	}

	function excluirCampanha($ID) {
		$this->db->where('campanha', $ID);
		$this->db->delete('news_envios');

		$this->db->where('id', $ID);
		$this->db->delete('news');
		return true;
	}

	function preparaLista($lista) {

		# FIX to False
		if(!$lista OR !strlen($lista)) {
			$lista['email'] = false;
			$lista['grupo'] = false;
			return $lista;
		}

		$s = array(',', ';', "\r\n", '|', ', ');
		$original = $r = array_filter(explode(',', str_replace($s, ',', $lista)));
		$rr = array_flip($r);

		if(count($r)) {
			$this->db->where('email', $r, 'IN');
			$this->db->where('entidade', $this->_auth->entidade->id);
			$e = $this->db->ObjectBuilder()->get('news_emails');
			// Remove já inseridos;
			if($e) { foreach ($e as $e) { unset($rr[$e->email]); } }
		}
		$rr = array_keys($rr);

		// Filtra $V verdadeiro ou $F Falso;
		foreach ($rr as $r) {
			$r = trim($r);
			if (filter_var($r, FILTER_VALIDATE_EMAIL)) {
				$v[$r] = 1;
			} else {
				$f[$r] = 2;
			}
		}		

		## Cria Arrays de Insert MultInsert
		if(count($v)) {		
			foreach($v as $k => $i) {
				if(!empty($k)) {
					$return['email'][] = array('email' => trim($k), 'status' => 1, 'entidade' => $this->_auth->entidade->id);
				}
			} 
		}
		if(count($f)) {		
			foreach($f as $k => $i) {
				if(!empty($k)) {
					$return['email'][] = array('email' => trim($k), 'status' => 2, 'entidade' => $this->_auth->entidade->id);
				}
			}
		}
		$return['grupo'] = $original;

		## Retorno
		return $return ?? false;
	}

	function novoGrupo($nome) {
		$this->db->where('nome', $nome);
		if( $g = $this->db->ObjectBuilder()->getOne('news_grupos') ) {
			$return = array(
				'id' => $g->id,
				'nome' => $g->nome,
				'novo' => false
			);
		} else {
			$data = array(
				'nome' => $nome,
				'entidade' => $this->_auth->entidade->id,
				);
			$this->db->insert('news_grupos', $data);
			$return = array(
				'id' => $this->db->getInsertId(),
				'nome' => $nome,
				'novo' => true
			);
		}
		return (object) $return;
	}

	function addListaGrupo($ID, $lista = false) {
		// Valida Cadastros de Emails
		if($lista['email']) {
			$this->db->insertMulti('news_emails', $lista['email']);
		}
		$this->db->where('e.email', $lista['grupo'], 'IN');
		$this->db->where('e.entidade', $this->_auth->entidade->id);
		$this->db->join('news_emails_grupos r', 'r.email = e.id AND r.grupo = '.$ID, 'LEFT');
		$this->db->having('r.id IS NULL');
		$this->db->groupBy('e.id');
		$insertGrupo = $this->db->ObjectBuilder()->get('news_emails e', null, 'e.*, r.id as reg');
		if($insertGrupo) {
			foreach($insertGrupo as $i) {
				$addGrupo[] = array(
					'email' => $i->id,
					'grupo' => $ID,
				);
			}
		}
		return $addGrupo ? $this->db->insertMulti('news_emails_grupos', $addGrupo) : true;
	}

	function addListaCampanha($ID, $lista, $grupo) {

		$lista = $this::preparaLista($lista);

		// Valida Cadastros de Emails
		if($lista['email']) {
			$this->db->insertMulti('news_emails', $lista['email']);
		}

		if($grupo) {

			if ( $lista = $this::getEmailsGrupoWOC($grupo, $ID) ) {
				foreach ($lista as $i) {
					$addCampanha[] = array(
						'email' => $i->id,
						'campanha' => $ID,
						'status' => 0,
					);
				}
				return $addCampanha ? $this->db->insertMulti('news_envios', $addCampanha) : true;
			} else {
				return true;
			}


		} else {
			$this->db->where('e.email', $lista['grupo'], 'IN');
			$this->db->where('e.entidade', $this->_auth->entidade->id);
			$this->db->join('news_envios l', 'l.email = e.id AND l.campanha = '.$ID, 'LEFT');
			$this->db->having('l.id IS NULL');
			$this->db->groupBy('e.id');
			$insertList = $this->db->ObjectBuilder()->get('news_emails e', null, 'e.*, l.id as lista');
			if($insertList) {
				foreach($insertList as $i) {
					$addCampanha[] = array(
						'email' => $i->id,
						'campanha' => $ID,
						'status' => 0,
					);
				}
			}
			return $addCampanha ? $this->db->insertMulti('news_envios', $addCampanha) : true;
		}
	}

	function addLista($lista, $grupo = false) {
		$lista = $this::preparaLista($lista);
		if($grupo) {
			return $this::addListaGrupo($grupo, $lista);
		} else {
			return $lista['email'] ? $this->db->insertMulti('news_emails', $lista['email']) : true;
		}
	}

	function excluirEmail($ID) {
		// Cadastro de Emails
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		$this->db->delete('news_emails');
		// Cadastro em Grupos
		$this->db->where('email', $ID);
		$this->db->delete('news_emails_grupos');
		// Cadastro na Lista de Envios
		$this->db->where('email', $ID);
		$this->db->delete('news_envios');
		return true;
	}

	function editarEmail($ID, $dados) {
		$this->db->where('id', $ID);
		return $this->db->update('news_emails', $dados);
	}

	function getGruposDisp($ID) {
		$this->db->join('news_emails_grupos eg', "eg.grupo = g.id AND eg.email = '$ID'", 'LEFT');
		$this->db->where('eg.id IS NULL');
		$this->db->OrderBy('g.nome', 'ASC');
		$this->db->where('g.entidade', $this->_auth->entidade->id);
		$this->db->groupBy('g.id');
		$this->db->groupBy('eg.grupo');
		$grupos = $this->db->ObjectBuilder()->get('news_grupos g', null, 'g.*');	
		return $grupos;
	}

	function agrupar($email, $grupo) {
		$this->db->where('email', $email);
		$this->db->where('grupo', $grupo);
		if( !$this->db->getOne('news_emails_grupos') ) {
			$dados = array( 'email' => $email, 'grupo' => $grupo );
			if ($this->db->insert('news_emails_grupos', $dados)) {
				return $this->db->getInsertId();
			}
		} else {
			return true;
		}
	}

	function getEmailRegGrupo($reg) {
		$this->db->where('id', $reg);
		return $this->db->getOne('news_emails_grupos')['email'];
	}

	function getCampanhaID($ID) {
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		if($campanha = $this->db->ObjectBuilder()->getOne('news')) {
			$campanha->{'header'} = $this::getArquivo($campanha->header);
			$campanha->{'footer'} = $this::getArquivo($campanha->footer);
			$campanha->{'lista'} = $this::getListaCampanha($ID);
			$campanha->{'envios'} = $this::getPorcentagem($campanha->lista);
		}
		return $campanha;
	}

	function getListaCampanha($ID) {
		$this->db->where('l.campanha', $ID);
		$this->db->join('news_emails e', 'e.id = l.email AND e.status = 1', 'INNER');
		return $this->db->ObjectBuilder()->get('news_envios l', null, 'l.*, e.email as email, l.email as email_id');
	}

	function getPorcentagem($lista) {
		if($lista) {
			$enviados = $total = $enviar = 0;
			foreach($lista as $l) {
				if($l->status == 1) {
					++$enviados;
				} else {
					++ $enviar;
				}
				++$total;
			}
			return (object) array(
				'enviados' => $enviados,
				'enviar' => $enviar,
				'pct' => ceil(($enviados*100)/($total)),
			);
		} else {
			return (object) array(
				'enviados' => 0,
				'enviar' => 0,
				'pct' => 0,
			);
		}
		
	}

	function getNomeGrupo($ID) {
		$this->db->where('id', $ID);
		return $this->db->getValue('news_grupos', 'nome');
	}


	function getCampanhaEnvio($ID) {
		$this->db->where('l.id', $ID);
		$this->db->join('news_envios l', 'l.campanha = c.id', 'INNER');
		$this->db->join('news_emails e', 'e.id = l.email', 'INNER');
		if($campanha = $this->db->ObjectBuilder()->getOne('news c', 'c.*, e.email')) {
			$campanha->{'header'} = $this::getArquivo($campanha->header);
			$campanha->{'footer'} = $this::getArquivo($campanha->footer);
		}
		return $campanha;
	}

	function unsubs($email) {
		$this->db->where('email', $email);
		$update['status'] = 0;
		$this->db->update('news_emails', $update);
	}


	function reiniciarCampanha($ID) {
		$this->db->where('campanha', $ID);
		$update = array( 'envio' => NULL, 'status' => 0, );
		return $this->db->update('news_envios', $update);
	}

	function historicoEnvios($campanha, $enviados) {
		$this->db->where('campanha', $campanha);
		$this->db->where('mes', date('m'));
		$this->db->where('ano', date('Y'));
		if ( $envios = $this->db->ObjectBuilder()->getOne('news_registros') ) {
			$dados['envios'] = ($envios->envios)+$enviados;
			$this->db->where('id', $envios->id);
			$this->db->update('news_registros', $dados);
		} else {
			$dados = array(
				'mes' => date('m'),
				'ano' => date('Y'),
				'campanha' => $campanha,
				'envios' => $enviados,
				);
			$this->db->insert('news_registros', $dados);
		}
	}

	
	PUBLIC function cronJob() {		
		$this->db->join('news c', 'r.campanha = c.id', 'INNER');
		$this->db->join('news_emails e', 'r.email = e.id', 'INNER');
		$this->db->where('r.status', 0);
		$this->db->where('c.status', 1);
		$this->db->where('e.status', 1);
		$this->db->GroupBy('e.id');
		$this->db->OrderBy('c.id');

		$return = 'Nenhum email a enviar.';

		if ( $REG = $this->db->ObjectBuilder()->get('news_envios r', 30, 'r.id as registro') ) {
			$n = 0;
			foreach($REG as $r) {
				$this::cronEnviarEmail($r->registro);
				$n++;
			}
			$return = $n.' emails enviados.';
		}
		return $return;
	}

}

return $NEWS = new News($isView);

?>