<?
class Mural extends APP {
	PRIVATE $APP;

	PUBLIC $murais;
	PUBLIC $secoes;

	function __construct($isView) {
		if($isView) { $this->isView = true; }
		parent::__construct($isView);
		$this::getMurais();
		$this::getSecoes();
		if ((int) ENTIDADE !== 0) {
			$this->_auth->entidade = $this::getEntidade(ENTIDADE);
		}
	}

	function setSetup($tabela, $ID, $dados) {
		$this->db->where('id', $ID);
		if ( $this->db->update('mural_'.$tabela, $dados) ) {
			return $ID;
		} else {
			return false;
		}
	}

	function addSetup($tabela, $ID, $dados) {
		if ( $this->db->insert('mural_'.$tabela, $dados) ) {
			return $this->db->getInsertID();
		} else {
			return false;
		}
	}

	function delSetup($tabela, $ID) {
		$this->db->where('id', $ID);
		if ( $this->db->delete('mural_'.$tabela) ) {
			return true;
		} else {
			return false;
		}
	}
	
	function getMurais() {
		$this->db->join('mural_secoes g', 'g.id = t.secao', 'LEFT');
		$this->db->where('t.entidade', $this->_auth->entidade->id);
		$this->murais = $this->db->ObjectBuilder()->get('mural t', null, 't.*, g.nome as secao, t.secao as secao_id');
		return $this->murais;
	}

	function getMuralTag($TAG) {
		$this->db->join('mural_secoes g', 'g.id = secao AND g.id = '.$TAG, 'LEFT');
		$this->db->where('t.entidade', $this->_auth->entidade->id);
		$mural = $this->db->ObjectBuilder()->get('mural t', null, 't.*, g.nome as secao, t.secao as secao_id')[0];
		return $mural;
	}

	function getMuralID($ID) {
		$this->db->where('id', $ID);
		$mural = $this->db->ObjectBuilder()->getOne('mural');
		return $mural;
	}

	function editar($ID, $dados) {
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		if( $this->db->update('mural', $dados) ) {
			return true;
		} else {
			return false;
		}
	}


	function excluir($ID) {
		$n = $this::getMuralID($ID);

		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->delete('mural');
	}


	function criar($dados) {
		if ($this->db->insert('mural', $dados)){
			return true;
		} else {
			var_dump($this->db->getLastError());
			return false;
		}
	}

	function desativar($ID) {
		$dados = array('status' => '0');
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->update('mural', $dados);
	}

	function ativar($ID) {
		$dados = array('status' => 1);
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->update('mural', $dados);
	}
	
	function getSecoes($check = false, $filtros = false) {
		if($check) {
			$this->db->join('mural m', 'm.secao = s.id', 'INNER');
			$this->db->where('m.entidade', $this->_auth->entidade->id);
		} else {
			$this->db->where('s.entidade', $this->_auth->entidade->id);
		}
		$this->db->OrderBy('s.nome', 'ASC');
		$this->db->groupBy('s.id');
		$this->secoes = $this->db->ObjectBuilder()->get('mural_secoes s', null, 's.*');
		return $this->secoes;
	}

	function getSecoesDisp($ID = null) {
		if($ID) {
			$this->db->join('mural c', "c.secao = s.id", 'LEFT');
			$this->db->where("(c.id IS NULL) OR (c.secao = '$ID')");
		} else {
			$this->db->join('mural c', "c.secao = s.id", 'LEFT');
			$this->db->where("c.id IS NULL");
		}
		$this->db->OrderBy('s.nome', 'ASC');
		$this->db->groupBy('s.nome');
		$this->db->where('s.entidade', $this->_auth->entidade->id);
		$this->db->groupBy('s.id');
		$this->secoes = $this->db->ObjectBuilder()->get('mural_secoes s', null, 's.*');
		return $this->secoes;
	}

	function getMuralNews($limitador, $secao = false, $secaoNao = false, $orderBy = false, $pagina = 1) {
		$this->db->join('mural_secoes s', 'a.secao = s.id', 'LEFT');
		if ($secao) {
			if (is_array($secao)) {
				$this->db->where('s.nome', $secao, 'IN');
			} else {
				$this->db->where('s.nome', $secao);
			}
		}
		if ($secaoNao) {
			if (is_array($secaoNao)) {
				$this->db->where('s.nome', $secaoNao, 'NOT IN');
			} else {
				$this->db->where('s.nome', $secaoNao, '!=');
			}
		}
		$this->db->where('a.entidade', $this->entidade->id);
		if ($orderBy) {
			$this->db->OrderBy('a.'.$orderBy->campo, $orderBy->ordem);
		} else {
			$this->db->OrderBy('a.data_pergunta', 'DESC');
		}
		$this->db->where('a.status', 1);
		$this->db->pageLimit = $limitador;
		if ($mural = $this->db->ObjectBuilder()->paginate('mural a', $pagina, 'a.*, s.nome as secao'))  {
			$this->totalCount = $this->db->totalCount;
			return $mural;
		} else {
			return false;
		}
	}

}

return $MURAL = new Mural($isView);

?>