<?
class Localizacao extends APP {
	PRIVATE $APP;

	PUBLIC $localizacoes;
	PUBLIC $secoes;

	function __construct($isView) {
		if($isView) { $this->isView = true; }
		parent::__construct($isView);
		$this::getLocalizacoes();
		$this::getSecoes();
		if ((int) ENTIDADE !== 0) {
			$this->_auth->entidade = $this::getEntidade(ENTIDADE);
		}
	}

	function setSetup($tabela, $ID, $dados) {
		$this->db->where('id', $ID);
		if ( $this->db->update('localizacao_'.$tabela, $dados) ) {
			return $ID;
		} else {
			return false;
		}
	}

	function addSetup($tabela, $ID, $dados) {
		if ( $this->db->insert('localizacao_'.$tabela, $dados) ) {
			return $this->db->getInsertID();
		} else {
			return false;
		}
	}

	function delSetup($tabela, $ID) {
		$this->db->where('id', $ID);
		if ( $this->db->delete('localizacao_'.$tabela) ) {
			return true;
		} else {
			return false;
		}
	}
	
	function getLocalizacoes() {
		$this->db->join('localizacao_secoes g', 'g.id = t.secao', 'LEFT');
		$this->db->where('t.entidade', $this->_auth->entidade->id);
		$this->localizacoes = $this->db->ObjectBuilder()->get('localizacao t', null, 't.*, g.nome as secao, t.secao as secao_id');
		return $this->localizacoes;
	}

	function getLocalizacaoTag($TAG) {
		$this->db->join('localizacao_secoes g', 'g.id = secao AND g.nome = '.$TAG, 'LEFT');
		$this->db->where('t.entidade', $this->_auth->entidade->id);
		$lcalizacao = $this->db->ObjectBuilder()->get('localizacao t', null, 't.*, g.nome as secao, t.secao as secao_id')[0];
		return $lcalizacao;
	}

	function getLocalizacaoID($ID) {
		$this->db->where('id', $ID);
		$lcalizacao = $this->db->ObjectBuilder()->getOne('localizacao');
		return $lcalizacao;
	}

	function editar($ID, $dados) {
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		if( $this->db->update('localizacao', $dados) ) {
			return $dados['secao'];
		} else {
			return false;
		}
	}


	function excluir($ID) {
		$n = $this::getLocalizacaoID($ID);
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->delete('localizacao');
	}


	function criar($dados) {
		if ($this->db->insert('localizacao', $dados)){
			return $dados['secao'];
		} else {
			var_dump($this->db->getLastError());
			return false;
		}
	}

	function getSecoes($check = false, $filtros = false) {
		if($check) {
			$this->db->join('localizacao l', 'l.secao = s.id', 'INNER');
		} 
		if ($filtros->ent) {
			$this->db->where('s.entidade', $filtros->ent);
		} else if($this->_auth->entidade->id) {
			$this->db->where('s.entidade', $this->_auth->entidade->id);
		} else {
			$this->db->where('s.entidade', $this->entidade->id);
		}
		$this->db->OrderBy('s.nome', 'ASC');
		$this->db->groupBy('s.nome');
		$this->secoes = $this->db->ObjectBuilder()->get('localizacao_secoes s');
		return $this->secoes;
	}

	function getLocalizacaoSecao($secao) {
		$this->db->join('localizacao_secoes g', 'g.id = t.secao AND g.nome = "'.$secao.'"', 'INNER');
		$this->db->where('t.entidade', $this->_auth->entidade->id);
		return $this->db->ObjectBuilder()->getOne('localizacao t', null, 't.*, g.nome as secao, t.secao as secao_id');
	}

	function getSecoesDisp($ID = null) {
		if($ID) {
			$this->db->join('localizacao c', "c.secao = s.id", 'LEFT');
			$this->db->where("(c.id IS NULL) OR (c.secao = '$ID')");
		} else {
			$this->db->join('localizacao c', "c.secao = s.id", 'LEFT');
			$this->db->where("c.id IS NULL");
		}
		$this->db->OrderBy('s.nome', 'ASC');
		$this->db->groupBy('s.nome');
		$this->db->where('s.entidade', $this->_auth->entidade->id);
		$this->db->groupBy('s.id');
		$this->secoes = $this->db->ObjectBuilder()->get('localizacao_secoes s', null, 's.*');
		return $this->secoes;
	}

}

return $LOCALIZACAO = new Localizacao($isView);

?>