<?
class Links extends APP {
	PRIVATE $APP;

	PUBLIC $links;
	PUBLIC $secoes;

	function __construct($isView) {
		if($isView) { $this->isView = true; }
		parent::__construct($isView);
		$this::getLinks();
		$this::getSecoes();
		if ((int) ENTIDADE !== 0) {
			$this->_auth->entidade = $this::getEntidade(ENTIDADE);
		}
	}

	function setSetup($tabela, $ID, $dados) {
		$this->db->where('id', $ID);
		if ( $this->db->update('links_'.$tabela, $dados) ) {
			return $ID;
		} else {
			return false;
		}
	}

	function addSetup($tabela, $ID, $dados) {
		if ( $this->db->insert('links_'.$tabela, $dados) ) {
			return $this->db->getInsertID();
		} else {
			return false;
		}
	}

	function delSetup($tabela, $ID) {
		$this->db->where('id', $ID);
		if ( $this->db->delete('links_'.$tabela) ) {
			return true;
		} else {
			return false;
		}
	}

	function getLinks() {
		$this->db->join('links_secoes s', 's.id = l.secao', 'LEFT');
		$this->db->where('l.entidade', $this->_auth->entidade->id);
		$this->links = $this->db->ObjectBuilder()->get('links l', null, 'l.*, s.nome as secao, s.id as secao_id');
		return $this->links;
	}

	function getLinkID($ID) {
		$this->db->where('l.id', $ID);
		$this->db->join('links_secoes s', 's.id = l.secao', 'LEFT');
		$this->db->where('l.entidade', $this->_auth->entidade->id);
		$this->links = $this->db->ObjectBuilder()->getOne('links l', 'l.*, s.nome as secao, s.id as secao_id');
		return $this->links;
	}

	function editar($ID, $dados) {
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->update('links', $dados);
	}
	function excluir($ID) {
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->delete('links');
	}
	function adicionar($dados) {
		if ($this->db->insert('links', $dados)){
			return $this->db->getInsertId();
		} else {
			return false;
		}
	}
	function getSecoes($check = false, $filtros = false) {
		if($check) {
			$this->db->join('links a', 'a.secao = s.id', 'INNER');
		} 
		if ($filtros->ent) {
			$this->db->where('s.entidade', $filtros->ent);
		} else {
			$this->db->where('s.entidade', $this->_auth->entidade->id);
		}
		$this->db->OrderBy('s.nome', 'ASC');
		$this->db->groupBy('s.nome');
		$this->secoes = $this->db->ObjectBuilder()->get('links_secoes s', null, 's.*');
		return $this->secoes;
	}

	function getLinksNews($limitador, $secao = false, $secaoNao = false, $orderBy = false, $pagina = 1) {
		$this->db->join('links_secoes s', 's.id = l.secao', 'LEFT');
		if ($secao) {
			if (is_array($secao)) {
				$this->db->where('s.nome', $secao, 'IN');
			} else {
				$this->db->where('s.nome', $secao);
			}
		}
		if ($secaoNao) {
			if (is_array($secaoNao)) {
				$this->db->where('s.nome', $secaoNao, 'NOT IN');
			} else {
				$this->db->where('s.nome', $secaoNao, '!=');
			}
		}
		$this->db->where('l.entidade', $this->_auth->entidade->id);
		if ($orderBy) {
			$this->db->OrderBy('l.'.$orderBy->campo, $orderBy->ordem);
		} else {
			$this->db->OrderBy('l.id', 'DESC');
		}

		$this->db->pageLimit = $limitador;
		if ($d = $this->db->ObjectBuilder()->paginate('links l', $pagina, 'l.*, s.nome as secao, s.id as secao_id'))  {
			$this->totalCount = $this->db->totalCount;
			return $d;
		} else {
			return false;
		}
	}
}

return $LINKS = new Links($isView);

?>