<?
class Licitacoes extends APP {
	PRIVATE $APP;

	PUBLIC $licitacoes;
	PUBLIC $secoes;
	PUBLIC $modalidades;
	PUBLIC $status;
	PUBLIC $tipos;

	function __construct($isView) {
		if($isView) { $this->isView = true; }
		parent::__construct($isView);
		$this::getLicitacoes();
		$this::getCategorias();
		$this::getModalidades(false);
		$this::getTipos();
		$this::getStatus();
	}

	function excluirArquivo($ID) {
		$a = $this::getArquivo($ID);
		if( is_file($a->path.$a->arquivo) ) {
			@unlink($a->path.$a->arquivo);
		}
		if( $a->tipo == 'imagem' ) {
			@unlink($a->path.'min/'.$a->arquivo);
		}
		$this->db->where('id', $ID);
		$this->db->delete('licitacoes_arquivos');
		return true;
	}

	function setEntidades($licitacao, $entidades = false) {
		$this::delEntidades($licitacao);
		if($entidades) {
			foreach($entidades as $e) {
				$insert[] = array(
					'licitacao' => $licitacao,
					'entidade' => $e,
					'usuario' => $this->_auth->usuario->ID
				);
			}
			return $this->db->insertMulti('licitacoes_entidades', $insert);
		}
		return true;
	}

	function getEntidades($licitacao) {
		$this->db->where('licitacao', $licitacao);
		return $this->db->getValue('licitacoes_entidades', 'entidade', null);
	}
	
	function delEntidades($licitacao, $entidade = false) {
		$this->db->where('licitacao', $licitacao);
		if($entidade) { $this->db->where('entidade', $entidade); }
		return $this->db->delete('licitacoes_entidades');
	}

	function setSetup($tabela, $ID, $dados) {
		$this->db->where('id', $ID);
		if ( $this->db->update('licitacoes_'.$tabela, $dados) ) {
			return $ID;
		} else {
			return false;
		}
	}

	function addSetup($tabela, $ID, $dados) {
		if ( $this->db->insert('licitacoes_'.$tabela, $dados) ) {
			return $this->db->getInsertID();
		} else {
			return false;
		}
	}

	function delSetup($tabela, $ID) {
		$this->db->where('id', $ID);
		if ( $this->db->delete('licitacoes_'.$tabela) ) {
			return true;
		} else {
			return false;
		}
	}

	function setLegenda($ID, $legenda) {
		$this->db->where('id', $ID);
		return $this->db->update('licitacoes_arquivos', $legenda);
	}

	function getArquivo($ID) {
		$this->db->where('id', $ID);
		return $this->db->ObjectBuilder()->getOne('licitacoes_arquivos');
	}

	function getArquivosCodigo($codigo) {
		$this->db->where('codigo', $codigo);
		return $this->db->ObjectBuilder()->get('licitacoes_arquivos');
	}

	function getUrlArquivo($ID) {
		$this->db->where('id', $ID);
		$a = $this->db->ObjectBuilder()->getOne('licitacoes_arquivos');
		if($a) {
			return DIR.$a->path.$a->arquivo;
		} else {
			return '';
		}
	}

	function galeriaImagem($n) {
		$this->db->where('codigo', $n->codigo);
		$this->db->where('tipo', 'imagem');
		return $this->db->ObjectBuilder()->get('licitacoes_arquivos');
	}

	function galeriaArquivos($n) {
		$this->db->where('codigo', $n->codigo);
		$this->db->where('tipo', 'arquivo');
		return $this->db->ObjectBuilder()->get('licitacoes_arquivos');
	}
	
	function getLicitacoes() {
		$this->db->join('licitacoes_entidades e', 'l.id = e.licitacao', 'LEFT');
		$this->db->join('app_entidades ee', 'e.entidade = ee.id', 'LEFT');
		$this->db->join('app_entidades e2', 'l.entidade = e2.id', 'LEFT');
		$this->db->where('(l.entidade = '.$this->_auth->entidade->id.' OR e.entidade = '.$this->_auth->entidade->id.')');
		$this->licitacoes = $this->db->ObjectBuilder()->get('licitacoes l', null, 'l.*, ee.id as entidade_id, e2.nome as entidade_nome');
		return $this->licitacoes;
	}

	function getLicitacaoTag($TAG) {
		$this->db->where('tag', $TAG);
		$this->db->join('licitacoes_entidades e', 'l.id = e.licitacao', 'LEFT');
		$this->db->join('app_entidades ee', 'e.entidade = ee.id', 'LEFT');
		$this->db->join('app_entidades e2', 'l.entidade = e2.id', 'LEFT');
		$this->db->where('(l.entidade = '.$this->_auth->entidade->id.' OR e.entidade = '.$this->_auth->entidade->id.')');
		return $this->db->ObjectBuilder()->get('licitacoes l', null, 'l.*, ee.id as entidade_id, e2.nome as entidade_nome')[0];
	}

	function getLicitacaoID($ID) {
		$this->db->where('id', $ID);
		$noticia = $this->db->ObjectBuilder()->getOne('licitacoes');
		return $noticia;
	}

	function editar($ID, $dados) {
		$this->db->where('(tag = "'.$dados['tag'].'" AND id != "'.$ID.'")');
		$this->db->orWhere('tag LIKE ("'.$dados['tag'].'_%")  AND id != "'.$ID.'"');
		$TAGS = count($this->db->get('licitacoes'));
		if($TAGS) {	$dados['tag'] = $dados['tag'].'_'.$TAGS; }

		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		if( $this->db->update('licitacoes', $dados) ) {
			return $dados['tag'];
		} else {
			var_dump($this->db->getLastError());
			return false;
		}
	}

	function excluir($ID) {
		$n = $this::getLicitacaoID($ID);

		if($n->entidade != $this->_auth->entidade->id) {
			return $this::delEntidades($ID, $this->_auth->entidade->id);
		}

		if ($A = $this::getArquivosCodigo($n->codigo)) {
			foreach ($A as $a) {
				$this::excluirArquivo($a->id);
			}
			$path = $A[0]->path;
			@rmdir($path.'min/');
			@rmdir($path);
			@rmdir($path.'arquivos/');
			$from = array('imagens/', 'arquivos/'); $to = array('', '');
			@rmdir(str_replace($from, $to, $path));
		}

		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->delete('licitacoes');
	}


	function criar($dados) {
		$this->db->where('tag', $dados['tag']);
		$this->db->orWhere('tag LIKE ("'.$dados['tag'].'_%")');
		$TAGS = count($this->db->get('licitacoes'));
		if($TAGS) {	$dados['tag'] = $dados['tag'].'_'.$TAGS; }
		if ($this->db->insert('licitacoes', $dados)){
			return $dados['tag'];
		} else {
			var_dump($this->db->getLastError());
			return false;
		}
	}
	
	function getCategorias() {
		$return[] = (object) array('id' => 1, 'nome' => 'Licitações');
		$return[] = (object) array('id' => 2, 'nome' => 'Contratos');
		$return[] = (object) array('id' => 3, 'nome' => 'Convênios');
		return $return;
	}

	function getModalidades($IDs) {
		if($IDs) {
			$this->db->where('id', $IDs, 'IN');
		} else {
			$this->db->where('entidade', $this->_auth->entidade->id);
		}
		$this->db->OrderBy('nome', 'ASC');
		$this->db->groupBy('nome');
		$this->modalidades = $this->db->ObjectBuilder()->get('licitacoes_modalidades');
		return $this->modalidades;
	}

	function getTipos() {
		$this->db->OrderBy('nome', 'ASC');
		$this->db->groupBy('nome');
		$this->db->where('entidade', $this->_auth->entidade->id);
		$this->tipos = $this->db->ObjectBuilder()->get('licitacoes_tipos');
		return $this->tipos;
	}
	function getStatus() {
		$this->db->OrderBy('nome', 'ASC');
		$this->db->groupBy('nome');
		$this->db->where('entidade', $this->_auth->entidade->id);
		$this->status = $this->db->ObjectBuilder()->get('licitacoes_status');
		return $this->status;
	}
	
	function viewCategoriasArquivos($filtros = false, $ordem = false) {
		# ANO
		if($filtros->ano) {
			$this->db->where("(YEAR(l.data) = '$filtros->ano' OR (l.inicio IS NOT NULL AND l.fim IS NOT NULL AND '$filtros->ano' BETWEEN YEAR(l.inicio) AND YEAR(l.fim)))");
		}
		# MES
		if($filtros->m) {
			$this->db->where("(MONTH(l.data) = '$filtros->m' OR (l.inicio IS NOT NULL AND l.fim IS NOT NULL AND '$filtros->m' BETWEEN MONTH(l.inicio) AND MONTH(l.fim)))");
		}
		# ENTIDADE
		$this->db->join('licitacoes_entidades e', 'e.licitacao = l.id', 'LEFT');
		if($filtros->ent) {
			$this->db->where('(l.entidade = '.$filtros->ent.' OR e.entidade = '.$filtros->ent.')');
		} else {
			$this->db->where('(l.entidade = '.$this->_auth->entidade->id.' OR e.entidade = '.$this->_auth->entidade->id.')');
		}
		# BUSCA
		if($filtros->b) {
			$this->db->where("(l.titulo LIKE '%$filtros->b%' OR l.objeto LIKE '%$filtros->b%' OR l.numero LIKE '%$filtros->b%')");
		}
		# MODALIDADE
		if($filtros->mod) {
			$this->db->where("m.nome", $filtros->mod);
		}
		if($filtros->cat) {
			$this->db->where('l.categoria', $filtros->cat);
		}
		$this->db->join('licitacoes_status s', 's.id = l.status', 'LEFT');
		$this->db->join('licitacoes_modalidades m', 'm.id = l.modalidade', 'LEFT');
		$this->db->join('licitacoes_tipos t', 't.id = l.tipo', 'LEFT');
		$this->db->OrderBy('l.categoria', 'ASC');
		if($ordem) {
			$this->db->orderBy('l.'.$ordem->campo, $ordem->ordem);
		} else {
			$this->db->orderBy('l.data', 'DESC');
		}
		if ($l = $this->db->ObjectBuilder()->get('licitacoes l', null, 'l.*, s.nome as status_nome, m.nome as modalidade_nome, t.nome as tipo_nome')) {
			$this->return = false;
			foreach($l as $l) {
				$l->{'arquivos'} = $this::getArquivosCodigo($l->codigo);
				$this->return->{$l->categoria}->{$l->id} = $l;
			}
			return $this->return;
		} else {
			return null;
		}		
	}

	function getModalidadesCat($cat, $filtros = false) {
		$this->db->where('l.categoria', $cat);
		# ANO
		if($filtros->ano) {
			$this->db->where('YEAR(l.data)', $filtros->ano);
		}
		# ENTIDADE
		$this->db->join('licitacoes_entidades e', 'e.licitacao = l.id', 'LEFT');
		if($filtros->ent) {
			$this->db->where('(l.entidade = '.$filtros->ent.' OR e.entidade = '.$filtros->ent.')');
		} else {
			$this->db->where('(l.entidade = '.$this->_auth->entidade->id.' OR e.entidade = '.$this->_auth->entidade->id.')');
		}
		# BUSCA
		if($filtros->b) {
			$this->db->where("l.titulo LIKE '%$filtros->b%'");
		}
		$this->db->join('licitacoes_modalidades m', 'l.modalidade = m.id', 'INNER');
		$this->db->groupBy('m.id');
		$m =  $this->db->ObjectBuilder()->get('licitacoes l', null, 'm.*');
		return $m;
	}
}

return $LICITACOES = new Licitacoes($isView);

?>