<?
class Imagens extends APP {
	PRIVATE $APP;

	PUBLIC $blocos;
	PUBLIC $secoes;

	function __construct($isView) {
		if($isView) { $this->isView = true; }
		parent::__construct($isView);
		$this::getImagens();
		$this::getSecoes();
		if ((int) ENTIDADE !== 0) {
			$this->_auth->entidade = $this::getEntidade(ENTIDADE);
		}
	}

	function setSetup($tabela, $ID, $dados) {
		$this->db->where('id', $ID);
		if ( $this->db->update('imagem_'.$tabela, $dados) ) {
			return $ID;
		} else {
			return false;
		}
	}

	function addSetup($tabela, $ID, $dados) {
		if ( $this->db->insert('imagem_'.$tabela, $dados) ) {
			return $this->db->getInsertID();
		} else {
			return false;
		}
	}

	function delSetup($tabela, $ID) {
		$this->db->where('id', $ID);
		if ( $this->db->delete('imagem_'.$tabela) ) {
			return true;
		} else {
			return false;
		}
	}

	function desativar($ID) {
		$dados = array('status' => 0);
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->update('imagem', $dados);
	}

	function ativar($ID, $secao) {
		$dados = array('status' => 1);
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->update('imagem', $dados);
	}
	
	function getImagens() {
		$this->db->join('imagem_secoes g', 'g.id = t.secao', 'LEFT');
		$this->db->where('t.entidade', $this->_auth->entidade->id);
		$this->db->OrderBy('g.nome', 'ASC');
		$this->db->OrderBy('t.ordem', 'ASC');
		$this->blocos = $this->db->ObjectBuilder()->get('imagem t', null, 't.*, g.nome as secao, t.secao as secao_id');
		return $this->blocos;
	}

	function getImagemID($ID) {
		$this->db->where('t.id', $ID);
		$this->db->join('imagem_secoes g', 'g.id = t.secao', 'LEFT');
		$bloco = $this->db->ObjectBuilder()->get('imagem t', null, 't.*, g.nome as secao, t.secao as secao_id')[0];
		return $bloco;
	}

	function editar($ID, $dados) {
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		if( $this->db->update('imagem', $dados) ) {
			return $dados['secao'];
		} else {
			return false;
		}
	}

	function atualizarImagem($ID, $dados) {
		$i = $this::getImagemID($ID);
		if( is_file($i->path.$i->arquivo) ) {
			@unlink($i->path.$i->arquivo);
		}
		if( $a->tipo == 'imagem' ) {
			@unlink($i->path.'min/'.$i->arquivo);
		}
		$this->db->where('id', $ID);
		$this->db->update('imagem', array('path' => null, 'arquivo' => null));

		$this->db->where('id', $ID);
		if( $this->db->update('imagem', $dados) ) {
			return true;
		} else {
			return false;
		}
	}


	function excluir($ID) {
		$n = $this::getImagemID($ID);

		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->delete('imagem');
	}


	function criar($dados) {
		if ($ID = $this->db->insert('imagem', $dados)){
			return $ID;
		} else {
			var_dump($this->db->getLastError());
			return false;
		}
	}

	function getSecoes() {
		$this->db->OrderBy('nome', 'ASC');
		$this->db->where('entidade', $this->_auth->entidade->id);
		$this->secoes = $this->db->ObjectBuilder()->get('imagem_secoes');
		return $this->secoes;
	}

	function getSecoesDisp($ID = null) {
		if($ID) {
			$this->db->join('imagem c', "c.secao = s.id", 'LEFT');
			$this->db->where("(c.id IS NULL OR c.secao = '$ID')");
		} else {
			$this->db->join('imagem c', "c.secao = s.id", 'LEFT');
			$this->db->where("c.id IS NULL");
		}
		$this->db->OrderBy('s.nome', 'ASC');
		$this->db->having('s.entidade', $this->_auth->entidade->id);
		$this->db->groupBy('s.id');
		$this->secoes = $this->db->ObjectBuilder()->get('imagem_secoes s', null, 's.*');
		return $this->secoes;
	}

	function getImagemSecao($nome) {
		$this->db->join('imagem_secoes s', "i.secao = s.id", 'INNER');
		$this->db->where('s.nome', $nome);
		$this->db->where('i.entidade', $this->_auth->entidade->id);
		$this->db->where('status', 1);
		$this->db->OrderBy('i.ordem', 'ASC');
		return $this->db->ObjectBuilder()->get('imagem i', null, 'i.*, s.nome as secao_nome');
	}

}

return $IMAGEM = new Imagens($isView);

?>