<?
class Governo extends APP {
	PRIVATE $APP;

	PUBLIC $governos;
	PUBLIC $secoes;

	function __construct($isView) {
		if($isView) { $this->isView = true; }
		parent::__construct($isView);
		if($isView) {
			$this->isView = true;
		} else {
			$this::getGovernos();
			$this::getSecoes();
		}		
		if (defined('ENTIDADE')) {
			$this->_auth->entidade = $this::getEntidade(ENTIDADE);
		}
	}

	function setSetup($tabela, $ID, $dados) {
		$this->db->where('id', $ID);
		if ( $this->db->update('governo_'.$tabela, $dados) ) {
			return $ID;
		} else {
			return false;
		}
	}

	function addSetup($tabela, $ID, $dados) {
		if ( $this->db->insert('governo_'.$tabela, $dados) ) {
			return $this->db->getInsertID();
		} else {
			return false;
		}
	}

	function delSetup($tabela, $ID) {
		$this->db->where('id', $ID);
		if ( $this->db->delete('governo_'.$tabela) ) {
			return true;
		} else {
			return false;
		}
	}

	function excluirArquivo($ID) {
		$a = $this::getArquivo($ID);
		if( is_file($a->path.$a->arquivo) ) {
			@unlink($a->path.$a->arquivo);
		}
		if( $a->tipo == 'imagem' ) {
			@unlink($a->path.'min/'.$a->arquivo);
		}
		$this->db->where('id', $ID);
		$this->db->delete('governo_arquivos');

		$this->db->where('capa', $ID);
		$this->db->update('governo', array('capa' => 0));
		return true;
	}

	function addLink($dados) {
		return $this->db->insert('governo_links', $dados);
	}
	function addVideo($dados) {
		return $this->db->insert('governo_videos', $dados);
	}

	function setLegenda($ID, $legenda) {
		$this->db->where('id', $ID);
		return $this->db->update('governo_arquivos', $legenda);
	}

	function getVideos($n) {
		$this->db->where('codigo', $n->codigo);
		return $this->db->ObjectBuilder()->get('governo_videos');
	}

	function getLinks($n) {
		$this->db->where('codigo', $n->codigo);
		return $this->db->ObjectBuilder()->get('governo_links');
	}

	function getArquivo($ID) {
		$this->db->where('id', $ID);
		return $this->db->ObjectBuilder()->getOne('governo_arquivos');
	}

	function getArquivosCodigo($codigo) {
		$this->db->where('codigo', $codigo);
		return $this->db->ObjectBuilder()->get('governo_arquivos');
	}

	function atualizaCapa($ID, $dados) { 
		$this->db->where('codigo', $dados['codigo']);
		$this->db->where('tipo', 'capa');
		if( $capa = $this->db->ObjectBuilder()->getOne('governo_arquivos') ) {
			$this->db->where('id', $capa->id);

			if ($this->db->update('governo_arquivos', $dados) ) {	

				$data = array('capa' => $capa->id);
				$this->db->where('id', $ID);
				if($this->db->update('governo', $data)) {
					return $capa;
				} else {
					return false;
				}				
			} else {
				return false;
			}
		} else {
			if( $this->db->insert('governo_arquivos', $dados) ) {
				$capa = $this->db->getInsertID();
		
				$data = array('capa' => $capa);

				$this->db->where('id', $ID);
				if($this->db->update('governo', $data)) {
					return $capa;
				} else {
					return false;
				}
			}
		}
	}

	function getUrlArquivo($ID) {
		$this->db->where('id', $ID);
		$a = $this->db->ObjectBuilder()->getOne('governo_arquivos');
		if($a) {
			return DIR.$a->path.$a->arquivo;
		} else {
			return '';
		}
	}

	function galeriaImagem($n, $capa = true) {
		if($capa) {
			$this->db->where("(codigo = '$n->codigo') AND (tipo = 'imagem' OR tipo = 'capa')");
		} else {
			$this->db->where("(codigo = '$n->codigo') AND (tipo = 'imagem')");
		}
		return $this->db->ObjectBuilder()->get('governo_arquivos');
	}

	function galeriaArquivos($n) {
		$this->db->where('codigo', $n->codigo);
		$this->db->where('tipo', 'arquivo');
		return $this->db->ObjectBuilder()->get('governo_arquivos');
	}

	function getCapa($n) {
		$this->db->where('codigo', $n->codigo);
		$this->db->where('tipo', 'capa');
		return $this->db->ObjectBuilder()->getOne('governo_arquivos');
	}

	function getCapaID($ID) {
		$this->db->where('id', $ID);
		if ( $capa = $this->db->ObjectBuilder()->getOne('governo_arquivos') ){
			return $capa;
		} else {
			return $capa = (object) array(
				'path' => API.HD.'governo/'.$this->entidade->id.'/',
				'arquivo' => 'capa.jpg',
			);
		}
	}
	
	function getGovernos() {
		$this->db->where('g.entidade', $this->_auth->entidade->id);
		$this->db->OrderBy('g.data', 'DESC');
		$this->db->join('governo_secoes s', 's.id = g.secao', 'LEFT');
		$this->governos = $this->db->ObjectBuilder()->get('governo g', null, 'g.*, s.nome as secao, s.id as secao_id');
		if($this->isView) {
			if ($gov = $this->db->ObjectBuilder()->get('governo'))  {
				$num = 0;
				foreach($gov as $n) {
					$arquivos['capa'] = $this::getCapaID($n->capa);
					$n->{'arquivos'} = (object) $arquivos;
					if($n->destaque == 1 AND $num < LIMITE_CAPA) {
						$governos['capas'][] = (object) $n;
						$num++;
					} else {
						$arquivos['capa'] = $this::getArquivo($n->capa);
						$governos['governo'][] = $n;
					}
				}
				$this->governos = (object) $governos;
				return $governos;
			} else {
				return false;
			}
		}
		return $this->governos;
	}

	function getGovernoTag($TAG) {
		$this->db->where('tag', $TAG);
		$this->db->where('entidade', $this->_auth->entidade->id);
		$governo = $this->db->ObjectBuilder()->getOne('governo');
		if($n = $governo) {
			$arquivos['capa'] = $this::getCapaID($n->capa);
			$arquivos['videos'] = $this::getVideos($n);
			$arquivos['arquivos'] = $this::galeriaArquivos($n);
			$arquivos['links'] = $this::getLinks($n);
			$arquivos['imagens'] = $this::galeriaImagem($n);
			$governo->{'arquivos'} = (object) $arquivos;
		}
		return $governo;
	}

	function getGovernoID($ID) {
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		$governo = $this->db->ObjectBuilder()->getOne('governo');
		if($n = $governo) {
			$arquivos['capa'] = $this::getCapaID($n->capa);
			$arquivos['videos'] = $this::getVideos($n);
			$arquivos['arquivos'] = $this::galeriaArquivos($n);
			$arquivos['links'] = $this::getLinks($n);
			$arquivos['imagens'] = $this::galeriaImagem($n);
			$governo->{'arquivos'} = (object) $arquivos;
		}
		return $governo;
	}

	function destacar($ID, $tipo) {
		$n = $this::getGovernoID($ID);

		if($n->destaque == $tipo) {
			$data['destaque'] = 0;
			$this->db->where('id', $ID);
			if( $this->db->update('governo', $data) ) {
				$return['status'] = true;
				$return['acao'] = 0;
			} else {
				return false;
			}
		
		} else {
			$data['destaque'] = $tipo;
			$this->db->where('id', $ID);
			if( $this->db->update('governo', $data) ) {
				$return['status'] = true;
				$return['acao'] = 1;
			} else {
				return false;
			}
		}
		return (object) $return;

	}

	function editar($ID, $dados) {
		$this->db->where('(tag = "'.$dados['tag'].'" AND id != "'.$ID.'")');
		$this->db->orWhere('tag LIKE ("'.$dados['tag'].'_%")  AND id != "'.$ID.'"');
		$TAGS = count($this->db->get('governo'));
		if($TAGS) {	$dados['tag'] = $dados['tag'].'_'.$TAGS; }

		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		if( $this->db->update('governo', $dados) ) {
			return $dados['tag'];
		} else {
			return false;
		}
	}

	function desativar($ID) {
		$dados = array('status' => '0');
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->update('governo', $dados);
	}

	function ativar($ID) {
		$dados = array('status' => 1);
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->update('governo', $dados);
	}

	function excluir($ID) {
		$n = $this::getGovernoID($ID);

		if ($A = $this::getArquivosCodigo($n->codigo)) {
			foreach ($A as $a) {
				$this::excluirArquivo($a->id);
			}
			$path = $A[0]->path;
			@rmdir($path.'min/');
			@rmdir($path);
			@rmdir($path.'arquivos/');
			$from = array('imagens/', 'arquivos/'); $to = array('', '');
			@rmdir(str_replace($from, $to, $path));
		}

		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->delete('governo');
	}

	function excluirLink($ID) {
		$this->db->where('id', $ID);
		return $this->db->delete('governo_links');
	}

	function excluirVideo($ID) {
		$this->db->where('id', $ID);
		return $this->db->delete('governo_videos');
	}

	function editarLink($ID, $dados) {
		$this->db->where('id', $ID);
		if( $this->db->update('governo_links', $dados) ) {
			return true;
		} else {
			return false;
		}
	}

	function editarVideo($ID, $dados) {
		$this->db->where('id', $ID);
		if( $this->db->update('governo_videos', $dados) ) {
			return true;
		} else {
			return false;
		}
	}

	function criar($dados) {
		$this->db->where('tag', $dados['tag']);
		$this->db->orWhere('tag LIKE ("'.$dados['tag'].'_%")');
		$TAGS = count($this->db->get('governo'));
		if($TAGS) {	$dados['tag'] = $dados['tag'].'_'.$TAGS; }
		if ($this->db->insert('governo', $dados)){
			return $dados['tag'];
		} else {
			var_dump($this->db->getLastError());
			return false;
		}
	}
	
	function getSecoes() {
		$this->db->OrderBy('nome', 'ASC');
		$this->db->where('entidade', $this->_auth->entidade->id);
		$this->secoes = $this->db->ObjectBuilder()->get('governo_secoes');
		return $this->secoes;
	}

	function getSecoesDisp($ID = null) {
		if($ID) {
			$this->db->join('governo c', "c.secao = s.id", 'LEFT');
			$this->db->where("(c.id IS NULL) OR (c.secao = '$ID')");
		} else {
			$this->db->join('governo c', "c.secao = s.id", 'LEFT');
			$this->db->where("c.id IS NULL");
		}
		$this->db->OrderBy('s.nome', 'ASC');
		$this->db->groupBy('s.nome');
		$this->db->where('s.entidade', $this->_auth->entidade->id);
		$this->db->groupBy('s.id');
		$this->secoes = $this->db->ObjectBuilder()->get('governo_secoes s', null, 's.*');
		return $this->secoes;
	}

	function contar($n) {
		$dados['contador'] = ++$n->contador;
		$this->db->where('id', $n->id);
		return $this->db->update('governo', $dados);
	}

	function getGovernoNews($limitador, $secao = false, $secaoNao = false, $orderBy = false, $pagina = 1) {
		$this->db->join('governo_secoes as s', 's.id = g.secao', 'LEFT');
		if ($secao) {
			if (is_array($secao)) {
				$this->db->where('s.nome', $secao, 'IN');
			} else {
				$this->db->where('s.nome', $secao);
			}
		}
		if ($secaoNao) {
			if (is_array($secaoNao)) {
				$this->db->where('s.nome', $secaoNao, 'NOT IN');
			} else {
				$this->db->where('s.nome', $secaoNao, '!=');
			}
		}
		$this->db->where('g.entidade', $this->entidade->id);
		if ($orderBy) {
			$this->db->OrderBy('g.'.$orderBy->campo, $orderBy->ordem);
		} else {
			$this->db->OrderBy('g.data', 'DESC');
		}
		$this->db->pageLimit = $limitador;
		if ($gov = $this->db->ObjectBuilder()->paginate('governo g', $pagina, 'g.*, s.nome as secao'))  {
			$this->totalCount = $this->db->totalCount;
			foreach($gov as $g) {
				$g->{'capa'} = (object) $this::getCapaID($g->capa);
				$governo[] = (object) $g;
			}
			return $governo;
		} else {
			return false;
		}
	}
	function getGovernoSecoes($limitador, $secao = false, $secaoNao = false, $orderBy = false, $pagina = 1) {
		$this->db->join('governo_secoes as s', 's.id = g.secao', 'LEFT');
		if ($secao) {
			if (is_array($secao)) {
				$this->db->where('s.nome', $secao, 'IN');
			} else {
				$this->db->where('s.nome', $secao);
			}
		}
		if ($secaoNao) {
			if (is_array($secaoNao)) {
				$this->db->where('s.nome', $secaoNao, 'NOT IN');
			} else {
				$this->db->where('s.nome', $secaoNao, '!=');
			}
		}
		//$this->db->where('g.entidade', $this->entidade->id);
		if ($orderBy) {
			$this->db->OrderBy('g.'.$orderBy->campo, $orderBy->ordem);
		} else {
			$this->db->orderBy('s.nome', 'ASC');
			$this->db->orderBy('g.titulo', 'ASC');
			$this->db->OrderBy('g.data', 'DESC');
		}
		$this->db->pageLimit = $limitador;
		if ($gov = $this->db->ObjectBuilder()->paginate('governo g', $pagina, 'g.*, s.nome as secao'))  {
			$this->totalCount = $this->db->totalCount;
			foreach($gov as $g) {
				$g->{'capa'} = (object) $this::getCapaID($g->capa);
				$governo[$g->secao][] = (object) $g;
			}
			return $governo;
		} else {
			return false;
		}
	}

}

return $GOVERNO = new Governo($isView);

?>