var FormWizard = function () {

    var handleSummernote = function () {
        var myElement = $('#texto');
        myElement.show();
        myElement.summernote({
            height: 250,
            dialogsFade: true,
            placeholder: 'Digite informações adicionais',
            lang: 'pt-BR',
            toolbar: [
                ['style', ['style']],
                ['font', ['bold', 'underline', 'clear']],
                //['fontname', ['fontname']],
                ['color', ['color']],
                ['para', ['ul', 'ol', 'paragraph']],
                ['table', ['table']],
                ['insert', ['link'/*, 'picture', 'video'*/]],
                ['view', ['fullscreen', 'codeview', 'help']]
              ],
            callbacks: {
                onChange: function(contents, $editable) {
                    myElement.val(myElement.summernote('isEmpty') ? "" : contents);
                    v.element(myElement); 
                }
            }
        });
        //API:
        //var sHTML = $('#summernote_1').code(); // get code
        //$('#summernote_1').destroy(); // destroy




        function format(state) {
            if (!state.id) return state.text; // optgroup
            return "<img class='flag' src='../../assets/global/img/flags/" + state.id.toLowerCase() + ".png'/>&nbsp;&nbsp;" + state.text;
        }

        var form = $('#form-novo');
        var error = $('.alert-danger', form);
        var success = $('.alert-success', form);

        var v = form.validate({
            doNotHideMessage: true, //this option enables to show the error/success messages on tab switch.
            errorElement: 'span', //default input error message container
            errorClass: 'help-block help-block-error', // default input error message class
            focusInvalid: false, // do not focus the last invalid input
            rules: {
                //account
                qtd: {
                    required:true,
                    number:true,
                    min: +1,
                    max: function() { return verificaCota() }
                },
            },

            ignore: ":hidden:not(#texto),.note-editable.panel-body",

            messages: { // custom messages for radio buttons and checkboxes
                
            },

            errorPlacement: function (error, element) { // render error placement for each input type
                if (element.attr("name") == "gender") { // for uniform radio buttons, insert the after the given container
                    //error.insertAfter("#form_gender_error");
                } else if (element.attr("name") == "texto") { // for uniform checkboxes, insert the after the given container
                    //error.insertAfter("#erro-editor");
                } else {
                    //error.insertAfter(element); // for other inputs, just perform default behavior
                }
            },

            invalidHandler: function (event, validator) { //display error alert on form submit   
                success.hide();
                error.show();
                App.scrollTo(error, -200);
            },

            highlight: function (element) { // hightlight error inputs
                $(element).closest('.form-group').removeClass('has-success').addClass('has-error'); // set error class to the control group
            },

            unhighlight: function (element) { // revert the change done by hightlight
                $(element)
                    .closest('.form-group').removeClass('has-error'); // set error class to the control group
            },

            success: function (label) {
                if (label.attr("for") == "gender" || label.attr("for") == "payment[]") { // for checkboxes and radio buttons, no need to show OK icon
                    label
                        .closest('.form-group').removeClass('has-error');
                    label.remove(); // remove error label here
                } else { // display success icon for other inputs
                    label
                        .addClass('valid') // mark the current input as valid and display OK icon
                    .closest('.form-group').removeClass('has-error'); // set success class to the control group
                }
            },

            submitHandler: function (form) {
                data = $('#form-novo').serialize();
                var action = $('#form-novo').attr('action');

                documento = $('[name=documento]').val()

                if( documento !== undefined && documento.length > 1 ) {

                    if ( !validar('[name=documento]', 'cpf-cnpj') ) {
                        $('[name=documento]').select();
                        swal("Documento inválido.", "O Documento informado é inválido.", "error");
                        return false;
                    }
                }

                //var acao = 'criar';
                $.ajax({
                    type: "POST",
                    dataType: "json",
                    url: action,
                    data: data,
                    beforeSend: function() {
                        BlockUI('#blockNovo');
                    },
                    success: function( data ) {
                        retornoAjax(data);
                        unBlockUI('#blockNovo');
                    },
                    error: function( data ) {
                        unBlockUI('#blockNovo');
                        $toast = toastr['error']('Informações inválidas. Atualize a página para continuar.');
                    }
                });
            }

        });
    }


    return {
        //main function to initiate the module
        init: function () {
            //validations();
            handleSummernote();
        }
    };

}();
jQuery(document).ready(function() {
    FormWizard.init();
});

$('[name=departamento]').on('change', function() {
    $('#alvo').html(veiculos[this.value]);
    $('#alvo').select2({
        selectOnClose: true,
        placeholder: 'Selecione um veículo',
        selectOnBlur: true,
        tags: false,
    });
    $('#combustivel').html(combustiveis[this.value]);
})
$(window).on('load', function() {
    $('[name=departamento]').trigger('change');
})

function verificaCota() {
    var d = $('#depto').val();
    var c = $('#combustivel').val();
    console.log(cota);
    var cotaDepto = cota[d+'-'+c];
    console.log(cotaDepto);
    return cotaDepto
}