var Editar = function() {
    var vEditar = function(){
        jQuery('#form-editar').validate({
            errorClass: 'help-block text-right animated fadeInDown',
            errorElement: 'div',
            errorPlacement: function(error, e) {
                jQuery(e).parents('.form-group > div').append(error);
            },
            highlight: function(e) {
                jQuery(e).closest('.form-group').removeClass('has-error').addClass('has-error');
                jQuery(e).closest('.help-block').remove();
            },
            success: function(e) {
                jQuery(e).closest('.form-group').removeClass('has-error');                
                jQuery(e).closest('.help-block').remove();
            },
            rules: {
                qtd: {
                    required: true,
                },
                combustivel: {
                    required: true,
                },
                departamento: {
                    required: true,
                },
                veiculo: {
                    required: true,
                },
                km: {
                    required: true,
                },
            },
            messages: {
                
            },
            submitHandler: function( form ){
                var dados = $( form ).serialize();
                var action = $( form ).attr('action');
                $.ajax({
                    type: "POST",
                    dataType: "json",
                    url: action,
                    data: dados,
                    success: function( data ) {
                        retornoAjax(data);
                    },
                    error: function( data ) {
                        $toast = toastr['error']('Informações inválidas. Atualize a página para continuar.');
                    }
                });
            }
        });
    };

    return {
        init: function () {
            // Init Login Form Validation
            vEditar();
        }
    };
}();
jQuery(function(){ Editar.init(); });

$('[name=departamento]').on('change', function() {
    $('#alvo').html(veiculos[this.value]);
    $('#alvo').select2({
        selectOnClose: true,
        placeholder: 'Selecione um veículo',
        selectOnBlur: true,
        tags: false,
    });
    $('#combustivel').html(combustiveis[this.value]);
})
$(window).on('load', function() {
    $('[name=departamento]').trigger('change');
})

function verificaCota() {
    var d = $('#depto').val();
    var c = $('#combustivel').val();
    console.log(cota);
    var cotaDepto = cota[d+'-'+c];
    console.log(cotaDepto);
    return cotaDepto
}