var tableAuditoria = function () {

    var tabelaAuditoria = function () {

        function restoreRow(oTable, nRow) {
            var aData = oTable.fnGetData(nRow);
            var jqTds = $('>td', nRow);

            for (var i = 0, iLen = jqTds.length; i < iLen; i++) {
                oTable.fnUpdate(aData[i], nRow, i, false);
            }

            oTable.fnDraw();
        }

        var tableLinks = $('#tabela_auditoria');


        var oTable = tableLinks.dataTable({
            buttons: [
                { extend: 'print',
                    title: 'Auditoria',
                    className: 'btn green no-shadow no-radius btn-outline font-s13',
                    text: '<i class="fa fa-print"></i> Imprimir',
                    exportOptions: { columns: [0,1,2,3,4] },
                },
                { extend: 'copy',
                    title: 'Auditoria',
                    className: 'btn green no-shadow no-radius btn-outline font-s13', 
                    text: '<i class="fa fa-clipboard"></i> Copiar',
                    exportOptions: { columns: [0,1,2,3,4] },
                },
                { extend: 'pdf',
                    title: 'Auditoria',
                    className: 'btn green no-shadow no-radius btn-outline font-s13',
                    text: '<i class="fa fa-pdf"></i> PDF',
                    exportOptions: { columns: [0,1,2,3,4] },
                },
                { extend: 'excel',
                    title: 'Auditoria',
                    className: 'btn green no-shadow no-radius btn-outline font-s13',
                    text: '<i class="fa fa-excel"></i> Excel',
                    exportOptions: { columns: [0,1,2,3,4] },
                },
                { extend: 'csv',
                    title: 'Auditoria',
                    className: 'btn green no-shadow no-radius btn-outline font-s13',
                    text: '<i class="fa fa-cvs"></i> CVS',
                    exportOptions: { columns: [0,1,2,3,4] },
                },
                { extend: 'colvis',
                    className: 'btn green no-shadow no-radius btn-outline font-s13',
                    text: 'Colunas',
                }
            ],

            "dom": "<'row' <'col-md-12'B>><'row'<'col-md-6 col-sm-12'l><'col-md-6 col-sm-12'f>r><'table-scrollable't><'row'<'col-md-5 col-sm-12'i><'col-md-7 col-sm-12'p>>",

            "lengthMenu": [
                [25, 50, 100, -1],
                [25, 50, 100, "Todos"] // change per page values here
            ],

            // Or you can use remote translation file
            //"language": {
            //   url: '//cdn.datatables.net/plug-ins/3cfcc339e89/i18n/Portuguese.json'
            //},

            // set the initial value
            "pageLength": 50,

            "language": {
                "sProcessing":   "A processar...",
                "sLengthMenu":   "Mostrar _MENU_ registros",
                "sZeroRecords":  "Não foram encontrados resultados",
                "sInfo":         "Mostrando de _START_ até _END_ de _TOTAL_ registros",
                "sInfoEmpty":    "Mostrando de 0 até 0 de 0 registros",
                "sInfoFiltered": "(filtrado de _MAX_ registros no total)",
                "sInfoPostFix":  "",
                "sSearch":       "Procurar:",
                "sUrl":          "",
                "oPaginate": {
                    "sFirst":    "Primeiro",
                    "sPrevious": "Anterior",
                    "sNext":     "Seguinte",
                    "sLast":     "Último"
                },
                "language": {
                    buttons: {
                        copySuccess: {
                            _: '%d Copiado com sucesso!',
                            1: '1 ligne copiée'
                        }
                    }
                }
            },

            "columnDefs": [{ // set default column settings
                'orderable': true,
                'type': 'date-uk',
                'targets': [0]
            }, {
                "searchable": true,
                "targets": [0]
            }],
            "order": [
                [0, "desc"]
            ], // set first column as a default sort by ascgetSaldoCliente
        });

        var tableWrapper = $("#editable_wrapper_link");

        var nEditing = null;
        var nNew = false;

        $('#adicionarD').click(function (e) {
            e.preventDefault();

            if (nNew && nEditing) {
                if (confirm("A linha em edição não foi salva. Você deseja salvá-la?")) {
                    saveRow(oTable, nEditing); // save
                    $(nEditing).find("td:first").html("Untitled");
                    nEditing = null;
                    nNew = false;

                } else {
                    oTable.fnDeleteRow(nEditing); // cancel
                    nEditing = null;
                    nNew = false;
                    return;
                }
            }

            var aiNew = oTable.fnAddData(['', '', '', '', '', '', '', '', '', '', '', '', '']);
            var nRow = oTable.fnGetNodes(aiNew[0]);
            oTable.find('tbody').prepend(nRow);
            $('#controle-ajax').attr('acao', 'novo');
            editRow(oTable, nRow);
            nEditing = nRow;
            nNew = true;
            $(oTable).find('input,select').first().focus();
        });

        
    }



    return {

        //main function to initiate the module
        init: function () {
            tabelaAuditoria();
        }

    };

}();
jQuery(document).ready(function() {
    tableAuditoria.init();
});