<?

class Frota extends APP {
	PRIVATE $APP;

	PUBLIC $pedidos;
	PUBLIC $status;
	PUBLIC $departamentos;
	PUBLIC $combustiveis;
	PUBLIC $frota;

	PUBLIC $_aprovado;
	PUBLIC $_negado;

	function __construct($isView) { GLOBAL $_POST;
		if($isView) { $this->isView = true; }
		parent::__construct($isView);
		$this->_admin = $this::consultaNivel($this->_auth->usuario->ID);
		$this::getPedidos($_POST['carregar']);
		$this::getDepartamentos();
		$this::getCombustiveis();
		$this::getUsuarios();
		$this::getPostos();
		$this::getStatus();
		$this::getFrota();
	}

	function excluirArquivo($ID) {
		$a = $this::getArquivo($ID);
		if( is_file($a->path.$a->arquivo) ) {
			@unlink($a->path.$a->arquivo);
		}
		if( $a->tipo == 'imagem' ) {
			@unlink($a->path.'min/'.$a->arquivo);
		}
		$this->db->where('id', $ID);
		$this->db->delete('frota_arquivos');
		return true;
	}

	function getArquivo($ID) {
		$this->db->where('id', $ID);
		return $this->db->ObjectBuilder()->getOne('frota_arquivos');
	}

	function getArquivosCodigo($codigo) {
		$this->db->where('codigo', $codigo);
		return $this->db->ObjectBuilder()->get('frota_arquivos');
	}

	function setStatus($ID, $status, $depto = false) {
		$this->db->where('id', $ID);
		$dados['status'] = $status;
		if($depto) { $dados['departamento'] = $depto; }
		$this->db->update('frota', $dados);
	}

	function setSetup($tabela, $ID, $dados) {
		$this->db->where('id', $ID);
		if ( $this->db->update('frota_'.$tabela, $dados) ) {
			return $ID;
		} else {
			return false;
		}
	}

	function setLegenda($ID, $legenda) {
		$this->db->where('id', $ID);
		return $this->db->update('frota_arquivos', $legenda);
	}

	function addSetup($tabela, $ID, $dados) {
		if ( $this->db->insert('frota_'.$tabela, $dados) ) {
			return $this->db->getInsertID();
		} else {
			return false;
		}
	}

	function delSetup($tabela, $ID) {
		$this->db->where('id', $ID);
		if ( $this->db->delete('frota_'.$tabela) ) {
			return true;
		} else {
			return false;
		}
	}

	function getPedidos($limitador = null) {
		if(!$limitador) { $limitador = 300; }

		if ( !$this->_admin ) {
			$this->db->join('frota_departamentos d', 'd.id = p.departamento', 'LEFT');
			$this->db->join('frota_departamentos_acesso a', "a.departamento = d.id AND a.usuario = '".$this->_auth->usuario->ID."'", 'INNER');
		} else {
			$this->db->join('frota_departamentos d', 'd.id = p.departamento', 'LEFT');
		}
		$this->db->join('app_usuarios u', 'u.ID = p.usuario', 'LEFT');
		$this->db->join('frota_status s', 's.id = p.status', 'LEFT');
		$this->db->join('frota_combustiveis c', 'c.id = p.combustivel', 'LEFT');
		$this->db->join('frota_frota v', 'v.id = p.veiculo', 'LEFT');
		$this->db->join('frota_postos po', 'po.id = p.posto', 'LEFT');
		//$this->db->where('s.nome', array('encerrado', 'encerrados', 'finalizado', 'finalizados', 'despachado', 'despachados'), 'NOT IN');
		$this->db->where('p.entidade', $this->_auth->entidade->id);
		$this->db->OrderBy('p.data', 'DESC');
		$this->pedidos = $this->db->ObjectBuilder()->get('frota p', $limitador, 'p.*, d.nome as departamento, p.departamento as departamento_id, s.nome as status, s.id as status_id, c.nome as combustivel, u.nome as usuario_nome, v.modelo, v.placa, v.km, po.nome as posto, po.id as posto_id');
		return $this->pedidos;
			
	}

	function getFrota() {
		$this->db->where('usuario', $this->_auth->usuario->ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		$this->db->where('nivel', 1);

		if ( !$this->db->getOne('frota_acessos') ) {
			$this->db->join('frota_departamentos d', 'd.id = f.departamento', 'LEFT');
			$this->db->join('frota_departamentos_acesso a', "a.departamento = d.id AND a.usuario = '".$this->_auth->usuario->ID."'", 'INNER');
		} else {
			$this->db->join('frota_departamentos d', 'd.id = f.departamento', 'LEFT');
		}
		$this->db->where('f.entidade', $this->_auth->entidade->id);
		$this->frota = $this->db->ObjectBuilder()->get('frota_frota f', null, 'f.*, d.nome as departamento, f.departamento as departamento_id');
		return $this->frota;
	}

	function getVeiculos($depto) {
		$this->db->join('frota_departamentos d', 'd.id = f.departamento AND d.id = '.$depto, 'LEFT');
		$this->db->where('f.entidade', $this->_auth->entidade->id);
		$frota = $this->db->ObjectBuilder()->get('frota_frota f', null, 'f.*, d.nome as departamento, f.departamento as departamento_id');
		return $frota;
	}

	function getPostos() {
		$this->db->where('entidade', $this->_auth->entidade->id);
		$this->postos = $this->db->ObjectBuilder()->get('frota_postos');
		return $this->postos;
	}

	function getDepartamentoID($ID) {
		$this->db->where('id', $ID);
		if($depto = $this->db->ObjectBuilder()->getOne('frota_departamentos')) {
			$depto->{'cota'} = $this::getCotas($depto->id);
			$depto->{'cotaD'} = $this::getCotasD($depto->id);
			return $depto;
		}
	}

	function getPedidoCodigo($codigo) {
		$this->db->join('frota_departamentos d', 'd.id = p.departamento', 'LEFT');
		$this->db->join('frota_status s', 's.id = p.status', 'LEFT');
		$this->db->where('p.codigo', $codigo);
		$this->db->where('p.entidade', $this->_auth->entidade->id);
		$pedido = $this->db->ObjectBuilder()->get('frota p', null, 'p.*, d.nome as departamento, p.departamento as departamento_id, s.nome as status, s.id as status_id')[0];
		return $pedido;
	}

	function getPedidoID($ID) {
		$this->db->join('frota_departamentos d', 'd.id = p.departamento', 'LEFT');
		$this->db->join('frota_status s', 's.id = p.status', 'LEFT');
		$this->db->where('p.id', $ID);
		if( $protocolo = $this->db->ObjectBuilder()->get('frota p', null, 'p.*, d.nome as departamento, p.departamento as departamento_id, s.nome as status, s.id as status_id')[0] ) {
		}
		return $protocolo;
	}

	function consultaAcessoProtocolo($usuario, $protocolo) {
		$this->db->where('usuario', $usuario);
		$this->db->where('entidade', $this->_auth->entidade->id);
		$this->db->where('nivel', 1);
		if ( $this->db->getOne('frota_acessos') ) {
			return true;
		
		} else {
			$this->db->join('frota_departamentos d', 'd.id = p.departamento', 'INNER');
			$this->db->join('frota_departamentos_acesso a', "a.departamento = d.id AND a.usuario = '".$this->_auth->usuario->ID."'", 'INNER');
			$this->db->where('p.id', $protocolo->id);

			if ( $this->db->get('frota p', null, 'p.*') ) {
				return true;

			} else {
				return $protocolo->departamento;

			}
		}


	}

	function getUsuarioID($ID) {
		$this->db->where('ID', $ID);
		return $this->db->ObjectBuilder()->getOne('app_usuarios');
	}

	function editar($ID, $dados) {
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		if( $this->db->update('frota', $dados) ) {
			return true;
		} else {
			return false;
		}
	}


	function excluir($ID) {
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->delete('frota');
	}


	function criar($dados) {
		$dados['status'] = $this::getStatusPadrao($dados['entidade']);
		if ($this->db->insert('frota', $dados)){
			$ID = $this->db->getInsertID();

			$update1 = array('km' => $dados['km_inicial']);
			$this->db->where('id', $dados['veiculo']);
			$this->db->update('frota_frota', $update1);

			$update2 = array('km_final' => $dados['km_inicial']);
			$this->db->where('id', $ID, '!=');
			$this->db->where('km_final', 0);
			$this->db->OrderBy('id', 'DESC');
			$this->db->update('frota', $update2, 1);

			return $ID;
		} else {
			var_dump($this->db->getLastError());
			return false;
		}
	}

	function updateKM($veiculo, $KM) {
		$dados = array('km' => $KM);
		return $this::setSetup('frota', $veiculo, $dados);
	}

	function getDepartamentos() {
		$this->db->OrderBy('nome', 'ASC');
		$this->db->groupBy('nome');
		$this->db->where('entidade', $this->_auth->entidade->id);
		if ($departamentos = $this->db->ObjectBuilder()->get('frota_departamentos')) {
			foreach ($departamentos as $d) {
				 $d->{'cotas'} = $this::getCotas($d->id);
				 $d->{'cotasD'} = $this::getCotasD($d->id);
				 $D[] = $d;
			}
			return $this->departamentos = $D;
		}
		return $this->departamentos = $D;
	}

	function setCota($ID, $dados) {
		$this->db->where('departamento', $ID);
		$this->db->delete('frota_cotas');
		return $this->db->insertMulti('frota_cotas', $dados);
	}

	function getCombustiveis() {
		$this->db->OrderBy('nome', 'ASC');
		$this->db->groupBy('nome');
		$this->db->where('entidade', $this->_auth->entidade->id);
		$this->combustiveis = $this->db->ObjectBuilder()->get('frota_combustiveis');
		return $this->combustiveis;
	}

	function getCombustivelID($ID) {
		$this->db->where('p.id', $ID);
		$this->db->join('app_usuarios u', 'u.ID = p.usuario', 'LEFT');
		$this->db->join('app_usuarios u2', 'u2.ID = p.usuario_autorizacao', 'LEFT');
		$this->db->join('frota_combustiveis c', 'c.id = p.combustivel', 'LEFT');
		$this->db->join('frota_status s', 's.id = p.status', 'LEFT');
		$this->db->join('frota_departamentos d', 'd.id = p.departamento', 'LEFT');
		$this->db->join('frota_frota v', 'v.id = p.veiculo', 'LEFT');
		$this->db->join('frota_postos po', 'po.id = p.posto', 'LEFT');
		$this->db->OrderBy('p.id', 'DESC');
		$combustivel = $this->db->ObjectBuilder()->get('frota p', 1, 'p.*, u.nome as usuario, u.ID as usuario_id, c.nome as combustivel, c.id as combustivel_id, s.nome as status, s.id as status_id, d.nome as departamento, d.id as departamento_id, v.modelo, v.placa, v.km, po.nome as posto, po.endereco as posto_endereco, po.telefone as posto_telefone, po.id as posto_id, u2.nome as autorizador')[0];
		return $combustivel;
	}

	function getStatus() {
		$this->statusAprovado = $this::statusAprovado();
		$this->statusNegado = $this::statusNegado();

		$this->db->OrderBy('nome', 'ASC');
		$this->db->groupBy('nome');
		$this->db->where('entidade', $this->_auth->entidade->id);
		$this->status = $this->db->ObjectBuilder()->get('frota_status');
		return $this->status;
	}

	function getStatusPadrao($entidade = false) {
		if($entidade) {
			$this->db->where('entidade', $entidade);
		} else {
			$this->db->where('entidade', $this->_auth->entidade->id);
		}
		$this->db->OrderBy('nome', 'ASC');
		$this->db->groupBy('nome');
		$this->db->where('padrao', 1);
		$this->status_padrao = $this->db->ObjectBuilder()->getValue('frota_status', 'id', 1);
		return $this->status_padrao ?? 0;
	}

	function padraoStatus($ID) {
		$dados['padrao'] = 0;
		$this->db->update('frota_status', $dados);

		$dados['padrao'] = 1;
		$this->db->where('id', $ID);
		$this->db->update('frota_status', $dados);
		return true;
	}

	function notificar($ID) {
		return $this::enviarEmail('atualizacao', $ID);
	}
	
	function resetEnvio($ID) {
		$this->db->where('id', $ID);
		$update['envio'] = 0;
		$this->db->update('frota', $update);
	}

	function getUsuarios() { GLOBAL $S;
		//$this->db->where('u.ID', $this->_auth->usuario->ID);
		$this->db->join('app_permissoes p', "p.usuario = u.ID AND p.aplicativo = '$S->ID' AND p.entidade = '".$this->_auth->entidade->id."'", 'INNER');
		$this->db->join('app_entidades_aplicativos e', "e.entidade = '".$this->_auth->entidade->id."' AND e.aplicativo = '$S->ID'", 'INNER');
		if ( $u = $this->db->ObjectBuilder()->get('app_usuarios u', null, 'u.*') ) {
			foreach ($u as $u) {
				$u->{'_admin'} = $this::consultaNivel($u->ID);
				$u->{'departamentos'} = $this::consultaDepartamentos($u->ID);
				$u->{'lista_dptos'} = $this::listarDepartamentos($u->ID);
				$usuarios[] = $u;
			}
		}
		$this->usuarios = $usuarios;
	}

	function consultaNivel($ID) {
		$this->db->where('usuario', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		$this->db->where('nivel', 1);
		return $nivel = $this->db->ObjectBuilder()->getValue('frota_acessos', 'id', 1);
	}

	function consultaDepartamentos($ID) {
		$this->db->where('a.usuario', $ID);
		$this->db->where('a.entidade', $this->_auth->entidade->id);
		$this->db->join('frota_departamentos_acesso a', 'a.departamento = d.id', 'INNER');
		if($departamentos = $this->db->ObjectBuilder()->get('frota_departamentos d', NULL, 'd.*')) {
			foreach($departamentos as $d) {
				$d->{'cotas'} = $this::getCotas($d->id);
				$d->{'cotasD'} = $this::getCotasD($d->id);
				$D[] = $d;
			}
			return $D;
		}
	}

	function listarDepartamentos($ID) {
		$this->db->where('a.usuario', $ID);
		$this->db->where('a.entidade', $this->_auth->entidade->id);
		$this->db->join('frota_departamentos_acesso a', 'a.departamento = d.id', 'INNER');
		if ( $lista = $this->db->getValue('frota_departamentos d', 'd.nome', null) ) {
			return implode(', ', $lista);
		}
	}

	function setAcesso($ID, $departamentos, $nivel = null) {
		$this::setDepartamentos($ID, $departamentos);
		$this::setNivel($ID, $nivel);
		return true;
	}

	function receber($ID) {
		$recebido = $this::statusRecebido();
		$dados = array(
			'frota' => $ID,
			'usuario' => $this->_auth->usuario->ID,
			'resposta' => 'frota recebido.',
			'codigo' => geraSenha(25),
			'data' => date('Y-m-d H:i:s'),
			);

		if ($recebido AND $this::addResposta($dados) ) {
			$this::setStatus($ID, $recebido);
			$this::resetEnvio($ID);
			return true;
		} else {
			$return = array(
				'success' => false,
				'msg' => 'Dados inválidos. Atualize a página e tente novamente.',
				'mtipo' => 'error',
			);
		}
		
	}

	function statusRecebido() {
		$this->db->where('nome', 'Recebido');
		$this->db->where('entidade', $this->_auth->entidade->id);
		if ( $status = $this->db->ObjectBuilder()->getOne('frota_status') ) {
			return $status->id;
		} else {
			$dados = array(
				'nome' => 'Recebido',
				'entidade' => $this->_auth->entidade->id,
				'padrao' => 0,
			);
			if($this->db->insert('frota_status', $dados)) {
				return $this->db->getInsertID();
			} else {
				return false;
			}
		}
	}

	function setDepartamentos($ID, $dep) {
		$this->db->where('usuario', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		$this->db->delete('frota_departamentos_acesso');
		if($dep) {
			foreach($dep as $d) {
				$dados[] = array(
					'usuario' => $ID,
					'entidade' => $this->_auth->entidade->id,
					'departamento' => $d
					);
			}
			$this->db->insertMulti('frota_departamentos_acesso', $dados);
		}
	}

	function setNivel($ID, $nivel) {
		if($nivel == 0) {
			$this->db->where('usuario', $ID);
			$this->db->where('entidade', $this->_auth->entidade->id);
			$this->db->delete('frota_acessos');

		} else if ( $reg = $this::consultaNivel($ID) ) {
			$dados = array ('usuario' => $ID, 'nivel' => $nivel, 'entidade' => $this->_auth->entidade->id);
			$this->db->where('id', $reg);
			$this->db->update('frota_acessos', $dados);

			$this->db->where('usuario', $ID);
			$this->db->where('entidade', $this->_auth->entidade->id);
			$this->db->delete('frota_departamentos_acesso');

		} else {
			$dados = array ('usuario' => $ID, 'nivel' => $nivel, 'entidade' => $this->_auth->entidade->id);
			$this->db->insert('frota_acessos', $dados);

			$this->db->where('usuario', $ID);
			$this->db->where('entidade', $this->_auth->entidade->id);
			$this->db->delete('frota_departamentos_acesso');
		}
	}

	function Auditoria($DEP = false) {
		if($DEP === false) {
			$this->db->join('frota_departamentos d', 'd.id = p.departamento', 'LEFT');
			$this->db->join('frota_status s', 's.id = p.status', 'LEFT');
			$this->db->where('p.entidade', $this->_auth->entidade->id);
			$this->db->OrderBy('d.nome', 'ASC');
			$this->db->GroupBy('d.id');
			$this->db->GroupBy('s.id');
			if ($protocolos = $this->db->ObjectBuilder()->get('frota p', null, 'p.*, d.nome as departamento, d.id as departamento_id, s.nome as status, count(s.id) as qtd, count(p.id) as total,  sum(p.qtd) as litros') ) {
				$auditoria = (object) array();
				foreach($protocolos as $p) {
					@$auditoria->{$p->departamento ?? 'Sem Departamento'}[$p->status]->{'qtd'} = $p->total;
					@$auditoria->{$p->departamento ?? 'Sem Departamento'}['id'] = $p->departamento_id;
					$auditoria->{$p->departamento ?? 'Sem Departamento'}[$p->status]->{'litros'} = $p->litros;
					$auditoria->{$p->departamento ?? 'Sem Departamento'}[$p->status]->{'media'} = $this::mediaVeiculo($p->veiculo);
				}
				return $auditoria;
			} else {
				return null;
			}
		} else {
			if($DEP > 0) {
				$this->db->where('d.id', $DEP);
			} else {
				$this->db->where('d.id IS NULL');
			}
			$this->db->join('frota_departamentos d', 'd.id = p.departamento', 'LEFT');
			$this->db->join('frota_status s', 's.id = p.status', 'LEFT');
			$this->db->join('frota_frota v', 'v.id = p.veiculo', 'LEFT');
			$this->db->where('p.entidade', $this->_auth->entidade->id);
			$this->db->OrderBy('d.nome', 'ASC');
			$this->db->OrderBy('s.nome', 'ASC', array('recebido', 'pendente', 'finalizado'));
			$this->db->OrderBy('p.data', 'ASC');
			$this->db->OrderBy('p.id', 'ASC');
			if ($pedidos = $this->db->ObjectBuilder()->get('frota p', 250, 'p.*, d.nome as departamento, p.departamento as departamento_id, s.nome as status, s.id as status_id, v.modelo, v.placa') ) {
				$auditoria = (object) array();
				foreach($pedidos as $p) {
					$p->{'media'} = $this::mediaVeiculo($p->veiculo);
					$auditoria->{$p->status}[] = $p;
				}
				return $auditoria;
			} else {
				return null;
			}
		}
	}

	function getCotasD($depto) {
		$negar = $this::statusNegado();
		$mes = date('m');
		$ano = date('Y');
		$this->db->join('frota_cotas co', "co.combustivel = c.id AND co.departamento = '$depto'", "LEFT");
		$this->db->join('frota p', "p.combustivel = c.id AND p.departamento = co.departamento AND p.status != '$negar' AND YEAR(p.data) = '$ano' AND MONTH(p.data) = '$mes'", "LEFT");
		$this->db->groupBy('c.id');
		if($cotas = $this->db->ObjectBuilder()->get('frota_combustiveis c', null, 'co.qtd-SUM(p.qtd) as qtd, co.qtd as total, c.id as combustivel')) {
			foreach($cotas as $c) {
				$R[$c->combustivel] = (int) ($c->qtd ?? $c->total ?? 0);
			}
			return $R;
		}
	}

	function getCotas($depto) {
		$this->db->where('departamento', $depto);
		if($cotas = $this->db->ObjectBuilder()->get('frota_cotas')) {
			foreach($cotas as $c) {
				$R[$c->combustivel] = $c->qtd;
			}
			return $R;
		}
	}

	function mediaVeiculo($veiculo) {
		$this->db->where('veiculo', $veiculo);
		$this->db->where('km_final', 0, '!=');
		$media = $this->db->ObjectBuilder()->get('frota', null, 'AVG(km_final - km_inicial) as media_km, AVG(qtd) as media_qtd');
		return $media[0];
	}

	function statusAprovado() {
		$autorizar = array('autorizado', 'liberado', 'permitido', 'concedido', 'aprovado');
		$this->db->where('nome', $autorizar, 'IN');
		return $this->db->getOne('frota_status')['id'];
	}

	function statusNegado() {
		$negar = array('não autorizado', 'negado', 'regeitado', 'impedido', 'não aprovado');
		$this->db->where('nome', $negar, 'IN');
		return $this->db->getOne('frota_status')['id'];
	}

	function autorizar($ID, $dados) {
		$dados['status'] = $this->statusAprovado;
		$dados['usuario_autorizacao'] = $this->_auth->usuario->ID;
		$this->db->where('id', $ID);
		return $this->db->update('frota', $dados);
	}

	function negar($ID, $dados) {
		$dados['status'] = $this->statusNegado;
		$dados['usuario_autorizacao'] = $this->_auth->usuario->ID;
		$this->db->where('id', $ID);
		return $this->db->update('frota', $dados);
	}

}

return $FROTA = new Frota($isView);

?>