<?
class Enquetes extends APP {
	PRIVATE $APP;

	PUBLIC $enquetes;
	PUBLIC $secoes;

	function __construct($isView) {
		if($isView) { $this->isView = true; }
		parent::__construct($isView);
		$this::getEnquetes();
		$this::getSecoes();
		if ((int) ENTIDADE !== 0) {
			$this->_auth->entidade = $this::getEntidade(ENTIDADE);
		}
	}

	function setSetup($tabela, $ID, $dados) {
		$this->db->where('id', $ID);
		if ( $this->db->update('enquetes_'.$tabela, $dados) ) {
			return $ID;
		} else {
			return false;
		}
	}

	function addSetup($tabela, $ID, $dados) {
		if ( $this->db->insert('enquetes_'.$tabela, $dados) ) {
			return $this->db->getInsertID();
		} else {
			return false;
		}
	}

	function delSetup($tabela, $ID) {
		$this->db->where('id', $ID);
		if ( $this->db->delete('enquetes_'.$tabela) ) {
			return true;
		} else {
			return false;
		}
	}

	function addOpcao($dados) {
		$this->db->insert('enquetes_opcoes', $dados);
		return $this->db->getInsertID();
	}

	function editOpcao($ID, $dados) {
		$this->db->where('id', $ID);
		return $this->db->update('enquetes_opcoes', $dados);
	}

	function delOpcao($ID) {
		$this->db->where('id', $ID);
		return $this->db->delete('enquetes_opcoes');
	}
	
	function getEnquetes($true = false) {
		$this->db->where('e.entidade', $this->_auth->entidade->id);
		$this->db->join('enquetes_secoes s', 's.id = e.secao', 'LEFT');
		$this->db->join('enquetes_opcoes o', 'o.enquete = e.id', 'LEFT');
		$this->db->OrderBy('e.data', 'DESC');
		$this->db->groupBy('e.id');
		if($true) { $this->db->where('status', 1); }
		$en = $this->db->ObjectBuilder()->get('enquetes e', NULL, 'e.*, s.nome as secao, s.id as secao_id, SUM(o.votos) as votos');
		if($en) {
			foreach($en as $e) {
				$e->{'opcoes'} = $this::getOpcoes($e->id);
				$enquetes[] = $e;
			}
			$this->enquetes = (object) $enquetes;
		}
		return $this->enquetes;
	}

	function getEnquetesView($filtros) {
		$this->db->join('enquetes_opcoes o', 'o.enquete = e.id', 'INNER');
		$this->db->OrderBy('e.data', 'DESC');
		$this->db->groupBy('e.id');
		## Entidade
		if($filtros->ent) {
			$this->db->where('e.entidade', $filtros->ent);
		} else if($this->_auth->entidade->id) {
			$this->db->where('e.entidade', $this->_auth->entidade->id);
		} else {
			$tthis->db->where('e.entidade', $this->entidade->id);
		}
		if($filtros->s) {
			$this->db->join('enquetes_secoes s', "(s.id = e.secao AND s.nome = '$filtros->s')", 'INNER');
		} else {
			$this->db->join('enquetes_secoes s', 's.id = e.secao', 'INNER');
		}
		$this->db->having('e.status', 1);
		if($en = $this->db->ObjectBuilder()->get('enquetes e', NULL, 'e.*, s.nome as secao, s.id as secao_id, SUM(o.votos) as votos')) {
			foreach($en as $e) {
				$e->{'opcoes'} = $this::getOpcoes($e->id);
				$enquetes[] = $e;
			}
			$enquetes = (object) $enquetes;
		}
		return $enquetes;
	}

	function getEnqueteID($ID) {
		$this->db->where('e.id', $ID);
		//$this->db->where('e.entidade', $this->_auth->entidade->id);
		$this->db->join('enquetes_secoes s', 's.id = e.secao', 'LEFT');
		$this->db->join('enquetes_opcoes o', 'o.enquete = e.id', 'LEFT');
		$this->db->OrderBy('e.data', 'DESC');
		$this->db->groupBy('e.id');
		$en = $this->db->ObjectBuilder()->get('enquetes e', NULL, 'e.*, s.nome as secao, s.id as secao_id, SUM(o.votos) as votos')[0];
		if($en) {
			$en->{'opcoes'} = $this::getOpcoes($en->id);
			return $en;
		}
		return $en;
	}

	function getOpcoes($ID) {
		$this->db->where('enquete', $ID);
		return $this->db->ObjectBuilder()->get('enquetes_opcoes');
	}

	function getOpcaoID($ID) {
		$this->db->where('id', $ID);
		return $this->db->ObjectBuilder()->getOne('enquetes_opcoes');
	}

	function getEnqueteTag($TAG) {
		$this->db->where('tag', $TAG);
		$this->db->where('entidade', $this->_auth->entidade->id);
		$enquete = $this->db->ObjectBuilder()->getOne('enquetes');
		return $enquete;
	}

	function editar($ID, $dados) {
		$this->db->where('(tag = "'.$dados['tag'].'" AND id != "'.$ID.'")');
		$this->db->orWhere('tag LIKE ("'.$dados['tag'].'_%")  AND id != "'.$ID.'"');
		$TAGS = count($this->db->get('enquetes'));
		if($TAGS) {	$dados['tag'] = $dados['tag'].'_'.$TAGS; }
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		if( $this->db->update('enquetes', $dados) ) {
			return $dados['tag'];
		} else {
			return false;
		}
	}

	function desativar($ID) {
		$dados = array('status' => '0');
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->update('enquetes', $dados);
	}

	function ativar($ID) {
		$dados = array('status' => 1);
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->update('enquetes', $dados);
	}

	function excluir($ID) {
		$this->db->where('enquete', $ID);
		$this->db->delete('enquetes_opcoes');

		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->delete('enquetes');
	}

	function criar($dados) {
		$this->db->where('tag', $dados['tag']);
		$this->db->orWhere('tag LIKE ("'.$dados['tag'].'_%")');
		$TAGS = count($this->db->get('enquetes'));
		if($TAGS) {	$dados['tag'] = $dados['tag'].'_'.$TAGS; }
		if ($this->db->insert('enquetes', $dados)){
			return $dados['tag'];
		} else {
			var_dump($this->db->getLastError());
			return false;
		}
	}
	
	function getSecoes($check = false, $filtros = false) {
		if ($check) {
			$this->db->join('enquetes e', 'e.secao = s.id', 'INNER');
		} else {
			$this->db->join('enquetes e', 'e.secao = s.id', 'LEFT');
		}
		if ($filtros->ent) {
			$this->db->where('s.entidade', $filtros->ent);
		} else {
			$this->db->where('s.entidade', $this->_auth->entidade->id);
		}
		$this->db->OrderBy('s.nome', 'ASC');
		$this->db->groupBy('s.nome');
		$this->secoes = $this->db->ObjectBuilder()->get('enquetes_secoes s', null, 's.*');
		return $this->secoes;
	}

	/*function votar($opcao) {
		$o = $this::getOpcaoID($opcao);

		$dados['votos'] = ++$o->votos;
		$this->db->where('id', $o->id);
		if ($this->db->update('enquetes_opcoes', $dados)) {
			$this->db->insert('enquetes_votos', array('enquete' => $o->enquete, 'ip' => getIP(),));
			$enquete = $this::getEnqueteID($o->enquete);
			$pct = array();
			foreach($enquete->opcoes as $o) {
				$pct[$o->id] = number_format(($o->votos*100)/$enquete->votos, 0).'%';
			}
			$return = array(
				'success' => true,
				'pct' => $pct,
				);
			return $return;
		}
	}*/

	function votar($opcao) {
		$o = $this::getOpcaoID($opcao);

		$this->db->where('enquete', $o->enquete);
		$this->db->where('ip', getIP());

		if(!$this->db->get('enquetes_votos')) {
			$dados['votos'] = ++$o->votos;
			$this->db->where('id', $o->id);
			if ( $this->db->update('enquetes_opcoes', $dados) ) {
				$this->db->insert('enquetes_votos', array('enquete' => $o->enquete, 'ip' => getIP(),));
				$enquete = $this::getEnqueteID($o->enquete);
				$pct = array();
				foreach($enquete->opcoes as $o) {
					$pct[$o->id] = number_format(($o->votos*100)/$enquete->votos, 0).'%';
				}
				$return = array(
					'success' => true,
					'pct' => $pct,
				);
				return $return;
			}
		} else {
			$enquete = $this::getEnqueteID($o->enquete);
			$pct = array();
			foreach($enquete->opcoes as $o) {
				$pct[$o->id] = number_format(($o->votos*100)/$enquete->votos, 0).'%';
			}
			$return = array(
				'pct' => $pct,
				'voto' => true,
			);
			return $return;
		}
	}

	function zerarVotos($ID) {
		$dados['votos'] = 0;
		$this->db->where('enquete', $ID);
		return $this->db->update('enquetes_opcoes', $dados);
	}

	function getEnquetesNews($limitador, $secao = false, $secaoNao = false, $orderBy = false, $pagina = 1) {
		
		$this->db->join('enquetes_opcoes o', 'o.enquete = e.id', 'INNER');
		$this->db->join('enquetes_secoes s', 's.id = e.secao', 'LEFT');
		if ($secao) {
			if (is_array($secao)) {
				$this->db->where('s.nome', $secao, 'IN');
			} else {
				$this->db->where('s.nome', $secao);
			}
		}
		if ($secaoNao) {
			if (is_array($secaoNao)) {
				$this->db->where('s.nome', $secaoNao, 'NOT IN');
			} else {
				$this->db->where('s.nome', $secaoNao, '!=');
			}
		}
		$this->db->where('e.entidade', $this->_auth->entidade->id);
		if ($orderBy) {
			$this->db->OrderBy('e.'.$orderBy->campo, $orderBy->ordem);
		} else {
			$this->db->OrderBy('e.data', 'DESC');
		}
		$this->db->groupBy('e.id');

		$this->db->pageLimit = $limitador;
		if ($en = $this->db->ObjectBuilder()->paginate('enquetes e', $pagina, 'e.*, s.nome as secao, SUM(o.votos) as votos'))  {
			foreach($en as $e) {
				$e->{'opcoes'} = $this::getOpcoes($e->id);
				$enquetes[] = $e;
			}
			$enquetes = (object) $enquetes;
			return $enquetes;
		} else {
			return false;
		}
	}

}

return $ENQUETES = new Enquetes($isView);

?>